# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetResourceAnalyticsTenancyAttachmentResult',
    'AwaitableGetResourceAnalyticsTenancyAttachmentResult',
    'get_resource_analytics_tenancy_attachment',
    'get_resource_analytics_tenancy_attachment_output',
]

@pulumi.output_type
class GetResourceAnalyticsTenancyAttachmentResult:
    """
    A collection of values returned by getResourceAnalyticsTenancyAttachment.
    """
    def __init__(__self__, description=None, id=None, is_reporting_tenancy=None, lifecycle_details=None, resource_analytics_instance_id=None, state=None, system_tags=None, tenancy_attachment_id=None, tenancy_id=None, time_created=None, time_updated=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_reporting_tenancy and not isinstance(is_reporting_tenancy, bool):
            raise TypeError("Expected argument 'is_reporting_tenancy' to be a bool")
        pulumi.set(__self__, "is_reporting_tenancy", is_reporting_tenancy)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if resource_analytics_instance_id and not isinstance(resource_analytics_instance_id, str):
            raise TypeError("Expected argument 'resource_analytics_instance_id' to be a str")
        pulumi.set(__self__, "resource_analytics_instance_id", resource_analytics_instance_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if tenancy_attachment_id and not isinstance(tenancy_attachment_id, str):
            raise TypeError("Expected argument 'tenancy_attachment_id' to be a str")
        pulumi.set(__self__, "tenancy_attachment_id", tenancy_attachment_id)
        if tenancy_id and not isinstance(tenancy_id, str):
            raise TypeError("Expected argument 'tenancy_id' to be a str")
        pulumi.set(__self__, "tenancy_id", tenancy_id)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        A description of the tenancy.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the TenancyAttachment.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isReportingTenancy")
    def is_reporting_tenancy(self) -> _builtins.bool:
        """
        Whether the tenancy is the tenancy used when creating Resource Analytics Instance.
        """
        return pulumi.get(self, "is_reporting_tenancy")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message that describes the current state of the TenancyAttachment in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="resourceAnalyticsInstanceId")
    def resource_analytics_instance_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ResourceAnalyticsInstance associated with this TenancyAttachment.
        """
        return pulumi.get(self, "resource_analytics_instance_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the TenancyAttachment.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="tenancyAttachmentId")
    def tenancy_attachment_id(self) -> _builtins.str:
        return pulumi.get(self, "tenancy_attachment_id")

    @_builtins.property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the tenancy associated with this TenancyAttachment.
        """
        return pulumi.get(self, "tenancy_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the TenancyAttachment was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time the TenancyAttachment was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetResourceAnalyticsTenancyAttachmentResult(GetResourceAnalyticsTenancyAttachmentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResourceAnalyticsTenancyAttachmentResult(
            description=self.description,
            id=self.id,
            is_reporting_tenancy=self.is_reporting_tenancy,
            lifecycle_details=self.lifecycle_details,
            resource_analytics_instance_id=self.resource_analytics_instance_id,
            state=self.state,
            system_tags=self.system_tags,
            tenancy_attachment_id=self.tenancy_attachment_id,
            tenancy_id=self.tenancy_id,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_resource_analytics_tenancy_attachment(tenancy_attachment_id: Optional[_builtins.str] = None,
                                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResourceAnalyticsTenancyAttachmentResult:
    """
    This data source provides details about a specific Tenancy Attachment resource in Oracle Cloud Infrastructure Resource Analytics service.

    Gets information about a TenancyAttachment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_tenancy_attachment = oci.oci.get_resource_analytics_tenancy_attachment(tenancy_attachment_id=test_tenancy_attachment_oci_resource_analytics_tenancy_attachment["id"])
    ```


    :param _builtins.str tenancy_attachment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the TenancyAttachment.
    """
    __args__ = dict()
    __args__['tenancyAttachmentId'] = tenancy_attachment_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:oci/getResourceAnalyticsTenancyAttachment:getResourceAnalyticsTenancyAttachment', __args__, opts=opts, typ=GetResourceAnalyticsTenancyAttachmentResult).value

    return AwaitableGetResourceAnalyticsTenancyAttachmentResult(
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        is_reporting_tenancy=pulumi.get(__ret__, 'is_reporting_tenancy'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        resource_analytics_instance_id=pulumi.get(__ret__, 'resource_analytics_instance_id'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        tenancy_attachment_id=pulumi.get(__ret__, 'tenancy_attachment_id'),
        tenancy_id=pulumi.get(__ret__, 'tenancy_id'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_resource_analytics_tenancy_attachment_output(tenancy_attachment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetResourceAnalyticsTenancyAttachmentResult]:
    """
    This data source provides details about a specific Tenancy Attachment resource in Oracle Cloud Infrastructure Resource Analytics service.

    Gets information about a TenancyAttachment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_tenancy_attachment = oci.oci.get_resource_analytics_tenancy_attachment(tenancy_attachment_id=test_tenancy_attachment_oci_resource_analytics_tenancy_attachment["id"])
    ```


    :param _builtins.str tenancy_attachment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the TenancyAttachment.
    """
    __args__ = dict()
    __args__['tenancyAttachmentId'] = tenancy_attachment_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:oci/getResourceAnalyticsTenancyAttachment:getResourceAnalyticsTenancyAttachment', __args__, opts=opts, typ=GetResourceAnalyticsTenancyAttachmentResult)
    return __ret__.apply(lambda __response__: GetResourceAnalyticsTenancyAttachmentResult(
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        is_reporting_tenancy=pulumi.get(__response__, 'is_reporting_tenancy'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        resource_analytics_instance_id=pulumi.get(__response__, 'resource_analytics_instance_id'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        tenancy_attachment_id=pulumi.get(__response__, 'tenancy_attachment_id'),
        tenancy_id=pulumi.get(__response__, 'tenancy_id'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
