# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetResourceAnalyticsTenancyAttachmentsResult',
    'AwaitableGetResourceAnalyticsTenancyAttachmentsResult',
    'get_resource_analytics_tenancy_attachments',
    'get_resource_analytics_tenancy_attachments_output',
]

@pulumi.output_type
class GetResourceAnalyticsTenancyAttachmentsResult:
    """
    A collection of values returned by getResourceAnalyticsTenancyAttachments.
    """
    def __init__(__self__, filters=None, id=None, resource_analytics_instance_id=None, state=None, tenancy_attachment_collections=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if resource_analytics_instance_id and not isinstance(resource_analytics_instance_id, str):
            raise TypeError("Expected argument 'resource_analytics_instance_id' to be a str")
        pulumi.set(__self__, "resource_analytics_instance_id", resource_analytics_instance_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if tenancy_attachment_collections and not isinstance(tenancy_attachment_collections, list):
            raise TypeError("Expected argument 'tenancy_attachment_collections' to be a list")
        pulumi.set(__self__, "tenancy_attachment_collections", tenancy_attachment_collections)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetResourceAnalyticsTenancyAttachmentsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the TenancyAttachment.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="resourceAnalyticsInstanceId")
    def resource_analytics_instance_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ResourceAnalyticsInstance associated with this TenancyAttachment.
        """
        return pulumi.get(self, "resource_analytics_instance_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the TenancyAttachment.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="tenancyAttachmentCollections")
    def tenancy_attachment_collections(self) -> Sequence['outputs.GetResourceAnalyticsTenancyAttachmentsTenancyAttachmentCollectionResult']:
        """
        The list of tenancy_attachment_collection.
        """
        return pulumi.get(self, "tenancy_attachment_collections")


class AwaitableGetResourceAnalyticsTenancyAttachmentsResult(GetResourceAnalyticsTenancyAttachmentsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResourceAnalyticsTenancyAttachmentsResult(
            filters=self.filters,
            id=self.id,
            resource_analytics_instance_id=self.resource_analytics_instance_id,
            state=self.state,
            tenancy_attachment_collections=self.tenancy_attachment_collections)


def get_resource_analytics_tenancy_attachments(filters: Optional[Sequence[Union['GetResourceAnalyticsTenancyAttachmentsFilterArgs', 'GetResourceAnalyticsTenancyAttachmentsFilterArgsDict']]] = None,
                                               id: Optional[_builtins.str] = None,
                                               resource_analytics_instance_id: Optional[_builtins.str] = None,
                                               state: Optional[_builtins.str] = None,
                                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResourceAnalyticsTenancyAttachmentsResult:
    """
    This data source provides the list of Tenancy Attachments in Oracle Cloud Infrastructure Resource Analytics service.

    Gets a list of TenancyAttachments.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_tenancy_attachments = oci.oci.get_resource_analytics_tenancy_attachments(id=tenancy_attachment_id,
        resource_analytics_instance_id=test_resource_analytics_instance["id"],
        state=tenancy_attachment_state)
    ```


    :param _builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the TenancyAttachment.
    :param _builtins.str resource_analytics_instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a ResourceAnalyticsInstance.
    :param _builtins.str state: A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['resourceAnalyticsInstanceId'] = resource_analytics_instance_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:oci/getResourceAnalyticsTenancyAttachments:getResourceAnalyticsTenancyAttachments', __args__, opts=opts, typ=GetResourceAnalyticsTenancyAttachmentsResult).value

    return AwaitableGetResourceAnalyticsTenancyAttachmentsResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        resource_analytics_instance_id=pulumi.get(__ret__, 'resource_analytics_instance_id'),
        state=pulumi.get(__ret__, 'state'),
        tenancy_attachment_collections=pulumi.get(__ret__, 'tenancy_attachment_collections'))
def get_resource_analytics_tenancy_attachments_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetResourceAnalyticsTenancyAttachmentsFilterArgs', 'GetResourceAnalyticsTenancyAttachmentsFilterArgsDict']]]]] = None,
                                                      id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                      resource_analytics_instance_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                      state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetResourceAnalyticsTenancyAttachmentsResult]:
    """
    This data source provides the list of Tenancy Attachments in Oracle Cloud Infrastructure Resource Analytics service.

    Gets a list of TenancyAttachments.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_tenancy_attachments = oci.oci.get_resource_analytics_tenancy_attachments(id=tenancy_attachment_id,
        resource_analytics_instance_id=test_resource_analytics_instance["id"],
        state=tenancy_attachment_state)
    ```


    :param _builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the TenancyAttachment.
    :param _builtins.str resource_analytics_instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a ResourceAnalyticsInstance.
    :param _builtins.str state: A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['resourceAnalyticsInstanceId'] = resource_analytics_instance_id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:oci/getResourceAnalyticsTenancyAttachments:getResourceAnalyticsTenancyAttachments', __args__, opts=opts, typ=GetResourceAnalyticsTenancyAttachmentsResult)
    return __ret__.apply(lambda __response__: GetResourceAnalyticsTenancyAttachmentsResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        resource_analytics_instance_id=pulumi.get(__response__, 'resource_analytics_instance_id'),
        state=pulumi.get(__response__, 'state'),
        tenancy_attachment_collections=pulumi.get(__response__, 'tenancy_attachment_collections')))
