# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IotDigitalTwinAdapterArgs', 'IotDigitalTwinAdapter']

@pulumi.input_type
class IotDigitalTwinAdapterArgs:
    def __init__(__self__, *,
                 iot_domain_id: pulumi.Input[_builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 digital_twin_model_id: Optional[pulumi.Input[_builtins.str]] = None,
                 digital_twin_model_spec_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 inbound_envelope: Optional[pulumi.Input['IotDigitalTwinAdapterInboundEnvelopeArgs']] = None,
                 inbound_routes: Optional[pulumi.Input[Sequence[pulumi.Input['IotDigitalTwinAdapterInboundRouteArgs']]]] = None):
        """
        The set of arguments for constructing a IotDigitalTwinAdapter resource.
        :param pulumi.Input[_builtins.str] iot_domain_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the IoT domain.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) A short description of the resource.
        :param pulumi.Input[_builtins.str] digital_twin_model_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the digital twin model.
        :param pulumi.Input[_builtins.str] digital_twin_model_spec_uri: The URI of the digital twin model specification.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input['IotDigitalTwinAdapterInboundEnvelopeArgs'] inbound_envelope: (Updatable) Payload containing device-specific metadata and optional value mappings used to interpret or transform that metadata. This structure includes the device endpoint, the actual payload, and an optional envelope mapping that applies [JQ](https://stedolan.github.io/jq/) expressions to extract or reshape the data as needed.
        :param pulumi.Input[Sequence[pulumi.Input['IotDigitalTwinAdapterInboundRouteArgs']]] inbound_routes: (Updatable) list of inbound routes
        """
        pulumi.set(__self__, "iot_domain_id", iot_domain_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if digital_twin_model_id is not None:
            pulumi.set(__self__, "digital_twin_model_id", digital_twin_model_id)
        if digital_twin_model_spec_uri is not None:
            pulumi.set(__self__, "digital_twin_model_spec_uri", digital_twin_model_spec_uri)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if inbound_envelope is not None:
            pulumi.set(__self__, "inbound_envelope", inbound_envelope)
        if inbound_routes is not None:
            pulumi.set(__self__, "inbound_routes", inbound_routes)

    @_builtins.property
    @pulumi.getter(name="iotDomainId")
    def iot_domain_id(self) -> pulumi.Input[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the IoT domain.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "iot_domain_id")

    @iot_domain_id.setter
    def iot_domain_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "iot_domain_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A short description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="digitalTwinModelId")
    def digital_twin_model_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the digital twin model.
        """
        return pulumi.get(self, "digital_twin_model_id")

    @digital_twin_model_id.setter
    def digital_twin_model_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "digital_twin_model_id", value)

    @_builtins.property
    @pulumi.getter(name="digitalTwinModelSpecUri")
    def digital_twin_model_spec_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI of the digital twin model specification.
        """
        return pulumi.get(self, "digital_twin_model_spec_uri")

    @digital_twin_model_spec_uri.setter
    def digital_twin_model_spec_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "digital_twin_model_spec_uri", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="inboundEnvelope")
    def inbound_envelope(self) -> Optional[pulumi.Input['IotDigitalTwinAdapterInboundEnvelopeArgs']]:
        """
        (Updatable) Payload containing device-specific metadata and optional value mappings used to interpret or transform that metadata. This structure includes the device endpoint, the actual payload, and an optional envelope mapping that applies [JQ](https://stedolan.github.io/jq/) expressions to extract or reshape the data as needed.
        """
        return pulumi.get(self, "inbound_envelope")

    @inbound_envelope.setter
    def inbound_envelope(self, value: Optional[pulumi.Input['IotDigitalTwinAdapterInboundEnvelopeArgs']]):
        pulumi.set(self, "inbound_envelope", value)

    @_builtins.property
    @pulumi.getter(name="inboundRoutes")
    def inbound_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IotDigitalTwinAdapterInboundRouteArgs']]]]:
        """
        (Updatable) list of inbound routes
        """
        return pulumi.get(self, "inbound_routes")

    @inbound_routes.setter
    def inbound_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IotDigitalTwinAdapterInboundRouteArgs']]]]):
        pulumi.set(self, "inbound_routes", value)


@pulumi.input_type
class _IotDigitalTwinAdapterState:
    def __init__(__self__, *,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 digital_twin_model_id: Optional[pulumi.Input[_builtins.str]] = None,
                 digital_twin_model_spec_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 inbound_envelope: Optional[pulumi.Input['IotDigitalTwinAdapterInboundEnvelopeArgs']] = None,
                 inbound_routes: Optional[pulumi.Input[Sequence[pulumi.Input['IotDigitalTwinAdapterInboundRouteArgs']]]] = None,
                 iot_domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering IotDigitalTwinAdapter resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) A short description of the resource.
        :param pulumi.Input[_builtins.str] digital_twin_model_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the digital twin model.
        :param pulumi.Input[_builtins.str] digital_twin_model_spec_uri: The URI of the digital twin model specification.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input['IotDigitalTwinAdapterInboundEnvelopeArgs'] inbound_envelope: (Updatable) Payload containing device-specific metadata and optional value mappings used to interpret or transform that metadata. This structure includes the device endpoint, the actual payload, and an optional envelope mapping that applies [JQ](https://stedolan.github.io/jq/) expressions to extract or reshape the data as needed.
        :param pulumi.Input[Sequence[pulumi.Input['IotDigitalTwinAdapterInboundRouteArgs']]] inbound_routes: (Updatable) list of inbound routes
        :param pulumi.Input[_builtins.str] iot_domain_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the IoT domain.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] state: The current state of the digital twin adapter.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The date and time when the resource was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_updated: The date and time when the resource was last updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if digital_twin_model_id is not None:
            pulumi.set(__self__, "digital_twin_model_id", digital_twin_model_id)
        if digital_twin_model_spec_uri is not None:
            pulumi.set(__self__, "digital_twin_model_spec_uri", digital_twin_model_spec_uri)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if inbound_envelope is not None:
            pulumi.set(__self__, "inbound_envelope", inbound_envelope)
        if inbound_routes is not None:
            pulumi.set(__self__, "inbound_routes", inbound_routes)
        if iot_domain_id is not None:
            pulumi.set(__self__, "iot_domain_id", iot_domain_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A short description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="digitalTwinModelId")
    def digital_twin_model_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the digital twin model.
        """
        return pulumi.get(self, "digital_twin_model_id")

    @digital_twin_model_id.setter
    def digital_twin_model_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "digital_twin_model_id", value)

    @_builtins.property
    @pulumi.getter(name="digitalTwinModelSpecUri")
    def digital_twin_model_spec_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI of the digital twin model specification.
        """
        return pulumi.get(self, "digital_twin_model_spec_uri")

    @digital_twin_model_spec_uri.setter
    def digital_twin_model_spec_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "digital_twin_model_spec_uri", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="inboundEnvelope")
    def inbound_envelope(self) -> Optional[pulumi.Input['IotDigitalTwinAdapterInboundEnvelopeArgs']]:
        """
        (Updatable) Payload containing device-specific metadata and optional value mappings used to interpret or transform that metadata. This structure includes the device endpoint, the actual payload, and an optional envelope mapping that applies [JQ](https://stedolan.github.io/jq/) expressions to extract or reshape the data as needed.
        """
        return pulumi.get(self, "inbound_envelope")

    @inbound_envelope.setter
    def inbound_envelope(self, value: Optional[pulumi.Input['IotDigitalTwinAdapterInboundEnvelopeArgs']]):
        pulumi.set(self, "inbound_envelope", value)

    @_builtins.property
    @pulumi.getter(name="inboundRoutes")
    def inbound_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IotDigitalTwinAdapterInboundRouteArgs']]]]:
        """
        (Updatable) list of inbound routes
        """
        return pulumi.get(self, "inbound_routes")

    @inbound_routes.setter
    def inbound_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IotDigitalTwinAdapterInboundRouteArgs']]]]):
        pulumi.set(self, "inbound_routes", value)

    @_builtins.property
    @pulumi.getter(name="iotDomainId")
    def iot_domain_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the IoT domain.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "iot_domain_id")

    @iot_domain_id.setter
    def iot_domain_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "iot_domain_id", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the digital twin adapter.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time when the resource was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time when the resource was last updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:oci/iotDigitalTwinAdapter:IotDigitalTwinAdapter")
class IotDigitalTwinAdapter(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 digital_twin_model_id: Optional[pulumi.Input[_builtins.str]] = None,
                 digital_twin_model_spec_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 inbound_envelope: Optional[pulumi.Input[Union['IotDigitalTwinAdapterInboundEnvelopeArgs', 'IotDigitalTwinAdapterInboundEnvelopeArgsDict']]] = None,
                 inbound_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IotDigitalTwinAdapterInboundRouteArgs', 'IotDigitalTwinAdapterInboundRouteArgsDict']]]]] = None,
                 iot_domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_digital_twin_adapter = oci.oci.IotDigitalTwinAdapter("test_digital_twin_adapter",
            iot_domain_id=test_iot_domain["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=digital_twin_adapter_description,
            digital_twin_model_id=test_digital_twin_model["id"],
            digital_twin_model_spec_uri=digital_twin_adapter_digital_twin_model_spec_uri,
            display_name=digital_twin_adapter_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            inbound_envelope={
                "reference_endpoint": digital_twin_adapter_inbound_envelope_reference_endpoint,
                "envelope_mapping": {
                    "time_observed": digital_twin_adapter_inbound_envelope_envelope_mapping_time_observed,
                },
                "reference_payload": {
                    "data": digital_twin_adapter_inbound_envelope_reference_payload_data,
                    "data_format": digital_twin_adapter_inbound_envelope_reference_payload_data_format,
                },
            },
            inbound_routes=[{
                "condition": digital_twin_adapter_inbound_routes_condition,
                "description": digital_twin_adapter_inbound_routes_description,
                "payload_mapping": digital_twin_adapter_inbound_routes_payload_mapping,
                "reference_payload": {
                    "data": digital_twin_adapter_inbound_routes_reference_payload_data,
                    "data_format": digital_twin_adapter_inbound_routes_reference_payload_data_format,
                },
            }])
        ```

        ## Import

        DigitalTwinAdapters can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:oci/iotDigitalTwinAdapter:IotDigitalTwinAdapter test_digital_twin_adapter "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) A short description of the resource.
        :param pulumi.Input[_builtins.str] digital_twin_model_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the digital twin model.
        :param pulumi.Input[_builtins.str] digital_twin_model_spec_uri: The URI of the digital twin model specification.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Union['IotDigitalTwinAdapterInboundEnvelopeArgs', 'IotDigitalTwinAdapterInboundEnvelopeArgsDict']] inbound_envelope: (Updatable) Payload containing device-specific metadata and optional value mappings used to interpret or transform that metadata. This structure includes the device endpoint, the actual payload, and an optional envelope mapping that applies [JQ](https://stedolan.github.io/jq/) expressions to extract or reshape the data as needed.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IotDigitalTwinAdapterInboundRouteArgs', 'IotDigitalTwinAdapterInboundRouteArgsDict']]]] inbound_routes: (Updatable) list of inbound routes
        :param pulumi.Input[_builtins.str] iot_domain_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the IoT domain.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IotDigitalTwinAdapterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_digital_twin_adapter = oci.oci.IotDigitalTwinAdapter("test_digital_twin_adapter",
            iot_domain_id=test_iot_domain["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=digital_twin_adapter_description,
            digital_twin_model_id=test_digital_twin_model["id"],
            digital_twin_model_spec_uri=digital_twin_adapter_digital_twin_model_spec_uri,
            display_name=digital_twin_adapter_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            inbound_envelope={
                "reference_endpoint": digital_twin_adapter_inbound_envelope_reference_endpoint,
                "envelope_mapping": {
                    "time_observed": digital_twin_adapter_inbound_envelope_envelope_mapping_time_observed,
                },
                "reference_payload": {
                    "data": digital_twin_adapter_inbound_envelope_reference_payload_data,
                    "data_format": digital_twin_adapter_inbound_envelope_reference_payload_data_format,
                },
            },
            inbound_routes=[{
                "condition": digital_twin_adapter_inbound_routes_condition,
                "description": digital_twin_adapter_inbound_routes_description,
                "payload_mapping": digital_twin_adapter_inbound_routes_payload_mapping,
                "reference_payload": {
                    "data": digital_twin_adapter_inbound_routes_reference_payload_data,
                    "data_format": digital_twin_adapter_inbound_routes_reference_payload_data_format,
                },
            }])
        ```

        ## Import

        DigitalTwinAdapters can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:oci/iotDigitalTwinAdapter:IotDigitalTwinAdapter test_digital_twin_adapter "id"
        ```

        :param str resource_name: The name of the resource.
        :param IotDigitalTwinAdapterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IotDigitalTwinAdapterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 digital_twin_model_id: Optional[pulumi.Input[_builtins.str]] = None,
                 digital_twin_model_spec_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 inbound_envelope: Optional[pulumi.Input[Union['IotDigitalTwinAdapterInboundEnvelopeArgs', 'IotDigitalTwinAdapterInboundEnvelopeArgsDict']]] = None,
                 inbound_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IotDigitalTwinAdapterInboundRouteArgs', 'IotDigitalTwinAdapterInboundRouteArgsDict']]]]] = None,
                 iot_domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IotDigitalTwinAdapterArgs.__new__(IotDigitalTwinAdapterArgs)

            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["digital_twin_model_id"] = digital_twin_model_id
            __props__.__dict__["digital_twin_model_spec_uri"] = digital_twin_model_spec_uri
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["inbound_envelope"] = inbound_envelope
            __props__.__dict__["inbound_routes"] = inbound_routes
            if iot_domain_id is None and not opts.urn:
                raise TypeError("Missing required property 'iot_domain_id'")
            __props__.__dict__["iot_domain_id"] = iot_domain_id
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(IotDigitalTwinAdapter, __self__).__init__(
            'oci:oci/iotDigitalTwinAdapter:IotDigitalTwinAdapter',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            digital_twin_model_id: Optional[pulumi.Input[_builtins.str]] = None,
            digital_twin_model_spec_uri: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            inbound_envelope: Optional[pulumi.Input[Union['IotDigitalTwinAdapterInboundEnvelopeArgs', 'IotDigitalTwinAdapterInboundEnvelopeArgsDict']]] = None,
            inbound_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IotDigitalTwinAdapterInboundRouteArgs', 'IotDigitalTwinAdapterInboundRouteArgsDict']]]]] = None,
            iot_domain_id: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None) -> 'IotDigitalTwinAdapter':
        """
        Get an existing IotDigitalTwinAdapter resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) A short description of the resource.
        :param pulumi.Input[_builtins.str] digital_twin_model_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the digital twin model.
        :param pulumi.Input[_builtins.str] digital_twin_model_spec_uri: The URI of the digital twin model specification.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Union['IotDigitalTwinAdapterInboundEnvelopeArgs', 'IotDigitalTwinAdapterInboundEnvelopeArgsDict']] inbound_envelope: (Updatable) Payload containing device-specific metadata and optional value mappings used to interpret or transform that metadata. This structure includes the device endpoint, the actual payload, and an optional envelope mapping that applies [JQ](https://stedolan.github.io/jq/) expressions to extract or reshape the data as needed.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IotDigitalTwinAdapterInboundRouteArgs', 'IotDigitalTwinAdapterInboundRouteArgsDict']]]] inbound_routes: (Updatable) list of inbound routes
        :param pulumi.Input[_builtins.str] iot_domain_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the IoT domain.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] state: The current state of the digital twin adapter.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The date and time when the resource was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_updated: The date and time when the resource was last updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IotDigitalTwinAdapterState.__new__(_IotDigitalTwinAdapterState)

        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["digital_twin_model_id"] = digital_twin_model_id
        __props__.__dict__["digital_twin_model_spec_uri"] = digital_twin_model_spec_uri
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["inbound_envelope"] = inbound_envelope
        __props__.__dict__["inbound_routes"] = inbound_routes
        __props__.__dict__["iot_domain_id"] = iot_domain_id
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return IotDigitalTwinAdapter(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) A short description of the resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="digitalTwinModelId")
    def digital_twin_model_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the digital twin model.
        """
        return pulumi.get(self, "digital_twin_model_id")

    @_builtins.property
    @pulumi.getter(name="digitalTwinModelSpecUri")
    def digital_twin_model_spec_uri(self) -> pulumi.Output[_builtins.str]:
        """
        The URI of the digital twin model specification.
        """
        return pulumi.get(self, "digital_twin_model_spec_uri")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="inboundEnvelope")
    def inbound_envelope(self) -> pulumi.Output['outputs.IotDigitalTwinAdapterInboundEnvelope']:
        """
        (Updatable) Payload containing device-specific metadata and optional value mappings used to interpret or transform that metadata. This structure includes the device endpoint, the actual payload, and an optional envelope mapping that applies [JQ](https://stedolan.github.io/jq/) expressions to extract or reshape the data as needed.
        """
        return pulumi.get(self, "inbound_envelope")

    @_builtins.property
    @pulumi.getter(name="inboundRoutes")
    def inbound_routes(self) -> pulumi.Output[Sequence['outputs.IotDigitalTwinAdapterInboundRoute']]:
        """
        (Updatable) list of inbound routes
        """
        return pulumi.get(self, "inbound_routes")

    @_builtins.property
    @pulumi.getter(name="iotDomainId")
    def iot_domain_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the IoT domain.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "iot_domain_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the digital twin adapter.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time when the resource was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time when the resource was last updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

