# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ManagedKafkaKafkaClusterArgs', 'ManagedKafkaKafkaCluster']

@pulumi.input_type
class ManagedKafkaKafkaClusterArgs:
    def __init__(__self__, *,
                 access_subnets: pulumi.Input[Sequence[pulumi.Input['ManagedKafkaKafkaClusterAccessSubnetArgs']]],
                 broker_shape: pulumi.Input['ManagedKafkaKafkaClusterBrokerShapeArgs'],
                 cluster_config_id: pulumi.Input[_builtins.str],
                 cluster_config_version: pulumi.Input[_builtins.int],
                 cluster_type: pulumi.Input[_builtins.str],
                 compartment_id: pulumi.Input[_builtins.str],
                 coordination_type: pulumi.Input[_builtins.str],
                 kafka_version: pulumi.Input[_builtins.str],
                 client_certificate_bundle: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a ManagedKafkaKafkaCluster resource.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedKafkaKafkaClusterAccessSubnetArgs']]] access_subnets: (Updatable) Subnets where broker/coordinator VNICs will be created.
        :param pulumi.Input['ManagedKafkaKafkaClusterBrokerShapeArgs'] broker_shape: (Updatable) Configuration of the broker node.
        :param pulumi.Input[_builtins.str] cluster_config_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of Kafka Cluster configuration object
        :param pulumi.Input[_builtins.int] cluster_config_version: (Updatable) The version of configuration object
        :param pulumi.Input[_builtins.str] cluster_type: Type of the cluster to spin up.  DEVELOPMENT - setting that allows to sacrifice HA and spin up cluster on single node PRODUCTION - Minimum allowed broker count is 3
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the KafkaCluster in.
        :param pulumi.Input[_builtins.str] coordination_type: (Updatable) Kafka coordination type. Set of available types depends on Kafka version
        :param pulumi.Input[_builtins.str] kafka_version: Version of Kafka to use to spin up the cluster
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] client_certificate_bundle: (Updatable) CA certificate bundle for mTLS broker authentication.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        pulumi.set(__self__, "access_subnets", access_subnets)
        pulumi.set(__self__, "broker_shape", broker_shape)
        pulumi.set(__self__, "cluster_config_id", cluster_config_id)
        pulumi.set(__self__, "cluster_config_version", cluster_config_version)
        pulumi.set(__self__, "cluster_type", cluster_type)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "coordination_type", coordination_type)
        pulumi.set(__self__, "kafka_version", kafka_version)
        if client_certificate_bundle is not None:
            pulumi.set(__self__, "client_certificate_bundle", client_certificate_bundle)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)

    @_builtins.property
    @pulumi.getter(name="accessSubnets")
    def access_subnets(self) -> pulumi.Input[Sequence[pulumi.Input['ManagedKafkaKafkaClusterAccessSubnetArgs']]]:
        """
        (Updatable) Subnets where broker/coordinator VNICs will be created.
        """
        return pulumi.get(self, "access_subnets")

    @access_subnets.setter
    def access_subnets(self, value: pulumi.Input[Sequence[pulumi.Input['ManagedKafkaKafkaClusterAccessSubnetArgs']]]):
        pulumi.set(self, "access_subnets", value)

    @_builtins.property
    @pulumi.getter(name="brokerShape")
    def broker_shape(self) -> pulumi.Input['ManagedKafkaKafkaClusterBrokerShapeArgs']:
        """
        (Updatable) Configuration of the broker node.
        """
        return pulumi.get(self, "broker_shape")

    @broker_shape.setter
    def broker_shape(self, value: pulumi.Input['ManagedKafkaKafkaClusterBrokerShapeArgs']):
        pulumi.set(self, "broker_shape", value)

    @_builtins.property
    @pulumi.getter(name="clusterConfigId")
    def cluster_config_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of Kafka Cluster configuration object
        """
        return pulumi.get(self, "cluster_config_id")

    @cluster_config_id.setter
    def cluster_config_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_config_id", value)

    @_builtins.property
    @pulumi.getter(name="clusterConfigVersion")
    def cluster_config_version(self) -> pulumi.Input[_builtins.int]:
        """
        (Updatable) The version of configuration object
        """
        return pulumi.get(self, "cluster_config_version")

    @cluster_config_version.setter
    def cluster_config_version(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "cluster_config_version", value)

    @_builtins.property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of the cluster to spin up.  DEVELOPMENT - setting that allows to sacrifice HA and spin up cluster on single node PRODUCTION - Minimum allowed broker count is 3
        """
        return pulumi.get(self, "cluster_type")

    @cluster_type.setter
    def cluster_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_type", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the KafkaCluster in.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="coordinationType")
    def coordination_type(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) Kafka coordination type. Set of available types depends on Kafka version
        """
        return pulumi.get(self, "coordination_type")

    @coordination_type.setter
    def coordination_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "coordination_type", value)

    @_builtins.property
    @pulumi.getter(name="kafkaVersion")
    def kafka_version(self) -> pulumi.Input[_builtins.str]:
        """
        Version of Kafka to use to spin up the cluster


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "kafka_version")

    @kafka_version.setter
    def kafka_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "kafka_version", value)

    @_builtins.property
    @pulumi.getter(name="clientCertificateBundle")
    def client_certificate_bundle(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) CA certificate bundle for mTLS broker authentication.
        """
        return pulumi.get(self, "client_certificate_bundle")

    @client_certificate_bundle.setter
    def client_certificate_bundle(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_certificate_bundle", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)


@pulumi.input_type
class _ManagedKafkaKafkaClusterState:
    def __init__(__self__, *,
                 access_subnets: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedKafkaKafkaClusterAccessSubnetArgs']]]] = None,
                 broker_shape: Optional[pulumi.Input['ManagedKafkaKafkaClusterBrokerShapeArgs']] = None,
                 client_certificate_bundle: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_config_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_config_version: Optional[pulumi.Input[_builtins.int]] = None,
                 cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 coordination_type: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 kafka_bootstrap_urls: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedKafkaKafkaClusterKafkaBootstrapUrlArgs']]]] = None,
                 kafka_version: Optional[pulumi.Input[_builtins.str]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ManagedKafkaKafkaCluster resources.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedKafkaKafkaClusterAccessSubnetArgs']]] access_subnets: (Updatable) Subnets where broker/coordinator VNICs will be created.
        :param pulumi.Input['ManagedKafkaKafkaClusterBrokerShapeArgs'] broker_shape: (Updatable) Configuration of the broker node.
        :param pulumi.Input[_builtins.str] client_certificate_bundle: (Updatable) CA certificate bundle for mTLS broker authentication.
        :param pulumi.Input[_builtins.str] cluster_config_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of Kafka Cluster configuration object
        :param pulumi.Input[_builtins.int] cluster_config_version: (Updatable) The version of configuration object
        :param pulumi.Input[_builtins.str] cluster_type: Type of the cluster to spin up.  DEVELOPMENT - setting that allows to sacrifice HA and spin up cluster on single node PRODUCTION - Minimum allowed broker count is 3
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the KafkaCluster in.
        :param pulumi.Input[_builtins.str] coordination_type: (Updatable) Kafka coordination type. Set of available types depends on Kafka version
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input['ManagedKafkaKafkaClusterKafkaBootstrapUrlArgs']]] kafka_bootstrap_urls: Bootstrap URL that can be used to connect to Kafka
        :param pulumi.Input[_builtins.str] kafka_version: Version of Kafka to use to spin up the cluster
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] lifecycle_details: A message that describes the current state of the KafkaCluster in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        :param pulumi.Input[_builtins.str] secret_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret that contains superuser password.
        :param pulumi.Input[_builtins.str] state: The current state of the KafkaCluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The date and time the KafkaCluster was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_updated: The date and time the KafkaCluster was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        if access_subnets is not None:
            pulumi.set(__self__, "access_subnets", access_subnets)
        if broker_shape is not None:
            pulumi.set(__self__, "broker_shape", broker_shape)
        if client_certificate_bundle is not None:
            pulumi.set(__self__, "client_certificate_bundle", client_certificate_bundle)
        if cluster_config_id is not None:
            pulumi.set(__self__, "cluster_config_id", cluster_config_id)
        if cluster_config_version is not None:
            pulumi.set(__self__, "cluster_config_version", cluster_config_version)
        if cluster_type is not None:
            pulumi.set(__self__, "cluster_type", cluster_type)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if coordination_type is not None:
            pulumi.set(__self__, "coordination_type", coordination_type)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if kafka_bootstrap_urls is not None:
            pulumi.set(__self__, "kafka_bootstrap_urls", kafka_bootstrap_urls)
        if kafka_version is not None:
            pulumi.set(__self__, "kafka_version", kafka_version)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if secret_id is not None:
            pulumi.set(__self__, "secret_id", secret_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="accessSubnets")
    def access_subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedKafkaKafkaClusterAccessSubnetArgs']]]]:
        """
        (Updatable) Subnets where broker/coordinator VNICs will be created.
        """
        return pulumi.get(self, "access_subnets")

    @access_subnets.setter
    def access_subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedKafkaKafkaClusterAccessSubnetArgs']]]]):
        pulumi.set(self, "access_subnets", value)

    @_builtins.property
    @pulumi.getter(name="brokerShape")
    def broker_shape(self) -> Optional[pulumi.Input['ManagedKafkaKafkaClusterBrokerShapeArgs']]:
        """
        (Updatable) Configuration of the broker node.
        """
        return pulumi.get(self, "broker_shape")

    @broker_shape.setter
    def broker_shape(self, value: Optional[pulumi.Input['ManagedKafkaKafkaClusterBrokerShapeArgs']]):
        pulumi.set(self, "broker_shape", value)

    @_builtins.property
    @pulumi.getter(name="clientCertificateBundle")
    def client_certificate_bundle(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) CA certificate bundle for mTLS broker authentication.
        """
        return pulumi.get(self, "client_certificate_bundle")

    @client_certificate_bundle.setter
    def client_certificate_bundle(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_certificate_bundle", value)

    @_builtins.property
    @pulumi.getter(name="clusterConfigId")
    def cluster_config_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of Kafka Cluster configuration object
        """
        return pulumi.get(self, "cluster_config_id")

    @cluster_config_id.setter
    def cluster_config_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_config_id", value)

    @_builtins.property
    @pulumi.getter(name="clusterConfigVersion")
    def cluster_config_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The version of configuration object
        """
        return pulumi.get(self, "cluster_config_version")

    @cluster_config_version.setter
    def cluster_config_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cluster_config_version", value)

    @_builtins.property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the cluster to spin up.  DEVELOPMENT - setting that allows to sacrifice HA and spin up cluster on single node PRODUCTION - Minimum allowed broker count is 3
        """
        return pulumi.get(self, "cluster_type")

    @cluster_type.setter
    def cluster_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_type", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the KafkaCluster in.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="coordinationType")
    def coordination_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Kafka coordination type. Set of available types depends on Kafka version
        """
        return pulumi.get(self, "coordination_type")

    @coordination_type.setter
    def coordination_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "coordination_type", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="kafkaBootstrapUrls")
    def kafka_bootstrap_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedKafkaKafkaClusterKafkaBootstrapUrlArgs']]]]:
        """
        Bootstrap URL that can be used to connect to Kafka
        """
        return pulumi.get(self, "kafka_bootstrap_urls")

    @kafka_bootstrap_urls.setter
    def kafka_bootstrap_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedKafkaKafkaClusterKafkaBootstrapUrlArgs']]]]):
        pulumi.set(self, "kafka_bootstrap_urls", value)

    @_builtins.property
    @pulumi.getter(name="kafkaVersion")
    def kafka_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version of Kafka to use to spin up the cluster


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "kafka_version")

    @kafka_version.setter
    def kafka_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kafka_version", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message that describes the current state of the KafkaCluster in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret that contains superuser password.
        """
        return pulumi.get(self, "secret_id")

    @secret_id.setter
    def secret_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_id", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the KafkaCluster.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the KafkaCluster was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the KafkaCluster was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:oci/managedKafkaKafkaCluster:ManagedKafkaKafkaCluster")
class ManagedKafkaKafkaCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedKafkaKafkaClusterAccessSubnetArgs', 'ManagedKafkaKafkaClusterAccessSubnetArgsDict']]]]] = None,
                 broker_shape: Optional[pulumi.Input[Union['ManagedKafkaKafkaClusterBrokerShapeArgs', 'ManagedKafkaKafkaClusterBrokerShapeArgsDict']]] = None,
                 client_certificate_bundle: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_config_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_config_version: Optional[pulumi.Input[_builtins.int]] = None,
                 cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 coordination_type: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 kafka_version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_kafka_cluster = oci.oci.ManagedKafkaKafkaCluster("test_kafka_cluster",
            access_subnets=[{
                "subnets": kafka_cluster_access_subnets_subnets,
            }],
            broker_shape={
                "node_count": kafka_cluster_broker_shape_node_count,
                "ocpu_count": kafka_cluster_broker_shape_ocpu_count,
                "storage_size_in_gbs": kafka_cluster_broker_shape_storage_size_in_gbs,
            },
            cluster_config_id=test_config["id"],
            cluster_config_version=kafka_cluster_cluster_config_version,
            cluster_type=kafka_cluster_cluster_type,
            compartment_id=compartment_id,
            coordination_type=kafka_cluster_coordination_type,
            kafka_version=kafka_cluster_kafka_version,
            client_certificate_bundle=kafka_cluster_client_certificate_bundle,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=kafka_cluster_display_name,
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ## Import

        KafkaClusters can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:oci/managedKafkaKafkaCluster:ManagedKafkaKafkaCluster test_kafka_cluster "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagedKafkaKafkaClusterAccessSubnetArgs', 'ManagedKafkaKafkaClusterAccessSubnetArgsDict']]]] access_subnets: (Updatable) Subnets where broker/coordinator VNICs will be created.
        :param pulumi.Input[Union['ManagedKafkaKafkaClusterBrokerShapeArgs', 'ManagedKafkaKafkaClusterBrokerShapeArgsDict']] broker_shape: (Updatable) Configuration of the broker node.
        :param pulumi.Input[_builtins.str] client_certificate_bundle: (Updatable) CA certificate bundle for mTLS broker authentication.
        :param pulumi.Input[_builtins.str] cluster_config_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of Kafka Cluster configuration object
        :param pulumi.Input[_builtins.int] cluster_config_version: (Updatable) The version of configuration object
        :param pulumi.Input[_builtins.str] cluster_type: Type of the cluster to spin up.  DEVELOPMENT - setting that allows to sacrifice HA and spin up cluster on single node PRODUCTION - Minimum allowed broker count is 3
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the KafkaCluster in.
        :param pulumi.Input[_builtins.str] coordination_type: (Updatable) Kafka coordination type. Set of available types depends on Kafka version
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] kafka_version: Version of Kafka to use to spin up the cluster
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedKafkaKafkaClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_kafka_cluster = oci.oci.ManagedKafkaKafkaCluster("test_kafka_cluster",
            access_subnets=[{
                "subnets": kafka_cluster_access_subnets_subnets,
            }],
            broker_shape={
                "node_count": kafka_cluster_broker_shape_node_count,
                "ocpu_count": kafka_cluster_broker_shape_ocpu_count,
                "storage_size_in_gbs": kafka_cluster_broker_shape_storage_size_in_gbs,
            },
            cluster_config_id=test_config["id"],
            cluster_config_version=kafka_cluster_cluster_config_version,
            cluster_type=kafka_cluster_cluster_type,
            compartment_id=compartment_id,
            coordination_type=kafka_cluster_coordination_type,
            kafka_version=kafka_cluster_kafka_version,
            client_certificate_bundle=kafka_cluster_client_certificate_bundle,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=kafka_cluster_display_name,
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ## Import

        KafkaClusters can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:oci/managedKafkaKafkaCluster:ManagedKafkaKafkaCluster test_kafka_cluster "id"
        ```

        :param str resource_name: The name of the resource.
        :param ManagedKafkaKafkaClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedKafkaKafkaClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedKafkaKafkaClusterAccessSubnetArgs', 'ManagedKafkaKafkaClusterAccessSubnetArgsDict']]]]] = None,
                 broker_shape: Optional[pulumi.Input[Union['ManagedKafkaKafkaClusterBrokerShapeArgs', 'ManagedKafkaKafkaClusterBrokerShapeArgsDict']]] = None,
                 client_certificate_bundle: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_config_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_config_version: Optional[pulumi.Input[_builtins.int]] = None,
                 cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 coordination_type: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 kafka_version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedKafkaKafkaClusterArgs.__new__(ManagedKafkaKafkaClusterArgs)

            if access_subnets is None and not opts.urn:
                raise TypeError("Missing required property 'access_subnets'")
            __props__.__dict__["access_subnets"] = access_subnets
            if broker_shape is None and not opts.urn:
                raise TypeError("Missing required property 'broker_shape'")
            __props__.__dict__["broker_shape"] = broker_shape
            __props__.__dict__["client_certificate_bundle"] = client_certificate_bundle
            if cluster_config_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_config_id'")
            __props__.__dict__["cluster_config_id"] = cluster_config_id
            if cluster_config_version is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_config_version'")
            __props__.__dict__["cluster_config_version"] = cluster_config_version
            if cluster_type is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_type'")
            __props__.__dict__["cluster_type"] = cluster_type
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if coordination_type is None and not opts.urn:
                raise TypeError("Missing required property 'coordination_type'")
            __props__.__dict__["coordination_type"] = coordination_type
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            if kafka_version is None and not opts.urn:
                raise TypeError("Missing required property 'kafka_version'")
            __props__.__dict__["kafka_version"] = kafka_version
            __props__.__dict__["kafka_bootstrap_urls"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["secret_id"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(ManagedKafkaKafkaCluster, __self__).__init__(
            'oci:oci/managedKafkaKafkaCluster:ManagedKafkaKafkaCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedKafkaKafkaClusterAccessSubnetArgs', 'ManagedKafkaKafkaClusterAccessSubnetArgsDict']]]]] = None,
            broker_shape: Optional[pulumi.Input[Union['ManagedKafkaKafkaClusterBrokerShapeArgs', 'ManagedKafkaKafkaClusterBrokerShapeArgsDict']]] = None,
            client_certificate_bundle: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_config_id: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_config_version: Optional[pulumi.Input[_builtins.int]] = None,
            cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            coordination_type: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            kafka_bootstrap_urls: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedKafkaKafkaClusterKafkaBootstrapUrlArgs', 'ManagedKafkaKafkaClusterKafkaBootstrapUrlArgsDict']]]]] = None,
            kafka_version: Optional[pulumi.Input[_builtins.str]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            secret_id: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None) -> 'ManagedKafkaKafkaCluster':
        """
        Get an existing ManagedKafkaKafkaCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagedKafkaKafkaClusterAccessSubnetArgs', 'ManagedKafkaKafkaClusterAccessSubnetArgsDict']]]] access_subnets: (Updatable) Subnets where broker/coordinator VNICs will be created.
        :param pulumi.Input[Union['ManagedKafkaKafkaClusterBrokerShapeArgs', 'ManagedKafkaKafkaClusterBrokerShapeArgsDict']] broker_shape: (Updatable) Configuration of the broker node.
        :param pulumi.Input[_builtins.str] client_certificate_bundle: (Updatable) CA certificate bundle for mTLS broker authentication.
        :param pulumi.Input[_builtins.str] cluster_config_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of Kafka Cluster configuration object
        :param pulumi.Input[_builtins.int] cluster_config_version: (Updatable) The version of configuration object
        :param pulumi.Input[_builtins.str] cluster_type: Type of the cluster to spin up.  DEVELOPMENT - setting that allows to sacrifice HA and spin up cluster on single node PRODUCTION - Minimum allowed broker count is 3
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the KafkaCluster in.
        :param pulumi.Input[_builtins.str] coordination_type: (Updatable) Kafka coordination type. Set of available types depends on Kafka version
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagedKafkaKafkaClusterKafkaBootstrapUrlArgs', 'ManagedKafkaKafkaClusterKafkaBootstrapUrlArgsDict']]]] kafka_bootstrap_urls: Bootstrap URL that can be used to connect to Kafka
        :param pulumi.Input[_builtins.str] kafka_version: Version of Kafka to use to spin up the cluster
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] lifecycle_details: A message that describes the current state of the KafkaCluster in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        :param pulumi.Input[_builtins.str] secret_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret that contains superuser password.
        :param pulumi.Input[_builtins.str] state: The current state of the KafkaCluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The date and time the KafkaCluster was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_updated: The date and time the KafkaCluster was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagedKafkaKafkaClusterState.__new__(_ManagedKafkaKafkaClusterState)

        __props__.__dict__["access_subnets"] = access_subnets
        __props__.__dict__["broker_shape"] = broker_shape
        __props__.__dict__["client_certificate_bundle"] = client_certificate_bundle
        __props__.__dict__["cluster_config_id"] = cluster_config_id
        __props__.__dict__["cluster_config_version"] = cluster_config_version
        __props__.__dict__["cluster_type"] = cluster_type
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["coordination_type"] = coordination_type
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["kafka_bootstrap_urls"] = kafka_bootstrap_urls
        __props__.__dict__["kafka_version"] = kafka_version
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["secret_id"] = secret_id
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return ManagedKafkaKafkaCluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessSubnets")
    def access_subnets(self) -> pulumi.Output[Sequence['outputs.ManagedKafkaKafkaClusterAccessSubnet']]:
        """
        (Updatable) Subnets where broker/coordinator VNICs will be created.
        """
        return pulumi.get(self, "access_subnets")

    @_builtins.property
    @pulumi.getter(name="brokerShape")
    def broker_shape(self) -> pulumi.Output['outputs.ManagedKafkaKafkaClusterBrokerShape']:
        """
        (Updatable) Configuration of the broker node.
        """
        return pulumi.get(self, "broker_shape")

    @_builtins.property
    @pulumi.getter(name="clientCertificateBundle")
    def client_certificate_bundle(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) CA certificate bundle for mTLS broker authentication.
        """
        return pulumi.get(self, "client_certificate_bundle")

    @_builtins.property
    @pulumi.getter(name="clusterConfigId")
    def cluster_config_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of Kafka Cluster configuration object
        """
        return pulumi.get(self, "cluster_config_id")

    @_builtins.property
    @pulumi.getter(name="clusterConfigVersion")
    def cluster_config_version(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) The version of configuration object
        """
        return pulumi.get(self, "cluster_config_version")

    @_builtins.property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of the cluster to spin up.  DEVELOPMENT - setting that allows to sacrifice HA and spin up cluster on single node PRODUCTION - Minimum allowed broker count is 3
        """
        return pulumi.get(self, "cluster_type")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the KafkaCluster in.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="coordinationType")
    def coordination_type(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Kafka coordination type. Set of available types depends on Kafka version
        """
        return pulumi.get(self, "coordination_type")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="kafkaBootstrapUrls")
    def kafka_bootstrap_urls(self) -> pulumi.Output[Sequence['outputs.ManagedKafkaKafkaClusterKafkaBootstrapUrl']]:
        """
        Bootstrap URL that can be used to connect to Kafka
        """
        return pulumi.get(self, "kafka_bootstrap_urls")

    @_builtins.property
    @pulumi.getter(name="kafkaVersion")
    def kafka_version(self) -> pulumi.Output[_builtins.str]:
        """
        Version of Kafka to use to spin up the cluster


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "kafka_version")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        A message that describes the current state of the KafkaCluster in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret that contains superuser password.
        """
        return pulumi.get(self, "secret_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the KafkaCluster.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the KafkaCluster was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the KafkaCluster was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

