# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetDatastoreClusterResult',
    'AwaitableGetDatastoreClusterResult',
    'get_datastore_cluster',
    'get_datastore_cluster_output',
]

@pulumi.output_type
class GetDatastoreClusterResult:
    """
    A collection of values returned by getDatastoreCluster.
    """
    def __init__(__self__, availability_domain=None, capacity_in_gbs=None, cluster_id=None, compartment_id=None, datastore_cluster_id=None, datastore_cluster_type=None, datastore_ids=None, defined_tags=None, display_name=None, esxi_host_ids=None, freeform_tags=None, id=None, sddc_id=None, state=None, system_tags=None, time_created=None, time_updated=None):
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if capacity_in_gbs and not isinstance(capacity_in_gbs, float):
            raise TypeError("Expected argument 'capacity_in_gbs' to be a float")
        pulumi.set(__self__, "capacity_in_gbs", capacity_in_gbs)
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if datastore_cluster_id and not isinstance(datastore_cluster_id, str):
            raise TypeError("Expected argument 'datastore_cluster_id' to be a str")
        pulumi.set(__self__, "datastore_cluster_id", datastore_cluster_id)
        if datastore_cluster_type and not isinstance(datastore_cluster_type, str):
            raise TypeError("Expected argument 'datastore_cluster_type' to be a str")
        pulumi.set(__self__, "datastore_cluster_type", datastore_cluster_type)
        if datastore_ids and not isinstance(datastore_ids, list):
            raise TypeError("Expected argument 'datastore_ids' to be a list")
        pulumi.set(__self__, "datastore_ids", datastore_ids)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if esxi_host_ids and not isinstance(esxi_host_ids, list):
            raise TypeError("Expected argument 'esxi_host_ids' to be a list")
        pulumi.set(__self__, "esxi_host_ids", esxi_host_ids)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if sddc_id and not isinstance(sddc_id, str):
            raise TypeError("Expected argument 'sddc_id' to be a str")
        pulumi.set(__self__, "sddc_id", sddc_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> _builtins.str:
        """
        The availability domain of the Datastore Cluster.
        """
        return pulumi.get(self, "availability_domain")

    @_builtins.property
    @pulumi.getter(name="capacityInGbs")
    def capacity_in_gbs(self) -> _builtins.float:
        """
        Total size of all datastores associated with the datastore cluster in GB.
        """
        return pulumi.get(self, "capacity_in_gbs")

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VMware Cluster that Datastore cluster is attached to.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the Datastore.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="datastoreClusterId")
    def datastore_cluster_id(self) -> _builtins.str:
        return pulumi.get(self, "datastore_cluster_id")

    @_builtins.property
    @pulumi.getter(name="datastoreClusterType")
    def datastore_cluster_type(self) -> _builtins.str:
        """
        Type of the datastore cluster.
        """
        return pulumi.get(self, "datastore_cluster_type")

    @_builtins.property
    @pulumi.getter(name="datastoreIds")
    def datastore_ids(self) -> Sequence[_builtins.str]:
        """
        The [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Datastores that belong to the Datastore Cluster
        """
        return pulumi.get(self, "datastore_ids")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A descriptive name for the Datastore Cluster. It must be unique within a SDDC, start with a letter, and contain only letters, digits, whitespaces, dashes and underscores. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="esxiHostIds")
    def esxi_host_ids(self) -> Sequence[_builtins.str]:
        """
        The [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ESXi hosts to attach the datastore to. All ESXi hosts must belong to the same VMware cluster.
        """
        return pulumi.get(self, "esxi_host_ids")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Datastore cluster.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="sddcId")
    def sddc_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the SDDC that Datastore cluster is associated with.
        """
        return pulumi.get(self, "sddc_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the Datastore Cluster.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{orcl-cloud: {free-tier-retain: true}}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the Datastore Cluster was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time the Datastore Cluster was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetDatastoreClusterResult(GetDatastoreClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatastoreClusterResult(
            availability_domain=self.availability_domain,
            capacity_in_gbs=self.capacity_in_gbs,
            cluster_id=self.cluster_id,
            compartment_id=self.compartment_id,
            datastore_cluster_id=self.datastore_cluster_id,
            datastore_cluster_type=self.datastore_cluster_type,
            datastore_ids=self.datastore_ids,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            esxi_host_ids=self.esxi_host_ids,
            freeform_tags=self.freeform_tags,
            id=self.id,
            sddc_id=self.sddc_id,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_datastore_cluster(datastore_cluster_id: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatastoreClusterResult:
    """
    This data source provides details about a specific Datastore Cluster resource in Oracle Cloud Infrastructure Oracle Cloud VMware Solution service.

    Get the specified Datastore Cluster information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_datastore_cluster = oci.Ocvp.get_datastore_cluster(datastore_cluster_id=test_datastore_cluster_oci_ocvp_datastore_cluster["id"])
    ```


    :param _builtins.str datastore_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Datastore Cluster.
    """
    __args__ = dict()
    __args__['datastoreClusterId'] = datastore_cluster_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Ocvp/getDatastoreCluster:getDatastoreCluster', __args__, opts=opts, typ=GetDatastoreClusterResult).value

    return AwaitableGetDatastoreClusterResult(
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        capacity_in_gbs=pulumi.get(__ret__, 'capacity_in_gbs'),
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        datastore_cluster_id=pulumi.get(__ret__, 'datastore_cluster_id'),
        datastore_cluster_type=pulumi.get(__ret__, 'datastore_cluster_type'),
        datastore_ids=pulumi.get(__ret__, 'datastore_ids'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        esxi_host_ids=pulumi.get(__ret__, 'esxi_host_ids'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        sddc_id=pulumi.get(__ret__, 'sddc_id'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_datastore_cluster_output(datastore_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDatastoreClusterResult]:
    """
    This data source provides details about a specific Datastore Cluster resource in Oracle Cloud Infrastructure Oracle Cloud VMware Solution service.

    Get the specified Datastore Cluster information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_datastore_cluster = oci.Ocvp.get_datastore_cluster(datastore_cluster_id=test_datastore_cluster_oci_ocvp_datastore_cluster["id"])
    ```


    :param _builtins.str datastore_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Datastore Cluster.
    """
    __args__ = dict()
    __args__['datastoreClusterId'] = datastore_cluster_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Ocvp/getDatastoreCluster:getDatastoreCluster', __args__, opts=opts, typ=GetDatastoreClusterResult)
    return __ret__.apply(lambda __response__: GetDatastoreClusterResult(
        availability_domain=pulumi.get(__response__, 'availability_domain'),
        capacity_in_gbs=pulumi.get(__response__, 'capacity_in_gbs'),
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        datastore_cluster_id=pulumi.get(__response__, 'datastore_cluster_id'),
        datastore_cluster_type=pulumi.get(__response__, 'datastore_cluster_type'),
        datastore_ids=pulumi.get(__response__, 'datastore_ids'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        esxi_host_ids=pulumi.get(__response__, 'esxi_host_ids'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        sddc_id=pulumi.get(__response__, 'sddc_id'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
