# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDatastoresResult',
    'AwaitableGetDatastoresResult',
    'get_datastores',
    'get_datastores_output',
]

@pulumi.output_type
class GetDatastoresResult:
    """
    A collection of values returned by getDatastores.
    """
    def __init__(__self__, cluster_id=None, compartment_id=None, datastore_collections=None, datastore_id=None, display_name=None, filters=None, id=None, state=None):
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if datastore_collections and not isinstance(datastore_collections, list):
            raise TypeError("Expected argument 'datastore_collections' to be a list")
        pulumi.set(__self__, "datastore_collections", datastore_collections)
        if datastore_id and not isinstance(datastore_id, str):
            raise TypeError("Expected argument 'datastore_id' to be a str")
        pulumi.set(__self__, "datastore_id", datastore_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VMware Cluster that Datastore is attached to.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the Datastore.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="datastoreCollections")
    def datastore_collections(self) -> Sequence['outputs.GetDatastoresDatastoreCollectionResult']:
        """
        The list of datastore_collection.
        """
        return pulumi.get(self, "datastore_collections")

    @_builtins.property
    @pulumi.getter(name="datastoreId")
    def datastore_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "datastore_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        A descriptive name for the Datastore. It must be unique within a SDDC, start with a letter, and contain only letters, digits, whitespaces, dashes and underscores. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDatastoresFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the Datastore.
        """
        return pulumi.get(self, "state")


class AwaitableGetDatastoresResult(GetDatastoresResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatastoresResult(
            cluster_id=self.cluster_id,
            compartment_id=self.compartment_id,
            datastore_collections=self.datastore_collections,
            datastore_id=self.datastore_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            state=self.state)


def get_datastores(cluster_id: Optional[_builtins.str] = None,
                   compartment_id: Optional[_builtins.str] = None,
                   datastore_id: Optional[_builtins.str] = None,
                   display_name: Optional[_builtins.str] = None,
                   filters: Optional[Sequence[Union['GetDatastoresFilterArgs', 'GetDatastoresFilterArgsDict']]] = None,
                   state: Optional[_builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatastoresResult:
    """
    This data source provides the list of Datastores in Oracle Cloud Infrastructure Oracle Cloud VMware Solution service.

    List the Datastores in the specified compartment. The list can be filtered
    by compartment, datastore id, display name and lifecycle state.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_datastores = oci.Ocvp.get_datastores(compartment_id=compartment_id,
        cluster_id=test_cluster["id"],
        datastore_id=test_datastore["id"],
        display_name=datastore_display_name,
        state=datastore_state)
    ```


    :param _builtins.str cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the SDDC Cluster.
    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param _builtins.str datastore_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Datastore.
    :param _builtins.str display_name: A filter to return only resources that match the given display name exactly.
    :param _builtins.str state: The lifecycle state of the resource.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['compartmentId'] = compartment_id
    __args__['datastoreId'] = datastore_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Ocvp/getDatastores:getDatastores', __args__, opts=opts, typ=GetDatastoresResult).value

    return AwaitableGetDatastoresResult(
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        datastore_collections=pulumi.get(__ret__, 'datastore_collections'),
        datastore_id=pulumi.get(__ret__, 'datastore_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))
def get_datastores_output(cluster_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                          datastore_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          filters: Optional[pulumi.Input[Optional[Sequence[Union['GetDatastoresFilterArgs', 'GetDatastoresFilterArgsDict']]]]] = None,
                          state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDatastoresResult]:
    """
    This data source provides the list of Datastores in Oracle Cloud Infrastructure Oracle Cloud VMware Solution service.

    List the Datastores in the specified compartment. The list can be filtered
    by compartment, datastore id, display name and lifecycle state.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_datastores = oci.Ocvp.get_datastores(compartment_id=compartment_id,
        cluster_id=test_cluster["id"],
        datastore_id=test_datastore["id"],
        display_name=datastore_display_name,
        state=datastore_state)
    ```


    :param _builtins.str cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the SDDC Cluster.
    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param _builtins.str datastore_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Datastore.
    :param _builtins.str display_name: A filter to return only resources that match the given display name exactly.
    :param _builtins.str state: The lifecycle state of the resource.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['compartmentId'] = compartment_id
    __args__['datastoreId'] = datastore_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Ocvp/getDatastores:getDatastores', __args__, opts=opts, typ=GetDatastoresResult)
    return __ret__.apply(lambda __response__: GetDatastoresResult(
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        datastore_collections=pulumi.get(__response__, 'datastore_collections'),
        datastore_id=pulumi.get(__response__, 'datastore_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state')))
