# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 data_node_count: pulumi.Input[_builtins.int],
                 data_node_host_memory_gb: pulumi.Input[_builtins.int],
                 data_node_host_ocpu_count: pulumi.Input[_builtins.int],
                 data_node_host_type: pulumi.Input[_builtins.str],
                 data_node_storage_gb: pulumi.Input[_builtins.int],
                 display_name: pulumi.Input[_builtins.str],
                 master_node_count: pulumi.Input[_builtins.int],
                 master_node_host_memory_gb: pulumi.Input[_builtins.int],
                 master_node_host_ocpu_count: pulumi.Input[_builtins.int],
                 master_node_host_type: pulumi.Input[_builtins.str],
                 opendashboard_node_count: pulumi.Input[_builtins.int],
                 opendashboard_node_host_memory_gb: pulumi.Input[_builtins.int],
                 opendashboard_node_host_ocpu_count: pulumi.Input[_builtins.int],
                 software_version: pulumi.Input[_builtins.str],
                 subnet_compartment_id: pulumi.Input[_builtins.str],
                 subnet_id: pulumi.Input[_builtins.str],
                 vcn_compartment_id: pulumi.Input[_builtins.str],
                 vcn_id: pulumi.Input[_builtins.str],
                 certificate_config: Optional[pulumi.Input['ClusterCertificateConfigArgs']] = None,
                 configure_outbound_cluster_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 data_node_host_bare_metal_shape: Optional[pulumi.Input[_builtins.str]] = None,
                 data_node_host_shape: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 inbound_cluster_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 maintenance_details: Optional[pulumi.Input['ClusterMaintenanceDetailsArgs']] = None,
                 master_node_host_bare_metal_shape: Optional[pulumi.Input[_builtins.str]] = None,
                 master_node_host_shape: Optional[pulumi.Input[_builtins.str]] = None,
                 nsg_id: Optional[pulumi.Input[_builtins.str]] = None,
                 opendashboard_node_host_shape: Optional[pulumi.Input[_builtins.str]] = None,
                 outbound_cluster_config: Optional[pulumi.Input['ClusterOutboundClusterConfigArgs']] = None,
                 reverse_connection_endpoint_customer_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 search_node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 search_node_host_memory_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 search_node_host_ocpu_count: Optional[pulumi.Input[_builtins.int]] = None,
                 search_node_host_shape: Optional[pulumi.Input[_builtins.str]] = None,
                 search_node_host_type: Optional[pulumi.Input[_builtins.str]] = None,
                 search_node_storage_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 security_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 security_master_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 security_master_user_password_hash: Optional[pulumi.Input[_builtins.str]] = None,
                 security_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 security_saml_config: Optional[pulumi.Input['ClusterSecuritySamlConfigArgs']] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 upgrade_major_version_trigger: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input[_builtins.str] compartment_id: The OCID of the compartment to create the cluster in.
        :param pulumi.Input[_builtins.int] data_node_count: (Updatable) The number of data nodes to configure for the cluster.
        :param pulumi.Input[_builtins.int] data_node_host_memory_gb: (Updatable) The amount of memory in GB, to configure per node for the cluster's data nodes.
        :param pulumi.Input[_builtins.int] data_node_host_ocpu_count: (Updatable) The number of OCPUs to configure for the cluster's data nodes.
        :param pulumi.Input[_builtins.str] data_node_host_type: TThe instance type for the cluster's data nodes.
        :param pulumi.Input[_builtins.int] data_node_storage_gb: (Updatable) The amount of storage in GB, to configure per node for the cluster's data nodes.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The name of the cluster. Avoid entering confidential information.
        :param pulumi.Input[_builtins.int] master_node_count: (Updatable) The number of master nodes to configure for the cluster.
        :param pulumi.Input[_builtins.int] master_node_host_memory_gb: (Updatable) The amount of memory in GB, to configure per node for the cluster's master nodes.
        :param pulumi.Input[_builtins.int] master_node_host_ocpu_count: (Updatable) The number of OCPUs to configure for the cluser's master nodes.
        :param pulumi.Input[_builtins.str] master_node_host_type: The instance type for the cluster's master nodes.
        :param pulumi.Input[_builtins.int] opendashboard_node_count: (Updatable) The number of OpenSearch Dashboard nodes to configure for the cluster.
        :param pulumi.Input[_builtins.int] opendashboard_node_host_memory_gb: (Updatable) The amount of memory in GB, to configure for the cluster's OpenSearch Dashboard nodes.
        :param pulumi.Input[_builtins.int] opendashboard_node_host_ocpu_count: (Updatable) The number of OCPUs to configure for the cluster's OpenSearch Dashboard nodes.
        :param pulumi.Input[_builtins.str] software_version: (Updatable) The version of the software the cluster is running.
        :param pulumi.Input[_builtins.str] subnet_compartment_id: The OCID for the compartment where the cluster's subnet is located.
        :param pulumi.Input[_builtins.str] subnet_id: The OCID of the cluster's subnet.
        :param pulumi.Input[_builtins.str] vcn_compartment_id: The OCID for the compartment where the cluster's VCN is located.
        :param pulumi.Input[_builtins.str] vcn_id: The OCID of the cluster's VCN.
        :param pulumi.Input['ClusterCertificateConfigArgs'] certificate_config: (Updatable) Custom certificate config for customer provided certs.
        :param pulumi.Input[_builtins.int] configure_outbound_cluster_trigger: (Updatable) An optional property when incremented triggers Configure Outbound Cluster. Could be set to any integer value.
        :param pulumi.Input[_builtins.str] data_node_host_bare_metal_shape: The bare metal shape for the cluster's data nodes.
        :param pulumi.Input[_builtins.str] data_node_host_shape: (Updatable) The node shape for the cluster's data nodes.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] inbound_cluster_ids: List of inbound clusters that will be queried using cross cluster search
        :param pulumi.Input['ClusterMaintenanceDetailsArgs'] maintenance_details: (Updatable) Details for creation of maintenance details
        :param pulumi.Input[_builtins.str] master_node_host_bare_metal_shape: The bare metal shape for the cluster's master nodes.
        :param pulumi.Input[_builtins.str] master_node_host_shape: (Updatable) The node shape for the cluster's master nodes.
        :param pulumi.Input[_builtins.str] nsg_id: The OCID of the NSG where the private endpoint vnic will be attached.
        :param pulumi.Input[_builtins.str] opendashboard_node_host_shape: (Updatable) The node shape for the cluster's OpenSearch Dashboard nodes.
        :param pulumi.Input['ClusterOutboundClusterConfigArgs'] outbound_cluster_config: (Updatable) This configuration is used for passing request details to connect outbound cluster(s) to the inbound cluster (coordinating cluster)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] reverse_connection_endpoint_customer_ips: (Updatable) The customer IP addresses of the endpoint in customer VCN
        :param pulumi.Input[_builtins.int] search_node_count: (Updatable) The number of search nodes configured for the cluster.
        :param pulumi.Input[_builtins.int] search_node_host_memory_gb: (Updatable) The amount of memory in GB, for the cluster's search nodes.
        :param pulumi.Input[_builtins.int] search_node_host_ocpu_count: (Updatable) The number of OCPUs configured for the cluster's search nodes.
        :param pulumi.Input[_builtins.str] search_node_host_shape: (Updatable) The node shape for the cluster's search nodes.
        :param pulumi.Input[_builtins.str] search_node_host_type: The instance type for the cluster's search nodes.
        :param pulumi.Input[_builtins.int] search_node_storage_gb: (Updatable) The amount of storage in GB, to configure per node for the cluster's search nodes.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] security_attributes: (Updatable) Security attributes for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Oracle-ZPR": {"MaxEgressCount": {"value": "42", "mode": "enforce"}}}`
        :param pulumi.Input[_builtins.str] security_master_user_name: (Updatable) The name of the master user that are used to manage security config
        :param pulumi.Input[_builtins.str] security_master_user_password_hash: (Updatable) The password hash of the master user that are used to manage security config
        :param pulumi.Input[_builtins.str] security_mode: (Updatable) The security mode of the cluster.
        :param pulumi.Input['ClusterSecuritySamlConfigArgs'] security_saml_config: SAML policy is optionally used for Opensearch cluster to config SAML authentication
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.int] upgrade_major_version_trigger: An optional property to upgrade the major version of the cluster. This workflow upgrades the cluster without creating a clone. If you want to create a clone and upgrade the clone for testing please use SDK or CLI.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "data_node_count", data_node_count)
        pulumi.set(__self__, "data_node_host_memory_gb", data_node_host_memory_gb)
        pulumi.set(__self__, "data_node_host_ocpu_count", data_node_host_ocpu_count)
        pulumi.set(__self__, "data_node_host_type", data_node_host_type)
        pulumi.set(__self__, "data_node_storage_gb", data_node_storage_gb)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "master_node_count", master_node_count)
        pulumi.set(__self__, "master_node_host_memory_gb", master_node_host_memory_gb)
        pulumi.set(__self__, "master_node_host_ocpu_count", master_node_host_ocpu_count)
        pulumi.set(__self__, "master_node_host_type", master_node_host_type)
        pulumi.set(__self__, "opendashboard_node_count", opendashboard_node_count)
        pulumi.set(__self__, "opendashboard_node_host_memory_gb", opendashboard_node_host_memory_gb)
        pulumi.set(__self__, "opendashboard_node_host_ocpu_count", opendashboard_node_host_ocpu_count)
        pulumi.set(__self__, "software_version", software_version)
        pulumi.set(__self__, "subnet_compartment_id", subnet_compartment_id)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "vcn_compartment_id", vcn_compartment_id)
        pulumi.set(__self__, "vcn_id", vcn_id)
        if certificate_config is not None:
            pulumi.set(__self__, "certificate_config", certificate_config)
        if configure_outbound_cluster_trigger is not None:
            pulumi.set(__self__, "configure_outbound_cluster_trigger", configure_outbound_cluster_trigger)
        if data_node_host_bare_metal_shape is not None:
            pulumi.set(__self__, "data_node_host_bare_metal_shape", data_node_host_bare_metal_shape)
        if data_node_host_shape is not None:
            pulumi.set(__self__, "data_node_host_shape", data_node_host_shape)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if inbound_cluster_ids is not None:
            pulumi.set(__self__, "inbound_cluster_ids", inbound_cluster_ids)
        if maintenance_details is not None:
            pulumi.set(__self__, "maintenance_details", maintenance_details)
        if master_node_host_bare_metal_shape is not None:
            pulumi.set(__self__, "master_node_host_bare_metal_shape", master_node_host_bare_metal_shape)
        if master_node_host_shape is not None:
            pulumi.set(__self__, "master_node_host_shape", master_node_host_shape)
        if nsg_id is not None:
            pulumi.set(__self__, "nsg_id", nsg_id)
        if opendashboard_node_host_shape is not None:
            pulumi.set(__self__, "opendashboard_node_host_shape", opendashboard_node_host_shape)
        if outbound_cluster_config is not None:
            pulumi.set(__self__, "outbound_cluster_config", outbound_cluster_config)
        if reverse_connection_endpoint_customer_ips is not None:
            pulumi.set(__self__, "reverse_connection_endpoint_customer_ips", reverse_connection_endpoint_customer_ips)
        if search_node_count is not None:
            pulumi.set(__self__, "search_node_count", search_node_count)
        if search_node_host_memory_gb is not None:
            pulumi.set(__self__, "search_node_host_memory_gb", search_node_host_memory_gb)
        if search_node_host_ocpu_count is not None:
            pulumi.set(__self__, "search_node_host_ocpu_count", search_node_host_ocpu_count)
        if search_node_host_shape is not None:
            pulumi.set(__self__, "search_node_host_shape", search_node_host_shape)
        if search_node_host_type is not None:
            pulumi.set(__self__, "search_node_host_type", search_node_host_type)
        if search_node_storage_gb is not None:
            pulumi.set(__self__, "search_node_storage_gb", search_node_storage_gb)
        if security_attributes is not None:
            pulumi.set(__self__, "security_attributes", security_attributes)
        if security_master_user_name is not None:
            pulumi.set(__self__, "security_master_user_name", security_master_user_name)
        if security_master_user_password_hash is not None:
            pulumi.set(__self__, "security_master_user_password_hash", security_master_user_password_hash)
        if security_mode is not None:
            pulumi.set(__self__, "security_mode", security_mode)
        if security_saml_config is not None:
            pulumi.set(__self__, "security_saml_config", security_saml_config)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if upgrade_major_version_trigger is not None:
            pulumi.set(__self__, "upgrade_major_version_trigger", upgrade_major_version_trigger)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        The OCID of the compartment to create the cluster in.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="dataNodeCount")
    def data_node_count(self) -> pulumi.Input[_builtins.int]:
        """
        (Updatable) The number of data nodes to configure for the cluster.
        """
        return pulumi.get(self, "data_node_count")

    @data_node_count.setter
    def data_node_count(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "data_node_count", value)

    @_builtins.property
    @pulumi.getter(name="dataNodeHostMemoryGb")
    def data_node_host_memory_gb(self) -> pulumi.Input[_builtins.int]:
        """
        (Updatable) The amount of memory in GB, to configure per node for the cluster's data nodes.
        """
        return pulumi.get(self, "data_node_host_memory_gb")

    @data_node_host_memory_gb.setter
    def data_node_host_memory_gb(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "data_node_host_memory_gb", value)

    @_builtins.property
    @pulumi.getter(name="dataNodeHostOcpuCount")
    def data_node_host_ocpu_count(self) -> pulumi.Input[_builtins.int]:
        """
        (Updatable) The number of OCPUs to configure for the cluster's data nodes.
        """
        return pulumi.get(self, "data_node_host_ocpu_count")

    @data_node_host_ocpu_count.setter
    def data_node_host_ocpu_count(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "data_node_host_ocpu_count", value)

    @_builtins.property
    @pulumi.getter(name="dataNodeHostType")
    def data_node_host_type(self) -> pulumi.Input[_builtins.str]:
        """
        TThe instance type for the cluster's data nodes.
        """
        return pulumi.get(self, "data_node_host_type")

    @data_node_host_type.setter
    def data_node_host_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "data_node_host_type", value)

    @_builtins.property
    @pulumi.getter(name="dataNodeStorageGb")
    def data_node_storage_gb(self) -> pulumi.Input[_builtins.int]:
        """
        (Updatable) The amount of storage in GB, to configure per node for the cluster's data nodes.
        """
        return pulumi.get(self, "data_node_storage_gb")

    @data_node_storage_gb.setter
    def data_node_storage_gb(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "data_node_storage_gb", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The name of the cluster. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="masterNodeCount")
    def master_node_count(self) -> pulumi.Input[_builtins.int]:
        """
        (Updatable) The number of master nodes to configure for the cluster.
        """
        return pulumi.get(self, "master_node_count")

    @master_node_count.setter
    def master_node_count(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "master_node_count", value)

    @_builtins.property
    @pulumi.getter(name="masterNodeHostMemoryGb")
    def master_node_host_memory_gb(self) -> pulumi.Input[_builtins.int]:
        """
        (Updatable) The amount of memory in GB, to configure per node for the cluster's master nodes.
        """
        return pulumi.get(self, "master_node_host_memory_gb")

    @master_node_host_memory_gb.setter
    def master_node_host_memory_gb(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "master_node_host_memory_gb", value)

    @_builtins.property
    @pulumi.getter(name="masterNodeHostOcpuCount")
    def master_node_host_ocpu_count(self) -> pulumi.Input[_builtins.int]:
        """
        (Updatable) The number of OCPUs to configure for the cluser's master nodes.
        """
        return pulumi.get(self, "master_node_host_ocpu_count")

    @master_node_host_ocpu_count.setter
    def master_node_host_ocpu_count(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "master_node_host_ocpu_count", value)

    @_builtins.property
    @pulumi.getter(name="masterNodeHostType")
    def master_node_host_type(self) -> pulumi.Input[_builtins.str]:
        """
        The instance type for the cluster's master nodes.
        """
        return pulumi.get(self, "master_node_host_type")

    @master_node_host_type.setter
    def master_node_host_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "master_node_host_type", value)

    @_builtins.property
    @pulumi.getter(name="opendashboardNodeCount")
    def opendashboard_node_count(self) -> pulumi.Input[_builtins.int]:
        """
        (Updatable) The number of OpenSearch Dashboard nodes to configure for the cluster.
        """
        return pulumi.get(self, "opendashboard_node_count")

    @opendashboard_node_count.setter
    def opendashboard_node_count(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "opendashboard_node_count", value)

    @_builtins.property
    @pulumi.getter(name="opendashboardNodeHostMemoryGb")
    def opendashboard_node_host_memory_gb(self) -> pulumi.Input[_builtins.int]:
        """
        (Updatable) The amount of memory in GB, to configure for the cluster's OpenSearch Dashboard nodes.
        """
        return pulumi.get(self, "opendashboard_node_host_memory_gb")

    @opendashboard_node_host_memory_gb.setter
    def opendashboard_node_host_memory_gb(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "opendashboard_node_host_memory_gb", value)

    @_builtins.property
    @pulumi.getter(name="opendashboardNodeHostOcpuCount")
    def opendashboard_node_host_ocpu_count(self) -> pulumi.Input[_builtins.int]:
        """
        (Updatable) The number of OCPUs to configure for the cluster's OpenSearch Dashboard nodes.
        """
        return pulumi.get(self, "opendashboard_node_host_ocpu_count")

    @opendashboard_node_host_ocpu_count.setter
    def opendashboard_node_host_ocpu_count(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "opendashboard_node_host_ocpu_count", value)

    @_builtins.property
    @pulumi.getter(name="softwareVersion")
    def software_version(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The version of the software the cluster is running.
        """
        return pulumi.get(self, "software_version")

    @software_version.setter
    def software_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "software_version", value)

    @_builtins.property
    @pulumi.getter(name="subnetCompartmentId")
    def subnet_compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        The OCID for the compartment where the cluster's subnet is located.
        """
        return pulumi.get(self, "subnet_compartment_id")

    @subnet_compartment_id.setter
    def subnet_compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subnet_compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[_builtins.str]:
        """
        The OCID of the cluster's subnet.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="vcnCompartmentId")
    def vcn_compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        The OCID for the compartment where the cluster's VCN is located.
        """
        return pulumi.get(self, "vcn_compartment_id")

    @vcn_compartment_id.setter
    def vcn_compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vcn_compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> pulumi.Input[_builtins.str]:
        """
        The OCID of the cluster's VCN.
        """
        return pulumi.get(self, "vcn_id")

    @vcn_id.setter
    def vcn_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vcn_id", value)

    @_builtins.property
    @pulumi.getter(name="certificateConfig")
    def certificate_config(self) -> Optional[pulumi.Input['ClusterCertificateConfigArgs']]:
        """
        (Updatable) Custom certificate config for customer provided certs.
        """
        return pulumi.get(self, "certificate_config")

    @certificate_config.setter
    def certificate_config(self, value: Optional[pulumi.Input['ClusterCertificateConfigArgs']]):
        pulumi.set(self, "certificate_config", value)

    @_builtins.property
    @pulumi.getter(name="configureOutboundClusterTrigger")
    def configure_outbound_cluster_trigger(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Configure Outbound Cluster. Could be set to any integer value.
        """
        return pulumi.get(self, "configure_outbound_cluster_trigger")

    @configure_outbound_cluster_trigger.setter
    def configure_outbound_cluster_trigger(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "configure_outbound_cluster_trigger", value)

    @_builtins.property
    @pulumi.getter(name="dataNodeHostBareMetalShape")
    def data_node_host_bare_metal_shape(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The bare metal shape for the cluster's data nodes.
        """
        return pulumi.get(self, "data_node_host_bare_metal_shape")

    @data_node_host_bare_metal_shape.setter
    def data_node_host_bare_metal_shape(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_node_host_bare_metal_shape", value)

    @_builtins.property
    @pulumi.getter(name="dataNodeHostShape")
    def data_node_host_shape(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The node shape for the cluster's data nodes.
        """
        return pulumi.get(self, "data_node_host_shape")

    @data_node_host_shape.setter
    def data_node_host_shape(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_node_host_shape", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="inboundClusterIds")
    def inbound_cluster_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of inbound clusters that will be queried using cross cluster search
        """
        return pulumi.get(self, "inbound_cluster_ids")

    @inbound_cluster_ids.setter
    def inbound_cluster_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "inbound_cluster_ids", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceDetails")
    def maintenance_details(self) -> Optional[pulumi.Input['ClusterMaintenanceDetailsArgs']]:
        """
        (Updatable) Details for creation of maintenance details
        """
        return pulumi.get(self, "maintenance_details")

    @maintenance_details.setter
    def maintenance_details(self, value: Optional[pulumi.Input['ClusterMaintenanceDetailsArgs']]):
        pulumi.set(self, "maintenance_details", value)

    @_builtins.property
    @pulumi.getter(name="masterNodeHostBareMetalShape")
    def master_node_host_bare_metal_shape(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The bare metal shape for the cluster's master nodes.
        """
        return pulumi.get(self, "master_node_host_bare_metal_shape")

    @master_node_host_bare_metal_shape.setter
    def master_node_host_bare_metal_shape(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "master_node_host_bare_metal_shape", value)

    @_builtins.property
    @pulumi.getter(name="masterNodeHostShape")
    def master_node_host_shape(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The node shape for the cluster's master nodes.
        """
        return pulumi.get(self, "master_node_host_shape")

    @master_node_host_shape.setter
    def master_node_host_shape(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "master_node_host_shape", value)

    @_builtins.property
    @pulumi.getter(name="nsgId")
    def nsg_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the NSG where the private endpoint vnic will be attached.
        """
        return pulumi.get(self, "nsg_id")

    @nsg_id.setter
    def nsg_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nsg_id", value)

    @_builtins.property
    @pulumi.getter(name="opendashboardNodeHostShape")
    def opendashboard_node_host_shape(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The node shape for the cluster's OpenSearch Dashboard nodes.
        """
        return pulumi.get(self, "opendashboard_node_host_shape")

    @opendashboard_node_host_shape.setter
    def opendashboard_node_host_shape(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "opendashboard_node_host_shape", value)

    @_builtins.property
    @pulumi.getter(name="outboundClusterConfig")
    def outbound_cluster_config(self) -> Optional[pulumi.Input['ClusterOutboundClusterConfigArgs']]:
        """
        (Updatable) This configuration is used for passing request details to connect outbound cluster(s) to the inbound cluster (coordinating cluster)
        """
        return pulumi.get(self, "outbound_cluster_config")

    @outbound_cluster_config.setter
    def outbound_cluster_config(self, value: Optional[pulumi.Input['ClusterOutboundClusterConfigArgs']]):
        pulumi.set(self, "outbound_cluster_config", value)

    @_builtins.property
    @pulumi.getter(name="reverseConnectionEndpointCustomerIps")
    def reverse_connection_endpoint_customer_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) The customer IP addresses of the endpoint in customer VCN
        """
        return pulumi.get(self, "reverse_connection_endpoint_customer_ips")

    @reverse_connection_endpoint_customer_ips.setter
    def reverse_connection_endpoint_customer_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "reverse_connection_endpoint_customer_ips", value)

    @_builtins.property
    @pulumi.getter(name="searchNodeCount")
    def search_node_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The number of search nodes configured for the cluster.
        """
        return pulumi.get(self, "search_node_count")

    @search_node_count.setter
    def search_node_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "search_node_count", value)

    @_builtins.property
    @pulumi.getter(name="searchNodeHostMemoryGb")
    def search_node_host_memory_gb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The amount of memory in GB, for the cluster's search nodes.
        """
        return pulumi.get(self, "search_node_host_memory_gb")

    @search_node_host_memory_gb.setter
    def search_node_host_memory_gb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "search_node_host_memory_gb", value)

    @_builtins.property
    @pulumi.getter(name="searchNodeHostOcpuCount")
    def search_node_host_ocpu_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The number of OCPUs configured for the cluster's search nodes.
        """
        return pulumi.get(self, "search_node_host_ocpu_count")

    @search_node_host_ocpu_count.setter
    def search_node_host_ocpu_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "search_node_host_ocpu_count", value)

    @_builtins.property
    @pulumi.getter(name="searchNodeHostShape")
    def search_node_host_shape(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The node shape for the cluster's search nodes.
        """
        return pulumi.get(self, "search_node_host_shape")

    @search_node_host_shape.setter
    def search_node_host_shape(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "search_node_host_shape", value)

    @_builtins.property
    @pulumi.getter(name="searchNodeHostType")
    def search_node_host_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance type for the cluster's search nodes.
        """
        return pulumi.get(self, "search_node_host_type")

    @search_node_host_type.setter
    def search_node_host_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "search_node_host_type", value)

    @_builtins.property
    @pulumi.getter(name="searchNodeStorageGb")
    def search_node_storage_gb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The amount of storage in GB, to configure per node for the cluster's search nodes.
        """
        return pulumi.get(self, "search_node_storage_gb")

    @search_node_storage_gb.setter
    def search_node_storage_gb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "search_node_storage_gb", value)

    @_builtins.property
    @pulumi.getter(name="securityAttributes")
    def security_attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Security attributes for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Oracle-ZPR": {"MaxEgressCount": {"value": "42", "mode": "enforce"}}}`
        """
        return pulumi.get(self, "security_attributes")

    @security_attributes.setter
    def security_attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_attributes", value)

    @_builtins.property
    @pulumi.getter(name="securityMasterUserName")
    def security_master_user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The name of the master user that are used to manage security config
        """
        return pulumi.get(self, "security_master_user_name")

    @security_master_user_name.setter
    def security_master_user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_master_user_name", value)

    @_builtins.property
    @pulumi.getter(name="securityMasterUserPasswordHash")
    def security_master_user_password_hash(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The password hash of the master user that are used to manage security config
        """
        return pulumi.get(self, "security_master_user_password_hash")

    @security_master_user_password_hash.setter
    def security_master_user_password_hash(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_master_user_password_hash", value)

    @_builtins.property
    @pulumi.getter(name="securityMode")
    def security_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The security mode of the cluster.
        """
        return pulumi.get(self, "security_mode")

    @security_mode.setter
    def security_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_mode", value)

    @_builtins.property
    @pulumi.getter(name="securitySamlConfig")
    def security_saml_config(self) -> Optional[pulumi.Input['ClusterSecuritySamlConfigArgs']]:
        """
        SAML policy is optionally used for Opensearch cluster to config SAML authentication
        """
        return pulumi.get(self, "security_saml_config")

    @security_saml_config.setter
    def security_saml_config(self, value: Optional[pulumi.Input['ClusterSecuritySamlConfigArgs']]):
        pulumi.set(self, "security_saml_config", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="upgradeMajorVersionTrigger")
    def upgrade_major_version_trigger(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        An optional property to upgrade the major version of the cluster. This workflow upgrades the cluster without creating a clone. If you want to create a clone and upgrade the clone for testing please use SDK or CLI.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "upgrade_major_version_trigger")

    @upgrade_major_version_trigger.setter
    def upgrade_major_version_trigger(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "upgrade_major_version_trigger", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 availability_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 certificate_config: Optional[pulumi.Input['ClusterCertificateConfigArgs']] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 configure_outbound_cluster_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 data_node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 data_node_host_bare_metal_shape: Optional[pulumi.Input[_builtins.str]] = None,
                 data_node_host_memory_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 data_node_host_ocpu_count: Optional[pulumi.Input[_builtins.int]] = None,
                 data_node_host_shape: Optional[pulumi.Input[_builtins.str]] = None,
                 data_node_host_type: Optional[pulumi.Input[_builtins.str]] = None,
                 data_node_storage_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 fqdn: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 inbound_cluster_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_details: Optional[pulumi.Input['ClusterMaintenanceDetailsArgs']] = None,
                 master_node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 master_node_host_bare_metal_shape: Optional[pulumi.Input[_builtins.str]] = None,
                 master_node_host_memory_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 master_node_host_ocpu_count: Optional[pulumi.Input[_builtins.int]] = None,
                 master_node_host_shape: Optional[pulumi.Input[_builtins.str]] = None,
                 master_node_host_type: Optional[pulumi.Input[_builtins.str]] = None,
                 nsg_id: Optional[pulumi.Input[_builtins.str]] = None,
                 opendashboard_fqdn: Optional[pulumi.Input[_builtins.str]] = None,
                 opendashboard_node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 opendashboard_node_host_memory_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 opendashboard_node_host_ocpu_count: Optional[pulumi.Input[_builtins.int]] = None,
                 opendashboard_node_host_shape: Optional[pulumi.Input[_builtins.str]] = None,
                 opendashboard_private_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 opensearch_fqdn: Optional[pulumi.Input[_builtins.str]] = None,
                 opensearch_private_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 outbound_cluster_config: Optional[pulumi.Input['ClusterOutboundClusterConfigArgs']] = None,
                 reverse_connection_endpoint_customer_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 reverse_connection_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterReverseConnectionEndpointArgs']]]] = None,
                 search_node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 search_node_host_memory_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 search_node_host_ocpu_count: Optional[pulumi.Input[_builtins.int]] = None,
                 search_node_host_shape: Optional[pulumi.Input[_builtins.str]] = None,
                 search_node_host_type: Optional[pulumi.Input[_builtins.str]] = None,
                 search_node_storage_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 security_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 security_master_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 security_master_user_password_hash: Optional[pulumi.Input[_builtins.str]] = None,
                 security_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 security_saml_config: Optional[pulumi.Input['ClusterSecuritySamlConfigArgs']] = None,
                 software_version: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_deleted: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 total_storage_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 upgrade_major_version_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 vcn_compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vcn_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_domains: The availability domains to distribute the cluser nodes across.
        :param pulumi.Input['ClusterCertificateConfigArgs'] certificate_config: (Updatable) Custom certificate config for customer provided certs.
        :param pulumi.Input[_builtins.str] compartment_id: The OCID of the compartment to create the cluster in.
        :param pulumi.Input[_builtins.int] configure_outbound_cluster_trigger: (Updatable) An optional property when incremented triggers Configure Outbound Cluster. Could be set to any integer value.
        :param pulumi.Input[_builtins.int] data_node_count: (Updatable) The number of data nodes to configure for the cluster.
        :param pulumi.Input[_builtins.str] data_node_host_bare_metal_shape: The bare metal shape for the cluster's data nodes.
        :param pulumi.Input[_builtins.int] data_node_host_memory_gb: (Updatable) The amount of memory in GB, to configure per node for the cluster's data nodes.
        :param pulumi.Input[_builtins.int] data_node_host_ocpu_count: (Updatable) The number of OCPUs to configure for the cluster's data nodes.
        :param pulumi.Input[_builtins.str] data_node_host_shape: (Updatable) The node shape for the cluster's data nodes.
        :param pulumi.Input[_builtins.str] data_node_host_type: TThe instance type for the cluster's data nodes.
        :param pulumi.Input[_builtins.int] data_node_storage_gb: (Updatable) The amount of storage in GB, to configure per node for the cluster's data nodes.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The name of the cluster. Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] fqdn: The fully qualified domain name (FQDN) for the cluster's API endpoint.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] inbound_cluster_ids: List of inbound clusters that will be queried using cross cluster search
        :param pulumi.Input[_builtins.str] lifecycle_details: Additional information about the current lifecycle state of the cluster.
        :param pulumi.Input['ClusterMaintenanceDetailsArgs'] maintenance_details: (Updatable) Details for creation of maintenance details
        :param pulumi.Input[_builtins.int] master_node_count: (Updatable) The number of master nodes to configure for the cluster.
        :param pulumi.Input[_builtins.str] master_node_host_bare_metal_shape: The bare metal shape for the cluster's master nodes.
        :param pulumi.Input[_builtins.int] master_node_host_memory_gb: (Updatable) The amount of memory in GB, to configure per node for the cluster's master nodes.
        :param pulumi.Input[_builtins.int] master_node_host_ocpu_count: (Updatable) The number of OCPUs to configure for the cluser's master nodes.
        :param pulumi.Input[_builtins.str] master_node_host_shape: (Updatable) The node shape for the cluster's master nodes.
        :param pulumi.Input[_builtins.str] master_node_host_type: The instance type for the cluster's master nodes.
        :param pulumi.Input[_builtins.str] nsg_id: The OCID of the NSG where the private endpoint vnic will be attached.
        :param pulumi.Input[_builtins.str] opendashboard_fqdn: The fully qualified domain name (FQDN) for the cluster's OpenSearch Dashboard API endpoint.
        :param pulumi.Input[_builtins.int] opendashboard_node_count: (Updatable) The number of OpenSearch Dashboard nodes to configure for the cluster.
        :param pulumi.Input[_builtins.int] opendashboard_node_host_memory_gb: (Updatable) The amount of memory in GB, to configure for the cluster's OpenSearch Dashboard nodes.
        :param pulumi.Input[_builtins.int] opendashboard_node_host_ocpu_count: (Updatable) The number of OCPUs to configure for the cluster's OpenSearch Dashboard nodes.
        :param pulumi.Input[_builtins.str] opendashboard_node_host_shape: (Updatable) The node shape for the cluster's OpenSearch Dashboard nodes.
        :param pulumi.Input[_builtins.str] opendashboard_private_ip: The private IP address for the cluster's OpenSearch Dashboard.
        :param pulumi.Input[_builtins.str] opensearch_fqdn: The fully qualified domain name (FQDN) for the cluster's API endpoint.
        :param pulumi.Input[_builtins.str] opensearch_private_ip: The cluster's private IP address.
        :param pulumi.Input['ClusterOutboundClusterConfigArgs'] outbound_cluster_config: (Updatable) This configuration is used for passing request details to connect outbound cluster(s) to the inbound cluster (coordinating cluster)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] reverse_connection_endpoint_customer_ips: (Updatable) The customer IP addresses of the endpoint in customer VCN
        :param pulumi.Input[Sequence[pulumi.Input['ClusterReverseConnectionEndpointArgs']]] reverse_connection_endpoints: The list of reverse connection endpoints.
        :param pulumi.Input[_builtins.int] search_node_count: (Updatable) The number of search nodes configured for the cluster.
        :param pulumi.Input[_builtins.int] search_node_host_memory_gb: (Updatable) The amount of memory in GB, for the cluster's search nodes.
        :param pulumi.Input[_builtins.int] search_node_host_ocpu_count: (Updatable) The number of OCPUs configured for the cluster's search nodes.
        :param pulumi.Input[_builtins.str] search_node_host_shape: (Updatable) The node shape for the cluster's search nodes.
        :param pulumi.Input[_builtins.str] search_node_host_type: The instance type for the cluster's search nodes.
        :param pulumi.Input[_builtins.int] search_node_storage_gb: (Updatable) The amount of storage in GB, to configure per node for the cluster's search nodes.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] security_attributes: (Updatable) Security attributes for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Oracle-ZPR": {"MaxEgressCount": {"value": "42", "mode": "enforce"}}}`
        :param pulumi.Input[_builtins.str] security_master_user_name: (Updatable) The name of the master user that are used to manage security config
        :param pulumi.Input[_builtins.str] security_master_user_password_hash: (Updatable) The password hash of the master user that are used to manage security config
        :param pulumi.Input[_builtins.str] security_mode: (Updatable) The security mode of the cluster.
        :param pulumi.Input['ClusterSecuritySamlConfigArgs'] security_saml_config: SAML policy is optionally used for Opensearch cluster to config SAML authentication
        :param pulumi.Input[_builtins.str] software_version: (Updatable) The version of the software the cluster is running.
        :param pulumi.Input[_builtins.str] state: The current state of the cluster.
        :param pulumi.Input[_builtins.str] subnet_compartment_id: The OCID for the compartment where the cluster's subnet is located.
        :param pulumi.Input[_builtins.str] subnet_id: The OCID of the cluster's subnet.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The amount of time in milliseconds since the cluster was created.
        :param pulumi.Input[_builtins.str] time_deleted: The amount of time in milliseconds since the cluster was updated.
        :param pulumi.Input[_builtins.str] time_updated: The amount of time in milliseconds since the cluster was updated.
        :param pulumi.Input[_builtins.int] total_storage_gb: The size in GB of the cluster's total storage.
        :param pulumi.Input[_builtins.int] upgrade_major_version_trigger: An optional property to upgrade the major version of the cluster. This workflow upgrades the cluster without creating a clone. If you want to create a clone and upgrade the clone for testing please use SDK or CLI.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] vcn_compartment_id: The OCID for the compartment where the cluster's VCN is located.
        :param pulumi.Input[_builtins.str] vcn_id: The OCID of the cluster's VCN.
        """
        if availability_domains is not None:
            pulumi.set(__self__, "availability_domains", availability_domains)
        if certificate_config is not None:
            pulumi.set(__self__, "certificate_config", certificate_config)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if configure_outbound_cluster_trigger is not None:
            pulumi.set(__self__, "configure_outbound_cluster_trigger", configure_outbound_cluster_trigger)
        if data_node_count is not None:
            pulumi.set(__self__, "data_node_count", data_node_count)
        if data_node_host_bare_metal_shape is not None:
            pulumi.set(__self__, "data_node_host_bare_metal_shape", data_node_host_bare_metal_shape)
        if data_node_host_memory_gb is not None:
            pulumi.set(__self__, "data_node_host_memory_gb", data_node_host_memory_gb)
        if data_node_host_ocpu_count is not None:
            pulumi.set(__self__, "data_node_host_ocpu_count", data_node_host_ocpu_count)
        if data_node_host_shape is not None:
            pulumi.set(__self__, "data_node_host_shape", data_node_host_shape)
        if data_node_host_type is not None:
            pulumi.set(__self__, "data_node_host_type", data_node_host_type)
        if data_node_storage_gb is not None:
            pulumi.set(__self__, "data_node_storage_gb", data_node_storage_gb)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if inbound_cluster_ids is not None:
            pulumi.set(__self__, "inbound_cluster_ids", inbound_cluster_ids)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if maintenance_details is not None:
            pulumi.set(__self__, "maintenance_details", maintenance_details)
        if master_node_count is not None:
            pulumi.set(__self__, "master_node_count", master_node_count)
        if master_node_host_bare_metal_shape is not None:
            pulumi.set(__self__, "master_node_host_bare_metal_shape", master_node_host_bare_metal_shape)
        if master_node_host_memory_gb is not None:
            pulumi.set(__self__, "master_node_host_memory_gb", master_node_host_memory_gb)
        if master_node_host_ocpu_count is not None:
            pulumi.set(__self__, "master_node_host_ocpu_count", master_node_host_ocpu_count)
        if master_node_host_shape is not None:
            pulumi.set(__self__, "master_node_host_shape", master_node_host_shape)
        if master_node_host_type is not None:
            pulumi.set(__self__, "master_node_host_type", master_node_host_type)
        if nsg_id is not None:
            pulumi.set(__self__, "nsg_id", nsg_id)
        if opendashboard_fqdn is not None:
            pulumi.set(__self__, "opendashboard_fqdn", opendashboard_fqdn)
        if opendashboard_node_count is not None:
            pulumi.set(__self__, "opendashboard_node_count", opendashboard_node_count)
        if opendashboard_node_host_memory_gb is not None:
            pulumi.set(__self__, "opendashboard_node_host_memory_gb", opendashboard_node_host_memory_gb)
        if opendashboard_node_host_ocpu_count is not None:
            pulumi.set(__self__, "opendashboard_node_host_ocpu_count", opendashboard_node_host_ocpu_count)
        if opendashboard_node_host_shape is not None:
            pulumi.set(__self__, "opendashboard_node_host_shape", opendashboard_node_host_shape)
        if opendashboard_private_ip is not None:
            pulumi.set(__self__, "opendashboard_private_ip", opendashboard_private_ip)
        if opensearch_fqdn is not None:
            pulumi.set(__self__, "opensearch_fqdn", opensearch_fqdn)
        if opensearch_private_ip is not None:
            pulumi.set(__self__, "opensearch_private_ip", opensearch_private_ip)
        if outbound_cluster_config is not None:
            pulumi.set(__self__, "outbound_cluster_config", outbound_cluster_config)
        if reverse_connection_endpoint_customer_ips is not None:
            pulumi.set(__self__, "reverse_connection_endpoint_customer_ips", reverse_connection_endpoint_customer_ips)
        if reverse_connection_endpoints is not None:
            pulumi.set(__self__, "reverse_connection_endpoints", reverse_connection_endpoints)
        if search_node_count is not None:
            pulumi.set(__self__, "search_node_count", search_node_count)
        if search_node_host_memory_gb is not None:
            pulumi.set(__self__, "search_node_host_memory_gb", search_node_host_memory_gb)
        if search_node_host_ocpu_count is not None:
            pulumi.set(__self__, "search_node_host_ocpu_count", search_node_host_ocpu_count)
        if search_node_host_shape is not None:
            pulumi.set(__self__, "search_node_host_shape", search_node_host_shape)
        if search_node_host_type is not None:
            pulumi.set(__self__, "search_node_host_type", search_node_host_type)
        if search_node_storage_gb is not None:
            pulumi.set(__self__, "search_node_storage_gb", search_node_storage_gb)
        if security_attributes is not None:
            pulumi.set(__self__, "security_attributes", security_attributes)
        if security_master_user_name is not None:
            pulumi.set(__self__, "security_master_user_name", security_master_user_name)
        if security_master_user_password_hash is not None:
            pulumi.set(__self__, "security_master_user_password_hash", security_master_user_password_hash)
        if security_mode is not None:
            pulumi.set(__self__, "security_mode", security_mode)
        if security_saml_config is not None:
            pulumi.set(__self__, "security_saml_config", security_saml_config)
        if software_version is not None:
            pulumi.set(__self__, "software_version", software_version)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subnet_compartment_id is not None:
            pulumi.set(__self__, "subnet_compartment_id", subnet_compartment_id)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_deleted is not None:
            pulumi.set(__self__, "time_deleted", time_deleted)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if total_storage_gb is not None:
            pulumi.set(__self__, "total_storage_gb", total_storage_gb)
        if upgrade_major_version_trigger is not None:
            pulumi.set(__self__, "upgrade_major_version_trigger", upgrade_major_version_trigger)
        if vcn_compartment_id is not None:
            pulumi.set(__self__, "vcn_compartment_id", vcn_compartment_id)
        if vcn_id is not None:
            pulumi.set(__self__, "vcn_id", vcn_id)

    @_builtins.property
    @pulumi.getter(name="availabilityDomains")
    def availability_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The availability domains to distribute the cluser nodes across.
        """
        return pulumi.get(self, "availability_domains")

    @availability_domains.setter
    def availability_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "availability_domains", value)

    @_builtins.property
    @pulumi.getter(name="certificateConfig")
    def certificate_config(self) -> Optional[pulumi.Input['ClusterCertificateConfigArgs']]:
        """
        (Updatable) Custom certificate config for customer provided certs.
        """
        return pulumi.get(self, "certificate_config")

    @certificate_config.setter
    def certificate_config(self, value: Optional[pulumi.Input['ClusterCertificateConfigArgs']]):
        pulumi.set(self, "certificate_config", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the compartment to create the cluster in.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="configureOutboundClusterTrigger")
    def configure_outbound_cluster_trigger(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Configure Outbound Cluster. Could be set to any integer value.
        """
        return pulumi.get(self, "configure_outbound_cluster_trigger")

    @configure_outbound_cluster_trigger.setter
    def configure_outbound_cluster_trigger(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "configure_outbound_cluster_trigger", value)

    @_builtins.property
    @pulumi.getter(name="dataNodeCount")
    def data_node_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The number of data nodes to configure for the cluster.
        """
        return pulumi.get(self, "data_node_count")

    @data_node_count.setter
    def data_node_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "data_node_count", value)

    @_builtins.property
    @pulumi.getter(name="dataNodeHostBareMetalShape")
    def data_node_host_bare_metal_shape(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The bare metal shape for the cluster's data nodes.
        """
        return pulumi.get(self, "data_node_host_bare_metal_shape")

    @data_node_host_bare_metal_shape.setter
    def data_node_host_bare_metal_shape(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_node_host_bare_metal_shape", value)

    @_builtins.property
    @pulumi.getter(name="dataNodeHostMemoryGb")
    def data_node_host_memory_gb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The amount of memory in GB, to configure per node for the cluster's data nodes.
        """
        return pulumi.get(self, "data_node_host_memory_gb")

    @data_node_host_memory_gb.setter
    def data_node_host_memory_gb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "data_node_host_memory_gb", value)

    @_builtins.property
    @pulumi.getter(name="dataNodeHostOcpuCount")
    def data_node_host_ocpu_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The number of OCPUs to configure for the cluster's data nodes.
        """
        return pulumi.get(self, "data_node_host_ocpu_count")

    @data_node_host_ocpu_count.setter
    def data_node_host_ocpu_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "data_node_host_ocpu_count", value)

    @_builtins.property
    @pulumi.getter(name="dataNodeHostShape")
    def data_node_host_shape(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The node shape for the cluster's data nodes.
        """
        return pulumi.get(self, "data_node_host_shape")

    @data_node_host_shape.setter
    def data_node_host_shape(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_node_host_shape", value)

    @_builtins.property
    @pulumi.getter(name="dataNodeHostType")
    def data_node_host_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        TThe instance type for the cluster's data nodes.
        """
        return pulumi.get(self, "data_node_host_type")

    @data_node_host_type.setter
    def data_node_host_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_node_host_type", value)

    @_builtins.property
    @pulumi.getter(name="dataNodeStorageGb")
    def data_node_storage_gb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The amount of storage in GB, to configure per node for the cluster's data nodes.
        """
        return pulumi.get(self, "data_node_storage_gb")

    @data_node_storage_gb.setter
    def data_node_storage_gb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "data_node_storage_gb", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The name of the cluster. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified domain name (FQDN) for the cluster's API endpoint.
        """
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fqdn", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="inboundClusterIds")
    def inbound_cluster_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of inbound clusters that will be queried using cross cluster search
        """
        return pulumi.get(self, "inbound_cluster_ids")

    @inbound_cluster_ids.setter
    def inbound_cluster_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "inbound_cluster_ids", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Additional information about the current lifecycle state of the cluster.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceDetails")
    def maintenance_details(self) -> Optional[pulumi.Input['ClusterMaintenanceDetailsArgs']]:
        """
        (Updatable) Details for creation of maintenance details
        """
        return pulumi.get(self, "maintenance_details")

    @maintenance_details.setter
    def maintenance_details(self, value: Optional[pulumi.Input['ClusterMaintenanceDetailsArgs']]):
        pulumi.set(self, "maintenance_details", value)

    @_builtins.property
    @pulumi.getter(name="masterNodeCount")
    def master_node_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The number of master nodes to configure for the cluster.
        """
        return pulumi.get(self, "master_node_count")

    @master_node_count.setter
    def master_node_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "master_node_count", value)

    @_builtins.property
    @pulumi.getter(name="masterNodeHostBareMetalShape")
    def master_node_host_bare_metal_shape(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The bare metal shape for the cluster's master nodes.
        """
        return pulumi.get(self, "master_node_host_bare_metal_shape")

    @master_node_host_bare_metal_shape.setter
    def master_node_host_bare_metal_shape(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "master_node_host_bare_metal_shape", value)

    @_builtins.property
    @pulumi.getter(name="masterNodeHostMemoryGb")
    def master_node_host_memory_gb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The amount of memory in GB, to configure per node for the cluster's master nodes.
        """
        return pulumi.get(self, "master_node_host_memory_gb")

    @master_node_host_memory_gb.setter
    def master_node_host_memory_gb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "master_node_host_memory_gb", value)

    @_builtins.property
    @pulumi.getter(name="masterNodeHostOcpuCount")
    def master_node_host_ocpu_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The number of OCPUs to configure for the cluser's master nodes.
        """
        return pulumi.get(self, "master_node_host_ocpu_count")

    @master_node_host_ocpu_count.setter
    def master_node_host_ocpu_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "master_node_host_ocpu_count", value)

    @_builtins.property
    @pulumi.getter(name="masterNodeHostShape")
    def master_node_host_shape(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The node shape for the cluster's master nodes.
        """
        return pulumi.get(self, "master_node_host_shape")

    @master_node_host_shape.setter
    def master_node_host_shape(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "master_node_host_shape", value)

    @_builtins.property
    @pulumi.getter(name="masterNodeHostType")
    def master_node_host_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance type for the cluster's master nodes.
        """
        return pulumi.get(self, "master_node_host_type")

    @master_node_host_type.setter
    def master_node_host_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "master_node_host_type", value)

    @_builtins.property
    @pulumi.getter(name="nsgId")
    def nsg_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the NSG where the private endpoint vnic will be attached.
        """
        return pulumi.get(self, "nsg_id")

    @nsg_id.setter
    def nsg_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nsg_id", value)

    @_builtins.property
    @pulumi.getter(name="opendashboardFqdn")
    def opendashboard_fqdn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified domain name (FQDN) for the cluster's OpenSearch Dashboard API endpoint.
        """
        return pulumi.get(self, "opendashboard_fqdn")

    @opendashboard_fqdn.setter
    def opendashboard_fqdn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "opendashboard_fqdn", value)

    @_builtins.property
    @pulumi.getter(name="opendashboardNodeCount")
    def opendashboard_node_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The number of OpenSearch Dashboard nodes to configure for the cluster.
        """
        return pulumi.get(self, "opendashboard_node_count")

    @opendashboard_node_count.setter
    def opendashboard_node_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "opendashboard_node_count", value)

    @_builtins.property
    @pulumi.getter(name="opendashboardNodeHostMemoryGb")
    def opendashboard_node_host_memory_gb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The amount of memory in GB, to configure for the cluster's OpenSearch Dashboard nodes.
        """
        return pulumi.get(self, "opendashboard_node_host_memory_gb")

    @opendashboard_node_host_memory_gb.setter
    def opendashboard_node_host_memory_gb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "opendashboard_node_host_memory_gb", value)

    @_builtins.property
    @pulumi.getter(name="opendashboardNodeHostOcpuCount")
    def opendashboard_node_host_ocpu_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The number of OCPUs to configure for the cluster's OpenSearch Dashboard nodes.
        """
        return pulumi.get(self, "opendashboard_node_host_ocpu_count")

    @opendashboard_node_host_ocpu_count.setter
    def opendashboard_node_host_ocpu_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "opendashboard_node_host_ocpu_count", value)

    @_builtins.property
    @pulumi.getter(name="opendashboardNodeHostShape")
    def opendashboard_node_host_shape(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The node shape for the cluster's OpenSearch Dashboard nodes.
        """
        return pulumi.get(self, "opendashboard_node_host_shape")

    @opendashboard_node_host_shape.setter
    def opendashboard_node_host_shape(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "opendashboard_node_host_shape", value)

    @_builtins.property
    @pulumi.getter(name="opendashboardPrivateIp")
    def opendashboard_private_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private IP address for the cluster's OpenSearch Dashboard.
        """
        return pulumi.get(self, "opendashboard_private_ip")

    @opendashboard_private_ip.setter
    def opendashboard_private_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "opendashboard_private_ip", value)

    @_builtins.property
    @pulumi.getter(name="opensearchFqdn")
    def opensearch_fqdn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified domain name (FQDN) for the cluster's API endpoint.
        """
        return pulumi.get(self, "opensearch_fqdn")

    @opensearch_fqdn.setter
    def opensearch_fqdn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "opensearch_fqdn", value)

    @_builtins.property
    @pulumi.getter(name="opensearchPrivateIp")
    def opensearch_private_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cluster's private IP address.
        """
        return pulumi.get(self, "opensearch_private_ip")

    @opensearch_private_ip.setter
    def opensearch_private_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "opensearch_private_ip", value)

    @_builtins.property
    @pulumi.getter(name="outboundClusterConfig")
    def outbound_cluster_config(self) -> Optional[pulumi.Input['ClusterOutboundClusterConfigArgs']]:
        """
        (Updatable) This configuration is used for passing request details to connect outbound cluster(s) to the inbound cluster (coordinating cluster)
        """
        return pulumi.get(self, "outbound_cluster_config")

    @outbound_cluster_config.setter
    def outbound_cluster_config(self, value: Optional[pulumi.Input['ClusterOutboundClusterConfigArgs']]):
        pulumi.set(self, "outbound_cluster_config", value)

    @_builtins.property
    @pulumi.getter(name="reverseConnectionEndpointCustomerIps")
    def reverse_connection_endpoint_customer_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) The customer IP addresses of the endpoint in customer VCN
        """
        return pulumi.get(self, "reverse_connection_endpoint_customer_ips")

    @reverse_connection_endpoint_customer_ips.setter
    def reverse_connection_endpoint_customer_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "reverse_connection_endpoint_customer_ips", value)

    @_builtins.property
    @pulumi.getter(name="reverseConnectionEndpoints")
    def reverse_connection_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterReverseConnectionEndpointArgs']]]]:
        """
        The list of reverse connection endpoints.
        """
        return pulumi.get(self, "reverse_connection_endpoints")

    @reverse_connection_endpoints.setter
    def reverse_connection_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterReverseConnectionEndpointArgs']]]]):
        pulumi.set(self, "reverse_connection_endpoints", value)

    @_builtins.property
    @pulumi.getter(name="searchNodeCount")
    def search_node_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The number of search nodes configured for the cluster.
        """
        return pulumi.get(self, "search_node_count")

    @search_node_count.setter
    def search_node_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "search_node_count", value)

    @_builtins.property
    @pulumi.getter(name="searchNodeHostMemoryGb")
    def search_node_host_memory_gb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The amount of memory in GB, for the cluster's search nodes.
        """
        return pulumi.get(self, "search_node_host_memory_gb")

    @search_node_host_memory_gb.setter
    def search_node_host_memory_gb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "search_node_host_memory_gb", value)

    @_builtins.property
    @pulumi.getter(name="searchNodeHostOcpuCount")
    def search_node_host_ocpu_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The number of OCPUs configured for the cluster's search nodes.
        """
        return pulumi.get(self, "search_node_host_ocpu_count")

    @search_node_host_ocpu_count.setter
    def search_node_host_ocpu_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "search_node_host_ocpu_count", value)

    @_builtins.property
    @pulumi.getter(name="searchNodeHostShape")
    def search_node_host_shape(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The node shape for the cluster's search nodes.
        """
        return pulumi.get(self, "search_node_host_shape")

    @search_node_host_shape.setter
    def search_node_host_shape(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "search_node_host_shape", value)

    @_builtins.property
    @pulumi.getter(name="searchNodeHostType")
    def search_node_host_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance type for the cluster's search nodes.
        """
        return pulumi.get(self, "search_node_host_type")

    @search_node_host_type.setter
    def search_node_host_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "search_node_host_type", value)

    @_builtins.property
    @pulumi.getter(name="searchNodeStorageGb")
    def search_node_storage_gb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The amount of storage in GB, to configure per node for the cluster's search nodes.
        """
        return pulumi.get(self, "search_node_storage_gb")

    @search_node_storage_gb.setter
    def search_node_storage_gb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "search_node_storage_gb", value)

    @_builtins.property
    @pulumi.getter(name="securityAttributes")
    def security_attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Security attributes for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Oracle-ZPR": {"MaxEgressCount": {"value": "42", "mode": "enforce"}}}`
        """
        return pulumi.get(self, "security_attributes")

    @security_attributes.setter
    def security_attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_attributes", value)

    @_builtins.property
    @pulumi.getter(name="securityMasterUserName")
    def security_master_user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The name of the master user that are used to manage security config
        """
        return pulumi.get(self, "security_master_user_name")

    @security_master_user_name.setter
    def security_master_user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_master_user_name", value)

    @_builtins.property
    @pulumi.getter(name="securityMasterUserPasswordHash")
    def security_master_user_password_hash(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The password hash of the master user that are used to manage security config
        """
        return pulumi.get(self, "security_master_user_password_hash")

    @security_master_user_password_hash.setter
    def security_master_user_password_hash(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_master_user_password_hash", value)

    @_builtins.property
    @pulumi.getter(name="securityMode")
    def security_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The security mode of the cluster.
        """
        return pulumi.get(self, "security_mode")

    @security_mode.setter
    def security_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_mode", value)

    @_builtins.property
    @pulumi.getter(name="securitySamlConfig")
    def security_saml_config(self) -> Optional[pulumi.Input['ClusterSecuritySamlConfigArgs']]:
        """
        SAML policy is optionally used for Opensearch cluster to config SAML authentication
        """
        return pulumi.get(self, "security_saml_config")

    @security_saml_config.setter
    def security_saml_config(self, value: Optional[pulumi.Input['ClusterSecuritySamlConfigArgs']]):
        pulumi.set(self, "security_saml_config", value)

    @_builtins.property
    @pulumi.getter(name="softwareVersion")
    def software_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The version of the software the cluster is running.
        """
        return pulumi.get(self, "software_version")

    @software_version.setter
    def software_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "software_version", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the cluster.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="subnetCompartmentId")
    def subnet_compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID for the compartment where the cluster's subnet is located.
        """
        return pulumi.get(self, "subnet_compartment_id")

    @subnet_compartment_id.setter
    def subnet_compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the cluster's subnet.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The amount of time in milliseconds since the cluster was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeDeleted")
    def time_deleted(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The amount of time in milliseconds since the cluster was updated.
        """
        return pulumi.get(self, "time_deleted")

    @time_deleted.setter
    def time_deleted(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_deleted", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The amount of time in milliseconds since the cluster was updated.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @_builtins.property
    @pulumi.getter(name="totalStorageGb")
    def total_storage_gb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The size in GB of the cluster's total storage.
        """
        return pulumi.get(self, "total_storage_gb")

    @total_storage_gb.setter
    def total_storage_gb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "total_storage_gb", value)

    @_builtins.property
    @pulumi.getter(name="upgradeMajorVersionTrigger")
    def upgrade_major_version_trigger(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        An optional property to upgrade the major version of the cluster. This workflow upgrades the cluster without creating a clone. If you want to create a clone and upgrade the clone for testing please use SDK or CLI.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "upgrade_major_version_trigger")

    @upgrade_major_version_trigger.setter
    def upgrade_major_version_trigger(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "upgrade_major_version_trigger", value)

    @_builtins.property
    @pulumi.getter(name="vcnCompartmentId")
    def vcn_compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID for the compartment where the cluster's VCN is located.
        """
        return pulumi.get(self, "vcn_compartment_id")

    @vcn_compartment_id.setter
    def vcn_compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vcn_compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the cluster's VCN.
        """
        return pulumi.get(self, "vcn_id")

    @vcn_id.setter
    def vcn_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vcn_id", value)


@pulumi.type_token("oci:Opensearch/cluster:Cluster")
class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_config: Optional[pulumi.Input[Union['ClusterCertificateConfigArgs', 'ClusterCertificateConfigArgsDict']]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 configure_outbound_cluster_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 data_node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 data_node_host_bare_metal_shape: Optional[pulumi.Input[_builtins.str]] = None,
                 data_node_host_memory_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 data_node_host_ocpu_count: Optional[pulumi.Input[_builtins.int]] = None,
                 data_node_host_shape: Optional[pulumi.Input[_builtins.str]] = None,
                 data_node_host_type: Optional[pulumi.Input[_builtins.str]] = None,
                 data_node_storage_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 inbound_cluster_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 maintenance_details: Optional[pulumi.Input[Union['ClusterMaintenanceDetailsArgs', 'ClusterMaintenanceDetailsArgsDict']]] = None,
                 master_node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 master_node_host_bare_metal_shape: Optional[pulumi.Input[_builtins.str]] = None,
                 master_node_host_memory_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 master_node_host_ocpu_count: Optional[pulumi.Input[_builtins.int]] = None,
                 master_node_host_shape: Optional[pulumi.Input[_builtins.str]] = None,
                 master_node_host_type: Optional[pulumi.Input[_builtins.str]] = None,
                 nsg_id: Optional[pulumi.Input[_builtins.str]] = None,
                 opendashboard_node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 opendashboard_node_host_memory_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 opendashboard_node_host_ocpu_count: Optional[pulumi.Input[_builtins.int]] = None,
                 opendashboard_node_host_shape: Optional[pulumi.Input[_builtins.str]] = None,
                 outbound_cluster_config: Optional[pulumi.Input[Union['ClusterOutboundClusterConfigArgs', 'ClusterOutboundClusterConfigArgsDict']]] = None,
                 reverse_connection_endpoint_customer_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 search_node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 search_node_host_memory_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 search_node_host_ocpu_count: Optional[pulumi.Input[_builtins.int]] = None,
                 search_node_host_shape: Optional[pulumi.Input[_builtins.str]] = None,
                 search_node_host_type: Optional[pulumi.Input[_builtins.str]] = None,
                 search_node_storage_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 security_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 security_master_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 security_master_user_password_hash: Optional[pulumi.Input[_builtins.str]] = None,
                 security_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 security_saml_config: Optional[pulumi.Input[Union['ClusterSecuritySamlConfigArgs', 'ClusterSecuritySamlConfigArgsDict']]] = None,
                 software_version: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 upgrade_major_version_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 vcn_compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vcn_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        OpensearchClusters can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Opensearch/cluster:Cluster test_opensearch_cluster "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ClusterCertificateConfigArgs', 'ClusterCertificateConfigArgsDict']] certificate_config: (Updatable) Custom certificate config for customer provided certs.
        :param pulumi.Input[_builtins.str] compartment_id: The OCID of the compartment to create the cluster in.
        :param pulumi.Input[_builtins.int] configure_outbound_cluster_trigger: (Updatable) An optional property when incremented triggers Configure Outbound Cluster. Could be set to any integer value.
        :param pulumi.Input[_builtins.int] data_node_count: (Updatable) The number of data nodes to configure for the cluster.
        :param pulumi.Input[_builtins.str] data_node_host_bare_metal_shape: The bare metal shape for the cluster's data nodes.
        :param pulumi.Input[_builtins.int] data_node_host_memory_gb: (Updatable) The amount of memory in GB, to configure per node for the cluster's data nodes.
        :param pulumi.Input[_builtins.int] data_node_host_ocpu_count: (Updatable) The number of OCPUs to configure for the cluster's data nodes.
        :param pulumi.Input[_builtins.str] data_node_host_shape: (Updatable) The node shape for the cluster's data nodes.
        :param pulumi.Input[_builtins.str] data_node_host_type: TThe instance type for the cluster's data nodes.
        :param pulumi.Input[_builtins.int] data_node_storage_gb: (Updatable) The amount of storage in GB, to configure per node for the cluster's data nodes.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The name of the cluster. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] inbound_cluster_ids: List of inbound clusters that will be queried using cross cluster search
        :param pulumi.Input[Union['ClusterMaintenanceDetailsArgs', 'ClusterMaintenanceDetailsArgsDict']] maintenance_details: (Updatable) Details for creation of maintenance details
        :param pulumi.Input[_builtins.int] master_node_count: (Updatable) The number of master nodes to configure for the cluster.
        :param pulumi.Input[_builtins.str] master_node_host_bare_metal_shape: The bare metal shape for the cluster's master nodes.
        :param pulumi.Input[_builtins.int] master_node_host_memory_gb: (Updatable) The amount of memory in GB, to configure per node for the cluster's master nodes.
        :param pulumi.Input[_builtins.int] master_node_host_ocpu_count: (Updatable) The number of OCPUs to configure for the cluser's master nodes.
        :param pulumi.Input[_builtins.str] master_node_host_shape: (Updatable) The node shape for the cluster's master nodes.
        :param pulumi.Input[_builtins.str] master_node_host_type: The instance type for the cluster's master nodes.
        :param pulumi.Input[_builtins.str] nsg_id: The OCID of the NSG where the private endpoint vnic will be attached.
        :param pulumi.Input[_builtins.int] opendashboard_node_count: (Updatable) The number of OpenSearch Dashboard nodes to configure for the cluster.
        :param pulumi.Input[_builtins.int] opendashboard_node_host_memory_gb: (Updatable) The amount of memory in GB, to configure for the cluster's OpenSearch Dashboard nodes.
        :param pulumi.Input[_builtins.int] opendashboard_node_host_ocpu_count: (Updatable) The number of OCPUs to configure for the cluster's OpenSearch Dashboard nodes.
        :param pulumi.Input[_builtins.str] opendashboard_node_host_shape: (Updatable) The node shape for the cluster's OpenSearch Dashboard nodes.
        :param pulumi.Input[Union['ClusterOutboundClusterConfigArgs', 'ClusterOutboundClusterConfigArgsDict']] outbound_cluster_config: (Updatable) This configuration is used for passing request details to connect outbound cluster(s) to the inbound cluster (coordinating cluster)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] reverse_connection_endpoint_customer_ips: (Updatable) The customer IP addresses of the endpoint in customer VCN
        :param pulumi.Input[_builtins.int] search_node_count: (Updatable) The number of search nodes configured for the cluster.
        :param pulumi.Input[_builtins.int] search_node_host_memory_gb: (Updatable) The amount of memory in GB, for the cluster's search nodes.
        :param pulumi.Input[_builtins.int] search_node_host_ocpu_count: (Updatable) The number of OCPUs configured for the cluster's search nodes.
        :param pulumi.Input[_builtins.str] search_node_host_shape: (Updatable) The node shape for the cluster's search nodes.
        :param pulumi.Input[_builtins.str] search_node_host_type: The instance type for the cluster's search nodes.
        :param pulumi.Input[_builtins.int] search_node_storage_gb: (Updatable) The amount of storage in GB, to configure per node for the cluster's search nodes.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] security_attributes: (Updatable) Security attributes for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Oracle-ZPR": {"MaxEgressCount": {"value": "42", "mode": "enforce"}}}`
        :param pulumi.Input[_builtins.str] security_master_user_name: (Updatable) The name of the master user that are used to manage security config
        :param pulumi.Input[_builtins.str] security_master_user_password_hash: (Updatable) The password hash of the master user that are used to manage security config
        :param pulumi.Input[_builtins.str] security_mode: (Updatable) The security mode of the cluster.
        :param pulumi.Input[Union['ClusterSecuritySamlConfigArgs', 'ClusterSecuritySamlConfigArgsDict']] security_saml_config: SAML policy is optionally used for Opensearch cluster to config SAML authentication
        :param pulumi.Input[_builtins.str] software_version: (Updatable) The version of the software the cluster is running.
        :param pulumi.Input[_builtins.str] subnet_compartment_id: The OCID for the compartment where the cluster's subnet is located.
        :param pulumi.Input[_builtins.str] subnet_id: The OCID of the cluster's subnet.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.int] upgrade_major_version_trigger: An optional property to upgrade the major version of the cluster. This workflow upgrades the cluster without creating a clone. If you want to create a clone and upgrade the clone for testing please use SDK or CLI.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] vcn_compartment_id: The OCID for the compartment where the cluster's VCN is located.
        :param pulumi.Input[_builtins.str] vcn_id: The OCID of the cluster's VCN.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        OpensearchClusters can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Opensearch/cluster:Cluster test_opensearch_cluster "id"
        ```

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_config: Optional[pulumi.Input[Union['ClusterCertificateConfigArgs', 'ClusterCertificateConfigArgsDict']]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 configure_outbound_cluster_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 data_node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 data_node_host_bare_metal_shape: Optional[pulumi.Input[_builtins.str]] = None,
                 data_node_host_memory_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 data_node_host_ocpu_count: Optional[pulumi.Input[_builtins.int]] = None,
                 data_node_host_shape: Optional[pulumi.Input[_builtins.str]] = None,
                 data_node_host_type: Optional[pulumi.Input[_builtins.str]] = None,
                 data_node_storage_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 inbound_cluster_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 maintenance_details: Optional[pulumi.Input[Union['ClusterMaintenanceDetailsArgs', 'ClusterMaintenanceDetailsArgsDict']]] = None,
                 master_node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 master_node_host_bare_metal_shape: Optional[pulumi.Input[_builtins.str]] = None,
                 master_node_host_memory_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 master_node_host_ocpu_count: Optional[pulumi.Input[_builtins.int]] = None,
                 master_node_host_shape: Optional[pulumi.Input[_builtins.str]] = None,
                 master_node_host_type: Optional[pulumi.Input[_builtins.str]] = None,
                 nsg_id: Optional[pulumi.Input[_builtins.str]] = None,
                 opendashboard_node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 opendashboard_node_host_memory_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 opendashboard_node_host_ocpu_count: Optional[pulumi.Input[_builtins.int]] = None,
                 opendashboard_node_host_shape: Optional[pulumi.Input[_builtins.str]] = None,
                 outbound_cluster_config: Optional[pulumi.Input[Union['ClusterOutboundClusterConfigArgs', 'ClusterOutboundClusterConfigArgsDict']]] = None,
                 reverse_connection_endpoint_customer_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 search_node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 search_node_host_memory_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 search_node_host_ocpu_count: Optional[pulumi.Input[_builtins.int]] = None,
                 search_node_host_shape: Optional[pulumi.Input[_builtins.str]] = None,
                 search_node_host_type: Optional[pulumi.Input[_builtins.str]] = None,
                 search_node_storage_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 security_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 security_master_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 security_master_user_password_hash: Optional[pulumi.Input[_builtins.str]] = None,
                 security_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 security_saml_config: Optional[pulumi.Input[Union['ClusterSecuritySamlConfigArgs', 'ClusterSecuritySamlConfigArgsDict']]] = None,
                 software_version: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 upgrade_major_version_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 vcn_compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vcn_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            __props__.__dict__["certificate_config"] = certificate_config
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["configure_outbound_cluster_trigger"] = configure_outbound_cluster_trigger
            if data_node_count is None and not opts.urn:
                raise TypeError("Missing required property 'data_node_count'")
            __props__.__dict__["data_node_count"] = data_node_count
            __props__.__dict__["data_node_host_bare_metal_shape"] = data_node_host_bare_metal_shape
            if data_node_host_memory_gb is None and not opts.urn:
                raise TypeError("Missing required property 'data_node_host_memory_gb'")
            __props__.__dict__["data_node_host_memory_gb"] = data_node_host_memory_gb
            if data_node_host_ocpu_count is None and not opts.urn:
                raise TypeError("Missing required property 'data_node_host_ocpu_count'")
            __props__.__dict__["data_node_host_ocpu_count"] = data_node_host_ocpu_count
            __props__.__dict__["data_node_host_shape"] = data_node_host_shape
            if data_node_host_type is None and not opts.urn:
                raise TypeError("Missing required property 'data_node_host_type'")
            __props__.__dict__["data_node_host_type"] = data_node_host_type
            if data_node_storage_gb is None and not opts.urn:
                raise TypeError("Missing required property 'data_node_storage_gb'")
            __props__.__dict__["data_node_storage_gb"] = data_node_storage_gb
            __props__.__dict__["defined_tags"] = defined_tags
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["inbound_cluster_ids"] = inbound_cluster_ids
            __props__.__dict__["maintenance_details"] = maintenance_details
            if master_node_count is None and not opts.urn:
                raise TypeError("Missing required property 'master_node_count'")
            __props__.__dict__["master_node_count"] = master_node_count
            __props__.__dict__["master_node_host_bare_metal_shape"] = master_node_host_bare_metal_shape
            if master_node_host_memory_gb is None and not opts.urn:
                raise TypeError("Missing required property 'master_node_host_memory_gb'")
            __props__.__dict__["master_node_host_memory_gb"] = master_node_host_memory_gb
            if master_node_host_ocpu_count is None and not opts.urn:
                raise TypeError("Missing required property 'master_node_host_ocpu_count'")
            __props__.__dict__["master_node_host_ocpu_count"] = master_node_host_ocpu_count
            __props__.__dict__["master_node_host_shape"] = master_node_host_shape
            if master_node_host_type is None and not opts.urn:
                raise TypeError("Missing required property 'master_node_host_type'")
            __props__.__dict__["master_node_host_type"] = master_node_host_type
            __props__.__dict__["nsg_id"] = nsg_id
            if opendashboard_node_count is None and not opts.urn:
                raise TypeError("Missing required property 'opendashboard_node_count'")
            __props__.__dict__["opendashboard_node_count"] = opendashboard_node_count
            if opendashboard_node_host_memory_gb is None and not opts.urn:
                raise TypeError("Missing required property 'opendashboard_node_host_memory_gb'")
            __props__.__dict__["opendashboard_node_host_memory_gb"] = opendashboard_node_host_memory_gb
            if opendashboard_node_host_ocpu_count is None and not opts.urn:
                raise TypeError("Missing required property 'opendashboard_node_host_ocpu_count'")
            __props__.__dict__["opendashboard_node_host_ocpu_count"] = opendashboard_node_host_ocpu_count
            __props__.__dict__["opendashboard_node_host_shape"] = opendashboard_node_host_shape
            __props__.__dict__["outbound_cluster_config"] = outbound_cluster_config
            __props__.__dict__["reverse_connection_endpoint_customer_ips"] = reverse_connection_endpoint_customer_ips
            __props__.__dict__["search_node_count"] = search_node_count
            __props__.__dict__["search_node_host_memory_gb"] = search_node_host_memory_gb
            __props__.__dict__["search_node_host_ocpu_count"] = search_node_host_ocpu_count
            __props__.__dict__["search_node_host_shape"] = search_node_host_shape
            __props__.__dict__["search_node_host_type"] = search_node_host_type
            __props__.__dict__["search_node_storage_gb"] = search_node_storage_gb
            __props__.__dict__["security_attributes"] = security_attributes
            __props__.__dict__["security_master_user_name"] = security_master_user_name
            __props__.__dict__["security_master_user_password_hash"] = None if security_master_user_password_hash is None else pulumi.Output.secret(security_master_user_password_hash)
            __props__.__dict__["security_mode"] = security_mode
            __props__.__dict__["security_saml_config"] = None if security_saml_config is None else pulumi.Output.secret(security_saml_config)
            if software_version is None and not opts.urn:
                raise TypeError("Missing required property 'software_version'")
            __props__.__dict__["software_version"] = software_version
            if subnet_compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_compartment_id'")
            __props__.__dict__["subnet_compartment_id"] = subnet_compartment_id
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["system_tags"] = system_tags
            __props__.__dict__["upgrade_major_version_trigger"] = upgrade_major_version_trigger
            if vcn_compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'vcn_compartment_id'")
            __props__.__dict__["vcn_compartment_id"] = vcn_compartment_id
            if vcn_id is None and not opts.urn:
                raise TypeError("Missing required property 'vcn_id'")
            __props__.__dict__["vcn_id"] = vcn_id
            __props__.__dict__["availability_domains"] = None
            __props__.__dict__["fqdn"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["opendashboard_fqdn"] = None
            __props__.__dict__["opendashboard_private_ip"] = None
            __props__.__dict__["opensearch_fqdn"] = None
            __props__.__dict__["opensearch_private_ip"] = None
            __props__.__dict__["reverse_connection_endpoints"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_deleted"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["total_storage_gb"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["securityMasterUserPasswordHash", "securitySamlConfig"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Cluster, __self__).__init__(
            'oci:Opensearch/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            availability_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            certificate_config: Optional[pulumi.Input[Union['ClusterCertificateConfigArgs', 'ClusterCertificateConfigArgsDict']]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            configure_outbound_cluster_trigger: Optional[pulumi.Input[_builtins.int]] = None,
            data_node_count: Optional[pulumi.Input[_builtins.int]] = None,
            data_node_host_bare_metal_shape: Optional[pulumi.Input[_builtins.str]] = None,
            data_node_host_memory_gb: Optional[pulumi.Input[_builtins.int]] = None,
            data_node_host_ocpu_count: Optional[pulumi.Input[_builtins.int]] = None,
            data_node_host_shape: Optional[pulumi.Input[_builtins.str]] = None,
            data_node_host_type: Optional[pulumi.Input[_builtins.str]] = None,
            data_node_storage_gb: Optional[pulumi.Input[_builtins.int]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            fqdn: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            inbound_cluster_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            maintenance_details: Optional[pulumi.Input[Union['ClusterMaintenanceDetailsArgs', 'ClusterMaintenanceDetailsArgsDict']]] = None,
            master_node_count: Optional[pulumi.Input[_builtins.int]] = None,
            master_node_host_bare_metal_shape: Optional[pulumi.Input[_builtins.str]] = None,
            master_node_host_memory_gb: Optional[pulumi.Input[_builtins.int]] = None,
            master_node_host_ocpu_count: Optional[pulumi.Input[_builtins.int]] = None,
            master_node_host_shape: Optional[pulumi.Input[_builtins.str]] = None,
            master_node_host_type: Optional[pulumi.Input[_builtins.str]] = None,
            nsg_id: Optional[pulumi.Input[_builtins.str]] = None,
            opendashboard_fqdn: Optional[pulumi.Input[_builtins.str]] = None,
            opendashboard_node_count: Optional[pulumi.Input[_builtins.int]] = None,
            opendashboard_node_host_memory_gb: Optional[pulumi.Input[_builtins.int]] = None,
            opendashboard_node_host_ocpu_count: Optional[pulumi.Input[_builtins.int]] = None,
            opendashboard_node_host_shape: Optional[pulumi.Input[_builtins.str]] = None,
            opendashboard_private_ip: Optional[pulumi.Input[_builtins.str]] = None,
            opensearch_fqdn: Optional[pulumi.Input[_builtins.str]] = None,
            opensearch_private_ip: Optional[pulumi.Input[_builtins.str]] = None,
            outbound_cluster_config: Optional[pulumi.Input[Union['ClusterOutboundClusterConfigArgs', 'ClusterOutboundClusterConfigArgsDict']]] = None,
            reverse_connection_endpoint_customer_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            reverse_connection_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterReverseConnectionEndpointArgs', 'ClusterReverseConnectionEndpointArgsDict']]]]] = None,
            search_node_count: Optional[pulumi.Input[_builtins.int]] = None,
            search_node_host_memory_gb: Optional[pulumi.Input[_builtins.int]] = None,
            search_node_host_ocpu_count: Optional[pulumi.Input[_builtins.int]] = None,
            search_node_host_shape: Optional[pulumi.Input[_builtins.str]] = None,
            search_node_host_type: Optional[pulumi.Input[_builtins.str]] = None,
            search_node_storage_gb: Optional[pulumi.Input[_builtins.int]] = None,
            security_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            security_master_user_name: Optional[pulumi.Input[_builtins.str]] = None,
            security_master_user_password_hash: Optional[pulumi.Input[_builtins.str]] = None,
            security_mode: Optional[pulumi.Input[_builtins.str]] = None,
            security_saml_config: Optional[pulumi.Input[Union['ClusterSecuritySamlConfigArgs', 'ClusterSecuritySamlConfigArgsDict']]] = None,
            software_version: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_deleted: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None,
            total_storage_gb: Optional[pulumi.Input[_builtins.int]] = None,
            upgrade_major_version_trigger: Optional[pulumi.Input[_builtins.int]] = None,
            vcn_compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            vcn_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_domains: The availability domains to distribute the cluser nodes across.
        :param pulumi.Input[Union['ClusterCertificateConfigArgs', 'ClusterCertificateConfigArgsDict']] certificate_config: (Updatable) Custom certificate config for customer provided certs.
        :param pulumi.Input[_builtins.str] compartment_id: The OCID of the compartment to create the cluster in.
        :param pulumi.Input[_builtins.int] configure_outbound_cluster_trigger: (Updatable) An optional property when incremented triggers Configure Outbound Cluster. Could be set to any integer value.
        :param pulumi.Input[_builtins.int] data_node_count: (Updatable) The number of data nodes to configure for the cluster.
        :param pulumi.Input[_builtins.str] data_node_host_bare_metal_shape: The bare metal shape for the cluster's data nodes.
        :param pulumi.Input[_builtins.int] data_node_host_memory_gb: (Updatable) The amount of memory in GB, to configure per node for the cluster's data nodes.
        :param pulumi.Input[_builtins.int] data_node_host_ocpu_count: (Updatable) The number of OCPUs to configure for the cluster's data nodes.
        :param pulumi.Input[_builtins.str] data_node_host_shape: (Updatable) The node shape for the cluster's data nodes.
        :param pulumi.Input[_builtins.str] data_node_host_type: TThe instance type for the cluster's data nodes.
        :param pulumi.Input[_builtins.int] data_node_storage_gb: (Updatable) The amount of storage in GB, to configure per node for the cluster's data nodes.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The name of the cluster. Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] fqdn: The fully qualified domain name (FQDN) for the cluster's API endpoint.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] inbound_cluster_ids: List of inbound clusters that will be queried using cross cluster search
        :param pulumi.Input[_builtins.str] lifecycle_details: Additional information about the current lifecycle state of the cluster.
        :param pulumi.Input[Union['ClusterMaintenanceDetailsArgs', 'ClusterMaintenanceDetailsArgsDict']] maintenance_details: (Updatable) Details for creation of maintenance details
        :param pulumi.Input[_builtins.int] master_node_count: (Updatable) The number of master nodes to configure for the cluster.
        :param pulumi.Input[_builtins.str] master_node_host_bare_metal_shape: The bare metal shape for the cluster's master nodes.
        :param pulumi.Input[_builtins.int] master_node_host_memory_gb: (Updatable) The amount of memory in GB, to configure per node for the cluster's master nodes.
        :param pulumi.Input[_builtins.int] master_node_host_ocpu_count: (Updatable) The number of OCPUs to configure for the cluser's master nodes.
        :param pulumi.Input[_builtins.str] master_node_host_shape: (Updatable) The node shape for the cluster's master nodes.
        :param pulumi.Input[_builtins.str] master_node_host_type: The instance type for the cluster's master nodes.
        :param pulumi.Input[_builtins.str] nsg_id: The OCID of the NSG where the private endpoint vnic will be attached.
        :param pulumi.Input[_builtins.str] opendashboard_fqdn: The fully qualified domain name (FQDN) for the cluster's OpenSearch Dashboard API endpoint.
        :param pulumi.Input[_builtins.int] opendashboard_node_count: (Updatable) The number of OpenSearch Dashboard nodes to configure for the cluster.
        :param pulumi.Input[_builtins.int] opendashboard_node_host_memory_gb: (Updatable) The amount of memory in GB, to configure for the cluster's OpenSearch Dashboard nodes.
        :param pulumi.Input[_builtins.int] opendashboard_node_host_ocpu_count: (Updatable) The number of OCPUs to configure for the cluster's OpenSearch Dashboard nodes.
        :param pulumi.Input[_builtins.str] opendashboard_node_host_shape: (Updatable) The node shape for the cluster's OpenSearch Dashboard nodes.
        :param pulumi.Input[_builtins.str] opendashboard_private_ip: The private IP address for the cluster's OpenSearch Dashboard.
        :param pulumi.Input[_builtins.str] opensearch_fqdn: The fully qualified domain name (FQDN) for the cluster's API endpoint.
        :param pulumi.Input[_builtins.str] opensearch_private_ip: The cluster's private IP address.
        :param pulumi.Input[Union['ClusterOutboundClusterConfigArgs', 'ClusterOutboundClusterConfigArgsDict']] outbound_cluster_config: (Updatable) This configuration is used for passing request details to connect outbound cluster(s) to the inbound cluster (coordinating cluster)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] reverse_connection_endpoint_customer_ips: (Updatable) The customer IP addresses of the endpoint in customer VCN
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterReverseConnectionEndpointArgs', 'ClusterReverseConnectionEndpointArgsDict']]]] reverse_connection_endpoints: The list of reverse connection endpoints.
        :param pulumi.Input[_builtins.int] search_node_count: (Updatable) The number of search nodes configured for the cluster.
        :param pulumi.Input[_builtins.int] search_node_host_memory_gb: (Updatable) The amount of memory in GB, for the cluster's search nodes.
        :param pulumi.Input[_builtins.int] search_node_host_ocpu_count: (Updatable) The number of OCPUs configured for the cluster's search nodes.
        :param pulumi.Input[_builtins.str] search_node_host_shape: (Updatable) The node shape for the cluster's search nodes.
        :param pulumi.Input[_builtins.str] search_node_host_type: The instance type for the cluster's search nodes.
        :param pulumi.Input[_builtins.int] search_node_storage_gb: (Updatable) The amount of storage in GB, to configure per node for the cluster's search nodes.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] security_attributes: (Updatable) Security attributes for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Oracle-ZPR": {"MaxEgressCount": {"value": "42", "mode": "enforce"}}}`
        :param pulumi.Input[_builtins.str] security_master_user_name: (Updatable) The name of the master user that are used to manage security config
        :param pulumi.Input[_builtins.str] security_master_user_password_hash: (Updatable) The password hash of the master user that are used to manage security config
        :param pulumi.Input[_builtins.str] security_mode: (Updatable) The security mode of the cluster.
        :param pulumi.Input[Union['ClusterSecuritySamlConfigArgs', 'ClusterSecuritySamlConfigArgsDict']] security_saml_config: SAML policy is optionally used for Opensearch cluster to config SAML authentication
        :param pulumi.Input[_builtins.str] software_version: (Updatable) The version of the software the cluster is running.
        :param pulumi.Input[_builtins.str] state: The current state of the cluster.
        :param pulumi.Input[_builtins.str] subnet_compartment_id: The OCID for the compartment where the cluster's subnet is located.
        :param pulumi.Input[_builtins.str] subnet_id: The OCID of the cluster's subnet.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The amount of time in milliseconds since the cluster was created.
        :param pulumi.Input[_builtins.str] time_deleted: The amount of time in milliseconds since the cluster was updated.
        :param pulumi.Input[_builtins.str] time_updated: The amount of time in milliseconds since the cluster was updated.
        :param pulumi.Input[_builtins.int] total_storage_gb: The size in GB of the cluster's total storage.
        :param pulumi.Input[_builtins.int] upgrade_major_version_trigger: An optional property to upgrade the major version of the cluster. This workflow upgrades the cluster without creating a clone. If you want to create a clone and upgrade the clone for testing please use SDK or CLI.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] vcn_compartment_id: The OCID for the compartment where the cluster's VCN is located.
        :param pulumi.Input[_builtins.str] vcn_id: The OCID of the cluster's VCN.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["availability_domains"] = availability_domains
        __props__.__dict__["certificate_config"] = certificate_config
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["configure_outbound_cluster_trigger"] = configure_outbound_cluster_trigger
        __props__.__dict__["data_node_count"] = data_node_count
        __props__.__dict__["data_node_host_bare_metal_shape"] = data_node_host_bare_metal_shape
        __props__.__dict__["data_node_host_memory_gb"] = data_node_host_memory_gb
        __props__.__dict__["data_node_host_ocpu_count"] = data_node_host_ocpu_count
        __props__.__dict__["data_node_host_shape"] = data_node_host_shape
        __props__.__dict__["data_node_host_type"] = data_node_host_type
        __props__.__dict__["data_node_storage_gb"] = data_node_storage_gb
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["fqdn"] = fqdn
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["inbound_cluster_ids"] = inbound_cluster_ids
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["maintenance_details"] = maintenance_details
        __props__.__dict__["master_node_count"] = master_node_count
        __props__.__dict__["master_node_host_bare_metal_shape"] = master_node_host_bare_metal_shape
        __props__.__dict__["master_node_host_memory_gb"] = master_node_host_memory_gb
        __props__.__dict__["master_node_host_ocpu_count"] = master_node_host_ocpu_count
        __props__.__dict__["master_node_host_shape"] = master_node_host_shape
        __props__.__dict__["master_node_host_type"] = master_node_host_type
        __props__.__dict__["nsg_id"] = nsg_id
        __props__.__dict__["opendashboard_fqdn"] = opendashboard_fqdn
        __props__.__dict__["opendashboard_node_count"] = opendashboard_node_count
        __props__.__dict__["opendashboard_node_host_memory_gb"] = opendashboard_node_host_memory_gb
        __props__.__dict__["opendashboard_node_host_ocpu_count"] = opendashboard_node_host_ocpu_count
        __props__.__dict__["opendashboard_node_host_shape"] = opendashboard_node_host_shape
        __props__.__dict__["opendashboard_private_ip"] = opendashboard_private_ip
        __props__.__dict__["opensearch_fqdn"] = opensearch_fqdn
        __props__.__dict__["opensearch_private_ip"] = opensearch_private_ip
        __props__.__dict__["outbound_cluster_config"] = outbound_cluster_config
        __props__.__dict__["reverse_connection_endpoint_customer_ips"] = reverse_connection_endpoint_customer_ips
        __props__.__dict__["reverse_connection_endpoints"] = reverse_connection_endpoints
        __props__.__dict__["search_node_count"] = search_node_count
        __props__.__dict__["search_node_host_memory_gb"] = search_node_host_memory_gb
        __props__.__dict__["search_node_host_ocpu_count"] = search_node_host_ocpu_count
        __props__.__dict__["search_node_host_shape"] = search_node_host_shape
        __props__.__dict__["search_node_host_type"] = search_node_host_type
        __props__.__dict__["search_node_storage_gb"] = search_node_storage_gb
        __props__.__dict__["security_attributes"] = security_attributes
        __props__.__dict__["security_master_user_name"] = security_master_user_name
        __props__.__dict__["security_master_user_password_hash"] = security_master_user_password_hash
        __props__.__dict__["security_mode"] = security_mode
        __props__.__dict__["security_saml_config"] = security_saml_config
        __props__.__dict__["software_version"] = software_version
        __props__.__dict__["state"] = state
        __props__.__dict__["subnet_compartment_id"] = subnet_compartment_id
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_deleted"] = time_deleted
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["total_storage_gb"] = total_storage_gb
        __props__.__dict__["upgrade_major_version_trigger"] = upgrade_major_version_trigger
        __props__.__dict__["vcn_compartment_id"] = vcn_compartment_id
        __props__.__dict__["vcn_id"] = vcn_id
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="availabilityDomains")
    def availability_domains(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The availability domains to distribute the cluser nodes across.
        """
        return pulumi.get(self, "availability_domains")

    @_builtins.property
    @pulumi.getter(name="certificateConfig")
    def certificate_config(self) -> pulumi.Output['outputs.ClusterCertificateConfig']:
        """
        (Updatable) Custom certificate config for customer provided certs.
        """
        return pulumi.get(self, "certificate_config")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the compartment to create the cluster in.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="configureOutboundClusterTrigger")
    def configure_outbound_cluster_trigger(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Configure Outbound Cluster. Could be set to any integer value.
        """
        return pulumi.get(self, "configure_outbound_cluster_trigger")

    @_builtins.property
    @pulumi.getter(name="dataNodeCount")
    def data_node_count(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) The number of data nodes to configure for the cluster.
        """
        return pulumi.get(self, "data_node_count")

    @_builtins.property
    @pulumi.getter(name="dataNodeHostBareMetalShape")
    def data_node_host_bare_metal_shape(self) -> pulumi.Output[_builtins.str]:
        """
        The bare metal shape for the cluster's data nodes.
        """
        return pulumi.get(self, "data_node_host_bare_metal_shape")

    @_builtins.property
    @pulumi.getter(name="dataNodeHostMemoryGb")
    def data_node_host_memory_gb(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) The amount of memory in GB, to configure per node for the cluster's data nodes.
        """
        return pulumi.get(self, "data_node_host_memory_gb")

    @_builtins.property
    @pulumi.getter(name="dataNodeHostOcpuCount")
    def data_node_host_ocpu_count(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) The number of OCPUs to configure for the cluster's data nodes.
        """
        return pulumi.get(self, "data_node_host_ocpu_count")

    @_builtins.property
    @pulumi.getter(name="dataNodeHostShape")
    def data_node_host_shape(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The node shape for the cluster's data nodes.
        """
        return pulumi.get(self, "data_node_host_shape")

    @_builtins.property
    @pulumi.getter(name="dataNodeHostType")
    def data_node_host_type(self) -> pulumi.Output[_builtins.str]:
        """
        TThe instance type for the cluster's data nodes.
        """
        return pulumi.get(self, "data_node_host_type")

    @_builtins.property
    @pulumi.getter(name="dataNodeStorageGb")
    def data_node_storage_gb(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) The amount of storage in GB, to configure per node for the cluster's data nodes.
        """
        return pulumi.get(self, "data_node_storage_gb")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The name of the cluster. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> pulumi.Output[_builtins.str]:
        """
        The fully qualified domain name (FQDN) for the cluster's API endpoint.
        """
        return pulumi.get(self, "fqdn")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="inboundClusterIds")
    def inbound_cluster_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of inbound clusters that will be queried using cross cluster search
        """
        return pulumi.get(self, "inbound_cluster_ids")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        Additional information about the current lifecycle state of the cluster.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="maintenanceDetails")
    def maintenance_details(self) -> pulumi.Output['outputs.ClusterMaintenanceDetails']:
        """
        (Updatable) Details for creation of maintenance details
        """
        return pulumi.get(self, "maintenance_details")

    @_builtins.property
    @pulumi.getter(name="masterNodeCount")
    def master_node_count(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) The number of master nodes to configure for the cluster.
        """
        return pulumi.get(self, "master_node_count")

    @_builtins.property
    @pulumi.getter(name="masterNodeHostBareMetalShape")
    def master_node_host_bare_metal_shape(self) -> pulumi.Output[_builtins.str]:
        """
        The bare metal shape for the cluster's master nodes.
        """
        return pulumi.get(self, "master_node_host_bare_metal_shape")

    @_builtins.property
    @pulumi.getter(name="masterNodeHostMemoryGb")
    def master_node_host_memory_gb(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) The amount of memory in GB, to configure per node for the cluster's master nodes.
        """
        return pulumi.get(self, "master_node_host_memory_gb")

    @_builtins.property
    @pulumi.getter(name="masterNodeHostOcpuCount")
    def master_node_host_ocpu_count(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) The number of OCPUs to configure for the cluser's master nodes.
        """
        return pulumi.get(self, "master_node_host_ocpu_count")

    @_builtins.property
    @pulumi.getter(name="masterNodeHostShape")
    def master_node_host_shape(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The node shape for the cluster's master nodes.
        """
        return pulumi.get(self, "master_node_host_shape")

    @_builtins.property
    @pulumi.getter(name="masterNodeHostType")
    def master_node_host_type(self) -> pulumi.Output[_builtins.str]:
        """
        The instance type for the cluster's master nodes.
        """
        return pulumi.get(self, "master_node_host_type")

    @_builtins.property
    @pulumi.getter(name="nsgId")
    def nsg_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the NSG where the private endpoint vnic will be attached.
        """
        return pulumi.get(self, "nsg_id")

    @_builtins.property
    @pulumi.getter(name="opendashboardFqdn")
    def opendashboard_fqdn(self) -> pulumi.Output[_builtins.str]:
        """
        The fully qualified domain name (FQDN) for the cluster's OpenSearch Dashboard API endpoint.
        """
        return pulumi.get(self, "opendashboard_fqdn")

    @_builtins.property
    @pulumi.getter(name="opendashboardNodeCount")
    def opendashboard_node_count(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) The number of OpenSearch Dashboard nodes to configure for the cluster.
        """
        return pulumi.get(self, "opendashboard_node_count")

    @_builtins.property
    @pulumi.getter(name="opendashboardNodeHostMemoryGb")
    def opendashboard_node_host_memory_gb(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) The amount of memory in GB, to configure for the cluster's OpenSearch Dashboard nodes.
        """
        return pulumi.get(self, "opendashboard_node_host_memory_gb")

    @_builtins.property
    @pulumi.getter(name="opendashboardNodeHostOcpuCount")
    def opendashboard_node_host_ocpu_count(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) The number of OCPUs to configure for the cluster's OpenSearch Dashboard nodes.
        """
        return pulumi.get(self, "opendashboard_node_host_ocpu_count")

    @_builtins.property
    @pulumi.getter(name="opendashboardNodeHostShape")
    def opendashboard_node_host_shape(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The node shape for the cluster's OpenSearch Dashboard nodes.
        """
        return pulumi.get(self, "opendashboard_node_host_shape")

    @_builtins.property
    @pulumi.getter(name="opendashboardPrivateIp")
    def opendashboard_private_ip(self) -> pulumi.Output[_builtins.str]:
        """
        The private IP address for the cluster's OpenSearch Dashboard.
        """
        return pulumi.get(self, "opendashboard_private_ip")

    @_builtins.property
    @pulumi.getter(name="opensearchFqdn")
    def opensearch_fqdn(self) -> pulumi.Output[_builtins.str]:
        """
        The fully qualified domain name (FQDN) for the cluster's API endpoint.
        """
        return pulumi.get(self, "opensearch_fqdn")

    @_builtins.property
    @pulumi.getter(name="opensearchPrivateIp")
    def opensearch_private_ip(self) -> pulumi.Output[_builtins.str]:
        """
        The cluster's private IP address.
        """
        return pulumi.get(self, "opensearch_private_ip")

    @_builtins.property
    @pulumi.getter(name="outboundClusterConfig")
    def outbound_cluster_config(self) -> pulumi.Output['outputs.ClusterOutboundClusterConfig']:
        """
        (Updatable) This configuration is used for passing request details to connect outbound cluster(s) to the inbound cluster (coordinating cluster)
        """
        return pulumi.get(self, "outbound_cluster_config")

    @_builtins.property
    @pulumi.getter(name="reverseConnectionEndpointCustomerIps")
    def reverse_connection_endpoint_customer_ips(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        (Updatable) The customer IP addresses of the endpoint in customer VCN
        """
        return pulumi.get(self, "reverse_connection_endpoint_customer_ips")

    @_builtins.property
    @pulumi.getter(name="reverseConnectionEndpoints")
    def reverse_connection_endpoints(self) -> pulumi.Output[Sequence['outputs.ClusterReverseConnectionEndpoint']]:
        """
        The list of reverse connection endpoints.
        """
        return pulumi.get(self, "reverse_connection_endpoints")

    @_builtins.property
    @pulumi.getter(name="searchNodeCount")
    def search_node_count(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) The number of search nodes configured for the cluster.
        """
        return pulumi.get(self, "search_node_count")

    @_builtins.property
    @pulumi.getter(name="searchNodeHostMemoryGb")
    def search_node_host_memory_gb(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) The amount of memory in GB, for the cluster's search nodes.
        """
        return pulumi.get(self, "search_node_host_memory_gb")

    @_builtins.property
    @pulumi.getter(name="searchNodeHostOcpuCount")
    def search_node_host_ocpu_count(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) The number of OCPUs configured for the cluster's search nodes.
        """
        return pulumi.get(self, "search_node_host_ocpu_count")

    @_builtins.property
    @pulumi.getter(name="searchNodeHostShape")
    def search_node_host_shape(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The node shape for the cluster's search nodes.
        """
        return pulumi.get(self, "search_node_host_shape")

    @_builtins.property
    @pulumi.getter(name="searchNodeHostType")
    def search_node_host_type(self) -> pulumi.Output[_builtins.str]:
        """
        The instance type for the cluster's search nodes.
        """
        return pulumi.get(self, "search_node_host_type")

    @_builtins.property
    @pulumi.getter(name="searchNodeStorageGb")
    def search_node_storage_gb(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) The amount of storage in GB, to configure per node for the cluster's search nodes.
        """
        return pulumi.get(self, "search_node_storage_gb")

    @_builtins.property
    @pulumi.getter(name="securityAttributes")
    def security_attributes(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Security attributes for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Oracle-ZPR": {"MaxEgressCount": {"value": "42", "mode": "enforce"}}}`
        """
        return pulumi.get(self, "security_attributes")

    @_builtins.property
    @pulumi.getter(name="securityMasterUserName")
    def security_master_user_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The name of the master user that are used to manage security config
        """
        return pulumi.get(self, "security_master_user_name")

    @_builtins.property
    @pulumi.getter(name="securityMasterUserPasswordHash")
    def security_master_user_password_hash(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The password hash of the master user that are used to manage security config
        """
        return pulumi.get(self, "security_master_user_password_hash")

    @_builtins.property
    @pulumi.getter(name="securityMode")
    def security_mode(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The security mode of the cluster.
        """
        return pulumi.get(self, "security_mode")

    @_builtins.property
    @pulumi.getter(name="securitySamlConfig")
    def security_saml_config(self) -> pulumi.Output['outputs.ClusterSecuritySamlConfig']:
        """
        SAML policy is optionally used for Opensearch cluster to config SAML authentication
        """
        return pulumi.get(self, "security_saml_config")

    @_builtins.property
    @pulumi.getter(name="softwareVersion")
    def software_version(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The version of the software the cluster is running.
        """
        return pulumi.get(self, "software_version")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the cluster.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="subnetCompartmentId")
    def subnet_compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID for the compartment where the cluster's subnet is located.
        """
        return pulumi.get(self, "subnet_compartment_id")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the cluster's subnet.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The amount of time in milliseconds since the cluster was created.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeDeleted")
    def time_deleted(self) -> pulumi.Output[_builtins.str]:
        """
        The amount of time in milliseconds since the cluster was updated.
        """
        return pulumi.get(self, "time_deleted")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The amount of time in milliseconds since the cluster was updated.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="totalStorageGb")
    def total_storage_gb(self) -> pulumi.Output[_builtins.int]:
        """
        The size in GB of the cluster's total storage.
        """
        return pulumi.get(self, "total_storage_gb")

    @_builtins.property
    @pulumi.getter(name="upgradeMajorVersionTrigger")
    def upgrade_major_version_trigger(self) -> pulumi.Output[_builtins.int]:
        """
        An optional property to upgrade the major version of the cluster. This workflow upgrades the cluster without creating a clone. If you want to create a clone and upgrade the clone for testing please use SDK or CLI.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "upgrade_major_version_trigger")

    @_builtins.property
    @pulumi.getter(name="vcnCompartmentId")
    def vcn_compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID for the compartment where the cluster's VCN is located.
        """
        return pulumi.get(self, "vcn_compartment_id")

    @_builtins.property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the cluster's VCN.
        """
        return pulumi.get(self, "vcn_id")

