# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NewsReportArgs', 'NewsReport']

@pulumi.input_type
class NewsReportArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 content_types: pulumi.Input['NewsReportContentTypesArgs'],
                 description: pulumi.Input[_builtins.str],
                 locale: pulumi.Input[_builtins.str],
                 news_frequency: pulumi.Input[_builtins.str],
                 ons_topic_id: pulumi.Input[_builtins.str],
                 are_child_compartments_included: Optional[pulumi.Input[_builtins.bool]] = None,
                 day_of_week: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 match_rule: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a NewsReport resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) Compartment Identifier where the news report will be created.
        :param pulumi.Input['NewsReportContentTypesArgs'] content_types: (Updatable) Content types that the news report can handle.
        :param pulumi.Input[_builtins.str] description: (Updatable) The description of the news report.
        :param pulumi.Input[_builtins.str] locale: (Updatable) Language of the news report.
        :param pulumi.Input[_builtins.str] news_frequency: (Updatable) News report frequency.
        :param pulumi.Input[_builtins.str] ons_topic_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ONS topic.
        :param pulumi.Input[_builtins.bool] are_child_compartments_included: (Updatable) A flag to consider the resources within a given compartment and all sub-compartments.
        :param pulumi.Input[_builtins.str] day_of_week: (Updatable) Day of the week in which the news report will be sent if the frequency is set to WEEKLY.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] match_rule: (Updatable) Match rule used for tag filters.
        :param pulumi.Input[_builtins.str] name: (Updatable) The news report name.
        :param pulumi.Input[_builtins.str] status: (Updatable) Defines if the news report will be enabled or disabled.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tag_filters: (Updatable) List of tag filters; each filter composed by a namespace, key, and value. Example for defined tags - '<TagNamespace>.<TagKey>=<TagValue>'. Example for freeform tags - '<TagKey>=<TagValue>' 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "content_types", content_types)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "locale", locale)
        pulumi.set(__self__, "news_frequency", news_frequency)
        pulumi.set(__self__, "ons_topic_id", ons_topic_id)
        if are_child_compartments_included is not None:
            pulumi.set(__self__, "are_child_compartments_included", are_child_compartments_included)
        if day_of_week is not None:
            pulumi.set(__self__, "day_of_week", day_of_week)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if match_rule is not None:
            pulumi.set(__self__, "match_rule", match_rule)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tag_filters is not None:
            pulumi.set(__self__, "tag_filters", tag_filters)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) Compartment Identifier where the news report will be created.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="contentTypes")
    def content_types(self) -> pulumi.Input['NewsReportContentTypesArgs']:
        """
        (Updatable) Content types that the news report can handle.
        """
        return pulumi.get(self, "content_types")

    @content_types.setter
    def content_types(self, value: pulumi.Input['NewsReportContentTypesArgs']):
        pulumi.set(self, "content_types", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The description of the news report.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def locale(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) Language of the news report.
        """
        return pulumi.get(self, "locale")

    @locale.setter
    def locale(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "locale", value)

    @_builtins.property
    @pulumi.getter(name="newsFrequency")
    def news_frequency(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) News report frequency.
        """
        return pulumi.get(self, "news_frequency")

    @news_frequency.setter
    def news_frequency(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "news_frequency", value)

    @_builtins.property
    @pulumi.getter(name="onsTopicId")
    def ons_topic_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ONS topic.
        """
        return pulumi.get(self, "ons_topic_id")

    @ons_topic_id.setter
    def ons_topic_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ons_topic_id", value)

    @_builtins.property
    @pulumi.getter(name="areChildCompartmentsIncluded")
    def are_child_compartments_included(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) A flag to consider the resources within a given compartment and all sub-compartments.
        """
        return pulumi.get(self, "are_child_compartments_included")

    @are_child_compartments_included.setter
    def are_child_compartments_included(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "are_child_compartments_included", value)

    @_builtins.property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Day of the week in which the news report will be sent if the frequency is set to WEEKLY.
        """
        return pulumi.get(self, "day_of_week")

    @day_of_week.setter
    def day_of_week(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "day_of_week", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="matchRule")
    def match_rule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Match rule used for tag filters.
        """
        return pulumi.get(self, "match_rule")

    @match_rule.setter
    def match_rule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "match_rule", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The news report name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Defines if the news report will be enabled or disabled.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="tagFilters")
    def tag_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) List of tag filters; each filter composed by a namespace, key, and value. Example for defined tags - '<TagNamespace>.<TagKey>=<TagValue>'. Example for freeform tags - '<TagKey>=<TagValue>' 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "tag_filters")

    @tag_filters.setter
    def tag_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tag_filters", value)


@pulumi.input_type
class _NewsReportState:
    def __init__(__self__, *,
                 are_child_compartments_included: Optional[pulumi.Input[_builtins.bool]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 content_types: Optional[pulumi.Input['NewsReportContentTypesArgs']] = None,
                 day_of_week: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 locale: Optional[pulumi.Input[_builtins.str]] = None,
                 match_rule: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 news_frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 ons_topic_id: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tag_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NewsReport resources.
        :param pulumi.Input[_builtins.bool] are_child_compartments_included: (Updatable) A flag to consider the resources within a given compartment and all sub-compartments.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) Compartment Identifier where the news report will be created.
        :param pulumi.Input['NewsReportContentTypesArgs'] content_types: (Updatable) Content types that the news report can handle.
        :param pulumi.Input[_builtins.str] day_of_week: (Updatable) Day of the week in which the news report will be sent if the frequency is set to WEEKLY.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) The description of the news report.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[_builtins.str] locale: (Updatable) Language of the news report.
        :param pulumi.Input[_builtins.str] match_rule: (Updatable) Match rule used for tag filters.
        :param pulumi.Input[_builtins.str] name: (Updatable) The news report name.
        :param pulumi.Input[_builtins.str] news_frequency: (Updatable) News report frequency.
        :param pulumi.Input[_builtins.str] ons_topic_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ONS topic.
        :param pulumi.Input[_builtins.str] state: The current state of the news report.
        :param pulumi.Input[_builtins.str] status: (Updatable) Defines if the news report will be enabled or disabled.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tag_filters: (Updatable) List of tag filters; each filter composed by a namespace, key, and value. Example for defined tags - '<TagNamespace>.<TagKey>=<TagValue>'. Example for freeform tags - '<TagKey>=<TagValue>' 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] time_created: The time the the news report was first enabled. An RFC3339 formatted datetime string.
        :param pulumi.Input[_builtins.str] time_updated: The time the news report was updated. An RFC3339 formatted datetime string.
        """
        if are_child_compartments_included is not None:
            pulumi.set(__self__, "are_child_compartments_included", are_child_compartments_included)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if content_types is not None:
            pulumi.set(__self__, "content_types", content_types)
        if day_of_week is not None:
            pulumi.set(__self__, "day_of_week", day_of_week)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if locale is not None:
            pulumi.set(__self__, "locale", locale)
        if match_rule is not None:
            pulumi.set(__self__, "match_rule", match_rule)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if news_frequency is not None:
            pulumi.set(__self__, "news_frequency", news_frequency)
        if ons_topic_id is not None:
            pulumi.set(__self__, "ons_topic_id", ons_topic_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if tag_filters is not None:
            pulumi.set(__self__, "tag_filters", tag_filters)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="areChildCompartmentsIncluded")
    def are_child_compartments_included(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) A flag to consider the resources within a given compartment and all sub-compartments.
        """
        return pulumi.get(self, "are_child_compartments_included")

    @are_child_compartments_included.setter
    def are_child_compartments_included(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "are_child_compartments_included", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Compartment Identifier where the news report will be created.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="contentTypes")
    def content_types(self) -> Optional[pulumi.Input['NewsReportContentTypesArgs']]:
        """
        (Updatable) Content types that the news report can handle.
        """
        return pulumi.get(self, "content_types")

    @content_types.setter
    def content_types(self, value: Optional[pulumi.Input['NewsReportContentTypesArgs']]):
        pulumi.set(self, "content_types", value)

    @_builtins.property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Day of the week in which the news report will be sent if the frequency is set to WEEKLY.
        """
        return pulumi.get(self, "day_of_week")

    @day_of_week.setter
    def day_of_week(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "day_of_week", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The description of the news report.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter
    def locale(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Language of the news report.
        """
        return pulumi.get(self, "locale")

    @locale.setter
    def locale(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "locale", value)

    @_builtins.property
    @pulumi.getter(name="matchRule")
    def match_rule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Match rule used for tag filters.
        """
        return pulumi.get(self, "match_rule")

    @match_rule.setter
    def match_rule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "match_rule", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The news report name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="newsFrequency")
    def news_frequency(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) News report frequency.
        """
        return pulumi.get(self, "news_frequency")

    @news_frequency.setter
    def news_frequency(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "news_frequency", value)

    @_builtins.property
    @pulumi.getter(name="onsTopicId")
    def ons_topic_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ONS topic.
        """
        return pulumi.get(self, "ons_topic_id")

    @ons_topic_id.setter
    def ons_topic_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ons_topic_id", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the news report.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Defines if the news report will be enabled or disabled.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="tagFilters")
    def tag_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) List of tag filters; each filter composed by a namespace, key, and value. Example for defined tags - '<TagNamespace>.<TagKey>=<TagValue>'. Example for freeform tags - '<TagKey>=<TagValue>' 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "tag_filters")

    @tag_filters.setter
    def tag_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tag_filters", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time the the news report was first enabled. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time the news report was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:Opsi/newsReport:NewsReport")
class NewsReport(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 are_child_compartments_included: Optional[pulumi.Input[_builtins.bool]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 content_types: Optional[pulumi.Input[Union['NewsReportContentTypesArgs', 'NewsReportContentTypesArgsDict']]] = None,
                 day_of_week: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 locale: Optional[pulumi.Input[_builtins.str]] = None,
                 match_rule: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 news_frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 ons_topic_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_news_report = oci.opsi.NewsReport("test_news_report",
            compartment_id=compartment_id,
            content_types={
                "actionable_insights_resources": news_report_content_types_actionable_insights_resources,
                "capacity_planning_resources": news_report_content_types_capacity_planning_resources,
                "sql_insights_fleet_analysis_resources": news_report_content_types_sql_insights_fleet_analysis_resources,
                "sql_insights_performance_degradation_resources": news_report_content_types_sql_insights_performance_degradation_resources,
                "sql_insights_plan_changes_resources": news_report_content_types_sql_insights_plan_changes_resources,
                "sql_insights_top_databases_resources": news_report_content_types_sql_insights_top_databases_resources,
                "sql_insights_top_sql_by_insights_resources": news_report_content_types_sql_insights_top_sql_by_insights_resources,
                "sql_insights_top_sql_resources": news_report_content_types_sql_insights_top_sql_resources,
            },
            description=news_report_description,
            locale=news_report_locale,
            name=news_report_name,
            news_frequency=news_report_news_frequency,
            ons_topic_id=test_ons_topic["id"],
            are_child_compartments_included=news_report_are_child_compartments_included,
            day_of_week=news_report_day_of_week,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            match_rule=news_report_match_rule,
            status=news_report_status,
            tag_filters=news_report_tag_filters)
        ```

        ## Import

        NewsReports can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Opsi/newsReport:NewsReport test_news_report "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] are_child_compartments_included: (Updatable) A flag to consider the resources within a given compartment and all sub-compartments.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) Compartment Identifier where the news report will be created.
        :param pulumi.Input[Union['NewsReportContentTypesArgs', 'NewsReportContentTypesArgsDict']] content_types: (Updatable) Content types that the news report can handle.
        :param pulumi.Input[_builtins.str] day_of_week: (Updatable) Day of the week in which the news report will be sent if the frequency is set to WEEKLY.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) The description of the news report.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] locale: (Updatable) Language of the news report.
        :param pulumi.Input[_builtins.str] match_rule: (Updatable) Match rule used for tag filters.
        :param pulumi.Input[_builtins.str] name: (Updatable) The news report name.
        :param pulumi.Input[_builtins.str] news_frequency: (Updatable) News report frequency.
        :param pulumi.Input[_builtins.str] ons_topic_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ONS topic.
        :param pulumi.Input[_builtins.str] status: (Updatable) Defines if the news report will be enabled or disabled.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tag_filters: (Updatable) List of tag filters; each filter composed by a namespace, key, and value. Example for defined tags - '<TagNamespace>.<TagKey>=<TagValue>'. Example for freeform tags - '<TagKey>=<TagValue>' 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NewsReportArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_news_report = oci.opsi.NewsReport("test_news_report",
            compartment_id=compartment_id,
            content_types={
                "actionable_insights_resources": news_report_content_types_actionable_insights_resources,
                "capacity_planning_resources": news_report_content_types_capacity_planning_resources,
                "sql_insights_fleet_analysis_resources": news_report_content_types_sql_insights_fleet_analysis_resources,
                "sql_insights_performance_degradation_resources": news_report_content_types_sql_insights_performance_degradation_resources,
                "sql_insights_plan_changes_resources": news_report_content_types_sql_insights_plan_changes_resources,
                "sql_insights_top_databases_resources": news_report_content_types_sql_insights_top_databases_resources,
                "sql_insights_top_sql_by_insights_resources": news_report_content_types_sql_insights_top_sql_by_insights_resources,
                "sql_insights_top_sql_resources": news_report_content_types_sql_insights_top_sql_resources,
            },
            description=news_report_description,
            locale=news_report_locale,
            name=news_report_name,
            news_frequency=news_report_news_frequency,
            ons_topic_id=test_ons_topic["id"],
            are_child_compartments_included=news_report_are_child_compartments_included,
            day_of_week=news_report_day_of_week,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            match_rule=news_report_match_rule,
            status=news_report_status,
            tag_filters=news_report_tag_filters)
        ```

        ## Import

        NewsReports can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Opsi/newsReport:NewsReport test_news_report "id"
        ```

        :param str resource_name: The name of the resource.
        :param NewsReportArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NewsReportArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 are_child_compartments_included: Optional[pulumi.Input[_builtins.bool]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 content_types: Optional[pulumi.Input[Union['NewsReportContentTypesArgs', 'NewsReportContentTypesArgsDict']]] = None,
                 day_of_week: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 locale: Optional[pulumi.Input[_builtins.str]] = None,
                 match_rule: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 news_frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 ons_topic_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NewsReportArgs.__new__(NewsReportArgs)

            __props__.__dict__["are_child_compartments_included"] = are_child_compartments_included
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if content_types is None and not opts.urn:
                raise TypeError("Missing required property 'content_types'")
            __props__.__dict__["content_types"] = content_types
            __props__.__dict__["day_of_week"] = day_of_week
            __props__.__dict__["defined_tags"] = defined_tags
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["freeform_tags"] = freeform_tags
            if locale is None and not opts.urn:
                raise TypeError("Missing required property 'locale'")
            __props__.__dict__["locale"] = locale
            __props__.__dict__["match_rule"] = match_rule
            __props__.__dict__["name"] = name
            if news_frequency is None and not opts.urn:
                raise TypeError("Missing required property 'news_frequency'")
            __props__.__dict__["news_frequency"] = news_frequency
            if ons_topic_id is None and not opts.urn:
                raise TypeError("Missing required property 'ons_topic_id'")
            __props__.__dict__["ons_topic_id"] = ons_topic_id
            __props__.__dict__["status"] = status
            __props__.__dict__["tag_filters"] = tag_filters
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(NewsReport, __self__).__init__(
            'oci:Opsi/newsReport:NewsReport',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            are_child_compartments_included: Optional[pulumi.Input[_builtins.bool]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            content_types: Optional[pulumi.Input[Union['NewsReportContentTypesArgs', 'NewsReportContentTypesArgsDict']]] = None,
            day_of_week: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            locale: Optional[pulumi.Input[_builtins.str]] = None,
            match_rule: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            news_frequency: Optional[pulumi.Input[_builtins.str]] = None,
            ons_topic_id: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tag_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None) -> 'NewsReport':
        """
        Get an existing NewsReport resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] are_child_compartments_included: (Updatable) A flag to consider the resources within a given compartment and all sub-compartments.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) Compartment Identifier where the news report will be created.
        :param pulumi.Input[Union['NewsReportContentTypesArgs', 'NewsReportContentTypesArgsDict']] content_types: (Updatable) Content types that the news report can handle.
        :param pulumi.Input[_builtins.str] day_of_week: (Updatable) Day of the week in which the news report will be sent if the frequency is set to WEEKLY.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) The description of the news report.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[_builtins.str] locale: (Updatable) Language of the news report.
        :param pulumi.Input[_builtins.str] match_rule: (Updatable) Match rule used for tag filters.
        :param pulumi.Input[_builtins.str] name: (Updatable) The news report name.
        :param pulumi.Input[_builtins.str] news_frequency: (Updatable) News report frequency.
        :param pulumi.Input[_builtins.str] ons_topic_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ONS topic.
        :param pulumi.Input[_builtins.str] state: The current state of the news report.
        :param pulumi.Input[_builtins.str] status: (Updatable) Defines if the news report will be enabled or disabled.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tag_filters: (Updatable) List of tag filters; each filter composed by a namespace, key, and value. Example for defined tags - '<TagNamespace>.<TagKey>=<TagValue>'. Example for freeform tags - '<TagKey>=<TagValue>' 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] time_created: The time the the news report was first enabled. An RFC3339 formatted datetime string.
        :param pulumi.Input[_builtins.str] time_updated: The time the news report was updated. An RFC3339 formatted datetime string.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NewsReportState.__new__(_NewsReportState)

        __props__.__dict__["are_child_compartments_included"] = are_child_compartments_included
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["content_types"] = content_types
        __props__.__dict__["day_of_week"] = day_of_week
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["locale"] = locale
        __props__.__dict__["match_rule"] = match_rule
        __props__.__dict__["name"] = name
        __props__.__dict__["news_frequency"] = news_frequency
        __props__.__dict__["ons_topic_id"] = ons_topic_id
        __props__.__dict__["state"] = state
        __props__.__dict__["status"] = status
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["tag_filters"] = tag_filters
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return NewsReport(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="areChildCompartmentsIncluded")
    def are_child_compartments_included(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) A flag to consider the resources within a given compartment and all sub-compartments.
        """
        return pulumi.get(self, "are_child_compartments_included")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Compartment Identifier where the news report will be created.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="contentTypes")
    def content_types(self) -> pulumi.Output['outputs.NewsReportContentTypes']:
        """
        (Updatable) Content types that the news report can handle.
        """
        return pulumi.get(self, "content_types")

    @_builtins.property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Day of the week in which the news report will be sent if the frequency is set to WEEKLY.
        """
        return pulumi.get(self, "day_of_week")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The description of the news report.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def locale(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Language of the news report.
        """
        return pulumi.get(self, "locale")

    @_builtins.property
    @pulumi.getter(name="matchRule")
    def match_rule(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Match rule used for tag filters.
        """
        return pulumi.get(self, "match_rule")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The news report name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="newsFrequency")
    def news_frequency(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) News report frequency.
        """
        return pulumi.get(self, "news_frequency")

    @_builtins.property
    @pulumi.getter(name="onsTopicId")
    def ons_topic_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ONS topic.
        """
        return pulumi.get(self, "ons_topic_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the news report.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Defines if the news report will be enabled or disabled.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="tagFilters")
    def tag_filters(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        (Updatable) List of tag filters; each filter composed by a namespace, key, and value. Example for defined tags - '<TagNamespace>.<TagKey>=<TagValue>'. Example for freeform tags - '<TagKey>=<TagValue>' 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "tag_filters")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The time the the news report was first enabled. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The time the news report was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

