# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConfigurationArgs', 'Configuration']

@pulumi.input_type
class ConfigurationArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 db_configuration_overrides: pulumi.Input['ConfigurationDbConfigurationOverridesArgs'],
                 db_version: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 compatible_shapes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 instance_memory_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_ocpu_count: Optional[pulumi.Input[_builtins.int]] = None,
                 is_flexible: Optional[pulumi.Input[_builtins.bool]] = None,
                 shape: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Configuration resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the configuration.
        :param pulumi.Input['ConfigurationDbConfigurationOverridesArgs'] db_configuration_overrides: Configuration overrides for a PostgreSQL instance.
        :param pulumi.Input[_builtins.str] db_version: Version of the PostgreSQL database.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly display name for the configuration. Avoid entering confidential information.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] compatible_shapes: (Updatable) Indicates the collection of compatible shapes for this configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) Details about the configuration set.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.int] instance_memory_size_in_gbs: Memory size in gigabytes with 1GB increment.
               
               Skip or set it's value to 0 if configuration is for a flexible shape.
        :param pulumi.Input[_builtins.int] instance_ocpu_count: CPU core count.
               
               Skip or set it's value to 0 if configuration is for a flexible shape.
        :param pulumi.Input[_builtins.bool] is_flexible: Whether the configuration supports flexible shapes.
        :param pulumi.Input[_builtins.str] shape: The name of the shape for the configuration. 
               
               For multi-shape enabled configurations, it is set to PostgreSQL.X86 or similar. Please use compatibleShapes property to set the list of supported shapes.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "db_configuration_overrides", db_configuration_overrides)
        pulumi.set(__self__, "db_version", db_version)
        pulumi.set(__self__, "display_name", display_name)
        if compatible_shapes is not None:
            pulumi.set(__self__, "compatible_shapes", compatible_shapes)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if instance_memory_size_in_gbs is not None:
            pulumi.set(__self__, "instance_memory_size_in_gbs", instance_memory_size_in_gbs)
        if instance_ocpu_count is not None:
            pulumi.set(__self__, "instance_ocpu_count", instance_ocpu_count)
        if is_flexible is not None:
            pulumi.set(__self__, "is_flexible", is_flexible)
        if shape is not None:
            pulumi.set(__self__, "shape", shape)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the configuration.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="dbConfigurationOverrides")
    def db_configuration_overrides(self) -> pulumi.Input['ConfigurationDbConfigurationOverridesArgs']:
        """
        Configuration overrides for a PostgreSQL instance.
        """
        return pulumi.get(self, "db_configuration_overrides")

    @db_configuration_overrides.setter
    def db_configuration_overrides(self, value: pulumi.Input['ConfigurationDbConfigurationOverridesArgs']):
        pulumi.set(self, "db_configuration_overrides", value)

    @_builtins.property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> pulumi.Input[_builtins.str]:
        """
        Version of the PostgreSQL database.
        """
        return pulumi.get(self, "db_version")

    @db_version.setter
    def db_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_version", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) A user-friendly display name for the configuration. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="compatibleShapes")
    def compatible_shapes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Indicates the collection of compatible shapes for this configuration.
        """
        return pulumi.get(self, "compatible_shapes")

    @compatible_shapes.setter
    def compatible_shapes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "compatible_shapes", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Details about the configuration set.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="instanceMemorySizeInGbs")
    def instance_memory_size_in_gbs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Memory size in gigabytes with 1GB increment.

        Skip or set it's value to 0 if configuration is for a flexible shape.
        """
        return pulumi.get(self, "instance_memory_size_in_gbs")

    @instance_memory_size_in_gbs.setter
    def instance_memory_size_in_gbs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "instance_memory_size_in_gbs", value)

    @_builtins.property
    @pulumi.getter(name="instanceOcpuCount")
    def instance_ocpu_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        CPU core count.

        Skip or set it's value to 0 if configuration is for a flexible shape.
        """
        return pulumi.get(self, "instance_ocpu_count")

    @instance_ocpu_count.setter
    def instance_ocpu_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "instance_ocpu_count", value)

    @_builtins.property
    @pulumi.getter(name="isFlexible")
    def is_flexible(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the configuration supports flexible shapes.
        """
        return pulumi.get(self, "is_flexible")

    @is_flexible.setter
    def is_flexible(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_flexible", value)

    @_builtins.property
    @pulumi.getter
    def shape(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the shape for the configuration. 

        For multi-shape enabled configurations, it is set to PostgreSQL.X86 or similar. Please use compatibleShapes property to set the list of supported shapes.
        """
        return pulumi.get(self, "shape")

    @shape.setter
    def shape(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "shape", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)


@pulumi.input_type
class _ConfigurationState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compatible_shapes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 config_type: Optional[pulumi.Input[_builtins.str]] = None,
                 configuration_details: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationConfigurationDetailArgs']]]] = None,
                 db_configuration_overrides: Optional[pulumi.Input['ConfigurationDbConfigurationOverridesArgs']] = None,
                 db_version: Optional[pulumi.Input[_builtins.str]] = None,
                 default_config_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 instance_memory_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_ocpu_count: Optional[pulumi.Input[_builtins.int]] = None,
                 is_flexible: Optional[pulumi.Input[_builtins.bool]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 shape: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Configuration resources.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the configuration.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] compatible_shapes: (Updatable) Indicates the collection of compatible shapes for this configuration.
        :param pulumi.Input[_builtins.str] config_type: The type of configuration. Either user-created or a default configuration.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigurationConfigurationDetailArgs']]] configuration_details: List of configuration details.
        :param pulumi.Input['ConfigurationDbConfigurationOverridesArgs'] db_configuration_overrides: Configuration overrides for a PostgreSQL instance.
        :param pulumi.Input[_builtins.str] db_version: Version of the PostgreSQL database.
        :param pulumi.Input[_builtins.str] default_config_id: The Default configuration used for this configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) Details about the configuration set.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly display name for the configuration. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.int] instance_memory_size_in_gbs: Memory size in gigabytes with 1GB increment.
               
               Skip or set it's value to 0 if configuration is for a flexible shape.
        :param pulumi.Input[_builtins.int] instance_ocpu_count: CPU core count.
               
               Skip or set it's value to 0 if configuration is for a flexible shape.
        :param pulumi.Input[_builtins.bool] is_flexible: Whether the configuration supports flexible shapes.
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[_builtins.str] shape: The name of the shape for the configuration. 
               
               For multi-shape enabled configurations, it is set to PostgreSQL.X86 or similar. Please use compatibleShapes property to set the list of supported shapes.
        :param pulumi.Input[_builtins.str] state: The current state of the configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] time_created: The date and time that the configuration was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if compatible_shapes is not None:
            pulumi.set(__self__, "compatible_shapes", compatible_shapes)
        if config_type is not None:
            pulumi.set(__self__, "config_type", config_type)
        if configuration_details is not None:
            pulumi.set(__self__, "configuration_details", configuration_details)
        if db_configuration_overrides is not None:
            pulumi.set(__self__, "db_configuration_overrides", db_configuration_overrides)
        if db_version is not None:
            pulumi.set(__self__, "db_version", db_version)
        if default_config_id is not None:
            pulumi.set(__self__, "default_config_id", default_config_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if instance_memory_size_in_gbs is not None:
            pulumi.set(__self__, "instance_memory_size_in_gbs", instance_memory_size_in_gbs)
        if instance_ocpu_count is not None:
            pulumi.set(__self__, "instance_ocpu_count", instance_ocpu_count)
        if is_flexible is not None:
            pulumi.set(__self__, "is_flexible", is_flexible)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if shape is not None:
            pulumi.set(__self__, "shape", shape)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the configuration.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="compatibleShapes")
    def compatible_shapes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Indicates the collection of compatible shapes for this configuration.
        """
        return pulumi.get(self, "compatible_shapes")

    @compatible_shapes.setter
    def compatible_shapes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "compatible_shapes", value)

    @_builtins.property
    @pulumi.getter(name="configType")
    def config_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of configuration. Either user-created or a default configuration.
        """
        return pulumi.get(self, "config_type")

    @config_type.setter
    def config_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "config_type", value)

    @_builtins.property
    @pulumi.getter(name="configurationDetails")
    def configuration_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationConfigurationDetailArgs']]]]:
        """
        List of configuration details.
        """
        return pulumi.get(self, "configuration_details")

    @configuration_details.setter
    def configuration_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationConfigurationDetailArgs']]]]):
        pulumi.set(self, "configuration_details", value)

    @_builtins.property
    @pulumi.getter(name="dbConfigurationOverrides")
    def db_configuration_overrides(self) -> Optional[pulumi.Input['ConfigurationDbConfigurationOverridesArgs']]:
        """
        Configuration overrides for a PostgreSQL instance.
        """
        return pulumi.get(self, "db_configuration_overrides")

    @db_configuration_overrides.setter
    def db_configuration_overrides(self, value: Optional[pulumi.Input['ConfigurationDbConfigurationOverridesArgs']]):
        pulumi.set(self, "db_configuration_overrides", value)

    @_builtins.property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version of the PostgreSQL database.
        """
        return pulumi.get(self, "db_version")

    @db_version.setter
    def db_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_version", value)

    @_builtins.property
    @pulumi.getter(name="defaultConfigId")
    def default_config_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Default configuration used for this configuration.
        """
        return pulumi.get(self, "default_config_id")

    @default_config_id.setter
    def default_config_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_config_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Details about the configuration set.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly display name for the configuration. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="instanceMemorySizeInGbs")
    def instance_memory_size_in_gbs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Memory size in gigabytes with 1GB increment.

        Skip or set it's value to 0 if configuration is for a flexible shape.
        """
        return pulumi.get(self, "instance_memory_size_in_gbs")

    @instance_memory_size_in_gbs.setter
    def instance_memory_size_in_gbs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "instance_memory_size_in_gbs", value)

    @_builtins.property
    @pulumi.getter(name="instanceOcpuCount")
    def instance_ocpu_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        CPU core count.

        Skip or set it's value to 0 if configuration is for a flexible shape.
        """
        return pulumi.get(self, "instance_ocpu_count")

    @instance_ocpu_count.setter
    def instance_ocpu_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "instance_ocpu_count", value)

    @_builtins.property
    @pulumi.getter(name="isFlexible")
    def is_flexible(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the configuration supports flexible shapes.
        """
        return pulumi.get(self, "is_flexible")

    @is_flexible.setter
    def is_flexible(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_flexible", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter
    def shape(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the shape for the configuration. 

        For multi-shape enabled configurations, it is set to PostgreSQL.X86 or similar. Please use compatibleShapes property to set the list of supported shapes.
        """
        return pulumi.get(self, "shape")

    @shape.setter
    def shape(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "shape", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the configuration.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time that the configuration was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)


@pulumi.type_token("oci:Psql/configuration:Configuration")
class Configuration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compatible_shapes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 db_configuration_overrides: Optional[pulumi.Input[Union['ConfigurationDbConfigurationOverridesArgs', 'ConfigurationDbConfigurationOverridesArgsDict']]] = None,
                 db_version: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 instance_memory_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_ocpu_count: Optional[pulumi.Input[_builtins.int]] = None,
                 is_flexible: Optional[pulumi.Input[_builtins.bool]] = None,
                 shape: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_configuration = oci.psql.Configuration("test_configuration",
            compartment_id=compartment_id,
            db_configuration_overrides={
                "items": [{
                    "config_key": configuration_db_configuration_overrides_items_config_key,
                    "overriden_config_value": configuration_db_configuration_overrides_items_overriden_config_value,
                }],
            },
            db_version=configuration_db_version,
            display_name=configuration_display_name,
            compatible_shapes=configuration_compatible_shapes,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=configuration_description,
            freeform_tags={
                "bar-key": "value",
            },
            instance_memory_size_in_gbs=configuration_instance_memory_size_in_gbs,
            instance_ocpu_count=configuration_instance_ocpu_count,
            is_flexible=configuration_is_flexible,
            shape=configuration_shape,
            system_tags=configuration_system_tags)
        ```

        ## Import

        Configurations can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Psql/configuration:Configuration test_configuration "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the configuration.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] compatible_shapes: (Updatable) Indicates the collection of compatible shapes for this configuration.
        :param pulumi.Input[Union['ConfigurationDbConfigurationOverridesArgs', 'ConfigurationDbConfigurationOverridesArgsDict']] db_configuration_overrides: Configuration overrides for a PostgreSQL instance.
        :param pulumi.Input[_builtins.str] db_version: Version of the PostgreSQL database.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) Details about the configuration set.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly display name for the configuration. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.int] instance_memory_size_in_gbs: Memory size in gigabytes with 1GB increment.
               
               Skip or set it's value to 0 if configuration is for a flexible shape.
        :param pulumi.Input[_builtins.int] instance_ocpu_count: CPU core count.
               
               Skip or set it's value to 0 if configuration is for a flexible shape.
        :param pulumi.Input[_builtins.bool] is_flexible: Whether the configuration supports flexible shapes.
        :param pulumi.Input[_builtins.str] shape: The name of the shape for the configuration. 
               
               For multi-shape enabled configurations, it is set to PostgreSQL.X86 or similar. Please use compatibleShapes property to set the list of supported shapes.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_configuration = oci.psql.Configuration("test_configuration",
            compartment_id=compartment_id,
            db_configuration_overrides={
                "items": [{
                    "config_key": configuration_db_configuration_overrides_items_config_key,
                    "overriden_config_value": configuration_db_configuration_overrides_items_overriden_config_value,
                }],
            },
            db_version=configuration_db_version,
            display_name=configuration_display_name,
            compatible_shapes=configuration_compatible_shapes,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=configuration_description,
            freeform_tags={
                "bar-key": "value",
            },
            instance_memory_size_in_gbs=configuration_instance_memory_size_in_gbs,
            instance_ocpu_count=configuration_instance_ocpu_count,
            is_flexible=configuration_is_flexible,
            shape=configuration_shape,
            system_tags=configuration_system_tags)
        ```

        ## Import

        Configurations can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Psql/configuration:Configuration test_configuration "id"
        ```

        :param str resource_name: The name of the resource.
        :param ConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compatible_shapes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 db_configuration_overrides: Optional[pulumi.Input[Union['ConfigurationDbConfigurationOverridesArgs', 'ConfigurationDbConfigurationOverridesArgsDict']]] = None,
                 db_version: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 instance_memory_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_ocpu_count: Optional[pulumi.Input[_builtins.int]] = None,
                 is_flexible: Optional[pulumi.Input[_builtins.bool]] = None,
                 shape: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConfigurationArgs.__new__(ConfigurationArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["compatible_shapes"] = compatible_shapes
            if db_configuration_overrides is None and not opts.urn:
                raise TypeError("Missing required property 'db_configuration_overrides'")
            __props__.__dict__["db_configuration_overrides"] = db_configuration_overrides
            if db_version is None and not opts.urn:
                raise TypeError("Missing required property 'db_version'")
            __props__.__dict__["db_version"] = db_version
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["instance_memory_size_in_gbs"] = instance_memory_size_in_gbs
            __props__.__dict__["instance_ocpu_count"] = instance_ocpu_count
            __props__.__dict__["is_flexible"] = is_flexible
            __props__.__dict__["shape"] = shape
            __props__.__dict__["system_tags"] = system_tags
            __props__.__dict__["config_type"] = None
            __props__.__dict__["configuration_details"] = None
            __props__.__dict__["default_config_id"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
        super(Configuration, __self__).__init__(
            'oci:Psql/configuration:Configuration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            compatible_shapes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            config_type: Optional[pulumi.Input[_builtins.str]] = None,
            configuration_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationConfigurationDetailArgs', 'ConfigurationConfigurationDetailArgsDict']]]]] = None,
            db_configuration_overrides: Optional[pulumi.Input[Union['ConfigurationDbConfigurationOverridesArgs', 'ConfigurationDbConfigurationOverridesArgsDict']]] = None,
            db_version: Optional[pulumi.Input[_builtins.str]] = None,
            default_config_id: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            instance_memory_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
            instance_ocpu_count: Optional[pulumi.Input[_builtins.int]] = None,
            is_flexible: Optional[pulumi.Input[_builtins.bool]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            shape: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None) -> 'Configuration':
        """
        Get an existing Configuration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the configuration.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] compatible_shapes: (Updatable) Indicates the collection of compatible shapes for this configuration.
        :param pulumi.Input[_builtins.str] config_type: The type of configuration. Either user-created or a default configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationConfigurationDetailArgs', 'ConfigurationConfigurationDetailArgsDict']]]] configuration_details: List of configuration details.
        :param pulumi.Input[Union['ConfigurationDbConfigurationOverridesArgs', 'ConfigurationDbConfigurationOverridesArgsDict']] db_configuration_overrides: Configuration overrides for a PostgreSQL instance.
        :param pulumi.Input[_builtins.str] db_version: Version of the PostgreSQL database.
        :param pulumi.Input[_builtins.str] default_config_id: The Default configuration used for this configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) Details about the configuration set.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly display name for the configuration. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.int] instance_memory_size_in_gbs: Memory size in gigabytes with 1GB increment.
               
               Skip or set it's value to 0 if configuration is for a flexible shape.
        :param pulumi.Input[_builtins.int] instance_ocpu_count: CPU core count.
               
               Skip or set it's value to 0 if configuration is for a flexible shape.
        :param pulumi.Input[_builtins.bool] is_flexible: Whether the configuration supports flexible shapes.
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[_builtins.str] shape: The name of the shape for the configuration. 
               
               For multi-shape enabled configurations, it is set to PostgreSQL.X86 or similar. Please use compatibleShapes property to set the list of supported shapes.
        :param pulumi.Input[_builtins.str] state: The current state of the configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] time_created: The date and time that the configuration was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConfigurationState.__new__(_ConfigurationState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["compatible_shapes"] = compatible_shapes
        __props__.__dict__["config_type"] = config_type
        __props__.__dict__["configuration_details"] = configuration_details
        __props__.__dict__["db_configuration_overrides"] = db_configuration_overrides
        __props__.__dict__["db_version"] = db_version
        __props__.__dict__["default_config_id"] = default_config_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["instance_memory_size_in_gbs"] = instance_memory_size_in_gbs
        __props__.__dict__["instance_ocpu_count"] = instance_ocpu_count
        __props__.__dict__["is_flexible"] = is_flexible
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["shape"] = shape
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        return Configuration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the configuration.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="compatibleShapes")
    def compatible_shapes(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        (Updatable) Indicates the collection of compatible shapes for this configuration.
        """
        return pulumi.get(self, "compatible_shapes")

    @_builtins.property
    @pulumi.getter(name="configType")
    def config_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of configuration. Either user-created or a default configuration.
        """
        return pulumi.get(self, "config_type")

    @_builtins.property
    @pulumi.getter(name="configurationDetails")
    def configuration_details(self) -> pulumi.Output[Sequence['outputs.ConfigurationConfigurationDetail']]:
        """
        List of configuration details.
        """
        return pulumi.get(self, "configuration_details")

    @_builtins.property
    @pulumi.getter(name="dbConfigurationOverrides")
    def db_configuration_overrides(self) -> pulumi.Output['outputs.ConfigurationDbConfigurationOverrides']:
        """
        Configuration overrides for a PostgreSQL instance.
        """
        return pulumi.get(self, "db_configuration_overrides")

    @_builtins.property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> pulumi.Output[_builtins.str]:
        """
        Version of the PostgreSQL database.
        """
        return pulumi.get(self, "db_version")

    @_builtins.property
    @pulumi.getter(name="defaultConfigId")
    def default_config_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Default configuration used for this configuration.
        """
        return pulumi.get(self, "default_config_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Details about the configuration set.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) A user-friendly display name for the configuration. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="instanceMemorySizeInGbs")
    def instance_memory_size_in_gbs(self) -> pulumi.Output[_builtins.int]:
        """
        Memory size in gigabytes with 1GB increment.

        Skip or set it's value to 0 if configuration is for a flexible shape.
        """
        return pulumi.get(self, "instance_memory_size_in_gbs")

    @_builtins.property
    @pulumi.getter(name="instanceOcpuCount")
    def instance_ocpu_count(self) -> pulumi.Output[_builtins.int]:
        """
        CPU core count.

        Skip or set it's value to 0 if configuration is for a flexible shape.
        """
        return pulumi.get(self, "instance_ocpu_count")

    @_builtins.property
    @pulumi.getter(name="isFlexible")
    def is_flexible(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the configuration supports flexible shapes.
        """
        return pulumi.get(self, "is_flexible")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def shape(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the shape for the configuration. 

        For multi-shape enabled configurations, it is set to PostgreSQL.X86 or similar. Please use compatibleShapes property to set the list of supported shapes.
        """
        return pulumi.get(self, "shape")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the configuration.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time that the configuration was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

