# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetRecoveryServiceSubnetResult',
    'AwaitableGetRecoveryServiceSubnetResult',
    'get_recovery_service_subnet',
    'get_recovery_service_subnet_output',
]

@pulumi.output_type
class GetRecoveryServiceSubnetResult:
    """
    A collection of values returned by getRecoveryServiceSubnet.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, lifecycle_details=None, nsg_ids=None, recovery_service_subnet_id=None, state=None, subnet_id=None, subnets=None, system_tags=None, time_created=None, time_updated=None, vcn_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if nsg_ids and not isinstance(nsg_ids, list):
            raise TypeError("Expected argument 'nsg_ids' to be a list")
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        if recovery_service_subnet_id and not isinstance(recovery_service_subnet_id, str):
            raise TypeError("Expected argument 'recovery_service_subnet_id' to be a str")
        pulumi.set(__self__, "recovery_service_subnet_id", recovery_service_subnet_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)
        if subnets and not isinstance(subnets, list):
            raise TypeError("Expected argument 'subnets' to be a list")
        pulumi.set(__self__, "subnets", subnets)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if vcn_id and not isinstance(vcn_id, str):
            raise TypeError("Expected argument 'vcn_id' to be a str")
        pulumi.set(__self__, "vcn_id", vcn_id)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The compartment OCID.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. For more information, see [Resource Tags](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/resourcetags.htm)
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A user-provided name for the recovery service subnet.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The recovery service subnet OCID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        Detailed description about the current lifecycle state of the recovery service subnet. For example, it can be used to provide actionable information for a resource in a Failed state
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[_builtins.str]:
        """
        A list of network security group (NSG) OCIDs that are associated with the Recovery Service subnet. You can specify a maximum of 5 unique OCIDs, which implies that you can associate a maximum of 5 NSGs to each Recovery Service subnet. Specify an empty array if you want to remove all the associated NSGs from a Recovery Service subnet. See [Network Security Groups](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/NetworkSecurityGroup/) for more information.
        """
        return pulumi.get(self, "nsg_ids")

    @_builtins.property
    @pulumi.getter(name="recoveryServiceSubnetId")
    def recovery_service_subnet_id(self) -> _builtins.str:
        return pulumi.get(self, "recovery_service_subnet_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the recovery service subnet.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    @_utilities.deprecated("""The 'subnet_id' field has been deprecated. Please use 'subnets' instead.""")
    def subnet_id(self) -> _builtins.str:
        """
        Deprecated. One of the subnets associated with the Recovery Service subnet.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter
    def subnets(self) -> Sequence[_builtins.str]:
        """
        A list of OCIDs of all the subnets associated with the Recovery Service subnet.
        """
        return pulumi.get(self, "subnets")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`. For more information, see [Resource Tags](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/resourcetags.htm)
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        An RFC3339 formatted datetime string that indicates the last created time for a recovery service subnet. For example: '2020-05-22T21:10:29.600Z'.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        An RFC3339 formatted datetime string that indicates the last updated time for a recovery service subnet. For example: '2020-05-22T21:10:29.600Z'.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> _builtins.str:
        """
        VCN Identifier.
        """
        return pulumi.get(self, "vcn_id")


class AwaitableGetRecoveryServiceSubnetResult(GetRecoveryServiceSubnetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRecoveryServiceSubnetResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            nsg_ids=self.nsg_ids,
            recovery_service_subnet_id=self.recovery_service_subnet_id,
            state=self.state,
            subnet_id=self.subnet_id,
            subnets=self.subnets,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated,
            vcn_id=self.vcn_id)


def get_recovery_service_subnet(recovery_service_subnet_id: Optional[_builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRecoveryServiceSubnetResult:
    """
    This data source provides details about a specific Recovery Service Subnet resource in Oracle Cloud Infrastructure Recovery service.

    Gets information about a specified recovery service subnet.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_recovery_service_subnet = oci.RecoveryMod.get_recovery_service_subnet(recovery_service_subnet_id=test_recovery_service_subnet_oci_recovery_recovery_service_subnet["id"])
    ```


    :param _builtins.str recovery_service_subnet_id: The recovery service subnet OCID.
    """
    __args__ = dict()
    __args__['recoveryServiceSubnetId'] = recovery_service_subnet_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:RecoveryMod/getRecoveryServiceSubnet:getRecoveryServiceSubnet', __args__, opts=opts, typ=GetRecoveryServiceSubnetResult).value

    return AwaitableGetRecoveryServiceSubnetResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        nsg_ids=pulumi.get(__ret__, 'nsg_ids'),
        recovery_service_subnet_id=pulumi.get(__ret__, 'recovery_service_subnet_id'),
        state=pulumi.get(__ret__, 'state'),
        subnet_id=pulumi.get(__ret__, 'subnet_id'),
        subnets=pulumi.get(__ret__, 'subnets'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        vcn_id=pulumi.get(__ret__, 'vcn_id'))
def get_recovery_service_subnet_output(recovery_service_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRecoveryServiceSubnetResult]:
    """
    This data source provides details about a specific Recovery Service Subnet resource in Oracle Cloud Infrastructure Recovery service.

    Gets information about a specified recovery service subnet.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_recovery_service_subnet = oci.RecoveryMod.get_recovery_service_subnet(recovery_service_subnet_id=test_recovery_service_subnet_oci_recovery_recovery_service_subnet["id"])
    ```


    :param _builtins.str recovery_service_subnet_id: The recovery service subnet OCID.
    """
    __args__ = dict()
    __args__['recoveryServiceSubnetId'] = recovery_service_subnet_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:RecoveryMod/getRecoveryServiceSubnet:getRecoveryServiceSubnet', __args__, opts=opts, typ=GetRecoveryServiceSubnetResult)
    return __ret__.apply(lambda __response__: GetRecoveryServiceSubnetResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        nsg_ids=pulumi.get(__response__, 'nsg_ids'),
        recovery_service_subnet_id=pulumi.get(__response__, 'recovery_service_subnet_id'),
        state=pulumi.get(__response__, 'state'),
        subnet_id=pulumi.get(__response__, 'subnet_id'),
        subnets=pulumi.get(__response__, 'subnets'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        vcn_id=pulumi.get(__response__, 'vcn_id')))
