# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetStacksResult',
    'AwaitableGetStacksResult',
    'get_stacks',
    'get_stacks_output',
]

@pulumi.output_type
class GetStacksResult:
    """
    A collection of values returned by getStacks.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, stacks=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if stacks and not isinstance(stacks, list):
            raise TypeError("Expected argument 'stacks' to be a list")
        pulumi.set(__self__, "stacks", stacks)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        Unique identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) for the compartment where the stack is located.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetStacksFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        Unique identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) for the stack.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def stacks(self) -> Sequence['outputs.GetStacksStackResult']:
        """
        The list of stacks.
        """
        return pulumi.get(self, "stacks")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current lifecycle state of the stack. For more information about stack lifecycle states in Resource Manager, see [Key Concepts](https://docs.cloud.oracle.com/iaas/Content/ResourceManager/Concepts/resourcemanager.htm#concepts__StackStates).
        """
        return pulumi.get(self, "state")


class AwaitableGetStacksResult(GetStacksResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStacksResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            stacks=self.stacks,
            state=self.state)


def get_stacks(compartment_id: Optional[_builtins.str] = None,
               display_name: Optional[_builtins.str] = None,
               filters: Optional[Sequence[Union['GetStacksFilterArgs', 'GetStacksFilterArgsDict']]] = None,
               id: Optional[_builtins.str] = None,
               state: Optional[_builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStacksResult:
    """
    This data source provides the list of Stacks in Oracle Cloud Infrastructure Resource Manager service.

    Lists stacks according to the specified filter.
    For more information, see
    [Listing Stacks](https://docs.cloud.oracle.com/iaas/Content/ResourceManager/Tasks/list-stacks.htm).
    - If called using the compartment ID, returns all stacks in the specified compartment.
    - If called using the stack ID, returns the specified stack. (See also [GetStack](https://docs.cloud.oracle.com/iaas/api/#/en/resourcemanager/latest/Stack/GetStack).)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_stacks = oci.ResourceManager.get_stacks(compartment_id=compartment_id,
        display_name=stack_display_name,
        id=stack_id,
        state=stack_state)
    ```


    :param _builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) on which to filter.
    :param _builtins.str display_name: Display name on which to query.
    :param _builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) on which to query for a stack.
    :param _builtins.str state: A filter that returns only those resources that match the specified lifecycle state. The state value is case-insensitive. For more information about stack lifecycle states, see [Key Concepts](https://docs.cloud.oracle.com/iaas/Content/ResourceManager/Concepts/resourcemanager.htm#concepts__StackStates).
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ResourceManager/getStacks:getStacks', __args__, opts=opts, typ=GetStacksResult).value

    return AwaitableGetStacksResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        stacks=pulumi.get(__ret__, 'stacks'),
        state=pulumi.get(__ret__, 'state'))
def get_stacks_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                      display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      filters: Optional[pulumi.Input[Optional[Sequence[Union['GetStacksFilterArgs', 'GetStacksFilterArgsDict']]]]] = None,
                      id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetStacksResult]:
    """
    This data source provides the list of Stacks in Oracle Cloud Infrastructure Resource Manager service.

    Lists stacks according to the specified filter.
    For more information, see
    [Listing Stacks](https://docs.cloud.oracle.com/iaas/Content/ResourceManager/Tasks/list-stacks.htm).
    - If called using the compartment ID, returns all stacks in the specified compartment.
    - If called using the stack ID, returns the specified stack. (See also [GetStack](https://docs.cloud.oracle.com/iaas/api/#/en/resourcemanager/latest/Stack/GetStack).)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_stacks = oci.ResourceManager.get_stacks(compartment_id=compartment_id,
        display_name=stack_display_name,
        id=stack_id,
        state=stack_state)
    ```


    :param _builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) on which to filter.
    :param _builtins.str display_name: Display name on which to query.
    :param _builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) on which to query for a stack.
    :param _builtins.str state: A filter that returns only those resources that match the specified lifecycle state. The state value is case-insensitive. For more information about stack lifecycle states, see [Key Concepts](https://docs.cloud.oracle.com/iaas/Content/ResourceManager/Concepts/resourcemanager.htm#concepts__StackStates).
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:ResourceManager/getStacks:getStacks', __args__, opts=opts, typ=GetStacksResult)
    return __ret__.apply(lambda __response__: GetStacksResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        stacks=pulumi.get(__response__, 'stacks'),
        state=pulumi.get(__response__, 'state')))
