# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ScheduleResource',
    'ScheduleResourceFilter',
    'ScheduleResourceFilterValue',
    'ScheduleResourceParameter',
    'GetScheduleResourceResult',
    'GetScheduleResourceFilterResult',
    'GetScheduleResourceFilterValueResult',
    'GetScheduleResourceParameterResult',
    'GetSchedulesFilterResult',
    'GetSchedulesScheduleCollectionResult',
    'GetSchedulesScheduleCollectionItemResult',
    'GetSchedulesScheduleCollectionItemResourceResult',
    'GetSchedulesScheduleCollectionItemResourceFilterResult',
    'GetSchedulesScheduleCollectionItemResourceFilterValueResult',
    'GetSchedulesScheduleCollectionItemResourceParameterResult',
]

@pulumi.output_type
class ScheduleResource(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 metadata: Optional[Mapping[str, _builtins.str]] = None,
                 parameters: Optional[Sequence['outputs.ScheduleResourceParameter']] = None):
        """
        :param _builtins.str id: (Updatable) This is the resource OCID.
        :param Mapping[str, _builtins.str] metadata: (Updatable) This is additional information that helps to identity the resource for the schedule.
               { "id": "<OCID_of_bucket>" "metadata": { "namespaceName": "sampleNamespace", "bucketName": "sampleBucket" } }
        :param Sequence['ScheduleResourceParameterArgs'] parameters: (Updatable) This is the user input parameters to use when acting on the resource.
               
               { "parameters": [ { "parameterType": "BODY", "value": { "ip": "192.168.44.44", "memory": "1024", "synced_folders": [ { "host_path": "data/", "guest_path": "/var/www", "type": "default" } ], "forwarded_ports": [] } }, { "parameterType": "PATH", "value": { "compartmentId": "ocid1.compartment.oc1..xxxxx", "instanceId": "ocid1.vcn.oc1..yyyy" } }, { "parameterType": "QUERY", "value": { "limit": "10", "tenantId": "ocid1.tenant.oc1..zzzz" } }, { "parameterType": "HEADER", "value": { "token": "xxxx" } } ] }
        """
        pulumi.set(__self__, "id", id)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        (Updatable) This is the resource OCID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        (Updatable) This is additional information that helps to identity the resource for the schedule.
        { "id": "<OCID_of_bucket>" "metadata": { "namespaceName": "sampleNamespace", "bucketName": "sampleBucket" } }
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[Sequence['outputs.ScheduleResourceParameter']]:
        """
        (Updatable) This is the user input parameters to use when acting on the resource.

        { "parameters": [ { "parameterType": "BODY", "value": { "ip": "192.168.44.44", "memory": "1024", "synced_folders": [ { "host_path": "data/", "guest_path": "/var/www", "type": "default" } ], "forwarded_ports": [] } }, { "parameterType": "PATH", "value": { "compartmentId": "ocid1.compartment.oc1..xxxxx", "instanceId": "ocid1.vcn.oc1..yyyy" } }, { "parameterType": "QUERY", "value": { "limit": "10", "tenantId": "ocid1.tenant.oc1..zzzz" } }, { "parameterType": "HEADER", "value": { "token": "xxxx" } } ] }
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class ScheduleResourceFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "shouldIncludeChildCompartments":
            suggest = "should_include_child_compartments"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduleResourceFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduleResourceFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduleResourceFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attribute: _builtins.str,
                 condition: Optional[_builtins.str] = None,
                 should_include_child_compartments: Optional[_builtins.bool] = None,
                 values: Optional[Sequence['outputs.ScheduleResourceFilterValue']] = None):
        """
        :param _builtins.str attribute: (Updatable) This is the resource attribute on which the threshold is defined. We support 5 different types of attributes: `DEFINED_TAGS`, `COMPARTMENT_ID`, `TIME_CREATED`, `LIFECYCLE_STATE` and `RESOURCE_TYPE`.
        :param _builtins.str condition: This is the condition for the filter in comparison to its creation time.
        :param _builtins.bool should_include_child_compartments: This sets whether to include child compartments.
        :param Sequence['ScheduleResourceFilterValueArgs'] values: (Updatable) This is a collection of resource filter values, different types of filter has different value format, see below:
               * When `attribute="DEFINED_TAGS"`:
        """
        pulumi.set(__self__, "attribute", attribute)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if should_include_child_compartments is not None:
            pulumi.set(__self__, "should_include_child_compartments", should_include_child_compartments)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def attribute(self) -> _builtins.str:
        """
        (Updatable) This is the resource attribute on which the threshold is defined. We support 5 different types of attributes: `DEFINED_TAGS`, `COMPARTMENT_ID`, `TIME_CREATED`, `LIFECYCLE_STATE` and `RESOURCE_TYPE`.
        """
        return pulumi.get(self, "attribute")

    @_builtins.property
    @pulumi.getter
    def condition(self) -> Optional[_builtins.str]:
        """
        This is the condition for the filter in comparison to its creation time.
        """
        return pulumi.get(self, "condition")

    @_builtins.property
    @pulumi.getter(name="shouldIncludeChildCompartments")
    def should_include_child_compartments(self) -> Optional[_builtins.bool]:
        """
        This sets whether to include child compartments.
        """
        return pulumi.get(self, "should_include_child_compartments")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Optional[Sequence['outputs.ScheduleResourceFilterValue']]:
        """
        (Updatable) This is a collection of resource filter values, different types of filter has different value format, see below:
        * When `attribute="DEFINED_TAGS"`:
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class ScheduleResourceFilterValue(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tagKey":
            suggest = "tag_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduleResourceFilterValue. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduleResourceFilterValue.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduleResourceFilterValue.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 namespace: Optional[_builtins.str] = None,
                 tag_key: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str namespace: This is the namespace of the defined tag.
        :param _builtins.str tag_key: This is the key of the defined tag.
        :param _builtins.str value: This is the lifecycle state value used for filtering.
        """
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if tag_key is not None:
            pulumi.set(__self__, "tag_key", tag_key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        """
        This is the namespace of the defined tag.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="tagKey")
    def tag_key(self) -> Optional[_builtins.str]:
        """
        This is the key of the defined tag.
        """
        return pulumi.get(self, "tag_key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        This is the lifecycle state value used for filtering.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ScheduleResourceParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "parameterType":
            suggest = "parameter_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduleResourceParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduleResourceParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduleResourceParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 parameter_type: _builtins.str,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str parameter_type: (Updatable) This is the parameter type on which the input parameter is defined
        :param _builtins.str value: (Updatable) This is the HTTP request header value.
               { "id": "<OCID_of_bucket>" "metadata": { "namespaceName": "sampleNamespace", "bucketName": "sampleBucket" } }
        """
        pulumi.set(__self__, "parameter_type", parameter_type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="parameterType")
    def parameter_type(self) -> _builtins.str:
        """
        (Updatable) This is the parameter type on which the input parameter is defined
        """
        return pulumi.get(self, "parameter_type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        (Updatable) This is the HTTP request header value.
        { "id": "<OCID_of_bucket>" "metadata": { "namespaceName": "sampleNamespace", "bucketName": "sampleBucket" } }
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetScheduleResourceResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 metadata: Mapping[str, _builtins.str],
                 parameters: Sequence['outputs.GetScheduleResourceParameterResult']):
        """
        :param _builtins.str id: This is the resource OCID.
        :param Mapping[str, _builtins.str] metadata: This is additional information that helps to identity the resource for the schedule.
        :param Sequence['GetScheduleResourceParameterArgs'] parameters: This is the user input parameters to use when acting on the resource.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "parameters", parameters)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        This is the resource OCID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Mapping[str, _builtins.str]:
        """
        This is additional information that helps to identity the resource for the schedule.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Sequence['outputs.GetScheduleResourceParameterResult']:
        """
        This is the user input parameters to use when acting on the resource.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class GetScheduleResourceFilterResult(dict):
    def __init__(__self__, *,
                 attribute: _builtins.str,
                 condition: _builtins.str,
                 should_include_child_compartments: _builtins.bool,
                 values: Sequence['outputs.GetScheduleResourceFilterValueResult']):
        """
        :param _builtins.str attribute: This is the resource attribute on which the threshold is defined.
        :param _builtins.str condition: This is the condition for the filter in comparison to its creation time.
        :param _builtins.bool should_include_child_compartments: This sets whether to include child compartments.
        :param Sequence['GetScheduleResourceFilterValueArgs'] values: This is the HTTP request header value.
        """
        pulumi.set(__self__, "attribute", attribute)
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "should_include_child_compartments", should_include_child_compartments)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def attribute(self) -> _builtins.str:
        """
        This is the resource attribute on which the threshold is defined.
        """
        return pulumi.get(self, "attribute")

    @_builtins.property
    @pulumi.getter
    def condition(self) -> _builtins.str:
        """
        This is the condition for the filter in comparison to its creation time.
        """
        return pulumi.get(self, "condition")

    @_builtins.property
    @pulumi.getter(name="shouldIncludeChildCompartments")
    def should_include_child_compartments(self) -> _builtins.bool:
        """
        This sets whether to include child compartments.
        """
        return pulumi.get(self, "should_include_child_compartments")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence['outputs.GetScheduleResourceFilterValueResult']:
        """
        This is the HTTP request header value.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetScheduleResourceFilterValueResult(dict):
    def __init__(__self__, *,
                 namespace: _builtins.str,
                 tag_key: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str namespace: This is the namespace of the defined tag.
        :param _builtins.str tag_key: This is the key of the defined tag.
        :param _builtins.str value: This is the HTTP request header value.
        """
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "tag_key", tag_key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        This is the namespace of the defined tag.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="tagKey")
    def tag_key(self) -> _builtins.str:
        """
        This is the key of the defined tag.
        """
        return pulumi.get(self, "tag_key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        This is the HTTP request header value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetScheduleResourceParameterResult(dict):
    def __init__(__self__, *,
                 parameter_type: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str parameter_type: This is the parameter type on which the input parameter is defined
        :param Sequence[_builtins.str] values: This is the HTTP request header value.
        """
        pulumi.set(__self__, "parameter_type", parameter_type)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter(name="parameterType")
    def parameter_type(self) -> _builtins.str:
        """
        This is the parameter type on which the input parameter is defined
        """
        return pulumi.get(self, "parameter_type")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        This is the HTTP request header value.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetSchedulesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetSchedulesScheduleCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetSchedulesScheduleCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetSchedulesScheduleCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetSchedulesScheduleCollectionItemResult(dict):
    def __init__(__self__, *,
                 action: _builtins.str,
                 compartment_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 description: _builtins.str,
                 display_name: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 last_run_status: _builtins.str,
                 recurrence_details: _builtins.str,
                 recurrence_type: _builtins.str,
                 resource_filters: Sequence['outputs.GetSchedulesScheduleCollectionItemResourceFilterResult'],
                 resources: Sequence['outputs.GetSchedulesScheduleCollectionItemResourceResult'],
                 state: _builtins.str,
                 system_tags: Mapping[str, _builtins.str],
                 time_created: _builtins.str,
                 time_ends: _builtins.str,
                 time_last_run: _builtins.str,
                 time_next_run: _builtins.str,
                 time_starts: _builtins.str,
                 time_updated: _builtins.str):
        """
        :param _builtins.str action: This is the action that will be executed by the schedule.
        :param _builtins.str compartment_id: This is the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources. You need to at least provide either `compartment_id` or `schedule_id` or both.
        :param Mapping[str, _builtins.str] defined_tags: These are defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param _builtins.str description: This is the description of the schedule.
        :param _builtins.str display_name: This is a filter to return only resources that match the given display name exactly.
        :param Mapping[str, _builtins.str] freeform_tags: These are free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param _builtins.str id: This is the resource OCID.
        :param _builtins.str last_run_status: This is the status of the last work request.
        :param _builtins.str recurrence_details: This is the frequency of recurrence of a schedule. The frequency field can either conform to RFC-5545 formatting or UNIX cron formatting for recurrences, based on the value specified by the recurrenceType field.
        :param _builtins.str recurrence_type: Type of recurrence of a schedule
        :param Sequence['GetSchedulesScheduleCollectionItemResourceFilterArgs'] resource_filters: This is a list of resources filters.  The schedule will be applied to resources matching all of them.
        :param Sequence['GetSchedulesScheduleCollectionItemResourceArgs'] resources: This is the list of resources to which the scheduled operation is applied.
        :param _builtins.str state: This is a filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
        :param Mapping[str, _builtins.str] system_tags: These are system tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param _builtins.str time_created: This is the date and time the schedule was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param _builtins.str time_ends: This is the date and time the schedule ends, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339)  Example: `2016-08-25T21:10:29.600Z`
        :param _builtins.str time_last_run: This is the date and time the schedule runs last time, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param _builtins.str time_next_run: This is the date and time the schedule run the next time, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param _builtins.str time_starts: This is the date and time the schedule starts, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339)  Example: `2016-08-25T21:10:29.600Z`
        :param _builtins.str time_updated: This is the date and time the schedule was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "last_run_status", last_run_status)
        pulumi.set(__self__, "recurrence_details", recurrence_details)
        pulumi.set(__self__, "recurrence_type", recurrence_type)
        pulumi.set(__self__, "resource_filters", resource_filters)
        pulumi.set(__self__, "resources", resources)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_ends", time_ends)
        pulumi.set(__self__, "time_last_run", time_last_run)
        pulumi.set(__self__, "time_next_run", time_next_run)
        pulumi.set(__self__, "time_starts", time_starts)
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.str:
        """
        This is the action that will be executed by the schedule.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        This is the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources. You need to at least provide either `compartment_id` or `schedule_id` or both.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        These are defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        This is the description of the schedule.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        This is a filter to return only resources that match the given display name exactly.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        These are free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        This is the resource OCID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lastRunStatus")
    def last_run_status(self) -> _builtins.str:
        """
        This is the status of the last work request.
        """
        return pulumi.get(self, "last_run_status")

    @_builtins.property
    @pulumi.getter(name="recurrenceDetails")
    def recurrence_details(self) -> _builtins.str:
        """
        This is the frequency of recurrence of a schedule. The frequency field can either conform to RFC-5545 formatting or UNIX cron formatting for recurrences, based on the value specified by the recurrenceType field.
        """
        return pulumi.get(self, "recurrence_details")

    @_builtins.property
    @pulumi.getter(name="recurrenceType")
    def recurrence_type(self) -> _builtins.str:
        """
        Type of recurrence of a schedule
        """
        return pulumi.get(self, "recurrence_type")

    @_builtins.property
    @pulumi.getter(name="resourceFilters")
    def resource_filters(self) -> Sequence['outputs.GetSchedulesScheduleCollectionItemResourceFilterResult']:
        """
        This is a list of resources filters.  The schedule will be applied to resources matching all of them.
        """
        return pulumi.get(self, "resource_filters")

    @_builtins.property
    @pulumi.getter
    def resources(self) -> Sequence['outputs.GetSchedulesScheduleCollectionItemResourceResult']:
        """
        This is the list of resources to which the scheduled operation is applied.
        """
        return pulumi.get(self, "resources")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        This is a filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        These are system tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        This is the date and time the schedule was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeEnds")
    def time_ends(self) -> _builtins.str:
        """
        This is the date and time the schedule ends, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339)  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_ends")

    @_builtins.property
    @pulumi.getter(name="timeLastRun")
    def time_last_run(self) -> _builtins.str:
        """
        This is the date and time the schedule runs last time, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_last_run")

    @_builtins.property
    @pulumi.getter(name="timeNextRun")
    def time_next_run(self) -> _builtins.str:
        """
        This is the date and time the schedule run the next time, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_next_run")

    @_builtins.property
    @pulumi.getter(name="timeStarts")
    def time_starts(self) -> _builtins.str:
        """
        This is the date and time the schedule starts, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339)  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_starts")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        This is the date and time the schedule was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetSchedulesScheduleCollectionItemResourceResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 metadata: Mapping[str, _builtins.str],
                 parameters: Sequence['outputs.GetSchedulesScheduleCollectionItemResourceParameterResult']):
        """
        :param _builtins.str id: This is the resource OCID.
        :param Mapping[str, _builtins.str] metadata: This is additional information that helps to identity the resource for the schedule.
        :param Sequence['GetSchedulesScheduleCollectionItemResourceParameterArgs'] parameters: This is the user input parameters to use when acting on the resource.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "parameters", parameters)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        This is the resource OCID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Mapping[str, _builtins.str]:
        """
        This is additional information that helps to identity the resource for the schedule.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Sequence['outputs.GetSchedulesScheduleCollectionItemResourceParameterResult']:
        """
        This is the user input parameters to use when acting on the resource.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class GetSchedulesScheduleCollectionItemResourceFilterResult(dict):
    def __init__(__self__, *,
                 attribute: _builtins.str,
                 condition: _builtins.str,
                 should_include_child_compartments: _builtins.bool,
                 values: Sequence['outputs.GetSchedulesScheduleCollectionItemResourceFilterValueResult']):
        """
        :param _builtins.str attribute: This is the resource attribute on which the threshold is defined.
        :param _builtins.str condition: This is the condition for the filter in comparison to its creation time.
        :param _builtins.bool should_include_child_compartments: This sets whether to include child compartments.
        :param Sequence['GetSchedulesScheduleCollectionItemResourceFilterValueArgs'] values: This is the HTTP request header value.
        """
        pulumi.set(__self__, "attribute", attribute)
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "should_include_child_compartments", should_include_child_compartments)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def attribute(self) -> _builtins.str:
        """
        This is the resource attribute on which the threshold is defined.
        """
        return pulumi.get(self, "attribute")

    @_builtins.property
    @pulumi.getter
    def condition(self) -> _builtins.str:
        """
        This is the condition for the filter in comparison to its creation time.
        """
        return pulumi.get(self, "condition")

    @_builtins.property
    @pulumi.getter(name="shouldIncludeChildCompartments")
    def should_include_child_compartments(self) -> _builtins.bool:
        """
        This sets whether to include child compartments.
        """
        return pulumi.get(self, "should_include_child_compartments")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence['outputs.GetSchedulesScheduleCollectionItemResourceFilterValueResult']:
        """
        This is the HTTP request header value.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetSchedulesScheduleCollectionItemResourceFilterValueResult(dict):
    def __init__(__self__, *,
                 namespace: _builtins.str,
                 tag_key: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str namespace: This is the namespace of the defined tag.
        :param _builtins.str tag_key: This is the key of the defined tag.
        :param _builtins.str value: This is the HTTP request header value.
        """
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "tag_key", tag_key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        This is the namespace of the defined tag.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="tagKey")
    def tag_key(self) -> _builtins.str:
        """
        This is the key of the defined tag.
        """
        return pulumi.get(self, "tag_key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        This is the HTTP request header value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetSchedulesScheduleCollectionItemResourceParameterResult(dict):
    def __init__(__self__, *,
                 parameter_type: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str parameter_type: This is the parameter type on which the input parameter is defined
        :param Sequence[_builtins.str] values: This is the HTTP request header value.
        """
        pulumi.set(__self__, "parameter_type", parameter_type)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter(name="parameterType")
    def parameter_type(self) -> _builtins.str:
        """
        This is the parameter type on which the input parameter is defined
        """
        return pulumi.get(self, "parameter_type")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        This is the HTTP request header value.
        """
        return pulumi.get(self, "values")


