# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetConnectorPluginsResult',
    'AwaitableGetConnectorPluginsResult',
    'get_connector_plugins',
    'get_connector_plugins_output',
]

@pulumi.output_type
class GetConnectorPluginsResult:
    """
    A collection of values returned by getConnectorPlugins.
    """
    def __init__(__self__, connector_plugin_collections=None, display_name=None, filters=None, id=None, name=None, state=None):
        if connector_plugin_collections and not isinstance(connector_plugin_collections, list):
            raise TypeError("Expected argument 'connector_plugin_collections' to be a list")
        pulumi.set(__self__, "connector_plugin_collections", connector_plugin_collections)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="connectorPluginCollections")
    def connector_plugin_collections(self) -> Sequence['outputs.GetConnectorPluginsConnectorPluginCollectionResult']:
        """
        The list of connector_plugin_collection.
        """
        return pulumi.get(self, "connector_plugin_collections")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetConnectorPluginsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The service to be called by the connector plugin. Example: `QueueSource`
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the service connector.
        """
        return pulumi.get(self, "state")


class AwaitableGetConnectorPluginsResult(GetConnectorPluginsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConnectorPluginsResult(
            connector_plugin_collections=self.connector_plugin_collections,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            name=self.name,
            state=self.state)


def get_connector_plugins(display_name: Optional[_builtins.str] = None,
                          filters: Optional[Sequence[Union['GetConnectorPluginsFilterArgs', 'GetConnectorPluginsFilterArgsDict']]] = None,
                          name: Optional[_builtins.str] = None,
                          state: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConnectorPluginsResult:
    """
    This data source provides the list of Connector Plugins in Oracle Cloud Infrastructure Service Connector Hub service.

    Lists connector plugins according to the specified filter.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_connector_plugins = oci.Sch.get_connector_plugins(display_name=connector_plugin_display_name,
        name=connector_plugin_name,
        state=connector_plugin_state)
    ```


    :param _builtins.str display_name: A filter to return only resources that match the given display name exactly.  Example: `example_service_connector`
    :param _builtins.str name: A filter to return only resources that match the given connector plugin name ignoring case.  Example: `QueueSource`
    :param _builtins.str state: A filter to return only resources that match the given lifecycle state.  Example: `ACTIVE`
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Sch/getConnectorPlugins:getConnectorPlugins', __args__, opts=opts, typ=GetConnectorPluginsResult).value

    return AwaitableGetConnectorPluginsResult(
        connector_plugin_collections=pulumi.get(__ret__, 'connector_plugin_collections'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        state=pulumi.get(__ret__, 'state'))
def get_connector_plugins_output(display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 filters: Optional[pulumi.Input[Optional[Sequence[Union['GetConnectorPluginsFilterArgs', 'GetConnectorPluginsFilterArgsDict']]]]] = None,
                                 name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetConnectorPluginsResult]:
    """
    This data source provides the list of Connector Plugins in Oracle Cloud Infrastructure Service Connector Hub service.

    Lists connector plugins according to the specified filter.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_connector_plugins = oci.Sch.get_connector_plugins(display_name=connector_plugin_display_name,
        name=connector_plugin_name,
        state=connector_plugin_state)
    ```


    :param _builtins.str display_name: A filter to return only resources that match the given display name exactly.  Example: `example_service_connector`
    :param _builtins.str name: A filter to return only resources that match the given connector plugin name ignoring case.  Example: `QueueSource`
    :param _builtins.str state: A filter to return only resources that match the given lifecycle state.  Example: `ACTIVE`
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Sch/getConnectorPlugins:getConnectorPlugins', __args__, opts=opts, typ=GetConnectorPluginsResult)
    return __ret__.apply(lambda __response__: GetConnectorPluginsResult(
        connector_plugin_collections=pulumi.get(__response__, 'connector_plugin_collections'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        state=pulumi.get(__response__, 'state')))
