# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['CatalogAssociationArgs', 'CatalogAssociation']

@pulumi.input_type
class CatalogAssociationArgs:
    def __init__(__self__, *,
                 entity_id: pulumi.Input[_builtins.str],
                 service_catalog_id: pulumi.Input[_builtins.str],
                 entity_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CatalogAssociation resource.
        :param pulumi.Input[_builtins.str] entity_id: Identifier of the entity being associated with service catalog.
        :param pulumi.Input[_builtins.str] service_catalog_id: Identifier of the service catalog.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] entity_type: The type of the entity that is associated with the service catalog.
        """
        pulumi.set(__self__, "entity_id", entity_id)
        pulumi.set(__self__, "service_catalog_id", service_catalog_id)
        if entity_type is not None:
            pulumi.set(__self__, "entity_type", entity_type)

    @_builtins.property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier of the entity being associated with service catalog.
        """
        return pulumi.get(self, "entity_id")

    @entity_id.setter
    def entity_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "entity_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceCatalogId")
    def service_catalog_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier of the service catalog.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "service_catalog_id")

    @service_catalog_id.setter
    def service_catalog_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_catalog_id", value)

    @_builtins.property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the entity that is associated with the service catalog.
        """
        return pulumi.get(self, "entity_type")

    @entity_type.setter
    def entity_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "entity_type", value)


@pulumi.input_type
class _CatalogAssociationState:
    def __init__(__self__, *,
                 entity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 entity_type: Optional[pulumi.Input[_builtins.str]] = None,
                 service_catalog_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CatalogAssociation resources.
        :param pulumi.Input[_builtins.str] entity_id: Identifier of the entity being associated with service catalog.
        :param pulumi.Input[_builtins.str] entity_type: The type of the entity that is associated with the service catalog.
        :param pulumi.Input[_builtins.str] service_catalog_id: Identifier of the service catalog.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] time_created: Timestamp of when the resource was associated with service catalog.
        """
        if entity_id is not None:
            pulumi.set(__self__, "entity_id", entity_id)
        if entity_type is not None:
            pulumi.set(__self__, "entity_type", entity_type)
        if service_catalog_id is not None:
            pulumi.set(__self__, "service_catalog_id", service_catalog_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier of the entity being associated with service catalog.
        """
        return pulumi.get(self, "entity_id")

    @entity_id.setter
    def entity_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "entity_id", value)

    @_builtins.property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the entity that is associated with the service catalog.
        """
        return pulumi.get(self, "entity_type")

    @entity_type.setter
    def entity_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "entity_type", value)

    @_builtins.property
    @pulumi.getter(name="serviceCatalogId")
    def service_catalog_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier of the service catalog.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "service_catalog_id")

    @service_catalog_id.setter
    def service_catalog_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_catalog_id", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp of when the resource was associated with service catalog.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)


@pulumi.type_token("oci:ServiceCatalog/catalogAssociation:CatalogAssociation")
class CatalogAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 entity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 entity_type: Optional[pulumi.Input[_builtins.str]] = None,
                 service_catalog_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_service_catalog_association = oci.servicecatalog.CatalogAssociation("test_service_catalog_association",
            entity_id=test_entity["id"],
            service_catalog_id=test_service_catalog["id"],
            entity_type=service_catalog_association_entity_type)
        ```

        ## Import

        ServiceCatalogAssociations can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:ServiceCatalog/catalogAssociation:CatalogAssociation test_service_catalog_association "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] entity_id: Identifier of the entity being associated with service catalog.
        :param pulumi.Input[_builtins.str] entity_type: The type of the entity that is associated with the service catalog.
        :param pulumi.Input[_builtins.str] service_catalog_id: Identifier of the service catalog.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CatalogAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_service_catalog_association = oci.servicecatalog.CatalogAssociation("test_service_catalog_association",
            entity_id=test_entity["id"],
            service_catalog_id=test_service_catalog["id"],
            entity_type=service_catalog_association_entity_type)
        ```

        ## Import

        ServiceCatalogAssociations can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:ServiceCatalog/catalogAssociation:CatalogAssociation test_service_catalog_association "id"
        ```

        :param str resource_name: The name of the resource.
        :param CatalogAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CatalogAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 entity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 entity_type: Optional[pulumi.Input[_builtins.str]] = None,
                 service_catalog_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CatalogAssociationArgs.__new__(CatalogAssociationArgs)

            if entity_id is None and not opts.urn:
                raise TypeError("Missing required property 'entity_id'")
            __props__.__dict__["entity_id"] = entity_id
            __props__.__dict__["entity_type"] = entity_type
            if service_catalog_id is None and not opts.urn:
                raise TypeError("Missing required property 'service_catalog_id'")
            __props__.__dict__["service_catalog_id"] = service_catalog_id
            __props__.__dict__["time_created"] = None
        super(CatalogAssociation, __self__).__init__(
            'oci:ServiceCatalog/catalogAssociation:CatalogAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            entity_id: Optional[pulumi.Input[_builtins.str]] = None,
            entity_type: Optional[pulumi.Input[_builtins.str]] = None,
            service_catalog_id: Optional[pulumi.Input[_builtins.str]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None) -> 'CatalogAssociation':
        """
        Get an existing CatalogAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] entity_id: Identifier of the entity being associated with service catalog.
        :param pulumi.Input[_builtins.str] entity_type: The type of the entity that is associated with the service catalog.
        :param pulumi.Input[_builtins.str] service_catalog_id: Identifier of the service catalog.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] time_created: Timestamp of when the resource was associated with service catalog.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CatalogAssociationState.__new__(_CatalogAssociationState)

        __props__.__dict__["entity_id"] = entity_id
        __props__.__dict__["entity_type"] = entity_type
        __props__.__dict__["service_catalog_id"] = service_catalog_id
        __props__.__dict__["time_created"] = time_created
        return CatalogAssociation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier of the entity being associated with service catalog.
        """
        return pulumi.get(self, "entity_id")

    @_builtins.property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the entity that is associated with the service catalog.
        """
        return pulumi.get(self, "entity_type")

    @_builtins.property
    @pulumi.getter(name="serviceCatalogId")
    def service_catalog_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier of the service catalog.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "service_catalog_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp of when the resource was associated with service catalog.
        """
        return pulumi.get(self, "time_created")

