# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['BaselineableMetricArgs', 'BaselineableMetric']

@pulumi.input_type
class BaselineableMetricArgs:
    def __init__(__self__, *,
                 column: pulumi.Input[_builtins.str],
                 compartment_id: pulumi.Input[_builtins.str],
                 namespace: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a BaselineableMetric resource.
        :param pulumi.Input[_builtins.str] column: (Updatable) metric column name
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) OCID of the compartment
        :param pulumi.Input[_builtins.str] namespace: (Updatable) namespace of the metric
        :param pulumi.Input[_builtins.str] name: (Updatable) name of the metric
        :param pulumi.Input[_builtins.str] resource_group: (Updatable) Resource group of the metric
        :param pulumi.Input[_builtins.str] resource_type: (Updatable) Resource type of the metric
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "column", column)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "namespace", namespace)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)

    @_builtins.property
    @pulumi.getter
    def column(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) metric column name
        """
        return pulumi.get(self, "column")

    @column.setter
    def column(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "column", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) OCID of the compartment
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) namespace of the metric
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) name of the metric
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Resource group of the metric
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group", value)

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Resource type of the metric


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_type", value)


@pulumi.input_type
class _BaselineableMetricState:
    def __init__(__self__, *,
                 column: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_out_of_box: Optional[pulumi.Input[_builtins.bool]] = None,
                 last_updated_by: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tenancy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_last_updated: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering BaselineableMetric resources.
        :param pulumi.Input[_builtins.str] column: (Updatable) metric column name
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) OCID of the compartment
        :param pulumi.Input[_builtins.str] created_by: Created user id
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.bool] is_out_of_box: Is the metric created out of box, default false
        :param pulumi.Input[_builtins.str] last_updated_by: last Updated user id
        :param pulumi.Input[_builtins.str] name: (Updatable) name of the metric
        :param pulumi.Input[_builtins.str] namespace: (Updatable) namespace of the metric
        :param pulumi.Input[_builtins.str] resource_group: (Updatable) Resource group of the metric
        :param pulumi.Input[_builtins.str] resource_type: (Updatable) Resource type of the metric
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] state: The current lifecycle state of the metric extension
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] tenancy_id: OCID of the tenancy
        :param pulumi.Input[_builtins.str] time_created: creation date
        :param pulumi.Input[_builtins.str] time_last_updated: last updated time
        """
        if column is not None:
            pulumi.set(__self__, "column", column)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_out_of_box is not None:
            pulumi.set(__self__, "is_out_of_box", is_out_of_box)
        if last_updated_by is not None:
            pulumi.set(__self__, "last_updated_by", last_updated_by)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if tenancy_id is not None:
            pulumi.set(__self__, "tenancy_id", tenancy_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_last_updated is not None:
            pulumi.set(__self__, "time_last_updated", time_last_updated)

    @_builtins.property
    @pulumi.getter
    def column(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) metric column name
        """
        return pulumi.get(self, "column")

    @column.setter
    def column(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "column", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) OCID of the compartment
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Created user id
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_by", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="isOutOfBox")
    def is_out_of_box(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is the metric created out of box, default false
        """
        return pulumi.get(self, "is_out_of_box")

    @is_out_of_box.setter
    def is_out_of_box(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_out_of_box", value)

    @_builtins.property
    @pulumi.getter(name="lastUpdatedBy")
    def last_updated_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        last Updated user id
        """
        return pulumi.get(self, "last_updated_by")

    @last_updated_by.setter
    def last_updated_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_updated_by", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) name of the metric
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) namespace of the metric
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Resource group of the metric
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group", value)

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Resource type of the metric


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_type", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current lifecycle state of the metric extension
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OCID of the tenancy
        """
        return pulumi.get(self, "tenancy_id")

    @tenancy_id.setter
    def tenancy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenancy_id", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        creation date
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeLastUpdated")
    def time_last_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        last updated time
        """
        return pulumi.get(self, "time_last_updated")

    @time_last_updated.setter
    def time_last_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_last_updated", value)


@pulumi.type_token("oci:StackMonitoring/baselineableMetric:BaselineableMetric")
class BaselineableMetric(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 column: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_baselineable_metric = oci.stackmonitoring.BaselineableMetric("test_baselineable_metric",
            column=baselineable_metric_column,
            compartment_id=compartment_id,
            namespace=baselineable_metric_namespace,
            name=baselineable_metric_name,
            resource_group=baselineable_metric_resource_group,
            resource_type=baselineable_metric_resource_type)
        ```

        ## Import

        BaselineableMetrics can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:StackMonitoring/baselineableMetric:BaselineableMetric test_baselineable_metric "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] column: (Updatable) metric column name
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) OCID of the compartment
        :param pulumi.Input[_builtins.str] name: (Updatable) name of the metric
        :param pulumi.Input[_builtins.str] namespace: (Updatable) namespace of the metric
        :param pulumi.Input[_builtins.str] resource_group: (Updatable) Resource group of the metric
        :param pulumi.Input[_builtins.str] resource_type: (Updatable) Resource type of the metric
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BaselineableMetricArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_baselineable_metric = oci.stackmonitoring.BaselineableMetric("test_baselineable_metric",
            column=baselineable_metric_column,
            compartment_id=compartment_id,
            namespace=baselineable_metric_namespace,
            name=baselineable_metric_name,
            resource_group=baselineable_metric_resource_group,
            resource_type=baselineable_metric_resource_type)
        ```

        ## Import

        BaselineableMetrics can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:StackMonitoring/baselineableMetric:BaselineableMetric test_baselineable_metric "id"
        ```

        :param str resource_name: The name of the resource.
        :param BaselineableMetricArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BaselineableMetricArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 column: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BaselineableMetricArgs.__new__(BaselineableMetricArgs)

            if column is None and not opts.urn:
                raise TypeError("Missing required property 'column'")
            __props__.__dict__["column"] = column
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["name"] = name
            if namespace is None and not opts.urn:
                raise TypeError("Missing required property 'namespace'")
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["resource_group"] = resource_group
            __props__.__dict__["resource_type"] = resource_type
            __props__.__dict__["created_by"] = None
            __props__.__dict__["defined_tags"] = None
            __props__.__dict__["freeform_tags"] = None
            __props__.__dict__["is_out_of_box"] = None
            __props__.__dict__["last_updated_by"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["tenancy_id"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_last_updated"] = None
        super(BaselineableMetric, __self__).__init__(
            'oci:StackMonitoring/baselineableMetric:BaselineableMetric',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            column: Optional[pulumi.Input[_builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            created_by: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            is_out_of_box: Optional[pulumi.Input[_builtins.bool]] = None,
            last_updated_by: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group: Optional[pulumi.Input[_builtins.str]] = None,
            resource_type: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tenancy_id: Optional[pulumi.Input[_builtins.str]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_last_updated: Optional[pulumi.Input[_builtins.str]] = None) -> 'BaselineableMetric':
        """
        Get an existing BaselineableMetric resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] column: (Updatable) metric column name
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) OCID of the compartment
        :param pulumi.Input[_builtins.str] created_by: Created user id
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.bool] is_out_of_box: Is the metric created out of box, default false
        :param pulumi.Input[_builtins.str] last_updated_by: last Updated user id
        :param pulumi.Input[_builtins.str] name: (Updatable) name of the metric
        :param pulumi.Input[_builtins.str] namespace: (Updatable) namespace of the metric
        :param pulumi.Input[_builtins.str] resource_group: (Updatable) Resource group of the metric
        :param pulumi.Input[_builtins.str] resource_type: (Updatable) Resource type of the metric
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] state: The current lifecycle state of the metric extension
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] tenancy_id: OCID of the tenancy
        :param pulumi.Input[_builtins.str] time_created: creation date
        :param pulumi.Input[_builtins.str] time_last_updated: last updated time
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BaselineableMetricState.__new__(_BaselineableMetricState)

        __props__.__dict__["column"] = column
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_out_of_box"] = is_out_of_box
        __props__.__dict__["last_updated_by"] = last_updated_by
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["resource_group"] = resource_group
        __props__.__dict__["resource_type"] = resource_type
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["tenancy_id"] = tenancy_id
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_last_updated"] = time_last_updated
        return BaselineableMetric(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def column(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) metric column name
        """
        return pulumi.get(self, "column")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) OCID of the compartment
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[_builtins.str]:
        """
        Created user id
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="isOutOfBox")
    def is_out_of_box(self) -> pulumi.Output[_builtins.bool]:
        """
        Is the metric created out of box, default false
        """
        return pulumi.get(self, "is_out_of_box")

    @_builtins.property
    @pulumi.getter(name="lastUpdatedBy")
    def last_updated_by(self) -> pulumi.Output[_builtins.str]:
        """
        last Updated user id
        """
        return pulumi.get(self, "last_updated_by")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) name of the metric
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) namespace of the metric
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Resource group of the metric
        """
        return pulumi.get(self, "resource_group")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Resource type of the metric


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current lifecycle state of the metric extension
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> pulumi.Output[_builtins.str]:
        """
        OCID of the tenancy
        """
        return pulumi.get(self, "tenancy_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        creation date
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeLastUpdated")
    def time_last_updated(self) -> pulumi.Output[_builtins.str]:
        """
        last updated time
        """
        return pulumi.get(self, "time_last_updated")

