# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MonitoredResourcesAssociateMonitoredResourceArgs', 'MonitoredResourcesAssociateMonitoredResource']

@pulumi.input_type
class MonitoredResourcesAssociateMonitoredResourceArgs:
    def __init__(__self__, *,
                 association_type: pulumi.Input[_builtins.str],
                 compartment_id: pulumi.Input[_builtins.str],
                 destination_resource_id: pulumi.Input[_builtins.str],
                 source_resource_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a MonitoredResourcesAssociateMonitoredResource resource.
        :param pulumi.Input[_builtins.str] association_type: Association type to be created between source and destination resources.
        :param pulumi.Input[_builtins.str] compartment_id: Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[_builtins.str] destination_resource_id: Destination Monitored Resource Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[_builtins.str] source_resource_id: Source Monitored Resource Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "association_type", association_type)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "destination_resource_id", destination_resource_id)
        pulumi.set(__self__, "source_resource_id", source_resource_id)

    @_builtins.property
    @pulumi.getter(name="associationType")
    def association_type(self) -> pulumi.Input[_builtins.str]:
        """
        Association type to be created between source and destination resources.
        """
        return pulumi.get(self, "association_type")

    @association_type.setter
    def association_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "association_type", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="destinationResourceId")
    def destination_resource_id(self) -> pulumi.Input[_builtins.str]:
        """
        Destination Monitored Resource Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "destination_resource_id")

    @destination_resource_id.setter
    def destination_resource_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "destination_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> pulumi.Input[_builtins.str]:
        """
        Source Monitored Resource Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "source_resource_id")

    @source_resource_id.setter
    def source_resource_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_resource_id", value)


@pulumi.input_type
class _MonitoredResourcesAssociateMonitoredResourceState:
    def __init__(__self__, *,
                 association_type: Optional[pulumi.Input[_builtins.str]] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_resource_details: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourcesAssociateMonitoredResourceDestinationResourceDetailArgs']]]] = None,
                 destination_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_resource_details: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourcesAssociateMonitoredResourceSourceResourceDetailArgs']]]] = None,
                 source_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering MonitoredResourcesAssociateMonitoredResource resources.
        :param pulumi.Input[_builtins.str] association_type: Association type to be created between source and destination resources.
        :param pulumi.Input[_builtins.str] category: Association category. Possible values are:
               * System created (SYSTEM),
               * User created using API (USER_API)
               * User created using tags (USER_TAG_ASSOC).
        :param pulumi.Input[_builtins.str] compartment_id: Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Sequence[pulumi.Input['MonitoredResourcesAssociateMonitoredResourceDestinationResourceDetailArgs']]] destination_resource_details: Association Resource Details.
        :param pulumi.Input[_builtins.str] destination_resource_id: Destination Monitored Resource Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Sequence[pulumi.Input['MonitoredResourcesAssociateMonitoredResourceSourceResourceDetailArgs']]] source_resource_details: Association Resource Details.
        :param pulumi.Input[_builtins.str] source_resource_id: Source Monitored Resource Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] tenant_id: Tenancy Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[_builtins.str] time_created: The time when the association was created. An RFC3339 formatted datetime string.
        """
        if association_type is not None:
            pulumi.set(__self__, "association_type", association_type)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if destination_resource_details is not None:
            pulumi.set(__self__, "destination_resource_details", destination_resource_details)
        if destination_resource_id is not None:
            pulumi.set(__self__, "destination_resource_id", destination_resource_id)
        if source_resource_details is not None:
            pulumi.set(__self__, "source_resource_details", source_resource_details)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter(name="associationType")
    def association_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Association type to be created between source and destination resources.
        """
        return pulumi.get(self, "association_type")

    @association_type.setter
    def association_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "association_type", value)

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Association category. Possible values are:
        * System created (SYSTEM),
        * User created using API (USER_API)
        * User created using tags (USER_TAG_ASSOC).
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "category", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="destinationResourceDetails")
    def destination_resource_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourcesAssociateMonitoredResourceDestinationResourceDetailArgs']]]]:
        """
        Association Resource Details.
        """
        return pulumi.get(self, "destination_resource_details")

    @destination_resource_details.setter
    def destination_resource_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourcesAssociateMonitoredResourceDestinationResourceDetailArgs']]]]):
        pulumi.set(self, "destination_resource_details", value)

    @_builtins.property
    @pulumi.getter(name="destinationResourceId")
    def destination_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Destination Monitored Resource Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "destination_resource_id")

    @destination_resource_id.setter
    def destination_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceResourceDetails")
    def source_resource_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourcesAssociateMonitoredResourceSourceResourceDetailArgs']]]]:
        """
        Association Resource Details.
        """
        return pulumi.get(self, "source_resource_details")

    @source_resource_details.setter
    def source_resource_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourcesAssociateMonitoredResourceSourceResourceDetailArgs']]]]):
        pulumi.set(self, "source_resource_details", value)

    @_builtins.property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Source Monitored Resource Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "source_resource_id")

    @source_resource_id.setter
    def source_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Tenancy Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the association was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)


@pulumi.type_token("oci:StackMonitoring/monitoredResourcesAssociateMonitoredResource:MonitoredResourcesAssociateMonitoredResource")
class MonitoredResourcesAssociateMonitoredResource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 association_type: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_monitored_resources_associate_monitored_resource = oci.stackmonitoring.MonitoredResourcesAssociateMonitoredResource("test_monitored_resources_associate_monitored_resource",
            association_type=monitored_resources_associate_monitored_resource_association_type,
            compartment_id=compartment_id,
            destination_resource_id=test_destination_resource["id"],
            source_resource_id=test_source_resource["id"])
        ```

        ## Import

        MonitoredResourcesAssociateMonitoredResources can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:StackMonitoring/monitoredResourcesAssociateMonitoredResource:MonitoredResourcesAssociateMonitoredResource test_monitored_resources_associate_monitored_resource "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] association_type: Association type to be created between source and destination resources.
        :param pulumi.Input[_builtins.str] compartment_id: Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[_builtins.str] destination_resource_id: Destination Monitored Resource Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[_builtins.str] source_resource_id: Source Monitored Resource Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MonitoredResourcesAssociateMonitoredResourceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_monitored_resources_associate_monitored_resource = oci.stackmonitoring.MonitoredResourcesAssociateMonitoredResource("test_monitored_resources_associate_monitored_resource",
            association_type=monitored_resources_associate_monitored_resource_association_type,
            compartment_id=compartment_id,
            destination_resource_id=test_destination_resource["id"],
            source_resource_id=test_source_resource["id"])
        ```

        ## Import

        MonitoredResourcesAssociateMonitoredResources can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:StackMonitoring/monitoredResourcesAssociateMonitoredResource:MonitoredResourcesAssociateMonitoredResource test_monitored_resources_associate_monitored_resource "id"
        ```

        :param str resource_name: The name of the resource.
        :param MonitoredResourcesAssociateMonitoredResourceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MonitoredResourcesAssociateMonitoredResourceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 association_type: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MonitoredResourcesAssociateMonitoredResourceArgs.__new__(MonitoredResourcesAssociateMonitoredResourceArgs)

            if association_type is None and not opts.urn:
                raise TypeError("Missing required property 'association_type'")
            __props__.__dict__["association_type"] = association_type
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if destination_resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'destination_resource_id'")
            __props__.__dict__["destination_resource_id"] = destination_resource_id
            if source_resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'source_resource_id'")
            __props__.__dict__["source_resource_id"] = source_resource_id
            __props__.__dict__["category"] = None
            __props__.__dict__["destination_resource_details"] = None
            __props__.__dict__["source_resource_details"] = None
            __props__.__dict__["tenant_id"] = None
            __props__.__dict__["time_created"] = None
        super(MonitoredResourcesAssociateMonitoredResource, __self__).__init__(
            'oci:StackMonitoring/monitoredResourcesAssociateMonitoredResource:MonitoredResourcesAssociateMonitoredResource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            association_type: Optional[pulumi.Input[_builtins.str]] = None,
            category: Optional[pulumi.Input[_builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            destination_resource_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MonitoredResourcesAssociateMonitoredResourceDestinationResourceDetailArgs', 'MonitoredResourcesAssociateMonitoredResourceDestinationResourceDetailArgsDict']]]]] = None,
            destination_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            source_resource_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MonitoredResourcesAssociateMonitoredResourceSourceResourceDetailArgs', 'MonitoredResourcesAssociateMonitoredResourceSourceResourceDetailArgsDict']]]]] = None,
            source_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None) -> 'MonitoredResourcesAssociateMonitoredResource':
        """
        Get an existing MonitoredResourcesAssociateMonitoredResource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] association_type: Association type to be created between source and destination resources.
        :param pulumi.Input[_builtins.str] category: Association category. Possible values are:
               * System created (SYSTEM),
               * User created using API (USER_API)
               * User created using tags (USER_TAG_ASSOC).
        :param pulumi.Input[_builtins.str] compartment_id: Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Sequence[pulumi.Input[Union['MonitoredResourcesAssociateMonitoredResourceDestinationResourceDetailArgs', 'MonitoredResourcesAssociateMonitoredResourceDestinationResourceDetailArgsDict']]]] destination_resource_details: Association Resource Details.
        :param pulumi.Input[_builtins.str] destination_resource_id: Destination Monitored Resource Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Sequence[pulumi.Input[Union['MonitoredResourcesAssociateMonitoredResourceSourceResourceDetailArgs', 'MonitoredResourcesAssociateMonitoredResourceSourceResourceDetailArgsDict']]]] source_resource_details: Association Resource Details.
        :param pulumi.Input[_builtins.str] source_resource_id: Source Monitored Resource Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] tenant_id: Tenancy Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[_builtins.str] time_created: The time when the association was created. An RFC3339 formatted datetime string.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MonitoredResourcesAssociateMonitoredResourceState.__new__(_MonitoredResourcesAssociateMonitoredResourceState)

        __props__.__dict__["association_type"] = association_type
        __props__.__dict__["category"] = category
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["destination_resource_details"] = destination_resource_details
        __props__.__dict__["destination_resource_id"] = destination_resource_id
        __props__.__dict__["source_resource_details"] = source_resource_details
        __props__.__dict__["source_resource_id"] = source_resource_id
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["time_created"] = time_created
        return MonitoredResourcesAssociateMonitoredResource(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="associationType")
    def association_type(self) -> pulumi.Output[_builtins.str]:
        """
        Association type to be created between source and destination resources.
        """
        return pulumi.get(self, "association_type")

    @_builtins.property
    @pulumi.getter
    def category(self) -> pulumi.Output[_builtins.str]:
        """
        Association category. Possible values are:
        * System created (SYSTEM),
        * User created using API (USER_API)
        * User created using tags (USER_TAG_ASSOC).
        """
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="destinationResourceDetails")
    def destination_resource_details(self) -> pulumi.Output[Sequence['outputs.MonitoredResourcesAssociateMonitoredResourceDestinationResourceDetail']]:
        """
        Association Resource Details.
        """
        return pulumi.get(self, "destination_resource_details")

    @_builtins.property
    @pulumi.getter(name="destinationResourceId")
    def destination_resource_id(self) -> pulumi.Output[_builtins.str]:
        """
        Destination Monitored Resource Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "destination_resource_id")

    @_builtins.property
    @pulumi.getter(name="sourceResourceDetails")
    def source_resource_details(self) -> pulumi.Output[Sequence['outputs.MonitoredResourcesAssociateMonitoredResourceSourceResourceDetail']]:
        """
        Association Resource Details.
        """
        return pulumi.get(self, "source_resource_details")

    @_builtins.property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> pulumi.Output[_builtins.str]:
        """
        Source Monitored Resource Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "source_resource_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[_builtins.str]:
        """
        Tenancy Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the association was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

