# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MonitoredResourcesSearchArgs', 'MonitoredResourcesSearch']

@pulumi.input_type
class MonitoredResourcesSearchArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 compartment_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 exclude_fields: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 external_id: Optional[pulumi.Input[_builtins.str]] = None,
                 fields: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 host_name_contains: Optional[pulumi.Input[_builtins.str]] = None,
                 license: Optional[pulumi.Input[_builtins.str]] = None,
                 lifecycle_states: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 management_agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_contains: Optional[pulumi.Input[_builtins.str]] = None,
                 property_equals: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 resource_category: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created_greater_than_or_equal_to: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created_less_than: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated_greater_than_or_equal_to: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated_less_than: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a MonitoredResourcesSearch resource.
        :param pulumi.Input[_builtins.str] compartment_id: Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] compartment_ids: Multiple compartment identifiers [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] exclude_fields: Partial response refers to an optimization technique offered by the RESTful web APIs, to return all the information except the fields requested to be excluded (excludeFields) by the client. In this mechanism, the client sends the exclude field names as the query parameters for an API to the server, and the server trims down the default response content by removing the fields that are not required by the client. The parameter controls which fields to exlude and to return and should be a query string parameter called "excludeFields" of an array type, provide the values as enums, and use collectionFormat.
        :param pulumi.Input[_builtins.str] external_id: External resource is any Oracle Cloud Infrastructure resource identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) which is not a Stack Monitoring service resource. Currently supports only following resource types - Container database, non-container database,  pluggable database and Oracle Cloud Infrastructure compute instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] fields: Partial response refers to an optimization technique offered by the RESTful web APIs, to return only the information (fields) required by the client. In this mechanism, the client sends the required field names as the query parameters for an API to the server, and the server trims down the default response content by removing the fields that are not required by the client. The parameter controls which fields to return and should be a query string parameter called "fields" of an array type, provide the values as enums, and use collectionFormat.
        :param pulumi.Input[_builtins.str] host_name: A filter to return resources with host name match.
        :param pulumi.Input[_builtins.str] host_name_contains: A filter to return resources with host name pattern.
        :param pulumi.Input[_builtins.str] license: License edition of the monitored resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] lifecycle_states: Multiple lifecycle states filter.
        :param pulumi.Input[_builtins.str] management_agent_id: A filter to return resources with matching management agent id.
        :param pulumi.Input[_builtins.str] name: A filter to return resources that match exact resource name.
        :param pulumi.Input[_builtins.str] name_contains: A filter to return resources that match resource name pattern given. The match is not case sensitive.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] property_equals: Criteria based on resource property.
        :param pulumi.Input[_builtins.str] resource_category: Resource category filter.
        :param pulumi.Input[_builtins.str] resource_time_zone: Time zone in the form of tz database canonical zone ID. Specifies the preference with a value that uses the IANA Time Zone Database format (x-obmcs-time-zone). For example - America/Los_Angeles
        :param pulumi.Input[_builtins.str] source_type: Source type filter.
        :param pulumi.Input[_builtins.str] state: A filter to return resources with matching lifecycle state.
        :param pulumi.Input[_builtins.str] time_created_greater_than_or_equal_to: Search for resources that were created within a specific date range, using this parameter to specify the earliest creation date for the returned list (inclusive). Specifying this parameter without the corresponding `timeCreatedLessThan` parameter will retrieve resources created from the given `timeCreatedGreaterThanOrEqualTo` to the current time, in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).
               
               **Example:** 2016-12-19T16:39:57.600Z
        :param pulumi.Input[_builtins.str] time_created_less_than: Search for resources that were created within a specific date range, using this parameter to specify the latest creation date for the returned list (exclusive). Specifying this parameter without the corresponding `timeCreatedGreaterThanOrEqualTo` parameter will retrieve all resources created before the specified end date, in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).
               
               **Example:** 2016-12-19T16:39:57.600Z
        :param pulumi.Input[_builtins.str] time_updated_greater_than_or_equal_to: Search for resources that were updated within a specific date range, using this parameter to specify the earliest update date for the returned list (inclusive). Specifying this parameter without the corresponding `timeUpdatedLessThan` parameter will retrieve resources updated from the given `timeUpdatedGreaterThanOrEqualTo` to the current time, in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).
               
               **Example:** 2016-12-19T16:39:57.600Z
        :param pulumi.Input[_builtins.str] time_updated_less_than: Search for resources that were updated within a specific date range, using this parameter to specify the latest creation date for the returned list (exclusive). Specifying this parameter without the corresponding `timeUpdatedGreaterThanOrEqualTo` parameter will retrieve all resources updated before the specified end date, in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).
               
               **Example:** 2016-12-19T16:39:57.600Z
        :param pulumi.Input[_builtins.str] type: A filter to return resources that match resource type. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_ids is not None:
            pulumi.set(__self__, "compartment_ids", compartment_ids)
        if exclude_fields is not None:
            pulumi.set(__self__, "exclude_fields", exclude_fields)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if fields is not None:
            pulumi.set(__self__, "fields", fields)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if host_name_contains is not None:
            pulumi.set(__self__, "host_name_contains", host_name_contains)
        if license is not None:
            pulumi.set(__self__, "license", license)
        if lifecycle_states is not None:
            pulumi.set(__self__, "lifecycle_states", lifecycle_states)
        if management_agent_id is not None:
            pulumi.set(__self__, "management_agent_id", management_agent_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_contains is not None:
            pulumi.set(__self__, "name_contains", name_contains)
        if property_equals is not None:
            pulumi.set(__self__, "property_equals", property_equals)
        if resource_category is not None:
            pulumi.set(__self__, "resource_category", resource_category)
        if resource_time_zone is not None:
            pulumi.set(__self__, "resource_time_zone", resource_time_zone)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created_greater_than_or_equal_to is not None:
            pulumi.set(__self__, "time_created_greater_than_or_equal_to", time_created_greater_than_or_equal_to)
        if time_created_less_than is not None:
            pulumi.set(__self__, "time_created_less_than", time_created_less_than)
        if time_updated_greater_than_or_equal_to is not None:
            pulumi.set(__self__, "time_updated_greater_than_or_equal_to", time_updated_greater_than_or_equal_to)
        if time_updated_less_than is not None:
            pulumi.set(__self__, "time_updated_less_than", time_updated_less_than)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="compartmentIds")
    def compartment_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Multiple compartment identifiers [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_ids")

    @compartment_ids.setter
    def compartment_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "compartment_ids", value)

    @_builtins.property
    @pulumi.getter(name="excludeFields")
    def exclude_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Partial response refers to an optimization technique offered by the RESTful web APIs, to return all the information except the fields requested to be excluded (excludeFields) by the client. In this mechanism, the client sends the exclude field names as the query parameters for an API to the server, and the server trims down the default response content by removing the fields that are not required by the client. The parameter controls which fields to exlude and to return and should be a query string parameter called "excludeFields" of an array type, provide the values as enums, and use collectionFormat.
        """
        return pulumi.get(self, "exclude_fields")

    @exclude_fields.setter
    def exclude_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "exclude_fields", value)

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        External resource is any Oracle Cloud Infrastructure resource identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) which is not a Stack Monitoring service resource. Currently supports only following resource types - Container database, non-container database,  pluggable database and Oracle Cloud Infrastructure compute instance.
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_id", value)

    @_builtins.property
    @pulumi.getter
    def fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Partial response refers to an optimization technique offered by the RESTful web APIs, to return only the information (fields) required by the client. In this mechanism, the client sends the required field names as the query parameters for an API to the server, and the server trims down the default response content by removing the fields that are not required by the client. The parameter controls which fields to return and should be a query string parameter called "fields" of an array type, provide the values as enums, and use collectionFormat.
        """
        return pulumi.get(self, "fields")

    @fields.setter
    def fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "fields", value)

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A filter to return resources with host name match.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_name", value)

    @_builtins.property
    @pulumi.getter(name="hostNameContains")
    def host_name_contains(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A filter to return resources with host name pattern.
        """
        return pulumi.get(self, "host_name_contains")

    @host_name_contains.setter
    def host_name_contains(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_name_contains", value)

    @_builtins.property
    @pulumi.getter
    def license(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        License edition of the monitored resource.
        """
        return pulumi.get(self, "license")

    @license.setter
    def license(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "license", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleStates")
    def lifecycle_states(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Multiple lifecycle states filter.
        """
        return pulumi.get(self, "lifecycle_states")

    @lifecycle_states.setter
    def lifecycle_states(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "lifecycle_states", value)

    @_builtins.property
    @pulumi.getter(name="managementAgentId")
    def management_agent_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A filter to return resources with matching management agent id.
        """
        return pulumi.get(self, "management_agent_id")

    @management_agent_id.setter
    def management_agent_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "management_agent_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A filter to return resources that match exact resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nameContains")
    def name_contains(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A filter to return resources that match resource name pattern given. The match is not case sensitive.
        """
        return pulumi.get(self, "name_contains")

    @name_contains.setter
    def name_contains(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name_contains", value)

    @_builtins.property
    @pulumi.getter(name="propertyEquals")
    def property_equals(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Criteria based on resource property.
        """
        return pulumi.get(self, "property_equals")

    @property_equals.setter
    def property_equals(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "property_equals", value)

    @_builtins.property
    @pulumi.getter(name="resourceCategory")
    def resource_category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource category filter.
        """
        return pulumi.get(self, "resource_category")

    @resource_category.setter
    def resource_category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_category", value)

    @_builtins.property
    @pulumi.getter(name="resourceTimeZone")
    def resource_time_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time zone in the form of tz database canonical zone ID. Specifies the preference with a value that uses the IANA Time Zone Database format (x-obmcs-time-zone). For example - America/Los_Angeles
        """
        return pulumi.get(self, "resource_time_zone")

    @resource_time_zone.setter
    def resource_time_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_time_zone", value)

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Source type filter.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_type", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A filter to return resources with matching lifecycle state.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="timeCreatedGreaterThanOrEqualTo")
    def time_created_greater_than_or_equal_to(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Search for resources that were created within a specific date range, using this parameter to specify the earliest creation date for the returned list (inclusive). Specifying this parameter without the corresponding `timeCreatedLessThan` parameter will retrieve resources created from the given `timeCreatedGreaterThanOrEqualTo` to the current time, in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).

        **Example:** 2016-12-19T16:39:57.600Z
        """
        return pulumi.get(self, "time_created_greater_than_or_equal_to")

    @time_created_greater_than_or_equal_to.setter
    def time_created_greater_than_or_equal_to(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created_greater_than_or_equal_to", value)

    @_builtins.property
    @pulumi.getter(name="timeCreatedLessThan")
    def time_created_less_than(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Search for resources that were created within a specific date range, using this parameter to specify the latest creation date for the returned list (exclusive). Specifying this parameter without the corresponding `timeCreatedGreaterThanOrEqualTo` parameter will retrieve all resources created before the specified end date, in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).

        **Example:** 2016-12-19T16:39:57.600Z
        """
        return pulumi.get(self, "time_created_less_than")

    @time_created_less_than.setter
    def time_created_less_than(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created_less_than", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdatedGreaterThanOrEqualTo")
    def time_updated_greater_than_or_equal_to(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Search for resources that were updated within a specific date range, using this parameter to specify the earliest update date for the returned list (inclusive). Specifying this parameter without the corresponding `timeUpdatedLessThan` parameter will retrieve resources updated from the given `timeUpdatedGreaterThanOrEqualTo` to the current time, in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).

        **Example:** 2016-12-19T16:39:57.600Z
        """
        return pulumi.get(self, "time_updated_greater_than_or_equal_to")

    @time_updated_greater_than_or_equal_to.setter
    def time_updated_greater_than_or_equal_to(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated_greater_than_or_equal_to", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdatedLessThan")
    def time_updated_less_than(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Search for resources that were updated within a specific date range, using this parameter to specify the latest creation date for the returned list (exclusive). Specifying this parameter without the corresponding `timeUpdatedGreaterThanOrEqualTo` parameter will retrieve all resources updated before the specified end date, in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).

        **Example:** 2016-12-19T16:39:57.600Z
        """
        return pulumi.get(self, "time_updated_less_than")

    @time_updated_less_than.setter
    def time_updated_less_than(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated_less_than", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A filter to return resources that match resource type. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _MonitoredResourcesSearchState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 exclude_fields: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 external_id: Optional[pulumi.Input[_builtins.str]] = None,
                 fields: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 host_name_contains: Optional[pulumi.Input[_builtins.str]] = None,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourcesSearchItemArgs']]]] = None,
                 license: Optional[pulumi.Input[_builtins.str]] = None,
                 lifecycle_states: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 management_agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_contains: Optional[pulumi.Input[_builtins.str]] = None,
                 property_equals: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 resource_category: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created_greater_than_or_equal_to: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created_less_than: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated_greater_than_or_equal_to: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated_less_than: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering MonitoredResourcesSearch resources.
        :param pulumi.Input[_builtins.str] compartment_id: Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] compartment_ids: Multiple compartment identifiers [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] exclude_fields: Partial response refers to an optimization technique offered by the RESTful web APIs, to return all the information except the fields requested to be excluded (excludeFields) by the client. In this mechanism, the client sends the exclude field names as the query parameters for an API to the server, and the server trims down the default response content by removing the fields that are not required by the client. The parameter controls which fields to exlude and to return and should be a query string parameter called "excludeFields" of an array type, provide the values as enums, and use collectionFormat.
        :param pulumi.Input[_builtins.str] external_id: External resource is any Oracle Cloud Infrastructure resource identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) which is not a Stack Monitoring service resource. Currently supports only following resource types - Container database, non-container database,  pluggable database and Oracle Cloud Infrastructure compute instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] fields: Partial response refers to an optimization technique offered by the RESTful web APIs, to return only the information (fields) required by the client. In this mechanism, the client sends the required field names as the query parameters for an API to the server, and the server trims down the default response content by removing the fields that are not required by the client. The parameter controls which fields to return and should be a query string parameter called "fields" of an array type, provide the values as enums, and use collectionFormat.
        :param pulumi.Input[_builtins.str] host_name: A filter to return resources with host name match.
        :param pulumi.Input[_builtins.str] host_name_contains: A filter to return resources with host name pattern.
        :param pulumi.Input[Sequence[pulumi.Input['MonitoredResourcesSearchItemArgs']]] items: List of monitored resources.
        :param pulumi.Input[_builtins.str] license: License edition of the monitored resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] lifecycle_states: Multiple lifecycle states filter.
        :param pulumi.Input[_builtins.str] management_agent_id: A filter to return resources with matching management agent id.
        :param pulumi.Input[_builtins.str] name: A filter to return resources that match exact resource name.
        :param pulumi.Input[_builtins.str] name_contains: A filter to return resources that match resource name pattern given. The match is not case sensitive.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] property_equals: Criteria based on resource property.
        :param pulumi.Input[_builtins.str] resource_category: Resource category filter.
        :param pulumi.Input[_builtins.str] resource_time_zone: Time zone in the form of tz database canonical zone ID. Specifies the preference with a value that uses the IANA Time Zone Database format (x-obmcs-time-zone). For example - America/Los_Angeles
        :param pulumi.Input[_builtins.str] source_type: Source type filter.
        :param pulumi.Input[_builtins.str] state: A filter to return resources with matching lifecycle state.
        :param pulumi.Input[_builtins.str] time_created_greater_than_or_equal_to: Search for resources that were created within a specific date range, using this parameter to specify the earliest creation date for the returned list (inclusive). Specifying this parameter without the corresponding `timeCreatedLessThan` parameter will retrieve resources created from the given `timeCreatedGreaterThanOrEqualTo` to the current time, in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).
               
               **Example:** 2016-12-19T16:39:57.600Z
        :param pulumi.Input[_builtins.str] time_created_less_than: Search for resources that were created within a specific date range, using this parameter to specify the latest creation date for the returned list (exclusive). Specifying this parameter without the corresponding `timeCreatedGreaterThanOrEqualTo` parameter will retrieve all resources created before the specified end date, in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).
               
               **Example:** 2016-12-19T16:39:57.600Z
        :param pulumi.Input[_builtins.str] time_updated_greater_than_or_equal_to: Search for resources that were updated within a specific date range, using this parameter to specify the earliest update date for the returned list (inclusive). Specifying this parameter without the corresponding `timeUpdatedLessThan` parameter will retrieve resources updated from the given `timeUpdatedGreaterThanOrEqualTo` to the current time, in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).
               
               **Example:** 2016-12-19T16:39:57.600Z
        :param pulumi.Input[_builtins.str] time_updated_less_than: Search for resources that were updated within a specific date range, using this parameter to specify the latest creation date for the returned list (exclusive). Specifying this parameter without the corresponding `timeUpdatedGreaterThanOrEqualTo` parameter will retrieve all resources updated before the specified end date, in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).
               
               **Example:** 2016-12-19T16:39:57.600Z
        :param pulumi.Input[_builtins.str] type: A filter to return resources that match resource type. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_ids is not None:
            pulumi.set(__self__, "compartment_ids", compartment_ids)
        if exclude_fields is not None:
            pulumi.set(__self__, "exclude_fields", exclude_fields)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if fields is not None:
            pulumi.set(__self__, "fields", fields)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if host_name_contains is not None:
            pulumi.set(__self__, "host_name_contains", host_name_contains)
        if items is not None:
            pulumi.set(__self__, "items", items)
        if license is not None:
            pulumi.set(__self__, "license", license)
        if lifecycle_states is not None:
            pulumi.set(__self__, "lifecycle_states", lifecycle_states)
        if management_agent_id is not None:
            pulumi.set(__self__, "management_agent_id", management_agent_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_contains is not None:
            pulumi.set(__self__, "name_contains", name_contains)
        if property_equals is not None:
            pulumi.set(__self__, "property_equals", property_equals)
        if resource_category is not None:
            pulumi.set(__self__, "resource_category", resource_category)
        if resource_time_zone is not None:
            pulumi.set(__self__, "resource_time_zone", resource_time_zone)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created_greater_than_or_equal_to is not None:
            pulumi.set(__self__, "time_created_greater_than_or_equal_to", time_created_greater_than_or_equal_to)
        if time_created_less_than is not None:
            pulumi.set(__self__, "time_created_less_than", time_created_less_than)
        if time_updated_greater_than_or_equal_to is not None:
            pulumi.set(__self__, "time_updated_greater_than_or_equal_to", time_updated_greater_than_or_equal_to)
        if time_updated_less_than is not None:
            pulumi.set(__self__, "time_updated_less_than", time_updated_less_than)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="compartmentIds")
    def compartment_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Multiple compartment identifiers [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_ids")

    @compartment_ids.setter
    def compartment_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "compartment_ids", value)

    @_builtins.property
    @pulumi.getter(name="excludeFields")
    def exclude_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Partial response refers to an optimization technique offered by the RESTful web APIs, to return all the information except the fields requested to be excluded (excludeFields) by the client. In this mechanism, the client sends the exclude field names as the query parameters for an API to the server, and the server trims down the default response content by removing the fields that are not required by the client. The parameter controls which fields to exlude and to return and should be a query string parameter called "excludeFields" of an array type, provide the values as enums, and use collectionFormat.
        """
        return pulumi.get(self, "exclude_fields")

    @exclude_fields.setter
    def exclude_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "exclude_fields", value)

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        External resource is any Oracle Cloud Infrastructure resource identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) which is not a Stack Monitoring service resource. Currently supports only following resource types - Container database, non-container database,  pluggable database and Oracle Cloud Infrastructure compute instance.
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_id", value)

    @_builtins.property
    @pulumi.getter
    def fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Partial response refers to an optimization technique offered by the RESTful web APIs, to return only the information (fields) required by the client. In this mechanism, the client sends the required field names as the query parameters for an API to the server, and the server trims down the default response content by removing the fields that are not required by the client. The parameter controls which fields to return and should be a query string parameter called "fields" of an array type, provide the values as enums, and use collectionFormat.
        """
        return pulumi.get(self, "fields")

    @fields.setter
    def fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "fields", value)

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A filter to return resources with host name match.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_name", value)

    @_builtins.property
    @pulumi.getter(name="hostNameContains")
    def host_name_contains(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A filter to return resources with host name pattern.
        """
        return pulumi.get(self, "host_name_contains")

    @host_name_contains.setter
    def host_name_contains(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_name_contains", value)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourcesSearchItemArgs']]]]:
        """
        List of monitored resources.
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourcesSearchItemArgs']]]]):
        pulumi.set(self, "items", value)

    @_builtins.property
    @pulumi.getter
    def license(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        License edition of the monitored resource.
        """
        return pulumi.get(self, "license")

    @license.setter
    def license(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "license", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleStates")
    def lifecycle_states(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Multiple lifecycle states filter.
        """
        return pulumi.get(self, "lifecycle_states")

    @lifecycle_states.setter
    def lifecycle_states(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "lifecycle_states", value)

    @_builtins.property
    @pulumi.getter(name="managementAgentId")
    def management_agent_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A filter to return resources with matching management agent id.
        """
        return pulumi.get(self, "management_agent_id")

    @management_agent_id.setter
    def management_agent_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "management_agent_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A filter to return resources that match exact resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nameContains")
    def name_contains(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A filter to return resources that match resource name pattern given. The match is not case sensitive.
        """
        return pulumi.get(self, "name_contains")

    @name_contains.setter
    def name_contains(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name_contains", value)

    @_builtins.property
    @pulumi.getter(name="propertyEquals")
    def property_equals(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Criteria based on resource property.
        """
        return pulumi.get(self, "property_equals")

    @property_equals.setter
    def property_equals(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "property_equals", value)

    @_builtins.property
    @pulumi.getter(name="resourceCategory")
    def resource_category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource category filter.
        """
        return pulumi.get(self, "resource_category")

    @resource_category.setter
    def resource_category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_category", value)

    @_builtins.property
    @pulumi.getter(name="resourceTimeZone")
    def resource_time_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time zone in the form of tz database canonical zone ID. Specifies the preference with a value that uses the IANA Time Zone Database format (x-obmcs-time-zone). For example - America/Los_Angeles
        """
        return pulumi.get(self, "resource_time_zone")

    @resource_time_zone.setter
    def resource_time_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_time_zone", value)

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Source type filter.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_type", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A filter to return resources with matching lifecycle state.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="timeCreatedGreaterThanOrEqualTo")
    def time_created_greater_than_or_equal_to(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Search for resources that were created within a specific date range, using this parameter to specify the earliest creation date for the returned list (inclusive). Specifying this parameter without the corresponding `timeCreatedLessThan` parameter will retrieve resources created from the given `timeCreatedGreaterThanOrEqualTo` to the current time, in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).

        **Example:** 2016-12-19T16:39:57.600Z
        """
        return pulumi.get(self, "time_created_greater_than_or_equal_to")

    @time_created_greater_than_or_equal_to.setter
    def time_created_greater_than_or_equal_to(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created_greater_than_or_equal_to", value)

    @_builtins.property
    @pulumi.getter(name="timeCreatedLessThan")
    def time_created_less_than(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Search for resources that were created within a specific date range, using this parameter to specify the latest creation date for the returned list (exclusive). Specifying this parameter without the corresponding `timeCreatedGreaterThanOrEqualTo` parameter will retrieve all resources created before the specified end date, in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).

        **Example:** 2016-12-19T16:39:57.600Z
        """
        return pulumi.get(self, "time_created_less_than")

    @time_created_less_than.setter
    def time_created_less_than(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created_less_than", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdatedGreaterThanOrEqualTo")
    def time_updated_greater_than_or_equal_to(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Search for resources that were updated within a specific date range, using this parameter to specify the earliest update date for the returned list (inclusive). Specifying this parameter without the corresponding `timeUpdatedLessThan` parameter will retrieve resources updated from the given `timeUpdatedGreaterThanOrEqualTo` to the current time, in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).

        **Example:** 2016-12-19T16:39:57.600Z
        """
        return pulumi.get(self, "time_updated_greater_than_or_equal_to")

    @time_updated_greater_than_or_equal_to.setter
    def time_updated_greater_than_or_equal_to(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated_greater_than_or_equal_to", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdatedLessThan")
    def time_updated_less_than(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Search for resources that were updated within a specific date range, using this parameter to specify the latest creation date for the returned list (exclusive). Specifying this parameter without the corresponding `timeUpdatedGreaterThanOrEqualTo` parameter will retrieve all resources updated before the specified end date, in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).

        **Example:** 2016-12-19T16:39:57.600Z
        """
        return pulumi.get(self, "time_updated_less_than")

    @time_updated_less_than.setter
    def time_updated_less_than(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated_less_than", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A filter to return resources that match resource type. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("oci:StackMonitoring/monitoredResourcesSearch:MonitoredResourcesSearch")
class MonitoredResourcesSearch(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 exclude_fields: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 external_id: Optional[pulumi.Input[_builtins.str]] = None,
                 fields: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 host_name_contains: Optional[pulumi.Input[_builtins.str]] = None,
                 license: Optional[pulumi.Input[_builtins.str]] = None,
                 lifecycle_states: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 management_agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_contains: Optional[pulumi.Input[_builtins.str]] = None,
                 property_equals: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 resource_category: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created_greater_than_or_equal_to: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created_less_than: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated_greater_than_or_equal_to: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated_less_than: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_monitored_resources_search = oci.stackmonitoring.MonitoredResourcesSearch("test_monitored_resources_search",
            compartment_id=compartment_id,
            compartment_ids=monitored_resources_search_compartment_ids,
            exclude_fields=monitored_resources_search_exclude_fields,
            external_id=test_external["id"],
            fields=monitored_resources_search_fields,
            host_name=monitored_resources_search_host_name,
            host_name_contains=monitored_resources_search_host_name_contains,
            license=monitored_resources_search_license,
            lifecycle_states=monitored_resources_search_lifecycle_states,
            management_agent_id=test_management_agent["id"],
            name=monitored_resources_search_name,
            name_contains=monitored_resources_search_name_contains,
            property_equals=monitored_resources_search_property_equals,
            resource_category=monitored_resources_search_resource_category,
            resource_time_zone=monitored_resources_search_resource_time_zone,
            source_type=monitored_resources_search_source_type,
            state=monitored_resources_search_state,
            time_created_greater_than_or_equal_to=monitored_resources_search_time_created_greater_than_or_equal_to,
            time_created_less_than=monitored_resources_search_time_created_less_than,
            time_updated_greater_than_or_equal_to=monitored_resources_search_time_updated_greater_than_or_equal_to,
            time_updated_less_than=monitored_resources_search_time_updated_less_than,
            type=monitored_resources_search_type)
        ```

        ## Import

        MonitoredResourcesSearch can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:StackMonitoring/monitoredResourcesSearch:MonitoredResourcesSearch test_monitored_resources_search "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] compartment_ids: Multiple compartment identifiers [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] exclude_fields: Partial response refers to an optimization technique offered by the RESTful web APIs, to return all the information except the fields requested to be excluded (excludeFields) by the client. In this mechanism, the client sends the exclude field names as the query parameters for an API to the server, and the server trims down the default response content by removing the fields that are not required by the client. The parameter controls which fields to exlude and to return and should be a query string parameter called "excludeFields" of an array type, provide the values as enums, and use collectionFormat.
        :param pulumi.Input[_builtins.str] external_id: External resource is any Oracle Cloud Infrastructure resource identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) which is not a Stack Monitoring service resource. Currently supports only following resource types - Container database, non-container database,  pluggable database and Oracle Cloud Infrastructure compute instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] fields: Partial response refers to an optimization technique offered by the RESTful web APIs, to return only the information (fields) required by the client. In this mechanism, the client sends the required field names as the query parameters for an API to the server, and the server trims down the default response content by removing the fields that are not required by the client. The parameter controls which fields to return and should be a query string parameter called "fields" of an array type, provide the values as enums, and use collectionFormat.
        :param pulumi.Input[_builtins.str] host_name: A filter to return resources with host name match.
        :param pulumi.Input[_builtins.str] host_name_contains: A filter to return resources with host name pattern.
        :param pulumi.Input[_builtins.str] license: License edition of the monitored resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] lifecycle_states: Multiple lifecycle states filter.
        :param pulumi.Input[_builtins.str] management_agent_id: A filter to return resources with matching management agent id.
        :param pulumi.Input[_builtins.str] name: A filter to return resources that match exact resource name.
        :param pulumi.Input[_builtins.str] name_contains: A filter to return resources that match resource name pattern given. The match is not case sensitive.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] property_equals: Criteria based on resource property.
        :param pulumi.Input[_builtins.str] resource_category: Resource category filter.
        :param pulumi.Input[_builtins.str] resource_time_zone: Time zone in the form of tz database canonical zone ID. Specifies the preference with a value that uses the IANA Time Zone Database format (x-obmcs-time-zone). For example - America/Los_Angeles
        :param pulumi.Input[_builtins.str] source_type: Source type filter.
        :param pulumi.Input[_builtins.str] state: A filter to return resources with matching lifecycle state.
        :param pulumi.Input[_builtins.str] time_created_greater_than_or_equal_to: Search for resources that were created within a specific date range, using this parameter to specify the earliest creation date for the returned list (inclusive). Specifying this parameter without the corresponding `timeCreatedLessThan` parameter will retrieve resources created from the given `timeCreatedGreaterThanOrEqualTo` to the current time, in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).
               
               **Example:** 2016-12-19T16:39:57.600Z
        :param pulumi.Input[_builtins.str] time_created_less_than: Search for resources that were created within a specific date range, using this parameter to specify the latest creation date for the returned list (exclusive). Specifying this parameter without the corresponding `timeCreatedGreaterThanOrEqualTo` parameter will retrieve all resources created before the specified end date, in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).
               
               **Example:** 2016-12-19T16:39:57.600Z
        :param pulumi.Input[_builtins.str] time_updated_greater_than_or_equal_to: Search for resources that were updated within a specific date range, using this parameter to specify the earliest update date for the returned list (inclusive). Specifying this parameter without the corresponding `timeUpdatedLessThan` parameter will retrieve resources updated from the given `timeUpdatedGreaterThanOrEqualTo` to the current time, in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).
               
               **Example:** 2016-12-19T16:39:57.600Z
        :param pulumi.Input[_builtins.str] time_updated_less_than: Search for resources that were updated within a specific date range, using this parameter to specify the latest creation date for the returned list (exclusive). Specifying this parameter without the corresponding `timeUpdatedGreaterThanOrEqualTo` parameter will retrieve all resources updated before the specified end date, in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).
               
               **Example:** 2016-12-19T16:39:57.600Z
        :param pulumi.Input[_builtins.str] type: A filter to return resources that match resource type. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MonitoredResourcesSearchArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_monitored_resources_search = oci.stackmonitoring.MonitoredResourcesSearch("test_monitored_resources_search",
            compartment_id=compartment_id,
            compartment_ids=monitored_resources_search_compartment_ids,
            exclude_fields=monitored_resources_search_exclude_fields,
            external_id=test_external["id"],
            fields=monitored_resources_search_fields,
            host_name=monitored_resources_search_host_name,
            host_name_contains=monitored_resources_search_host_name_contains,
            license=monitored_resources_search_license,
            lifecycle_states=monitored_resources_search_lifecycle_states,
            management_agent_id=test_management_agent["id"],
            name=monitored_resources_search_name,
            name_contains=monitored_resources_search_name_contains,
            property_equals=monitored_resources_search_property_equals,
            resource_category=monitored_resources_search_resource_category,
            resource_time_zone=monitored_resources_search_resource_time_zone,
            source_type=monitored_resources_search_source_type,
            state=monitored_resources_search_state,
            time_created_greater_than_or_equal_to=monitored_resources_search_time_created_greater_than_or_equal_to,
            time_created_less_than=monitored_resources_search_time_created_less_than,
            time_updated_greater_than_or_equal_to=monitored_resources_search_time_updated_greater_than_or_equal_to,
            time_updated_less_than=monitored_resources_search_time_updated_less_than,
            type=monitored_resources_search_type)
        ```

        ## Import

        MonitoredResourcesSearch can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:StackMonitoring/monitoredResourcesSearch:MonitoredResourcesSearch test_monitored_resources_search "id"
        ```

        :param str resource_name: The name of the resource.
        :param MonitoredResourcesSearchArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MonitoredResourcesSearchArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 exclude_fields: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 external_id: Optional[pulumi.Input[_builtins.str]] = None,
                 fields: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 host_name_contains: Optional[pulumi.Input[_builtins.str]] = None,
                 license: Optional[pulumi.Input[_builtins.str]] = None,
                 lifecycle_states: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 management_agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_contains: Optional[pulumi.Input[_builtins.str]] = None,
                 property_equals: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 resource_category: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created_greater_than_or_equal_to: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created_less_than: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated_greater_than_or_equal_to: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated_less_than: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MonitoredResourcesSearchArgs.__new__(MonitoredResourcesSearchArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["compartment_ids"] = compartment_ids
            __props__.__dict__["exclude_fields"] = exclude_fields
            __props__.__dict__["external_id"] = external_id
            __props__.__dict__["fields"] = fields
            __props__.__dict__["host_name"] = host_name
            __props__.__dict__["host_name_contains"] = host_name_contains
            __props__.__dict__["license"] = license
            __props__.__dict__["lifecycle_states"] = lifecycle_states
            __props__.__dict__["management_agent_id"] = management_agent_id
            __props__.__dict__["name"] = name
            __props__.__dict__["name_contains"] = name_contains
            __props__.__dict__["property_equals"] = property_equals
            __props__.__dict__["resource_category"] = resource_category
            __props__.__dict__["resource_time_zone"] = resource_time_zone
            __props__.__dict__["source_type"] = source_type
            __props__.__dict__["state"] = state
            __props__.__dict__["time_created_greater_than_or_equal_to"] = time_created_greater_than_or_equal_to
            __props__.__dict__["time_created_less_than"] = time_created_less_than
            __props__.__dict__["time_updated_greater_than_or_equal_to"] = time_updated_greater_than_or_equal_to
            __props__.__dict__["time_updated_less_than"] = time_updated_less_than
            __props__.__dict__["type"] = type
            __props__.__dict__["items"] = None
        super(MonitoredResourcesSearch, __self__).__init__(
            'oci:StackMonitoring/monitoredResourcesSearch:MonitoredResourcesSearch',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            compartment_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            exclude_fields: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            external_id: Optional[pulumi.Input[_builtins.str]] = None,
            fields: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            host_name: Optional[pulumi.Input[_builtins.str]] = None,
            host_name_contains: Optional[pulumi.Input[_builtins.str]] = None,
            items: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MonitoredResourcesSearchItemArgs', 'MonitoredResourcesSearchItemArgsDict']]]]] = None,
            license: Optional[pulumi.Input[_builtins.str]] = None,
            lifecycle_states: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            management_agent_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            name_contains: Optional[pulumi.Input[_builtins.str]] = None,
            property_equals: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            resource_category: Optional[pulumi.Input[_builtins.str]] = None,
            resource_time_zone: Optional[pulumi.Input[_builtins.str]] = None,
            source_type: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            time_created_greater_than_or_equal_to: Optional[pulumi.Input[_builtins.str]] = None,
            time_created_less_than: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated_greater_than_or_equal_to: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated_less_than: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'MonitoredResourcesSearch':
        """
        Get an existing MonitoredResourcesSearch resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] compartment_ids: Multiple compartment identifiers [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] exclude_fields: Partial response refers to an optimization technique offered by the RESTful web APIs, to return all the information except the fields requested to be excluded (excludeFields) by the client. In this mechanism, the client sends the exclude field names as the query parameters for an API to the server, and the server trims down the default response content by removing the fields that are not required by the client. The parameter controls which fields to exlude and to return and should be a query string parameter called "excludeFields" of an array type, provide the values as enums, and use collectionFormat.
        :param pulumi.Input[_builtins.str] external_id: External resource is any Oracle Cloud Infrastructure resource identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) which is not a Stack Monitoring service resource. Currently supports only following resource types - Container database, non-container database,  pluggable database and Oracle Cloud Infrastructure compute instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] fields: Partial response refers to an optimization technique offered by the RESTful web APIs, to return only the information (fields) required by the client. In this mechanism, the client sends the required field names as the query parameters for an API to the server, and the server trims down the default response content by removing the fields that are not required by the client. The parameter controls which fields to return and should be a query string parameter called "fields" of an array type, provide the values as enums, and use collectionFormat.
        :param pulumi.Input[_builtins.str] host_name: A filter to return resources with host name match.
        :param pulumi.Input[_builtins.str] host_name_contains: A filter to return resources with host name pattern.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MonitoredResourcesSearchItemArgs', 'MonitoredResourcesSearchItemArgsDict']]]] items: List of monitored resources.
        :param pulumi.Input[_builtins.str] license: License edition of the monitored resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] lifecycle_states: Multiple lifecycle states filter.
        :param pulumi.Input[_builtins.str] management_agent_id: A filter to return resources with matching management agent id.
        :param pulumi.Input[_builtins.str] name: A filter to return resources that match exact resource name.
        :param pulumi.Input[_builtins.str] name_contains: A filter to return resources that match resource name pattern given. The match is not case sensitive.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] property_equals: Criteria based on resource property.
        :param pulumi.Input[_builtins.str] resource_category: Resource category filter.
        :param pulumi.Input[_builtins.str] resource_time_zone: Time zone in the form of tz database canonical zone ID. Specifies the preference with a value that uses the IANA Time Zone Database format (x-obmcs-time-zone). For example - America/Los_Angeles
        :param pulumi.Input[_builtins.str] source_type: Source type filter.
        :param pulumi.Input[_builtins.str] state: A filter to return resources with matching lifecycle state.
        :param pulumi.Input[_builtins.str] time_created_greater_than_or_equal_to: Search for resources that were created within a specific date range, using this parameter to specify the earliest creation date for the returned list (inclusive). Specifying this parameter without the corresponding `timeCreatedLessThan` parameter will retrieve resources created from the given `timeCreatedGreaterThanOrEqualTo` to the current time, in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).
               
               **Example:** 2016-12-19T16:39:57.600Z
        :param pulumi.Input[_builtins.str] time_created_less_than: Search for resources that were created within a specific date range, using this parameter to specify the latest creation date for the returned list (exclusive). Specifying this parameter without the corresponding `timeCreatedGreaterThanOrEqualTo` parameter will retrieve all resources created before the specified end date, in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).
               
               **Example:** 2016-12-19T16:39:57.600Z
        :param pulumi.Input[_builtins.str] time_updated_greater_than_or_equal_to: Search for resources that were updated within a specific date range, using this parameter to specify the earliest update date for the returned list (inclusive). Specifying this parameter without the corresponding `timeUpdatedLessThan` parameter will retrieve resources updated from the given `timeUpdatedGreaterThanOrEqualTo` to the current time, in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).
               
               **Example:** 2016-12-19T16:39:57.600Z
        :param pulumi.Input[_builtins.str] time_updated_less_than: Search for resources that were updated within a specific date range, using this parameter to specify the latest creation date for the returned list (exclusive). Specifying this parameter without the corresponding `timeUpdatedGreaterThanOrEqualTo` parameter will retrieve all resources updated before the specified end date, in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).
               
               **Example:** 2016-12-19T16:39:57.600Z
        :param pulumi.Input[_builtins.str] type: A filter to return resources that match resource type. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MonitoredResourcesSearchState.__new__(_MonitoredResourcesSearchState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["compartment_ids"] = compartment_ids
        __props__.__dict__["exclude_fields"] = exclude_fields
        __props__.__dict__["external_id"] = external_id
        __props__.__dict__["fields"] = fields
        __props__.__dict__["host_name"] = host_name
        __props__.__dict__["host_name_contains"] = host_name_contains
        __props__.__dict__["items"] = items
        __props__.__dict__["license"] = license
        __props__.__dict__["lifecycle_states"] = lifecycle_states
        __props__.__dict__["management_agent_id"] = management_agent_id
        __props__.__dict__["name"] = name
        __props__.__dict__["name_contains"] = name_contains
        __props__.__dict__["property_equals"] = property_equals
        __props__.__dict__["resource_category"] = resource_category
        __props__.__dict__["resource_time_zone"] = resource_time_zone
        __props__.__dict__["source_type"] = source_type
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created_greater_than_or_equal_to"] = time_created_greater_than_or_equal_to
        __props__.__dict__["time_created_less_than"] = time_created_less_than
        __props__.__dict__["time_updated_greater_than_or_equal_to"] = time_updated_greater_than_or_equal_to
        __props__.__dict__["time_updated_less_than"] = time_updated_less_than
        __props__.__dict__["type"] = type
        return MonitoredResourcesSearch(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="compartmentIds")
    def compartment_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Multiple compartment identifiers [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_ids")

    @_builtins.property
    @pulumi.getter(name="excludeFields")
    def exclude_fields(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Partial response refers to an optimization technique offered by the RESTful web APIs, to return all the information except the fields requested to be excluded (excludeFields) by the client. In this mechanism, the client sends the exclude field names as the query parameters for an API to the server, and the server trims down the default response content by removing the fields that are not required by the client. The parameter controls which fields to exlude and to return and should be a query string parameter called "excludeFields" of an array type, provide the values as enums, and use collectionFormat.
        """
        return pulumi.get(self, "exclude_fields")

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        External resource is any Oracle Cloud Infrastructure resource identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) which is not a Stack Monitoring service resource. Currently supports only following resource types - Container database, non-container database,  pluggable database and Oracle Cloud Infrastructure compute instance.
        """
        return pulumi.get(self, "external_id")

    @_builtins.property
    @pulumi.getter
    def fields(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Partial response refers to an optimization technique offered by the RESTful web APIs, to return only the information (fields) required by the client. In this mechanism, the client sends the required field names as the query parameters for an API to the server, and the server trims down the default response content by removing the fields that are not required by the client. The parameter controls which fields to return and should be a query string parameter called "fields" of an array type, provide the values as enums, and use collectionFormat.
        """
        return pulumi.get(self, "fields")

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A filter to return resources with host name match.
        """
        return pulumi.get(self, "host_name")

    @_builtins.property
    @pulumi.getter(name="hostNameContains")
    def host_name_contains(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A filter to return resources with host name pattern.
        """
        return pulumi.get(self, "host_name_contains")

    @_builtins.property
    @pulumi.getter
    def items(self) -> pulumi.Output[Sequence['outputs.MonitoredResourcesSearchItem']]:
        """
        List of monitored resources.
        """
        return pulumi.get(self, "items")

    @_builtins.property
    @pulumi.getter
    def license(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        License edition of the monitored resource.
        """
        return pulumi.get(self, "license")

    @_builtins.property
    @pulumi.getter(name="lifecycleStates")
    def lifecycle_states(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Multiple lifecycle states filter.
        """
        return pulumi.get(self, "lifecycle_states")

    @_builtins.property
    @pulumi.getter(name="managementAgentId")
    def management_agent_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A filter to return resources with matching management agent id.
        """
        return pulumi.get(self, "management_agent_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        A filter to return resources that match exact resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nameContains")
    def name_contains(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A filter to return resources that match resource name pattern given. The match is not case sensitive.
        """
        return pulumi.get(self, "name_contains")

    @_builtins.property
    @pulumi.getter(name="propertyEquals")
    def property_equals(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Criteria based on resource property.
        """
        return pulumi.get(self, "property_equals")

    @_builtins.property
    @pulumi.getter(name="resourceCategory")
    def resource_category(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Resource category filter.
        """
        return pulumi.get(self, "resource_category")

    @_builtins.property
    @pulumi.getter(name="resourceTimeZone")
    def resource_time_zone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Time zone in the form of tz database canonical zone ID. Specifies the preference with a value that uses the IANA Time Zone Database format (x-obmcs-time-zone). For example - America/Los_Angeles
        """
        return pulumi.get(self, "resource_time_zone")

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Source type filter.
        """
        return pulumi.get(self, "source_type")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A filter to return resources with matching lifecycle state.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreatedGreaterThanOrEqualTo")
    def time_created_greater_than_or_equal_to(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Search for resources that were created within a specific date range, using this parameter to specify the earliest creation date for the returned list (inclusive). Specifying this parameter without the corresponding `timeCreatedLessThan` parameter will retrieve resources created from the given `timeCreatedGreaterThanOrEqualTo` to the current time, in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).

        **Example:** 2016-12-19T16:39:57.600Z
        """
        return pulumi.get(self, "time_created_greater_than_or_equal_to")

    @_builtins.property
    @pulumi.getter(name="timeCreatedLessThan")
    def time_created_less_than(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Search for resources that were created within a specific date range, using this parameter to specify the latest creation date for the returned list (exclusive). Specifying this parameter without the corresponding `timeCreatedGreaterThanOrEqualTo` parameter will retrieve all resources created before the specified end date, in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).

        **Example:** 2016-12-19T16:39:57.600Z
        """
        return pulumi.get(self, "time_created_less_than")

    @_builtins.property
    @pulumi.getter(name="timeUpdatedGreaterThanOrEqualTo")
    def time_updated_greater_than_or_equal_to(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Search for resources that were updated within a specific date range, using this parameter to specify the earliest update date for the returned list (inclusive). Specifying this parameter without the corresponding `timeUpdatedLessThan` parameter will retrieve resources updated from the given `timeUpdatedGreaterThanOrEqualTo` to the current time, in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).

        **Example:** 2016-12-19T16:39:57.600Z
        """
        return pulumi.get(self, "time_updated_greater_than_or_equal_to")

    @_builtins.property
    @pulumi.getter(name="timeUpdatedLessThan")
    def time_updated_less_than(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Search for resources that were updated within a specific date range, using this parameter to specify the latest creation date for the returned list (exclusive). Specifying this parameter without the corresponding `timeUpdatedGreaterThanOrEqualTo` parameter will retrieve all resources updated before the specified end date, in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).

        **Example:** 2016-12-19T16:39:57.600Z
        """
        return pulumi.get(self, "time_updated_less_than")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A filter to return resources that match resource type. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

