# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetConnectHarnessesResult',
    'AwaitableGetConnectHarnessesResult',
    'get_connect_harnesses',
    'get_connect_harnesses_output',
]

@pulumi.output_type
class GetConnectHarnessesResult:
    """
    A collection of values returned by getConnectHarnesses.
    """
    def __init__(__self__, compartment_id=None, connect_harnesses=None, filters=None, id=None, name=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if connect_harnesses and not isinstance(connect_harnesses, list):
            raise TypeError("Expected argument 'connect_harnesses' to be a list")
        pulumi.set(__self__, "connect_harnesses", connect_harnesses)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment that contains the connect harness.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="connectHarnesses")
    def connect_harnesses(self) -> Sequence['outputs.GetConnectHarnessesConnectHarnessResult']:
        """
        The list of connect_harness.
        """
        return pulumi.get(self, "connect_harnesses")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetConnectHarnessesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The OCID of the connect harness.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the connect harness. Avoid entering confidential information.  Example: `JDBCConnector`
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the connect harness.
        """
        return pulumi.get(self, "state")


class AwaitableGetConnectHarnessesResult(GetConnectHarnessesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConnectHarnessesResult(
            compartment_id=self.compartment_id,
            connect_harnesses=self.connect_harnesses,
            filters=self.filters,
            id=self.id,
            name=self.name,
            state=self.state)


def get_connect_harnesses(compartment_id: Optional[_builtins.str] = None,
                          filters: Optional[Sequence[Union['GetConnectHarnessesFilterArgs', 'GetConnectHarnessesFilterArgsDict']]] = None,
                          id: Optional[_builtins.str] = None,
                          name: Optional[_builtins.str] = None,
                          state: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConnectHarnessesResult:
    """
    This data source provides the list of Connect Harnesses in Oracle Cloud Infrastructure Streaming service.

    Lists the connectharness.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_connect_harnesses = oci.Streaming.get_connect_harnesses(compartment_id=compartment_id,
        id=connect_harness_id,
        name=connect_harness_name,
        state=connect_harness_state)
    ```


    :param _builtins.str compartment_id: The OCID of the compartment.
    :param _builtins.str id: A filter to return only resources that match the given ID exactly.
    :param _builtins.str name: A filter to return only resources that match the given name exactly.
    :param _builtins.str state: A filter to only return resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['name'] = name
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Streaming/getConnectHarnesses:getConnectHarnesses', __args__, opts=opts, typ=GetConnectHarnessesResult).value

    return AwaitableGetConnectHarnessesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        connect_harnesses=pulumi.get(__ret__, 'connect_harnesses'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        state=pulumi.get(__ret__, 'state'))
def get_connect_harnesses_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                 filters: Optional[pulumi.Input[Optional[Sequence[Union['GetConnectHarnessesFilterArgs', 'GetConnectHarnessesFilterArgsDict']]]]] = None,
                                 id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetConnectHarnessesResult]:
    """
    This data source provides the list of Connect Harnesses in Oracle Cloud Infrastructure Streaming service.

    Lists the connectharness.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_connect_harnesses = oci.Streaming.get_connect_harnesses(compartment_id=compartment_id,
        id=connect_harness_id,
        name=connect_harness_name,
        state=connect_harness_state)
    ```


    :param _builtins.str compartment_id: The OCID of the compartment.
    :param _builtins.str id: A filter to return only resources that match the given ID exactly.
    :param _builtins.str name: A filter to return only resources that match the given name exactly.
    :param _builtins.str state: A filter to only return resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['name'] = name
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Streaming/getConnectHarnesses:getConnectHarnesses', __args__, opts=opts, typ=GetConnectHarnessesResult)
    return __ret__.apply(lambda __response__: GetConnectHarnessesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        connect_harnesses=pulumi.get(__response__, 'connect_harnesses'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        state=pulumi.get(__response__, 'state')))
