# BIDS Schema Tools

[![License](https://img.shields.io/badge/License-MIT-blue.svg)](https://opensource.org/licenses/MIT)
[![codecov](https://codecov.io/gh/bids-standard/bids-specification/branch/master/graph/badge.svg)](https://codecov.io/gh/bids-standard/bids-specification)
[![Gentoo (::science)](https://repology.org/badge/version-for-repo/gentoo_ovl_science/bidsschematools.svg?header=Gentoo%20%28%3A%3Ascience%29)](https://repology.org/project/bidsschematools/versions)
[![PyPI version fury.io](https://badge.fury.io/py/bidsschematools.svg)](https://pypi.org/project/bidsschematools/)

A Python library (available after installation in the Python interpreter as `bidsschematools`)
for working with the [Brain Imaging Data Structure (BIDS)](https://bids.neuroimaging.io/) schema.

Features:
* lightweight
* reference schema parsing implementation used for schema testing
* simple CLI bindings (e.g. `bst export`)

If you have questions, you can post them in one of several channels where BIDS members are active:
  - the [NeuroStars](https://neurostars.org/tags/bids) discourse forum
  - the [BrainHack Mattermost](https://mattermost.brainhack.org),
    for instant messaging (see also this [news item](https://bids.neuroimaging.io/2020/06/24/Join-the-BIDS-community-on-the-BrainHack-Mattermost.html))
  - the [Google group](https://groups.google.com/forum/#!forum/bids-discussion),
    for broader discussions surrounding BIDS
