// Generated by https://github.com/foxglove/foxglove-sdk

export const ArrowPrimitive = {
  "title": "foxglove.ArrowPrimitive",
  "description": "A primitive representing an arrow",
  "$comment": "Generated by https://github.com/foxglove/foxglove-sdk",
  "type": "object",
  "properties": {
    "pose": {
      "title": "foxglove.Pose",
      "description": "Position of the arrow's tail and orientation of the arrow. Identity orientation means the arrow points in the +x direction.",
      "type": "object",
      "properties": {
        "position": {
          "title": "foxglove.Vector3",
          "description": "Point denoting position in 3D space",
          "type": "object",
          "properties": {
            "x": {
              "type": "number",
              "description": "x coordinate length"
            },
            "y": {
              "type": "number",
              "description": "y coordinate length"
            },
            "z": {
              "type": "number",
              "description": "z coordinate length"
            }
          },
          "required": [
            "x",
            "y",
            "z"
          ]
        },
        "orientation": {
          "title": "foxglove.Quaternion",
          "description": "Quaternion denoting orientation in 3D space",
          "type": "object",
          "properties": {
            "x": {
              "type": "number",
              "description": "x value"
            },
            "y": {
              "type": "number",
              "description": "y value"
            },
            "z": {
              "type": "number",
              "description": "z value"
            },
            "w": {
              "type": "number",
              "description": "w value"
            }
          },
          "required": [
            "x",
            "y",
            "z",
            "w"
          ]
        }
      },
      "required": [
        "position",
        "orientation"
      ]
    },
    "shaft_length": {
      "type": "number",
      "description": "Length of the arrow shaft"
    },
    "shaft_diameter": {
      "type": "number",
      "description": "Diameter of the arrow shaft"
    },
    "head_length": {
      "type": "number",
      "description": "Length of the arrow head"
    },
    "head_diameter": {
      "type": "number",
      "description": "Diameter of the arrow head"
    },
    "color": {
      "title": "foxglove.Color",
      "description": "Color of the arrow",
      "type": "object",
      "properties": {
        "r": {
          "type": "number",
          "description": "Red value between 0 and 1"
        },
        "g": {
          "type": "number",
          "description": "Green value between 0 and 1"
        },
        "b": {
          "type": "number",
          "description": "Blue value between 0 and 1"
        },
        "a": {
          "type": "number",
          "description": "Alpha value between 0 and 1"
        }
      },
      "required": [
        "r",
        "g",
        "b",
        "a"
      ]
    }
  },
  "required": [
    "pose",
    "shaft_length",
    "shaft_diameter",
    "head_length",
    "head_diameter",
    "color"
  ]
};

export const CameraCalibration = {
  "title": "foxglove.CameraCalibration",
  "description": "Camera calibration parameters",
  "$comment": "Generated by https://github.com/foxglove/foxglove-sdk",
  "type": "object",
  "properties": {
    "timestamp": {
      "type": "object",
      "title": "time",
      "properties": {
        "sec": {
          "type": "integer",
          "minimum": 0
        },
        "nsec": {
          "type": "integer",
          "minimum": 0,
          "maximum": 999999999
        }
      },
      "description": "Timestamp of calibration data"
    },
    "frame_id": {
      "type": "string",
      "description": "Frame of reference for the camera. The origin of the frame is the optical center of the camera. +x points to the right in the image, +y points down, and +z points into the plane of the image."
    },
    "width": {
      "type": "integer",
      "minimum": 0,
      "description": "Image width"
    },
    "height": {
      "type": "integer",
      "minimum": 0,
      "description": "Image height"
    },
    "distortion_model": {
      "type": "string",
      "description": "Name of distortion model\n\nSupported parameters: `plumb_bob` (k1, k2, p1, p2, k3), `rational_polynomial` (k1, k2, p1, p2, k3, k4, k5, k6), and `kannala_brandt` (k1, k2, k3, k4). `plumb_bob` and `rational_polynomial` models are based on the pinhole model [OpenCV's](https://docs.opencv.org/4.11.0/d9/d0c/group__calib3d.html) [pinhole camera model](https://en.wikipedia.org/wiki/Distortion_%28optics%29#Software_correction). The `kannala_brandt` model matches the [OpenvCV fisheye](https://docs.opencv.org/4.11.0/db/d58/group__calib3d__fisheye.html) model."
    },
    "D": {
      "type": "array",
      "items": {
        "type": "number"
      },
      "description": "Distortion parameters"
    },
    "K": {
      "type": "array",
      "items": {
        "type": "number"
      },
      "minItems": 9,
      "maxItems": 9,
      "description": "Intrinsic camera matrix (3x3 row-major matrix)\n\nA 3x3 row-major matrix for the raw (distorted) image.\n\nProjects 3D points in the camera coordinate frame to 2D pixel coordinates using the focal lengths (fx, fy) and principal point (cx, cy).\n\n```\n    [fx  0 cx]\nK = [ 0 fy cy]\n    [ 0  0  1]\n```\n"
    },
    "R": {
      "type": "array",
      "items": {
        "type": "number"
      },
      "minItems": 9,
      "maxItems": 9,
      "description": "Rectification matrix (stereo cameras only, 3x3 row-major matrix)\n\nA rotation matrix aligning the camera coordinate system to the ideal stereo image plane so that epipolar lines in both stereo images are parallel."
    },
    "P": {
      "type": "array",
      "items": {
        "type": "number"
      },
      "minItems": 12,
      "maxItems": 12,
      "description": "Projection/camera matrix (3x4 row-major matrix)\n\n```\n    [fx'  0  cx' Tx]\nP = [ 0  fy' cy' Ty]\n    [ 0   0   1   0]\n```\n\nBy convention, this matrix specifies the intrinsic (camera) matrix of the processed (rectified) image. That is, the left 3x3 portion is the normal camera intrinsic matrix for the rectified image.\n\nIt projects 3D points in the camera coordinate frame to 2D pixel coordinates using the focal lengths (fx', fy') and principal point (cx', cy') - these may differ from the values in K.\n\nFor monocular cameras, Tx = Ty = 0. Normally, monocular cameras will also have R = the identity and P[1:3,1:3] = K.\n\nFoxglove currently does not support displaying stereo images, so Tx and Ty are ignored.\n\nGiven a 3D point [X Y Z]', the projection (x, y) of the point onto the rectified image is given by:\n\n```\n[u v w]' = P * [X Y Z 1]'\n       x = u / w\n       y = v / w\n```\n\nThis holds for both images of a stereo pair.\n"
    }
  },
  "required": [
    "timestamp",
    "frame_id",
    "width",
    "height",
    "distortion_model",
    "D",
    "K",
    "R",
    "P"
  ]
};

export const CircleAnnotation = {
  "title": "foxglove.CircleAnnotation",
  "description": "A circle annotation on a 2D image",
  "$comment": "Generated by https://github.com/foxglove/foxglove-sdk",
  "type": "object",
  "properties": {
    "timestamp": {
      "type": "object",
      "title": "time",
      "properties": {
        "sec": {
          "type": "integer",
          "minimum": 0
        },
        "nsec": {
          "type": "integer",
          "minimum": 0,
          "maximum": 999999999
        }
      },
      "description": "Timestamp of circle"
    },
    "position": {
      "title": "foxglove.Point2",
      "description": "Center of the circle in 2D image coordinates (pixels).\nThe coordinate uses the top-left corner of the top-left pixel of the image as the origin.",
      "type": "object",
      "properties": {
        "x": {
          "type": "number",
          "description": "x coordinate position"
        },
        "y": {
          "type": "number",
          "description": "y coordinate position"
        }
      },
      "required": [
        "x",
        "y"
      ]
    },
    "diameter": {
      "type": "number",
      "description": "Circle diameter in pixels"
    },
    "thickness": {
      "type": "number",
      "description": "Line thickness in pixels"
    },
    "fill_color": {
      "title": "foxglove.Color",
      "description": "Fill color",
      "type": "object",
      "properties": {
        "r": {
          "type": "number",
          "description": "Red value between 0 and 1"
        },
        "g": {
          "type": "number",
          "description": "Green value between 0 and 1"
        },
        "b": {
          "type": "number",
          "description": "Blue value between 0 and 1"
        },
        "a": {
          "type": "number",
          "description": "Alpha value between 0 and 1"
        }
      },
      "required": [
        "r",
        "g",
        "b",
        "a"
      ]
    },
    "outline_color": {
      "title": "foxglove.Color",
      "description": "Outline color",
      "type": "object",
      "properties": {
        "r": {
          "type": "number",
          "description": "Red value between 0 and 1"
        },
        "g": {
          "type": "number",
          "description": "Green value between 0 and 1"
        },
        "b": {
          "type": "number",
          "description": "Blue value between 0 and 1"
        },
        "a": {
          "type": "number",
          "description": "Alpha value between 0 and 1"
        }
      },
      "required": [
        "r",
        "g",
        "b",
        "a"
      ]
    }
  },
  "required": [
    "timestamp",
    "position",
    "diameter",
    "thickness",
    "fill_color",
    "outline_color"
  ]
};

export const Color = {
  "title": "foxglove.Color",
  "description": "A color in RGBA format",
  "$comment": "Generated by https://github.com/foxglove/foxglove-sdk",
  "type": "object",
  "properties": {
    "r": {
      "type": "number",
      "description": "Red value between 0 and 1"
    },
    "g": {
      "type": "number",
      "description": "Green value between 0 and 1"
    },
    "b": {
      "type": "number",
      "description": "Blue value between 0 and 1"
    },
    "a": {
      "type": "number",
      "description": "Alpha value between 0 and 1"
    }
  },
  "required": [
    "r",
    "g",
    "b",
    "a"
  ]
};

export const CompressedImage = {
  "title": "foxglove.CompressedImage",
  "description": "A compressed image",
  "$comment": "Generated by https://github.com/foxglove/foxglove-sdk",
  "type": "object",
  "properties": {
    "timestamp": {
      "type": "object",
      "title": "time",
      "properties": {
        "sec": {
          "type": "integer",
          "minimum": 0
        },
        "nsec": {
          "type": "integer",
          "minimum": 0,
          "maximum": 999999999
        }
      },
      "description": "Timestamp of image"
    },
    "frame_id": {
      "type": "string",
      "description": "Frame of reference for the image. The origin of the frame is the optical center of the camera. +x points to the right in the image, +y points down, and +z points into the plane of the image."
    },
    "data": {
      "type": "string",
      "contentEncoding": "base64",
      "description": "Compressed image data"
    },
    "format": {
      "type": "string",
      "description": "Image format\n\nSupported values: `jpeg`, `png`, `webp`, `avif`"
    }
  },
  "required": [
    "timestamp",
    "frame_id",
    "data",
    "format"
  ]
};

export const CompressedVideo = {
  "title": "foxglove.CompressedVideo",
  "description": "A single frame of a compressed video bitstream",
  "$comment": "Generated by https://github.com/foxglove/foxglove-sdk",
  "type": "object",
  "properties": {
    "timestamp": {
      "type": "object",
      "title": "time",
      "properties": {
        "sec": {
          "type": "integer",
          "minimum": 0
        },
        "nsec": {
          "type": "integer",
          "minimum": 0,
          "maximum": 999999999
        }
      },
      "description": "Timestamp of video frame"
    },
    "frame_id": {
      "type": "string",
      "description": "Frame of reference for the video.\n\nThe origin of the frame is the optical center of the camera. +x points to the right in the video, +y points down, and +z points into the plane of the video."
    },
    "data": {
      "type": "string",
      "contentEncoding": "base64",
      "description": "Compressed video frame data.\n\nFor packet-based video codecs this data must begin and end on packet boundaries (no partial packets), and must contain enough video packets to decode exactly one image (either a keyframe or delta frame). Note: Foxglove does not support video streams that include B frames because they require lookahead.\n\nSpecifically, the requirements for different `format` values are:\n\n- `h264`\n  - Use Annex B formatted data\n  - Each CompressedVideo message should contain enough NAL units to decode exactly one video frame\n  - Each message containing a key frame (IDR) must also include a SPS NAL unit\n\n- `h265` (HEVC)\n  - Use Annex B formatted data\n  - Each CompressedVideo message should contain enough NAL units to decode exactly one video frame\n  - Each message containing a key frame (IRAP) must also include relevant VPS/SPS/PPS NAL units\n\n- `vp9`\n  - Each CompressedVideo message should contain exactly one video frame\n\n- `av1`\n  - Use the \"Low overhead bitstream format\" (section 5.2)\n  - Each CompressedVideo message should contain enough OBUs to decode exactly one video frame\n  - Each message containing a key frame must also include a Sequence Header OBU"
    },
    "format": {
      "type": "string",
      "description": "Video format.\n\nSupported values: `h264`, `h265`, `vp9`, `av1`.\n\nNote: compressed video support is subject to hardware limitations and patent licensing, so not all encodings may be supported on all platforms. See more about [H.265 support](https://caniuse.com/hevc), [VP9 support](https://caniuse.com/webm), and [AV1 support](https://caniuse.com/av1)."
    }
  },
  "required": [
    "timestamp",
    "frame_id",
    "data",
    "format"
  ]
};

export const CylinderPrimitive = {
  "title": "foxglove.CylinderPrimitive",
  "description": "A primitive representing a cylinder, elliptic cylinder, or truncated cone",
  "$comment": "Generated by https://github.com/foxglove/foxglove-sdk",
  "type": "object",
  "properties": {
    "pose": {
      "title": "foxglove.Pose",
      "description": "Position of the center of the cylinder and orientation of the cylinder. The flat face(s) are perpendicular to the z-axis.",
      "type": "object",
      "properties": {
        "position": {
          "title": "foxglove.Vector3",
          "description": "Point denoting position in 3D space",
          "type": "object",
          "properties": {
            "x": {
              "type": "number",
              "description": "x coordinate length"
            },
            "y": {
              "type": "number",
              "description": "y coordinate length"
            },
            "z": {
              "type": "number",
              "description": "z coordinate length"
            }
          },
          "required": [
            "x",
            "y",
            "z"
          ]
        },
        "orientation": {
          "title": "foxglove.Quaternion",
          "description": "Quaternion denoting orientation in 3D space",
          "type": "object",
          "properties": {
            "x": {
              "type": "number",
              "description": "x value"
            },
            "y": {
              "type": "number",
              "description": "y value"
            },
            "z": {
              "type": "number",
              "description": "z value"
            },
            "w": {
              "type": "number",
              "description": "w value"
            }
          },
          "required": [
            "x",
            "y",
            "z",
            "w"
          ]
        }
      },
      "required": [
        "position",
        "orientation"
      ]
    },
    "size": {
      "title": "foxglove.Vector3",
      "description": "Size of the cylinder's bounding box",
      "type": "object",
      "properties": {
        "x": {
          "type": "number",
          "description": "x coordinate length"
        },
        "y": {
          "type": "number",
          "description": "y coordinate length"
        },
        "z": {
          "type": "number",
          "description": "z coordinate length"
        }
      },
      "required": [
        "x",
        "y",
        "z"
      ]
    },
    "bottom_scale": {
      "type": "number",
      "description": "0-1, ratio of the diameter of the cylinder's bottom face (min z) to the bottom of the bounding box"
    },
    "top_scale": {
      "type": "number",
      "description": "0-1, ratio of the diameter of the cylinder's top face (max z) to the top of the bounding box"
    },
    "color": {
      "title": "foxglove.Color",
      "description": "Color of the cylinder",
      "type": "object",
      "properties": {
        "r": {
          "type": "number",
          "description": "Red value between 0 and 1"
        },
        "g": {
          "type": "number",
          "description": "Green value between 0 and 1"
        },
        "b": {
          "type": "number",
          "description": "Blue value between 0 and 1"
        },
        "a": {
          "type": "number",
          "description": "Alpha value between 0 and 1"
        }
      },
      "required": [
        "r",
        "g",
        "b",
        "a"
      ]
    }
  },
  "required": [
    "pose",
    "size",
    "bottom_scale",
    "top_scale",
    "color"
  ]
};

export const CubePrimitive = {
  "title": "foxglove.CubePrimitive",
  "description": "A primitive representing a cube or rectangular prism",
  "$comment": "Generated by https://github.com/foxglove/foxglove-sdk",
  "type": "object",
  "properties": {
    "pose": {
      "title": "foxglove.Pose",
      "description": "Position of the center of the cube and orientation of the cube",
      "type": "object",
      "properties": {
        "position": {
          "title": "foxglove.Vector3",
          "description": "Point denoting position in 3D space",
          "type": "object",
          "properties": {
            "x": {
              "type": "number",
              "description": "x coordinate length"
            },
            "y": {
              "type": "number",
              "description": "y coordinate length"
            },
            "z": {
              "type": "number",
              "description": "z coordinate length"
            }
          },
          "required": [
            "x",
            "y",
            "z"
          ]
        },
        "orientation": {
          "title": "foxglove.Quaternion",
          "description": "Quaternion denoting orientation in 3D space",
          "type": "object",
          "properties": {
            "x": {
              "type": "number",
              "description": "x value"
            },
            "y": {
              "type": "number",
              "description": "y value"
            },
            "z": {
              "type": "number",
              "description": "z value"
            },
            "w": {
              "type": "number",
              "description": "w value"
            }
          },
          "required": [
            "x",
            "y",
            "z",
            "w"
          ]
        }
      },
      "required": [
        "position",
        "orientation"
      ]
    },
    "size": {
      "title": "foxglove.Vector3",
      "description": "Size of the cube along each axis",
      "type": "object",
      "properties": {
        "x": {
          "type": "number",
          "description": "x coordinate length"
        },
        "y": {
          "type": "number",
          "description": "y coordinate length"
        },
        "z": {
          "type": "number",
          "description": "z coordinate length"
        }
      },
      "required": [
        "x",
        "y",
        "z"
      ]
    },
    "color": {
      "title": "foxglove.Color",
      "description": "Color of the cube",
      "type": "object",
      "properties": {
        "r": {
          "type": "number",
          "description": "Red value between 0 and 1"
        },
        "g": {
          "type": "number",
          "description": "Green value between 0 and 1"
        },
        "b": {
          "type": "number",
          "description": "Blue value between 0 and 1"
        },
        "a": {
          "type": "number",
          "description": "Alpha value between 0 and 1"
        }
      },
      "required": [
        "r",
        "g",
        "b",
        "a"
      ]
    }
  },
  "required": [
    "pose",
    "size",
    "color"
  ]
};

export const Duration = {
  "title": "foxglove.Duration",
  "description": "A duration of time, composed of seconds and nanoseconds",
  "$comment": "Generated by https://github.com/foxglove/foxglove-sdk",
  "type": "object",
  "properties": {
    "sec": {
      "type": "integer",
      "description": "The number of seconds in the duration"
    },
    "nsec": {
      "type": "integer",
      "minimum": 0,
      "description": "The number of nanoseconds in the positive direction"
    }
  },
  "required": [
    "sec",
    "nsec"
  ]
};

export const FrameTransform = {
  "title": "foxglove.FrameTransform",
  "description": "A transform between two reference frames in 3D space",
  "$comment": "Generated by https://github.com/foxglove/foxglove-sdk",
  "type": "object",
  "properties": {
    "timestamp": {
      "type": "object",
      "title": "time",
      "properties": {
        "sec": {
          "type": "integer",
          "minimum": 0
        },
        "nsec": {
          "type": "integer",
          "minimum": 0,
          "maximum": 999999999
        }
      },
      "description": "Timestamp of transform"
    },
    "parent_frame_id": {
      "type": "string",
      "description": "Name of the parent frame"
    },
    "child_frame_id": {
      "type": "string",
      "description": "Name of the child frame"
    },
    "translation": {
      "title": "foxglove.Vector3",
      "description": "Translation component of the transform",
      "type": "object",
      "properties": {
        "x": {
          "type": "number",
          "description": "x coordinate length"
        },
        "y": {
          "type": "number",
          "description": "y coordinate length"
        },
        "z": {
          "type": "number",
          "description": "z coordinate length"
        }
      },
      "required": [
        "x",
        "y",
        "z"
      ]
    },
    "rotation": {
      "title": "foxglove.Quaternion",
      "description": "Rotation component of the transform",
      "type": "object",
      "properties": {
        "x": {
          "type": "number",
          "description": "x value"
        },
        "y": {
          "type": "number",
          "description": "y value"
        },
        "z": {
          "type": "number",
          "description": "z value"
        },
        "w": {
          "type": "number",
          "description": "w value"
        }
      },
      "required": [
        "x",
        "y",
        "z",
        "w"
      ]
    }
  },
  "required": [
    "timestamp",
    "parent_frame_id",
    "child_frame_id",
    "translation",
    "rotation"
  ]
};

export const FrameTransforms = {
  "title": "foxglove.FrameTransforms",
  "description": "An array of FrameTransform messages",
  "$comment": "Generated by https://github.com/foxglove/foxglove-sdk",
  "type": "object",
  "properties": {
    "transforms": {
      "type": "array",
      "items": {
        "title": "foxglove.FrameTransform",
        "description": "A transform between two reference frames in 3D space",
        "type": "object",
        "properties": {
          "timestamp": {
            "type": "object",
            "title": "time",
            "properties": {
              "sec": {
                "type": "integer",
                "minimum": 0
              },
              "nsec": {
                "type": "integer",
                "minimum": 0,
                "maximum": 999999999
              }
            },
            "description": "Timestamp of transform"
          },
          "parent_frame_id": {
            "type": "string",
            "description": "Name of the parent frame"
          },
          "child_frame_id": {
            "type": "string",
            "description": "Name of the child frame"
          },
          "translation": {
            "title": "foxglove.Vector3",
            "description": "Translation component of the transform",
            "type": "object",
            "properties": {
              "x": {
                "type": "number",
                "description": "x coordinate length"
              },
              "y": {
                "type": "number",
                "description": "y coordinate length"
              },
              "z": {
                "type": "number",
                "description": "z coordinate length"
              }
            },
            "required": [
              "x",
              "y",
              "z"
            ]
          },
          "rotation": {
            "title": "foxglove.Quaternion",
            "description": "Rotation component of the transform",
            "type": "object",
            "properties": {
              "x": {
                "type": "number",
                "description": "x value"
              },
              "y": {
                "type": "number",
                "description": "y value"
              },
              "z": {
                "type": "number",
                "description": "z value"
              },
              "w": {
                "type": "number",
                "description": "w value"
              }
            },
            "required": [
              "x",
              "y",
              "z",
              "w"
            ]
          }
        },
        "required": [
          "timestamp",
          "parent_frame_id",
          "child_frame_id",
          "translation",
          "rotation"
        ]
      },
      "description": "Array of transforms"
    }
  },
  "required": [
    "transforms"
  ]
};

export const GeoJSON = {
  "title": "foxglove.GeoJSON",
  "description": "GeoJSON data for annotating maps",
  "$comment": "Generated by https://github.com/foxglove/foxglove-sdk",
  "type": "object",
  "properties": {
    "geojson": {
      "type": "string",
      "description": "GeoJSON data encoded as a UTF-8 string"
    }
  },
  "required": [
    "geojson"
  ]
};

export const Grid = {
  "title": "foxglove.Grid",
  "description": "A 2D grid of data",
  "$comment": "Generated by https://github.com/foxglove/foxglove-sdk",
  "type": "object",
  "properties": {
    "timestamp": {
      "type": "object",
      "title": "time",
      "properties": {
        "sec": {
          "type": "integer",
          "minimum": 0
        },
        "nsec": {
          "type": "integer",
          "minimum": 0,
          "maximum": 999999999
        }
      },
      "description": "Timestamp of grid"
    },
    "frame_id": {
      "type": "string",
      "description": "Frame of reference"
    },
    "pose": {
      "title": "foxglove.Pose",
      "description": "Origin of grid's corner relative to frame of reference; grid is positioned in the x-y plane relative to this origin",
      "type": "object",
      "properties": {
        "position": {
          "title": "foxglove.Vector3",
          "description": "Point denoting position in 3D space",
          "type": "object",
          "properties": {
            "x": {
              "type": "number",
              "description": "x coordinate length"
            },
            "y": {
              "type": "number",
              "description": "y coordinate length"
            },
            "z": {
              "type": "number",
              "description": "z coordinate length"
            }
          },
          "required": [
            "x",
            "y",
            "z"
          ]
        },
        "orientation": {
          "title": "foxglove.Quaternion",
          "description": "Quaternion denoting orientation in 3D space",
          "type": "object",
          "properties": {
            "x": {
              "type": "number",
              "description": "x value"
            },
            "y": {
              "type": "number",
              "description": "y value"
            },
            "z": {
              "type": "number",
              "description": "z value"
            },
            "w": {
              "type": "number",
              "description": "w value"
            }
          },
          "required": [
            "x",
            "y",
            "z",
            "w"
          ]
        }
      },
      "required": [
        "position",
        "orientation"
      ]
    },
    "column_count": {
      "type": "integer",
      "minimum": 0,
      "description": "Number of grid columns"
    },
    "cell_size": {
      "title": "foxglove.Vector2",
      "description": "Size of single grid cell along x and y axes, relative to `pose`",
      "type": "object",
      "properties": {
        "x": {
          "type": "number",
          "description": "x coordinate length"
        },
        "y": {
          "type": "number",
          "description": "y coordinate length"
        }
      },
      "required": [
        "x",
        "y"
      ]
    },
    "row_stride": {
      "type": "integer",
      "minimum": 0,
      "description": "Number of bytes between rows in `data`"
    },
    "cell_stride": {
      "type": "integer",
      "minimum": 0,
      "description": "Number of bytes between cells within a row in `data`"
    },
    "fields": {
      "type": "array",
      "items": {
        "title": "foxglove.PackedElementField",
        "description": "A field present within each element in a byte array of packed elements.",
        "type": "object",
        "properties": {
          "name": {
            "type": "string",
            "description": "Name of the field"
          },
          "offset": {
            "type": "integer",
            "minimum": 0,
            "description": "Byte offset from start of data buffer"
          },
          "type": {
            "title": "foxglove.NumericType",
            "description": "Type of data in the field. Integers are stored using little-endian byte order.",
            "oneOf": [
              {
                "title": "UNKNOWN",
                "const": 0,
                "description": "Unknown numeric type"
              },
              {
                "title": "UINT8",
                "const": 1,
                "description": "Unsigned 8-bit integer"
              },
              {
                "title": "INT8",
                "const": 2,
                "description": "Signed 8-bit integer"
              },
              {
                "title": "UINT16",
                "const": 3,
                "description": "Unsigned 16-bit integer"
              },
              {
                "title": "INT16",
                "const": 4,
                "description": "Signed 16-bit integer"
              },
              {
                "title": "UINT32",
                "const": 5,
                "description": "Unsigned 32-bit integer"
              },
              {
                "title": "INT32",
                "const": 6,
                "description": "Signed 32-bit integer"
              },
              {
                "title": "FLOAT32",
                "const": 7,
                "description": "32-bit floating-point number"
              },
              {
                "title": "FLOAT64",
                "const": 8,
                "description": "64-bit floating-point number"
              }
            ]
          }
        },
        "required": [
          "name",
          "offset",
          "type"
        ]
      },
      "description": "Fields in `data`. `red`, `green`, `blue`, and `alpha` are optional for customizing the grid's color."
    },
    "data": {
      "type": "string",
      "contentEncoding": "base64",
      "description": "Grid cell data, interpreted using `fields`, in row-major (y-major) order.\n For the data element starting at byte offset i, the coordinates of its corner closest to the origin will be:\n y = (i / cell_stride) % row_stride * cell_size.y\n x = i % cell_stride * cell_size.x"
    }
  },
  "required": [
    "timestamp",
    "frame_id",
    "pose",
    "column_count",
    "cell_size",
    "row_stride",
    "cell_stride",
    "fields",
    "data"
  ]
};

export const VoxelGrid = {
  "title": "foxglove.VoxelGrid",
  "description": "A 3D grid of data",
  "$comment": "Generated by https://github.com/foxglove/foxglove-sdk",
  "type": "object",
  "properties": {
    "timestamp": {
      "type": "object",
      "title": "time",
      "properties": {
        "sec": {
          "type": "integer",
          "minimum": 0
        },
        "nsec": {
          "type": "integer",
          "minimum": 0,
          "maximum": 999999999
        }
      },
      "description": "Timestamp of grid"
    },
    "frame_id": {
      "type": "string",
      "description": "Frame of reference"
    },
    "pose": {
      "title": "foxglove.Pose",
      "description": "Origin of grid's corner relative to frame of reference",
      "type": "object",
      "properties": {
        "position": {
          "title": "foxglove.Vector3",
          "description": "Point denoting position in 3D space",
          "type": "object",
          "properties": {
            "x": {
              "type": "number",
              "description": "x coordinate length"
            },
            "y": {
              "type": "number",
              "description": "y coordinate length"
            },
            "z": {
              "type": "number",
              "description": "z coordinate length"
            }
          },
          "required": [
            "x",
            "y",
            "z"
          ]
        },
        "orientation": {
          "title": "foxglove.Quaternion",
          "description": "Quaternion denoting orientation in 3D space",
          "type": "object",
          "properties": {
            "x": {
              "type": "number",
              "description": "x value"
            },
            "y": {
              "type": "number",
              "description": "y value"
            },
            "z": {
              "type": "number",
              "description": "z value"
            },
            "w": {
              "type": "number",
              "description": "w value"
            }
          },
          "required": [
            "x",
            "y",
            "z",
            "w"
          ]
        }
      },
      "required": [
        "position",
        "orientation"
      ]
    },
    "row_count": {
      "type": "integer",
      "minimum": 0,
      "description": "Number of grid rows"
    },
    "column_count": {
      "type": "integer",
      "minimum": 0,
      "description": "Number of grid columns"
    },
    "cell_size": {
      "title": "foxglove.Vector3",
      "description": "Size of single grid cell along x, y, and z axes, relative to `pose`",
      "type": "object",
      "properties": {
        "x": {
          "type": "number",
          "description": "x coordinate length"
        },
        "y": {
          "type": "number",
          "description": "y coordinate length"
        },
        "z": {
          "type": "number",
          "description": "z coordinate length"
        }
      },
      "required": [
        "x",
        "y",
        "z"
      ]
    },
    "slice_stride": {
      "type": "integer",
      "minimum": 0,
      "description": "Number of bytes between depth slices in `data`"
    },
    "row_stride": {
      "type": "integer",
      "minimum": 0,
      "description": "Number of bytes between rows in `data`"
    },
    "cell_stride": {
      "type": "integer",
      "minimum": 0,
      "description": "Number of bytes between cells within a row in `data`"
    },
    "fields": {
      "type": "array",
      "items": {
        "title": "foxglove.PackedElementField",
        "description": "A field present within each element in a byte array of packed elements.",
        "type": "object",
        "properties": {
          "name": {
            "type": "string",
            "description": "Name of the field"
          },
          "offset": {
            "type": "integer",
            "minimum": 0,
            "description": "Byte offset from start of data buffer"
          },
          "type": {
            "title": "foxglove.NumericType",
            "description": "Type of data in the field. Integers are stored using little-endian byte order.",
            "oneOf": [
              {
                "title": "UNKNOWN",
                "const": 0,
                "description": "Unknown numeric type"
              },
              {
                "title": "UINT8",
                "const": 1,
                "description": "Unsigned 8-bit integer"
              },
              {
                "title": "INT8",
                "const": 2,
                "description": "Signed 8-bit integer"
              },
              {
                "title": "UINT16",
                "const": 3,
                "description": "Unsigned 16-bit integer"
              },
              {
                "title": "INT16",
                "const": 4,
                "description": "Signed 16-bit integer"
              },
              {
                "title": "UINT32",
                "const": 5,
                "description": "Unsigned 32-bit integer"
              },
              {
                "title": "INT32",
                "const": 6,
                "description": "Signed 32-bit integer"
              },
              {
                "title": "FLOAT32",
                "const": 7,
                "description": "32-bit floating-point number"
              },
              {
                "title": "FLOAT64",
                "const": 8,
                "description": "64-bit floating-point number"
              }
            ]
          }
        },
        "required": [
          "name",
          "offset",
          "type"
        ]
      },
      "description": "Fields in `data`. `red`, `green`, `blue`, and `alpha` are optional for customizing the grid's color."
    },
    "data": {
      "type": "string",
      "contentEncoding": "base64",
      "description": "Grid cell data, interpreted using `fields`, in depth-major, row-major (Z-Y-X) order.\n For the data element starting at byte offset i, the coordinates of its corner closest to the origin will be:\n z = i / slice_stride * cell_size.z\n y = (i % slice_stride) / row_stride * cell_size.y\n x = (i % row_stride) / cell_stride * cell_size.x"
    }
  },
  "required": [
    "timestamp",
    "frame_id",
    "pose",
    "row_count",
    "column_count",
    "cell_size",
    "slice_stride",
    "row_stride",
    "cell_stride",
    "fields",
    "data"
  ]
};

export const ImageAnnotations = {
  "title": "foxglove.ImageAnnotations",
  "description": "Array of annotations for a 2D image",
  "$comment": "Generated by https://github.com/foxglove/foxglove-sdk",
  "type": "object",
  "properties": {
    "circles": {
      "type": "array",
      "items": {
        "title": "foxglove.CircleAnnotation",
        "description": "A circle annotation on a 2D image",
        "type": "object",
        "properties": {
          "timestamp": {
            "type": "object",
            "title": "time",
            "properties": {
              "sec": {
                "type": "integer",
                "minimum": 0
              },
              "nsec": {
                "type": "integer",
                "minimum": 0,
                "maximum": 999999999
              }
            },
            "description": "Timestamp of circle"
          },
          "position": {
            "title": "foxglove.Point2",
            "description": "Center of the circle in 2D image coordinates (pixels).\nThe coordinate uses the top-left corner of the top-left pixel of the image as the origin.",
            "type": "object",
            "properties": {
              "x": {
                "type": "number",
                "description": "x coordinate position"
              },
              "y": {
                "type": "number",
                "description": "y coordinate position"
              }
            },
            "required": [
              "x",
              "y"
            ]
          },
          "diameter": {
            "type": "number",
            "description": "Circle diameter in pixels"
          },
          "thickness": {
            "type": "number",
            "description": "Line thickness in pixels"
          },
          "fill_color": {
            "title": "foxglove.Color",
            "description": "Fill color",
            "type": "object",
            "properties": {
              "r": {
                "type": "number",
                "description": "Red value between 0 and 1"
              },
              "g": {
                "type": "number",
                "description": "Green value between 0 and 1"
              },
              "b": {
                "type": "number",
                "description": "Blue value between 0 and 1"
              },
              "a": {
                "type": "number",
                "description": "Alpha value between 0 and 1"
              }
            },
            "required": [
              "r",
              "g",
              "b",
              "a"
            ]
          },
          "outline_color": {
            "title": "foxglove.Color",
            "description": "Outline color",
            "type": "object",
            "properties": {
              "r": {
                "type": "number",
                "description": "Red value between 0 and 1"
              },
              "g": {
                "type": "number",
                "description": "Green value between 0 and 1"
              },
              "b": {
                "type": "number",
                "description": "Blue value between 0 and 1"
              },
              "a": {
                "type": "number",
                "description": "Alpha value between 0 and 1"
              }
            },
            "required": [
              "r",
              "g",
              "b",
              "a"
            ]
          }
        },
        "required": [
          "timestamp",
          "position",
          "diameter",
          "thickness",
          "fill_color",
          "outline_color"
        ]
      },
      "description": "Circle annotations"
    },
    "points": {
      "type": "array",
      "items": {
        "title": "foxglove.PointsAnnotation",
        "description": "An array of points on a 2D image",
        "type": "object",
        "properties": {
          "timestamp": {
            "type": "object",
            "title": "time",
            "properties": {
              "sec": {
                "type": "integer",
                "minimum": 0
              },
              "nsec": {
                "type": "integer",
                "minimum": 0,
                "maximum": 999999999
              }
            },
            "description": "Timestamp of annotation"
          },
          "type": {
            "title": "foxglove.PointsAnnotationType",
            "description": "Type of points annotation to draw",
            "oneOf": [
              {
                "title": "UNKNOWN",
                "const": 0,
                "description": "Unknown points annotation type"
              },
              {
                "title": "POINTS",
                "const": 1,
                "description": "Individual points: 0, 1, 2, ..."
              },
              {
                "title": "LINE_LOOP",
                "const": 2,
                "description": "Closed polygon: 0-1, 1-2, ..., (n-1)-n, n-0"
              },
              {
                "title": "LINE_STRIP",
                "const": 3,
                "description": "Connected line segments: 0-1, 1-2, ..., (n-1)-n"
              },
              {
                "title": "LINE_LIST",
                "const": 4,
                "description": "Individual line segments: 0-1, 2-3, 4-5, ..."
              }
            ]
          },
          "points": {
            "type": "array",
            "items": {
              "title": "foxglove.Point2",
              "description": "A point representing a position in 2D space",
              "type": "object",
              "properties": {
                "x": {
                  "type": "number",
                  "description": "x coordinate position"
                },
                "y": {
                  "type": "number",
                  "description": "y coordinate position"
                }
              },
              "required": [
                "x",
                "y"
              ]
            },
            "description": "Points in 2D image coordinates (pixels).\nThese coordinates use the top-left corner of the top-left pixel of the image as the origin."
          },
          "outline_color": {
            "title": "foxglove.Color",
            "description": "Outline color",
            "type": "object",
            "properties": {
              "r": {
                "type": "number",
                "description": "Red value between 0 and 1"
              },
              "g": {
                "type": "number",
                "description": "Green value between 0 and 1"
              },
              "b": {
                "type": "number",
                "description": "Blue value between 0 and 1"
              },
              "a": {
                "type": "number",
                "description": "Alpha value between 0 and 1"
              }
            },
            "required": [
              "r",
              "g",
              "b",
              "a"
            ]
          },
          "outline_colors": {
            "type": "array",
            "items": {
              "title": "foxglove.Color",
              "description": "A color in RGBA format",
              "type": "object",
              "properties": {
                "r": {
                  "type": "number",
                  "description": "Red value between 0 and 1"
                },
                "g": {
                  "type": "number",
                  "description": "Green value between 0 and 1"
                },
                "b": {
                  "type": "number",
                  "description": "Blue value between 0 and 1"
                },
                "a": {
                  "type": "number",
                  "description": "Alpha value between 0 and 1"
                }
              },
              "required": [
                "r",
                "g",
                "b",
                "a"
              ]
            },
            "description": "Per-point colors, if `type` is `POINTS`, or per-segment stroke colors, if `type` is `LINE_LIST`, `LINE_STRIP` or `LINE_LOOP`."
          },
          "fill_color": {
            "title": "foxglove.Color",
            "description": "Fill color",
            "type": "object",
            "properties": {
              "r": {
                "type": "number",
                "description": "Red value between 0 and 1"
              },
              "g": {
                "type": "number",
                "description": "Green value between 0 and 1"
              },
              "b": {
                "type": "number",
                "description": "Blue value between 0 and 1"
              },
              "a": {
                "type": "number",
                "description": "Alpha value between 0 and 1"
              }
            },
            "required": [
              "r",
              "g",
              "b",
              "a"
            ]
          },
          "thickness": {
            "type": "number",
            "description": "Stroke thickness in pixels"
          }
        },
        "required": [
          "timestamp",
          "type",
          "points",
          "outline_color",
          "outline_colors",
          "fill_color",
          "thickness"
        ]
      },
      "description": "Points annotations"
    },
    "texts": {
      "type": "array",
      "items": {
        "title": "foxglove.TextAnnotation",
        "description": "A text label on a 2D image",
        "type": "object",
        "properties": {
          "timestamp": {
            "type": "object",
            "title": "time",
            "properties": {
              "sec": {
                "type": "integer",
                "minimum": 0
              },
              "nsec": {
                "type": "integer",
                "minimum": 0,
                "maximum": 999999999
              }
            },
            "description": "Timestamp of annotation"
          },
          "position": {
            "title": "foxglove.Point2",
            "description": "Bottom-left origin of the text label in 2D image coordinates (pixels).\nThe coordinate uses the top-left corner of the top-left pixel of the image as the origin.",
            "type": "object",
            "properties": {
              "x": {
                "type": "number",
                "description": "x coordinate position"
              },
              "y": {
                "type": "number",
                "description": "y coordinate position"
              }
            },
            "required": [
              "x",
              "y"
            ]
          },
          "text": {
            "type": "string",
            "description": "Text to display"
          },
          "font_size": {
            "type": "number",
            "description": "Font size in pixels"
          },
          "text_color": {
            "title": "foxglove.Color",
            "description": "Text color",
            "type": "object",
            "properties": {
              "r": {
                "type": "number",
                "description": "Red value between 0 and 1"
              },
              "g": {
                "type": "number",
                "description": "Green value between 0 and 1"
              },
              "b": {
                "type": "number",
                "description": "Blue value between 0 and 1"
              },
              "a": {
                "type": "number",
                "description": "Alpha value between 0 and 1"
              }
            },
            "required": [
              "r",
              "g",
              "b",
              "a"
            ]
          },
          "background_color": {
            "title": "foxglove.Color",
            "description": "Background fill color",
            "type": "object",
            "properties": {
              "r": {
                "type": "number",
                "description": "Red value between 0 and 1"
              },
              "g": {
                "type": "number",
                "description": "Green value between 0 and 1"
              },
              "b": {
                "type": "number",
                "description": "Blue value between 0 and 1"
              },
              "a": {
                "type": "number",
                "description": "Alpha value between 0 and 1"
              }
            },
            "required": [
              "r",
              "g",
              "b",
              "a"
            ]
          }
        },
        "required": [
          "timestamp",
          "position",
          "text",
          "font_size",
          "text_color",
          "background_color"
        ]
      },
      "description": "Text annotations"
    }
  },
  "required": [
    "circles",
    "points",
    "texts"
  ]
};

export const KeyValuePair = {
  "title": "foxglove.KeyValuePair",
  "description": "A key with its associated value",
  "$comment": "Generated by https://github.com/foxglove/foxglove-sdk",
  "type": "object",
  "properties": {
    "key": {
      "type": "string",
      "description": "Key"
    },
    "value": {
      "type": "string",
      "description": "Value"
    }
  },
  "required": [
    "key",
    "value"
  ]
};

export const LaserScan = {
  "title": "foxglove.LaserScan",
  "description": "A single scan from a planar laser range-finder",
  "$comment": "Generated by https://github.com/foxglove/foxglove-sdk",
  "type": "object",
  "properties": {
    "timestamp": {
      "type": "object",
      "title": "time",
      "properties": {
        "sec": {
          "type": "integer",
          "minimum": 0
        },
        "nsec": {
          "type": "integer",
          "minimum": 0,
          "maximum": 999999999
        }
      },
      "description": "Timestamp of scan"
    },
    "frame_id": {
      "type": "string",
      "description": "Frame of reference"
    },
    "pose": {
      "title": "foxglove.Pose",
      "description": "Origin of scan relative to frame of reference; points are positioned in the x-y plane relative to this origin; angles are interpreted as counterclockwise rotations around the z axis with 0 rad being in the +x direction",
      "type": "object",
      "properties": {
        "position": {
          "title": "foxglove.Vector3",
          "description": "Point denoting position in 3D space",
          "type": "object",
          "properties": {
            "x": {
              "type": "number",
              "description": "x coordinate length"
            },
            "y": {
              "type": "number",
              "description": "y coordinate length"
            },
            "z": {
              "type": "number",
              "description": "z coordinate length"
            }
          },
          "required": [
            "x",
            "y",
            "z"
          ]
        },
        "orientation": {
          "title": "foxglove.Quaternion",
          "description": "Quaternion denoting orientation in 3D space",
          "type": "object",
          "properties": {
            "x": {
              "type": "number",
              "description": "x value"
            },
            "y": {
              "type": "number",
              "description": "y value"
            },
            "z": {
              "type": "number",
              "description": "z value"
            },
            "w": {
              "type": "number",
              "description": "w value"
            }
          },
          "required": [
            "x",
            "y",
            "z",
            "w"
          ]
        }
      },
      "required": [
        "position",
        "orientation"
      ]
    },
    "start_angle": {
      "type": "number",
      "description": "Bearing of first point, in radians"
    },
    "end_angle": {
      "type": "number",
      "description": "Bearing of last point, in radians"
    },
    "ranges": {
      "type": "array",
      "items": {
        "type": "number"
      },
      "description": "Distance of detections from origin; assumed to be at equally-spaced angles between `start_angle` and `end_angle`"
    },
    "intensities": {
      "type": "array",
      "items": {
        "type": "number"
      },
      "description": "Intensity of detections"
    }
  },
  "required": [
    "timestamp",
    "frame_id",
    "pose",
    "start_angle",
    "end_angle",
    "ranges",
    "intensities"
  ]
};

export const LinePrimitive = {
  "title": "foxglove.LinePrimitive",
  "description": "A primitive representing a series of points connected by lines",
  "$comment": "Generated by https://github.com/foxglove/foxglove-sdk",
  "type": "object",
  "properties": {
    "type": {
      "title": "foxglove.LineType",
      "description": "Drawing primitive to use for lines",
      "oneOf": [
        {
          "title": "LINE_STRIP",
          "const": 0,
          "description": "Connected line segments: 0-1, 1-2, ..., (n-1)-n"
        },
        {
          "title": "LINE_LOOP",
          "const": 1,
          "description": "Closed polygon: 0-1, 1-2, ..., (n-1)-n, n-0"
        },
        {
          "title": "LINE_LIST",
          "const": 2,
          "description": "Individual line segments: 0-1, 2-3, 4-5, ..."
        }
      ]
    },
    "pose": {
      "title": "foxglove.Pose",
      "description": "Origin of lines relative to reference frame",
      "type": "object",
      "properties": {
        "position": {
          "title": "foxglove.Vector3",
          "description": "Point denoting position in 3D space",
          "type": "object",
          "properties": {
            "x": {
              "type": "number",
              "description": "x coordinate length"
            },
            "y": {
              "type": "number",
              "description": "y coordinate length"
            },
            "z": {
              "type": "number",
              "description": "z coordinate length"
            }
          },
          "required": [
            "x",
            "y",
            "z"
          ]
        },
        "orientation": {
          "title": "foxglove.Quaternion",
          "description": "Quaternion denoting orientation in 3D space",
          "type": "object",
          "properties": {
            "x": {
              "type": "number",
              "description": "x value"
            },
            "y": {
              "type": "number",
              "description": "y value"
            },
            "z": {
              "type": "number",
              "description": "z value"
            },
            "w": {
              "type": "number",
              "description": "w value"
            }
          },
          "required": [
            "x",
            "y",
            "z",
            "w"
          ]
        }
      },
      "required": [
        "position",
        "orientation"
      ]
    },
    "thickness": {
      "type": "number",
      "description": "Line thickness"
    },
    "scale_invariant": {
      "type": "boolean",
      "description": "Indicates whether `thickness` is a fixed size in screen pixels (true), or specified in world coordinates and scales with distance from the camera (false)"
    },
    "points": {
      "type": "array",
      "items": {
        "title": "foxglove.Point3",
        "description": "A point representing a position in 3D space",
        "type": "object",
        "properties": {
          "x": {
            "type": "number",
            "description": "x coordinate position"
          },
          "y": {
            "type": "number",
            "description": "y coordinate position"
          },
          "z": {
            "type": "number",
            "description": "z coordinate position"
          }
        },
        "required": [
          "x",
          "y",
          "z"
        ]
      },
      "description": "Points along the line"
    },
    "color": {
      "title": "foxglove.Color",
      "description": "Solid color to use for the whole line. One of `color` or `colors` must be provided.",
      "type": "object",
      "properties": {
        "r": {
          "type": "number",
          "description": "Red value between 0 and 1"
        },
        "g": {
          "type": "number",
          "description": "Green value between 0 and 1"
        },
        "b": {
          "type": "number",
          "description": "Blue value between 0 and 1"
        },
        "a": {
          "type": "number",
          "description": "Alpha value between 0 and 1"
        }
      },
      "required": [
        "r",
        "g",
        "b",
        "a"
      ]
    },
    "colors": {
      "type": "array",
      "items": {
        "title": "foxglove.Color",
        "description": "A color in RGBA format",
        "type": "object",
        "properties": {
          "r": {
            "type": "number",
            "description": "Red value between 0 and 1"
          },
          "g": {
            "type": "number",
            "description": "Green value between 0 and 1"
          },
          "b": {
            "type": "number",
            "description": "Blue value between 0 and 1"
          },
          "a": {
            "type": "number",
            "description": "Alpha value between 0 and 1"
          }
        },
        "required": [
          "r",
          "g",
          "b",
          "a"
        ]
      },
      "description": "Per-point colors (if specified, must have the same length as `points`). One of `color` or `colors` must be provided."
    },
    "indices": {
      "type": "array",
      "items": {
        "type": "integer",
        "minimum": 0
      },
      "description": "Indices into the `points` and `colors` attribute arrays, which can be used to avoid duplicating attribute data.\n\nIf omitted or empty, indexing will not be used. This default behavior is equivalent to specifying [0, 1, ..., N-1] for the indices (where N is the number of `points` provided)."
    }
  },
  "required": [
    "type",
    "pose",
    "thickness",
    "scale_invariant",
    "points",
    "color",
    "colors",
    "indices"
  ]
};

export const LocationFix = {
  "title": "foxglove.LocationFix",
  "description": "A navigation satellite fix for any Global Navigation Satellite System",
  "$comment": "Generated by https://github.com/foxglove/foxglove-sdk",
  "type": "object",
  "properties": {
    "timestamp": {
      "type": "object",
      "title": "time",
      "properties": {
        "sec": {
          "type": "integer",
          "minimum": 0
        },
        "nsec": {
          "type": "integer",
          "minimum": 0,
          "maximum": 999999999
        }
      },
      "description": "Timestamp of the message"
    },
    "frame_id": {
      "type": "string",
      "description": "Frame for the sensor. Latitude and longitude readings are at the origin of the frame."
    },
    "latitude": {
      "type": "number",
      "description": "Latitude in degrees"
    },
    "longitude": {
      "type": "number",
      "description": "Longitude in degrees"
    },
    "altitude": {
      "type": "number",
      "description": "Altitude in meters"
    },
    "position_covariance": {
      "type": "array",
      "items": {
        "type": "number"
      },
      "minItems": 9,
      "maxItems": 9,
      "description": "Position covariance (m^2) defined relative to a tangential plane through the reported position. The components are East, North, and Up (ENU), in row-major order."
    },
    "position_covariance_type": {
      "title": "foxglove.PositionCovarianceType",
      "description": "If `position_covariance` is available, `position_covariance_type` must be set to indicate the type of covariance.",
      "oneOf": [
        {
          "title": "UNKNOWN",
          "const": 0,
          "description": "Unknown position covariance type"
        },
        {
          "title": "APPROXIMATED",
          "const": 1,
          "description": "Position covariance is approximated"
        },
        {
          "title": "DIAGONAL_KNOWN",
          "const": 2,
          "description": "Position covariance is per-axis, so put it along the diagonal"
        },
        {
          "title": "KNOWN",
          "const": 3,
          "description": "Position covariance of the fix is known"
        }
      ]
    },
    "color": {
      "title": "foxglove.Color",
      "description": "Color used to visualize the location",
      "type": "object",
      "properties": {
        "r": {
          "type": "number",
          "description": "Red value between 0 and 1"
        },
        "g": {
          "type": "number",
          "description": "Green value between 0 and 1"
        },
        "b": {
          "type": "number",
          "description": "Blue value between 0 and 1"
        },
        "a": {
          "type": "number",
          "description": "Alpha value between 0 and 1"
        }
      },
      "required": [
        "r",
        "g",
        "b",
        "a"
      ]
    }
  },
  "required": [
    "timestamp",
    "frame_id",
    "latitude",
    "longitude",
    "altitude",
    "position_covariance",
    "position_covariance_type",
    "color"
  ]
};

export const LocationFixes = {
  "title": "foxglove.LocationFixes",
  "description": "A group of LocationFix messages",
  "$comment": "Generated by https://github.com/foxglove/foxglove-sdk",
  "type": "object",
  "properties": {
    "fixes": {
      "type": "array",
      "items": {
        "title": "foxglove.LocationFix",
        "description": "A navigation satellite fix for any Global Navigation Satellite System",
        "type": "object",
        "properties": {
          "timestamp": {
            "type": "object",
            "title": "time",
            "properties": {
              "sec": {
                "type": "integer",
                "minimum": 0
              },
              "nsec": {
                "type": "integer",
                "minimum": 0,
                "maximum": 999999999
              }
            },
            "description": "Timestamp of the message"
          },
          "frame_id": {
            "type": "string",
            "description": "Frame for the sensor. Latitude and longitude readings are at the origin of the frame."
          },
          "latitude": {
            "type": "number",
            "description": "Latitude in degrees"
          },
          "longitude": {
            "type": "number",
            "description": "Longitude in degrees"
          },
          "altitude": {
            "type": "number",
            "description": "Altitude in meters"
          },
          "position_covariance": {
            "type": "array",
            "items": {
              "type": "number"
            },
            "minItems": 9,
            "maxItems": 9,
            "description": "Position covariance (m^2) defined relative to a tangential plane through the reported position. The components are East, North, and Up (ENU), in row-major order."
          },
          "position_covariance_type": {
            "title": "foxglove.PositionCovarianceType",
            "description": "If `position_covariance` is available, `position_covariance_type` must be set to indicate the type of covariance.",
            "oneOf": [
              {
                "title": "UNKNOWN",
                "const": 0,
                "description": "Unknown position covariance type"
              },
              {
                "title": "APPROXIMATED",
                "const": 1,
                "description": "Position covariance is approximated"
              },
              {
                "title": "DIAGONAL_KNOWN",
                "const": 2,
                "description": "Position covariance is per-axis, so put it along the diagonal"
              },
              {
                "title": "KNOWN",
                "const": 3,
                "description": "Position covariance of the fix is known"
              }
            ]
          },
          "color": {
            "title": "foxglove.Color",
            "description": "Color used to visualize the location",
            "type": "object",
            "properties": {
              "r": {
                "type": "number",
                "description": "Red value between 0 and 1"
              },
              "g": {
                "type": "number",
                "description": "Green value between 0 and 1"
              },
              "b": {
                "type": "number",
                "description": "Blue value between 0 and 1"
              },
              "a": {
                "type": "number",
                "description": "Alpha value between 0 and 1"
              }
            },
            "required": [
              "r",
              "g",
              "b",
              "a"
            ]
          }
        },
        "required": [
          "timestamp",
          "frame_id",
          "latitude",
          "longitude",
          "altitude",
          "position_covariance",
          "position_covariance_type",
          "color"
        ]
      },
      "description": "An array of location fixes"
    }
  },
  "required": [
    "fixes"
  ]
};

export const Log = {
  "title": "foxglove.Log",
  "description": "A log message",
  "$comment": "Generated by https://github.com/foxglove/foxglove-sdk",
  "type": "object",
  "properties": {
    "timestamp": {
      "type": "object",
      "title": "time",
      "properties": {
        "sec": {
          "type": "integer",
          "minimum": 0
        },
        "nsec": {
          "type": "integer",
          "minimum": 0,
          "maximum": 999999999
        }
      },
      "description": "Timestamp of log message"
    },
    "level": {
      "title": "foxglove.LogLevel",
      "description": "Log level",
      "oneOf": [
        {
          "title": "UNKNOWN",
          "const": 0,
          "description": "Unknown log level"
        },
        {
          "title": "DEBUG",
          "const": 1,
          "description": "Debug log level"
        },
        {
          "title": "INFO",
          "const": 2,
          "description": "Info log level"
        },
        {
          "title": "WARNING",
          "const": 3,
          "description": "Warning log level"
        },
        {
          "title": "ERROR",
          "const": 4,
          "description": "Error log level"
        },
        {
          "title": "FATAL",
          "const": 5,
          "description": "Fatal log level"
        }
      ]
    },
    "message": {
      "type": "string",
      "description": "Log message"
    },
    "name": {
      "type": "string",
      "description": "Process or node name"
    },
    "file": {
      "type": "string",
      "description": "Filename"
    },
    "line": {
      "type": "integer",
      "minimum": 0,
      "description": "Line number in the file"
    }
  },
  "required": [
    "timestamp",
    "level",
    "message",
    "name",
    "file",
    "line"
  ]
};

export const SceneEntityDeletion = {
  "title": "foxglove.SceneEntityDeletion",
  "description": "Command to remove previously published entities",
  "$comment": "Generated by https://github.com/foxglove/foxglove-sdk",
  "type": "object",
  "properties": {
    "timestamp": {
      "type": "object",
      "title": "time",
      "properties": {
        "sec": {
          "type": "integer",
          "minimum": 0
        },
        "nsec": {
          "type": "integer",
          "minimum": 0,
          "maximum": 999999999
        }
      },
      "description": "Timestamp of the deletion. Only matching entities earlier than this timestamp will be deleted."
    },
    "type": {
      "title": "foxglove.SceneEntityDeletionType",
      "description": "Type of deletion action to perform",
      "oneOf": [
        {
          "title": "MATCHING_ID",
          "const": 0,
          "description": "Delete the existing entity on the same topic that has the provided `id`"
        },
        {
          "title": "ALL",
          "const": 1,
          "description": "Delete all existing entities on the same topic"
        }
      ]
    },
    "id": {
      "type": "string",
      "description": "Identifier which must match if `type` is `MATCHING_ID`."
    }
  },
  "required": [
    "timestamp",
    "type",
    "id"
  ]
};

export const SceneEntity = {
  "title": "foxglove.SceneEntity",
  "description": "A visual element in a 3D scene. An entity may be composed of multiple primitives which all share the same frame of reference.",
  "$comment": "Generated by https://github.com/foxglove/foxglove-sdk",
  "type": "object",
  "properties": {
    "timestamp": {
      "type": "object",
      "title": "time",
      "properties": {
        "sec": {
          "type": "integer",
          "minimum": 0
        },
        "nsec": {
          "type": "integer",
          "minimum": 0,
          "maximum": 999999999
        }
      },
      "description": "Timestamp of the entity"
    },
    "frame_id": {
      "type": "string",
      "description": "Frame of reference"
    },
    "id": {
      "type": "string",
      "description": "Identifier for the entity. A entity will replace any prior entity on the same topic with the same `id`."
    },
    "lifetime": {
      "type": "object",
      "title": "duration",
      "properties": {
        "sec": {
          "type": "integer"
        },
        "nsec": {
          "type": "integer",
          "minimum": 0,
          "maximum": 999999999
        }
      },
      "description": "Length of time (relative to `timestamp`) after which the entity should be automatically removed. Zero value indicates the entity should remain visible until it is replaced or deleted."
    },
    "frame_locked": {
      "type": "boolean",
      "description": "Whether the entity should keep its location in the fixed frame (false) or follow the frame specified in `frame_id` as it moves relative to the fixed frame (true)"
    },
    "metadata": {
      "type": "array",
      "items": {
        "title": "foxglove.KeyValuePair",
        "description": "A key with its associated value",
        "type": "object",
        "properties": {
          "key": {
            "type": "string",
            "description": "Key"
          },
          "value": {
            "type": "string",
            "description": "Value"
          }
        },
        "required": [
          "key",
          "value"
        ]
      },
      "description": "Additional user-provided metadata associated with the entity. Keys must be unique."
    },
    "arrows": {
      "type": "array",
      "items": {
        "title": "foxglove.ArrowPrimitive",
        "description": "A primitive representing an arrow",
        "type": "object",
        "properties": {
          "pose": {
            "title": "foxglove.Pose",
            "description": "Position of the arrow's tail and orientation of the arrow. Identity orientation means the arrow points in the +x direction.",
            "type": "object",
            "properties": {
              "position": {
                "title": "foxglove.Vector3",
                "description": "Point denoting position in 3D space",
                "type": "object",
                "properties": {
                  "x": {
                    "type": "number",
                    "description": "x coordinate length"
                  },
                  "y": {
                    "type": "number",
                    "description": "y coordinate length"
                  },
                  "z": {
                    "type": "number",
                    "description": "z coordinate length"
                  }
                },
                "required": [
                  "x",
                  "y",
                  "z"
                ]
              },
              "orientation": {
                "title": "foxglove.Quaternion",
                "description": "Quaternion denoting orientation in 3D space",
                "type": "object",
                "properties": {
                  "x": {
                    "type": "number",
                    "description": "x value"
                  },
                  "y": {
                    "type": "number",
                    "description": "y value"
                  },
                  "z": {
                    "type": "number",
                    "description": "z value"
                  },
                  "w": {
                    "type": "number",
                    "description": "w value"
                  }
                },
                "required": [
                  "x",
                  "y",
                  "z",
                  "w"
                ]
              }
            },
            "required": [
              "position",
              "orientation"
            ]
          },
          "shaft_length": {
            "type": "number",
            "description": "Length of the arrow shaft"
          },
          "shaft_diameter": {
            "type": "number",
            "description": "Diameter of the arrow shaft"
          },
          "head_length": {
            "type": "number",
            "description": "Length of the arrow head"
          },
          "head_diameter": {
            "type": "number",
            "description": "Diameter of the arrow head"
          },
          "color": {
            "title": "foxglove.Color",
            "description": "Color of the arrow",
            "type": "object",
            "properties": {
              "r": {
                "type": "number",
                "description": "Red value between 0 and 1"
              },
              "g": {
                "type": "number",
                "description": "Green value between 0 and 1"
              },
              "b": {
                "type": "number",
                "description": "Blue value between 0 and 1"
              },
              "a": {
                "type": "number",
                "description": "Alpha value between 0 and 1"
              }
            },
            "required": [
              "r",
              "g",
              "b",
              "a"
            ]
          }
        },
        "required": [
          "pose",
          "shaft_length",
          "shaft_diameter",
          "head_length",
          "head_diameter",
          "color"
        ]
      },
      "description": "Arrow primitives"
    },
    "cubes": {
      "type": "array",
      "items": {
        "title": "foxglove.CubePrimitive",
        "description": "A primitive representing a cube or rectangular prism",
        "type": "object",
        "properties": {
          "pose": {
            "title": "foxglove.Pose",
            "description": "Position of the center of the cube and orientation of the cube",
            "type": "object",
            "properties": {
              "position": {
                "title": "foxglove.Vector3",
                "description": "Point denoting position in 3D space",
                "type": "object",
                "properties": {
                  "x": {
                    "type": "number",
                    "description": "x coordinate length"
                  },
                  "y": {
                    "type": "number",
                    "description": "y coordinate length"
                  },
                  "z": {
                    "type": "number",
                    "description": "z coordinate length"
                  }
                },
                "required": [
                  "x",
                  "y",
                  "z"
                ]
              },
              "orientation": {
                "title": "foxglove.Quaternion",
                "description": "Quaternion denoting orientation in 3D space",
                "type": "object",
                "properties": {
                  "x": {
                    "type": "number",
                    "description": "x value"
                  },
                  "y": {
                    "type": "number",
                    "description": "y value"
                  },
                  "z": {
                    "type": "number",
                    "description": "z value"
                  },
                  "w": {
                    "type": "number",
                    "description": "w value"
                  }
                },
                "required": [
                  "x",
                  "y",
                  "z",
                  "w"
                ]
              }
            },
            "required": [
              "position",
              "orientation"
            ]
          },
          "size": {
            "title": "foxglove.Vector3",
            "description": "Size of the cube along each axis",
            "type": "object",
            "properties": {
              "x": {
                "type": "number",
                "description": "x coordinate length"
              },
              "y": {
                "type": "number",
                "description": "y coordinate length"
              },
              "z": {
                "type": "number",
                "description": "z coordinate length"
              }
            },
            "required": [
              "x",
              "y",
              "z"
            ]
          },
          "color": {
            "title": "foxglove.Color",
            "description": "Color of the cube",
            "type": "object",
            "properties": {
              "r": {
                "type": "number",
                "description": "Red value between 0 and 1"
              },
              "g": {
                "type": "number",
                "description": "Green value between 0 and 1"
              },
              "b": {
                "type": "number",
                "description": "Blue value between 0 and 1"
              },
              "a": {
                "type": "number",
                "description": "Alpha value between 0 and 1"
              }
            },
            "required": [
              "r",
              "g",
              "b",
              "a"
            ]
          }
        },
        "required": [
          "pose",
          "size",
          "color"
        ]
      },
      "description": "Cube primitives"
    },
    "spheres": {
      "type": "array",
      "items": {
        "title": "foxglove.SpherePrimitive",
        "description": "A primitive representing a sphere or ellipsoid",
        "type": "object",
        "properties": {
          "pose": {
            "title": "foxglove.Pose",
            "description": "Position of the center of the sphere and orientation of the sphere",
            "type": "object",
            "properties": {
              "position": {
                "title": "foxglove.Vector3",
                "description": "Point denoting position in 3D space",
                "type": "object",
                "properties": {
                  "x": {
                    "type": "number",
                    "description": "x coordinate length"
                  },
                  "y": {
                    "type": "number",
                    "description": "y coordinate length"
                  },
                  "z": {
                    "type": "number",
                    "description": "z coordinate length"
                  }
                },
                "required": [
                  "x",
                  "y",
                  "z"
                ]
              },
              "orientation": {
                "title": "foxglove.Quaternion",
                "description": "Quaternion denoting orientation in 3D space",
                "type": "object",
                "properties": {
                  "x": {
                    "type": "number",
                    "description": "x value"
                  },
                  "y": {
                    "type": "number",
                    "description": "y value"
                  },
                  "z": {
                    "type": "number",
                    "description": "z value"
                  },
                  "w": {
                    "type": "number",
                    "description": "w value"
                  }
                },
                "required": [
                  "x",
                  "y",
                  "z",
                  "w"
                ]
              }
            },
            "required": [
              "position",
              "orientation"
            ]
          },
          "size": {
            "title": "foxglove.Vector3",
            "description": "Size (diameter) of the sphere along each axis",
            "type": "object",
            "properties": {
              "x": {
                "type": "number",
                "description": "x coordinate length"
              },
              "y": {
                "type": "number",
                "description": "y coordinate length"
              },
              "z": {
                "type": "number",
                "description": "z coordinate length"
              }
            },
            "required": [
              "x",
              "y",
              "z"
            ]
          },
          "color": {
            "title": "foxglove.Color",
            "description": "Color of the sphere",
            "type": "object",
            "properties": {
              "r": {
                "type": "number",
                "description": "Red value between 0 and 1"
              },
              "g": {
                "type": "number",
                "description": "Green value between 0 and 1"
              },
              "b": {
                "type": "number",
                "description": "Blue value between 0 and 1"
              },
              "a": {
                "type": "number",
                "description": "Alpha value between 0 and 1"
              }
            },
            "required": [
              "r",
              "g",
              "b",
              "a"
            ]
          }
        },
        "required": [
          "pose",
          "size",
          "color"
        ]
      },
      "description": "Sphere primitives"
    },
    "cylinders": {
      "type": "array",
      "items": {
        "title": "foxglove.CylinderPrimitive",
        "description": "A primitive representing a cylinder, elliptic cylinder, or truncated cone",
        "type": "object",
        "properties": {
          "pose": {
            "title": "foxglove.Pose",
            "description": "Position of the center of the cylinder and orientation of the cylinder. The flat face(s) are perpendicular to the z-axis.",
            "type": "object",
            "properties": {
              "position": {
                "title": "foxglove.Vector3",
                "description": "Point denoting position in 3D space",
                "type": "object",
                "properties": {
                  "x": {
                    "type": "number",
                    "description": "x coordinate length"
                  },
                  "y": {
                    "type": "number",
                    "description": "y coordinate length"
                  },
                  "z": {
                    "type": "number",
                    "description": "z coordinate length"
                  }
                },
                "required": [
                  "x",
                  "y",
                  "z"
                ]
              },
              "orientation": {
                "title": "foxglove.Quaternion",
                "description": "Quaternion denoting orientation in 3D space",
                "type": "object",
                "properties": {
                  "x": {
                    "type": "number",
                    "description": "x value"
                  },
                  "y": {
                    "type": "number",
                    "description": "y value"
                  },
                  "z": {
                    "type": "number",
                    "description": "z value"
                  },
                  "w": {
                    "type": "number",
                    "description": "w value"
                  }
                },
                "required": [
                  "x",
                  "y",
                  "z",
                  "w"
                ]
              }
            },
            "required": [
              "position",
              "orientation"
            ]
          },
          "size": {
            "title": "foxglove.Vector3",
            "description": "Size of the cylinder's bounding box",
            "type": "object",
            "properties": {
              "x": {
                "type": "number",
                "description": "x coordinate length"
              },
              "y": {
                "type": "number",
                "description": "y coordinate length"
              },
              "z": {
                "type": "number",
                "description": "z coordinate length"
              }
            },
            "required": [
              "x",
              "y",
              "z"
            ]
          },
          "bottom_scale": {
            "type": "number",
            "description": "0-1, ratio of the diameter of the cylinder's bottom face (min z) to the bottom of the bounding box"
          },
          "top_scale": {
            "type": "number",
            "description": "0-1, ratio of the diameter of the cylinder's top face (max z) to the top of the bounding box"
          },
          "color": {
            "title": "foxglove.Color",
            "description": "Color of the cylinder",
            "type": "object",
            "properties": {
              "r": {
                "type": "number",
                "description": "Red value between 0 and 1"
              },
              "g": {
                "type": "number",
                "description": "Green value between 0 and 1"
              },
              "b": {
                "type": "number",
                "description": "Blue value between 0 and 1"
              },
              "a": {
                "type": "number",
                "description": "Alpha value between 0 and 1"
              }
            },
            "required": [
              "r",
              "g",
              "b",
              "a"
            ]
          }
        },
        "required": [
          "pose",
          "size",
          "bottom_scale",
          "top_scale",
          "color"
        ]
      },
      "description": "Cylinder primitives"
    },
    "lines": {
      "type": "array",
      "items": {
        "title": "foxglove.LinePrimitive",
        "description": "A primitive representing a series of points connected by lines",
        "type": "object",
        "properties": {
          "type": {
            "title": "foxglove.LineType",
            "description": "Drawing primitive to use for lines",
            "oneOf": [
              {
                "title": "LINE_STRIP",
                "const": 0,
                "description": "Connected line segments: 0-1, 1-2, ..., (n-1)-n"
              },
              {
                "title": "LINE_LOOP",
                "const": 1,
                "description": "Closed polygon: 0-1, 1-2, ..., (n-1)-n, n-0"
              },
              {
                "title": "LINE_LIST",
                "const": 2,
                "description": "Individual line segments: 0-1, 2-3, 4-5, ..."
              }
            ]
          },
          "pose": {
            "title": "foxglove.Pose",
            "description": "Origin of lines relative to reference frame",
            "type": "object",
            "properties": {
              "position": {
                "title": "foxglove.Vector3",
                "description": "Point denoting position in 3D space",
                "type": "object",
                "properties": {
                  "x": {
                    "type": "number",
                    "description": "x coordinate length"
                  },
                  "y": {
                    "type": "number",
                    "description": "y coordinate length"
                  },
                  "z": {
                    "type": "number",
                    "description": "z coordinate length"
                  }
                },
                "required": [
                  "x",
                  "y",
                  "z"
                ]
              },
              "orientation": {
                "title": "foxglove.Quaternion",
                "description": "Quaternion denoting orientation in 3D space",
                "type": "object",
                "properties": {
                  "x": {
                    "type": "number",
                    "description": "x value"
                  },
                  "y": {
                    "type": "number",
                    "description": "y value"
                  },
                  "z": {
                    "type": "number",
                    "description": "z value"
                  },
                  "w": {
                    "type": "number",
                    "description": "w value"
                  }
                },
                "required": [
                  "x",
                  "y",
                  "z",
                  "w"
                ]
              }
            },
            "required": [
              "position",
              "orientation"
            ]
          },
          "thickness": {
            "type": "number",
            "description": "Line thickness"
          },
          "scale_invariant": {
            "type": "boolean",
            "description": "Indicates whether `thickness` is a fixed size in screen pixels (true), or specified in world coordinates and scales with distance from the camera (false)"
          },
          "points": {
            "type": "array",
            "items": {
              "title": "foxglove.Point3",
              "description": "A point representing a position in 3D space",
              "type": "object",
              "properties": {
                "x": {
                  "type": "number",
                  "description": "x coordinate position"
                },
                "y": {
                  "type": "number",
                  "description": "y coordinate position"
                },
                "z": {
                  "type": "number",
                  "description": "z coordinate position"
                }
              },
              "required": [
                "x",
                "y",
                "z"
              ]
            },
            "description": "Points along the line"
          },
          "color": {
            "title": "foxglove.Color",
            "description": "Solid color to use for the whole line. One of `color` or `colors` must be provided.",
            "type": "object",
            "properties": {
              "r": {
                "type": "number",
                "description": "Red value between 0 and 1"
              },
              "g": {
                "type": "number",
                "description": "Green value between 0 and 1"
              },
              "b": {
                "type": "number",
                "description": "Blue value between 0 and 1"
              },
              "a": {
                "type": "number",
                "description": "Alpha value between 0 and 1"
              }
            },
            "required": [
              "r",
              "g",
              "b",
              "a"
            ]
          },
          "colors": {
            "type": "array",
            "items": {
              "title": "foxglove.Color",
              "description": "A color in RGBA format",
              "type": "object",
              "properties": {
                "r": {
                  "type": "number",
                  "description": "Red value between 0 and 1"
                },
                "g": {
                  "type": "number",
                  "description": "Green value between 0 and 1"
                },
                "b": {
                  "type": "number",
                  "description": "Blue value between 0 and 1"
                },
                "a": {
                  "type": "number",
                  "description": "Alpha value between 0 and 1"
                }
              },
              "required": [
                "r",
                "g",
                "b",
                "a"
              ]
            },
            "description": "Per-point colors (if specified, must have the same length as `points`). One of `color` or `colors` must be provided."
          },
          "indices": {
            "type": "array",
            "items": {
              "type": "integer",
              "minimum": 0
            },
            "description": "Indices into the `points` and `colors` attribute arrays, which can be used to avoid duplicating attribute data.\n\nIf omitted or empty, indexing will not be used. This default behavior is equivalent to specifying [0, 1, ..., N-1] for the indices (where N is the number of `points` provided)."
          }
        },
        "required": [
          "type",
          "pose",
          "thickness",
          "scale_invariant",
          "points",
          "color",
          "colors",
          "indices"
        ]
      },
      "description": "Line primitives"
    },
    "triangles": {
      "type": "array",
      "items": {
        "title": "foxglove.TriangleListPrimitive",
        "description": "A primitive representing a set of triangles or a surface tiled by triangles",
        "type": "object",
        "properties": {
          "pose": {
            "title": "foxglove.Pose",
            "description": "Origin of triangles relative to reference frame",
            "type": "object",
            "properties": {
              "position": {
                "title": "foxglove.Vector3",
                "description": "Point denoting position in 3D space",
                "type": "object",
                "properties": {
                  "x": {
                    "type": "number",
                    "description": "x coordinate length"
                  },
                  "y": {
                    "type": "number",
                    "description": "y coordinate length"
                  },
                  "z": {
                    "type": "number",
                    "description": "z coordinate length"
                  }
                },
                "required": [
                  "x",
                  "y",
                  "z"
                ]
              },
              "orientation": {
                "title": "foxglove.Quaternion",
                "description": "Quaternion denoting orientation in 3D space",
                "type": "object",
                "properties": {
                  "x": {
                    "type": "number",
                    "description": "x value"
                  },
                  "y": {
                    "type": "number",
                    "description": "y value"
                  },
                  "z": {
                    "type": "number",
                    "description": "z value"
                  },
                  "w": {
                    "type": "number",
                    "description": "w value"
                  }
                },
                "required": [
                  "x",
                  "y",
                  "z",
                  "w"
                ]
              }
            },
            "required": [
              "position",
              "orientation"
            ]
          },
          "points": {
            "type": "array",
            "items": {
              "title": "foxglove.Point3",
              "description": "A point representing a position in 3D space",
              "type": "object",
              "properties": {
                "x": {
                  "type": "number",
                  "description": "x coordinate position"
                },
                "y": {
                  "type": "number",
                  "description": "y coordinate position"
                },
                "z": {
                  "type": "number",
                  "description": "z coordinate position"
                }
              },
              "required": [
                "x",
                "y",
                "z"
              ]
            },
            "description": "Vertices to use for triangles, interpreted as a list of triples (0-1-2, 3-4-5, ...)"
          },
          "color": {
            "title": "foxglove.Color",
            "description": "Solid color to use for the whole shape. One of `color` or `colors` must be provided.",
            "type": "object",
            "properties": {
              "r": {
                "type": "number",
                "description": "Red value between 0 and 1"
              },
              "g": {
                "type": "number",
                "description": "Green value between 0 and 1"
              },
              "b": {
                "type": "number",
                "description": "Blue value between 0 and 1"
              },
              "a": {
                "type": "number",
                "description": "Alpha value between 0 and 1"
              }
            },
            "required": [
              "r",
              "g",
              "b",
              "a"
            ]
          },
          "colors": {
            "type": "array",
            "items": {
              "title": "foxglove.Color",
              "description": "A color in RGBA format",
              "type": "object",
              "properties": {
                "r": {
                  "type": "number",
                  "description": "Red value between 0 and 1"
                },
                "g": {
                  "type": "number",
                  "description": "Green value between 0 and 1"
                },
                "b": {
                  "type": "number",
                  "description": "Blue value between 0 and 1"
                },
                "a": {
                  "type": "number",
                  "description": "Alpha value between 0 and 1"
                }
              },
              "required": [
                "r",
                "g",
                "b",
                "a"
              ]
            },
            "description": "Per-vertex colors (if specified, must have the same length as `points`). One of `color` or `colors` must be provided."
          },
          "indices": {
            "type": "array",
            "items": {
              "type": "integer",
              "minimum": 0
            },
            "description": "Indices into the `points` and `colors` attribute arrays, which can be used to avoid duplicating attribute data.\n\nIf omitted or empty, indexing will not be used. This default behavior is equivalent to specifying [0, 1, ..., N-1] for the indices (where N is the number of `points` provided)."
          }
        },
        "required": [
          "pose",
          "points",
          "color",
          "colors",
          "indices"
        ]
      },
      "description": "Triangle list primitives"
    },
    "texts": {
      "type": "array",
      "items": {
        "title": "foxglove.TextPrimitive",
        "description": "A primitive representing a text label",
        "type": "object",
        "properties": {
          "pose": {
            "title": "foxglove.Pose",
            "description": "Position of the center of the text box and orientation of the text. Identity orientation means the text is oriented in the xy-plane and flows from -x to +x.",
            "type": "object",
            "properties": {
              "position": {
                "title": "foxglove.Vector3",
                "description": "Point denoting position in 3D space",
                "type": "object",
                "properties": {
                  "x": {
                    "type": "number",
                    "description": "x coordinate length"
                  },
                  "y": {
                    "type": "number",
                    "description": "y coordinate length"
                  },
                  "z": {
                    "type": "number",
                    "description": "z coordinate length"
                  }
                },
                "required": [
                  "x",
                  "y",
                  "z"
                ]
              },
              "orientation": {
                "title": "foxglove.Quaternion",
                "description": "Quaternion denoting orientation in 3D space",
                "type": "object",
                "properties": {
                  "x": {
                    "type": "number",
                    "description": "x value"
                  },
                  "y": {
                    "type": "number",
                    "description": "y value"
                  },
                  "z": {
                    "type": "number",
                    "description": "z value"
                  },
                  "w": {
                    "type": "number",
                    "description": "w value"
                  }
                },
                "required": [
                  "x",
                  "y",
                  "z",
                  "w"
                ]
              }
            },
            "required": [
              "position",
              "orientation"
            ]
          },
          "billboard": {
            "type": "boolean",
            "description": "Whether the text should respect `pose.orientation` (false) or always face the camera (true)"
          },
          "font_size": {
            "type": "number",
            "description": "Font size (height of one line of text)"
          },
          "scale_invariant": {
            "type": "boolean",
            "description": "Indicates whether `font_size` is a fixed size in screen pixels (true), or specified in world coordinates and scales with distance from the camera (false)"
          },
          "color": {
            "title": "foxglove.Color",
            "description": "Color of the text",
            "type": "object",
            "properties": {
              "r": {
                "type": "number",
                "description": "Red value between 0 and 1"
              },
              "g": {
                "type": "number",
                "description": "Green value between 0 and 1"
              },
              "b": {
                "type": "number",
                "description": "Blue value between 0 and 1"
              },
              "a": {
                "type": "number",
                "description": "Alpha value between 0 and 1"
              }
            },
            "required": [
              "r",
              "g",
              "b",
              "a"
            ]
          },
          "text": {
            "type": "string",
            "description": "Text"
          }
        },
        "required": [
          "pose",
          "billboard",
          "font_size",
          "scale_invariant",
          "color",
          "text"
        ]
      },
      "description": "Text primitives"
    },
    "models": {
      "type": "array",
      "items": {
        "title": "foxglove.ModelPrimitive",
        "description": "A primitive representing a 3D model file loaded from an external URL or embedded data",
        "type": "object",
        "properties": {
          "pose": {
            "title": "foxglove.Pose",
            "description": "Origin of model relative to reference frame",
            "type": "object",
            "properties": {
              "position": {
                "title": "foxglove.Vector3",
                "description": "Point denoting position in 3D space",
                "type": "object",
                "properties": {
                  "x": {
                    "type": "number",
                    "description": "x coordinate length"
                  },
                  "y": {
                    "type": "number",
                    "description": "y coordinate length"
                  },
                  "z": {
                    "type": "number",
                    "description": "z coordinate length"
                  }
                },
                "required": [
                  "x",
                  "y",
                  "z"
                ]
              },
              "orientation": {
                "title": "foxglove.Quaternion",
                "description": "Quaternion denoting orientation in 3D space",
                "type": "object",
                "properties": {
                  "x": {
                    "type": "number",
                    "description": "x value"
                  },
                  "y": {
                    "type": "number",
                    "description": "y value"
                  },
                  "z": {
                    "type": "number",
                    "description": "z value"
                  },
                  "w": {
                    "type": "number",
                    "description": "w value"
                  }
                },
                "required": [
                  "x",
                  "y",
                  "z",
                  "w"
                ]
              }
            },
            "required": [
              "position",
              "orientation"
            ]
          },
          "scale": {
            "title": "foxglove.Vector3",
            "description": "Scale factor to apply to the model along each axis",
            "type": "object",
            "properties": {
              "x": {
                "type": "number",
                "description": "x coordinate length"
              },
              "y": {
                "type": "number",
                "description": "y coordinate length"
              },
              "z": {
                "type": "number",
                "description": "z coordinate length"
              }
            },
            "required": [
              "x",
              "y",
              "z"
            ]
          },
          "color": {
            "title": "foxglove.Color",
            "description": "Solid color to use for the whole model if `override_color` is true.",
            "type": "object",
            "properties": {
              "r": {
                "type": "number",
                "description": "Red value between 0 and 1"
              },
              "g": {
                "type": "number",
                "description": "Green value between 0 and 1"
              },
              "b": {
                "type": "number",
                "description": "Blue value between 0 and 1"
              },
              "a": {
                "type": "number",
                "description": "Alpha value between 0 and 1"
              }
            },
            "required": [
              "r",
              "g",
              "b",
              "a"
            ]
          },
          "override_color": {
            "type": "boolean",
            "description": "Whether to use the color specified in `color` instead of any materials embedded in the original model."
          },
          "url": {
            "type": "string",
            "description": "URL pointing to model file. One of `url` or `data` should be provided."
          },
          "media_type": {
            "type": "string",
            "description": "[Media type](https://developer.mozilla.org/en-US/docs/Web/HTTP/Basics_of_HTTP/MIME_types) of embedded model (e.g. `model/gltf-binary`). Required if `data` is provided instead of `url`. Overrides the inferred media type if `url` is provided."
          },
          "data": {
            "type": "string",
            "contentEncoding": "base64",
            "description": "Embedded model. One of `url` or `data` should be provided. If `data` is provided, `media_type` must be set to indicate the type of the data."
          }
        },
        "required": [
          "pose",
          "scale",
          "color",
          "override_color",
          "url",
          "media_type",
          "data"
        ]
      },
      "description": "Model primitives"
    }
  },
  "required": [
    "timestamp",
    "frame_id",
    "id",
    "lifetime",
    "frame_locked",
    "metadata",
    "arrows",
    "cubes",
    "spheres",
    "cylinders",
    "lines",
    "triangles",
    "texts",
    "models"
  ]
};

export const SceneUpdate = {
  "title": "foxglove.SceneUpdate",
  "description": "An update to the entities displayed in a 3D scene",
  "$comment": "Generated by https://github.com/foxglove/foxglove-sdk",
  "type": "object",
  "properties": {
    "deletions": {
      "type": "array",
      "items": {
        "title": "foxglove.SceneEntityDeletion",
        "description": "Command to remove previously published entities",
        "type": "object",
        "properties": {
          "timestamp": {
            "type": "object",
            "title": "time",
            "properties": {
              "sec": {
                "type": "integer",
                "minimum": 0
              },
              "nsec": {
                "type": "integer",
                "minimum": 0,
                "maximum": 999999999
              }
            },
            "description": "Timestamp of the deletion. Only matching entities earlier than this timestamp will be deleted."
          },
          "type": {
            "title": "foxglove.SceneEntityDeletionType",
            "description": "Type of deletion action to perform",
            "oneOf": [
              {
                "title": "MATCHING_ID",
                "const": 0,
                "description": "Delete the existing entity on the same topic that has the provided `id`"
              },
              {
                "title": "ALL",
                "const": 1,
                "description": "Delete all existing entities on the same topic"
              }
            ]
          },
          "id": {
            "type": "string",
            "description": "Identifier which must match if `type` is `MATCHING_ID`."
          }
        },
        "required": [
          "timestamp",
          "type",
          "id"
        ]
      },
      "description": "Scene entities to delete"
    },
    "entities": {
      "type": "array",
      "items": {
        "title": "foxglove.SceneEntity",
        "description": "A visual element in a 3D scene. An entity may be composed of multiple primitives which all share the same frame of reference.",
        "type": "object",
        "properties": {
          "timestamp": {
            "type": "object",
            "title": "time",
            "properties": {
              "sec": {
                "type": "integer",
                "minimum": 0
              },
              "nsec": {
                "type": "integer",
                "minimum": 0,
                "maximum": 999999999
              }
            },
            "description": "Timestamp of the entity"
          },
          "frame_id": {
            "type": "string",
            "description": "Frame of reference"
          },
          "id": {
            "type": "string",
            "description": "Identifier for the entity. A entity will replace any prior entity on the same topic with the same `id`."
          },
          "lifetime": {
            "type": "object",
            "title": "duration",
            "properties": {
              "sec": {
                "type": "integer"
              },
              "nsec": {
                "type": "integer",
                "minimum": 0,
                "maximum": 999999999
              }
            },
            "description": "Length of time (relative to `timestamp`) after which the entity should be automatically removed. Zero value indicates the entity should remain visible until it is replaced or deleted."
          },
          "frame_locked": {
            "type": "boolean",
            "description": "Whether the entity should keep its location in the fixed frame (false) or follow the frame specified in `frame_id` as it moves relative to the fixed frame (true)"
          },
          "metadata": {
            "type": "array",
            "items": {
              "title": "foxglove.KeyValuePair",
              "description": "A key with its associated value",
              "type": "object",
              "properties": {
                "key": {
                  "type": "string",
                  "description": "Key"
                },
                "value": {
                  "type": "string",
                  "description": "Value"
                }
              },
              "required": [
                "key",
                "value"
              ]
            },
            "description": "Additional user-provided metadata associated with the entity. Keys must be unique."
          },
          "arrows": {
            "type": "array",
            "items": {
              "title": "foxglove.ArrowPrimitive",
              "description": "A primitive representing an arrow",
              "type": "object",
              "properties": {
                "pose": {
                  "title": "foxglove.Pose",
                  "description": "Position of the arrow's tail and orientation of the arrow. Identity orientation means the arrow points in the +x direction.",
                  "type": "object",
                  "properties": {
                    "position": {
                      "title": "foxglove.Vector3",
                      "description": "Point denoting position in 3D space",
                      "type": "object",
                      "properties": {
                        "x": {
                          "type": "number",
                          "description": "x coordinate length"
                        },
                        "y": {
                          "type": "number",
                          "description": "y coordinate length"
                        },
                        "z": {
                          "type": "number",
                          "description": "z coordinate length"
                        }
                      },
                      "required": [
                        "x",
                        "y",
                        "z"
                      ]
                    },
                    "orientation": {
                      "title": "foxglove.Quaternion",
                      "description": "Quaternion denoting orientation in 3D space",
                      "type": "object",
                      "properties": {
                        "x": {
                          "type": "number",
                          "description": "x value"
                        },
                        "y": {
                          "type": "number",
                          "description": "y value"
                        },
                        "z": {
                          "type": "number",
                          "description": "z value"
                        },
                        "w": {
                          "type": "number",
                          "description": "w value"
                        }
                      },
                      "required": [
                        "x",
                        "y",
                        "z",
                        "w"
                      ]
                    }
                  },
                  "required": [
                    "position",
                    "orientation"
                  ]
                },
                "shaft_length": {
                  "type": "number",
                  "description": "Length of the arrow shaft"
                },
                "shaft_diameter": {
                  "type": "number",
                  "description": "Diameter of the arrow shaft"
                },
                "head_length": {
                  "type": "number",
                  "description": "Length of the arrow head"
                },
                "head_diameter": {
                  "type": "number",
                  "description": "Diameter of the arrow head"
                },
                "color": {
                  "title": "foxglove.Color",
                  "description": "Color of the arrow",
                  "type": "object",
                  "properties": {
                    "r": {
                      "type": "number",
                      "description": "Red value between 0 and 1"
                    },
                    "g": {
                      "type": "number",
                      "description": "Green value between 0 and 1"
                    },
                    "b": {
                      "type": "number",
                      "description": "Blue value between 0 and 1"
                    },
                    "a": {
                      "type": "number",
                      "description": "Alpha value between 0 and 1"
                    }
                  },
                  "required": [
                    "r",
                    "g",
                    "b",
                    "a"
                  ]
                }
              },
              "required": [
                "pose",
                "shaft_length",
                "shaft_diameter",
                "head_length",
                "head_diameter",
                "color"
              ]
            },
            "description": "Arrow primitives"
          },
          "cubes": {
            "type": "array",
            "items": {
              "title": "foxglove.CubePrimitive",
              "description": "A primitive representing a cube or rectangular prism",
              "type": "object",
              "properties": {
                "pose": {
                  "title": "foxglove.Pose",
                  "description": "Position of the center of the cube and orientation of the cube",
                  "type": "object",
                  "properties": {
                    "position": {
                      "title": "foxglove.Vector3",
                      "description": "Point denoting position in 3D space",
                      "type": "object",
                      "properties": {
                        "x": {
                          "type": "number",
                          "description": "x coordinate length"
                        },
                        "y": {
                          "type": "number",
                          "description": "y coordinate length"
                        },
                        "z": {
                          "type": "number",
                          "description": "z coordinate length"
                        }
                      },
                      "required": [
                        "x",
                        "y",
                        "z"
                      ]
                    },
                    "orientation": {
                      "title": "foxglove.Quaternion",
                      "description": "Quaternion denoting orientation in 3D space",
                      "type": "object",
                      "properties": {
                        "x": {
                          "type": "number",
                          "description": "x value"
                        },
                        "y": {
                          "type": "number",
                          "description": "y value"
                        },
                        "z": {
                          "type": "number",
                          "description": "z value"
                        },
                        "w": {
                          "type": "number",
                          "description": "w value"
                        }
                      },
                      "required": [
                        "x",
                        "y",
                        "z",
                        "w"
                      ]
                    }
                  },
                  "required": [
                    "position",
                    "orientation"
                  ]
                },
                "size": {
                  "title": "foxglove.Vector3",
                  "description": "Size of the cube along each axis",
                  "type": "object",
                  "properties": {
                    "x": {
                      "type": "number",
                      "description": "x coordinate length"
                    },
                    "y": {
                      "type": "number",
                      "description": "y coordinate length"
                    },
                    "z": {
                      "type": "number",
                      "description": "z coordinate length"
                    }
                  },
                  "required": [
                    "x",
                    "y",
                    "z"
                  ]
                },
                "color": {
                  "title": "foxglove.Color",
                  "description": "Color of the cube",
                  "type": "object",
                  "properties": {
                    "r": {
                      "type": "number",
                      "description": "Red value between 0 and 1"
                    },
                    "g": {
                      "type": "number",
                      "description": "Green value between 0 and 1"
                    },
                    "b": {
                      "type": "number",
                      "description": "Blue value between 0 and 1"
                    },
                    "a": {
                      "type": "number",
                      "description": "Alpha value between 0 and 1"
                    }
                  },
                  "required": [
                    "r",
                    "g",
                    "b",
                    "a"
                  ]
                }
              },
              "required": [
                "pose",
                "size",
                "color"
              ]
            },
            "description": "Cube primitives"
          },
          "spheres": {
            "type": "array",
            "items": {
              "title": "foxglove.SpherePrimitive",
              "description": "A primitive representing a sphere or ellipsoid",
              "type": "object",
              "properties": {
                "pose": {
                  "title": "foxglove.Pose",
                  "description": "Position of the center of the sphere and orientation of the sphere",
                  "type": "object",
                  "properties": {
                    "position": {
                      "title": "foxglove.Vector3",
                      "description": "Point denoting position in 3D space",
                      "type": "object",
                      "properties": {
                        "x": {
                          "type": "number",
                          "description": "x coordinate length"
                        },
                        "y": {
                          "type": "number",
                          "description": "y coordinate length"
                        },
                        "z": {
                          "type": "number",
                          "description": "z coordinate length"
                        }
                      },
                      "required": [
                        "x",
                        "y",
                        "z"
                      ]
                    },
                    "orientation": {
                      "title": "foxglove.Quaternion",
                      "description": "Quaternion denoting orientation in 3D space",
                      "type": "object",
                      "properties": {
                        "x": {
                          "type": "number",
                          "description": "x value"
                        },
                        "y": {
                          "type": "number",
                          "description": "y value"
                        },
                        "z": {
                          "type": "number",
                          "description": "z value"
                        },
                        "w": {
                          "type": "number",
                          "description": "w value"
                        }
                      },
                      "required": [
                        "x",
                        "y",
                        "z",
                        "w"
                      ]
                    }
                  },
                  "required": [
                    "position",
                    "orientation"
                  ]
                },
                "size": {
                  "title": "foxglove.Vector3",
                  "description": "Size (diameter) of the sphere along each axis",
                  "type": "object",
                  "properties": {
                    "x": {
                      "type": "number",
                      "description": "x coordinate length"
                    },
                    "y": {
                      "type": "number",
                      "description": "y coordinate length"
                    },
                    "z": {
                      "type": "number",
                      "description": "z coordinate length"
                    }
                  },
                  "required": [
                    "x",
                    "y",
                    "z"
                  ]
                },
                "color": {
                  "title": "foxglove.Color",
                  "description": "Color of the sphere",
                  "type": "object",
                  "properties": {
                    "r": {
                      "type": "number",
                      "description": "Red value between 0 and 1"
                    },
                    "g": {
                      "type": "number",
                      "description": "Green value between 0 and 1"
                    },
                    "b": {
                      "type": "number",
                      "description": "Blue value between 0 and 1"
                    },
                    "a": {
                      "type": "number",
                      "description": "Alpha value between 0 and 1"
                    }
                  },
                  "required": [
                    "r",
                    "g",
                    "b",
                    "a"
                  ]
                }
              },
              "required": [
                "pose",
                "size",
                "color"
              ]
            },
            "description": "Sphere primitives"
          },
          "cylinders": {
            "type": "array",
            "items": {
              "title": "foxglove.CylinderPrimitive",
              "description": "A primitive representing a cylinder, elliptic cylinder, or truncated cone",
              "type": "object",
              "properties": {
                "pose": {
                  "title": "foxglove.Pose",
                  "description": "Position of the center of the cylinder and orientation of the cylinder. The flat face(s) are perpendicular to the z-axis.",
                  "type": "object",
                  "properties": {
                    "position": {
                      "title": "foxglove.Vector3",
                      "description": "Point denoting position in 3D space",
                      "type": "object",
                      "properties": {
                        "x": {
                          "type": "number",
                          "description": "x coordinate length"
                        },
                        "y": {
                          "type": "number",
                          "description": "y coordinate length"
                        },
                        "z": {
                          "type": "number",
                          "description": "z coordinate length"
                        }
                      },
                      "required": [
                        "x",
                        "y",
                        "z"
                      ]
                    },
                    "orientation": {
                      "title": "foxglove.Quaternion",
                      "description": "Quaternion denoting orientation in 3D space",
                      "type": "object",
                      "properties": {
                        "x": {
                          "type": "number",
                          "description": "x value"
                        },
                        "y": {
                          "type": "number",
                          "description": "y value"
                        },
                        "z": {
                          "type": "number",
                          "description": "z value"
                        },
                        "w": {
                          "type": "number",
                          "description": "w value"
                        }
                      },
                      "required": [
                        "x",
                        "y",
                        "z",
                        "w"
                      ]
                    }
                  },
                  "required": [
                    "position",
                    "orientation"
                  ]
                },
                "size": {
                  "title": "foxglove.Vector3",
                  "description": "Size of the cylinder's bounding box",
                  "type": "object",
                  "properties": {
                    "x": {
                      "type": "number",
                      "description": "x coordinate length"
                    },
                    "y": {
                      "type": "number",
                      "description": "y coordinate length"
                    },
                    "z": {
                      "type": "number",
                      "description": "z coordinate length"
                    }
                  },
                  "required": [
                    "x",
                    "y",
                    "z"
                  ]
                },
                "bottom_scale": {
                  "type": "number",
                  "description": "0-1, ratio of the diameter of the cylinder's bottom face (min z) to the bottom of the bounding box"
                },
                "top_scale": {
                  "type": "number",
                  "description": "0-1, ratio of the diameter of the cylinder's top face (max z) to the top of the bounding box"
                },
                "color": {
                  "title": "foxglove.Color",
                  "description": "Color of the cylinder",
                  "type": "object",
                  "properties": {
                    "r": {
                      "type": "number",
                      "description": "Red value between 0 and 1"
                    },
                    "g": {
                      "type": "number",
                      "description": "Green value between 0 and 1"
                    },
                    "b": {
                      "type": "number",
                      "description": "Blue value between 0 and 1"
                    },
                    "a": {
                      "type": "number",
                      "description": "Alpha value between 0 and 1"
                    }
                  },
                  "required": [
                    "r",
                    "g",
                    "b",
                    "a"
                  ]
                }
              },
              "required": [
                "pose",
                "size",
                "bottom_scale",
                "top_scale",
                "color"
              ]
            },
            "description": "Cylinder primitives"
          },
          "lines": {
            "type": "array",
            "items": {
              "title": "foxglove.LinePrimitive",
              "description": "A primitive representing a series of points connected by lines",
              "type": "object",
              "properties": {
                "type": {
                  "title": "foxglove.LineType",
                  "description": "Drawing primitive to use for lines",
                  "oneOf": [
                    {
                      "title": "LINE_STRIP",
                      "const": 0,
                      "description": "Connected line segments: 0-1, 1-2, ..., (n-1)-n"
                    },
                    {
                      "title": "LINE_LOOP",
                      "const": 1,
                      "description": "Closed polygon: 0-1, 1-2, ..., (n-1)-n, n-0"
                    },
                    {
                      "title": "LINE_LIST",
                      "const": 2,
                      "description": "Individual line segments: 0-1, 2-3, 4-5, ..."
                    }
                  ]
                },
                "pose": {
                  "title": "foxglove.Pose",
                  "description": "Origin of lines relative to reference frame",
                  "type": "object",
                  "properties": {
                    "position": {
                      "title": "foxglove.Vector3",
                      "description": "Point denoting position in 3D space",
                      "type": "object",
                      "properties": {
                        "x": {
                          "type": "number",
                          "description": "x coordinate length"
                        },
                        "y": {
                          "type": "number",
                          "description": "y coordinate length"
                        },
                        "z": {
                          "type": "number",
                          "description": "z coordinate length"
                        }
                      },
                      "required": [
                        "x",
                        "y",
                        "z"
                      ]
                    },
                    "orientation": {
                      "title": "foxglove.Quaternion",
                      "description": "Quaternion denoting orientation in 3D space",
                      "type": "object",
                      "properties": {
                        "x": {
                          "type": "number",
                          "description": "x value"
                        },
                        "y": {
                          "type": "number",
                          "description": "y value"
                        },
                        "z": {
                          "type": "number",
                          "description": "z value"
                        },
                        "w": {
                          "type": "number",
                          "description": "w value"
                        }
                      },
                      "required": [
                        "x",
                        "y",
                        "z",
                        "w"
                      ]
                    }
                  },
                  "required": [
                    "position",
                    "orientation"
                  ]
                },
                "thickness": {
                  "type": "number",
                  "description": "Line thickness"
                },
                "scale_invariant": {
                  "type": "boolean",
                  "description": "Indicates whether `thickness` is a fixed size in screen pixels (true), or specified in world coordinates and scales with distance from the camera (false)"
                },
                "points": {
                  "type": "array",
                  "items": {
                    "title": "foxglove.Point3",
                    "description": "A point representing a position in 3D space",
                    "type": "object",
                    "properties": {
                      "x": {
                        "type": "number",
                        "description": "x coordinate position"
                      },
                      "y": {
                        "type": "number",
                        "description": "y coordinate position"
                      },
                      "z": {
                        "type": "number",
                        "description": "z coordinate position"
                      }
                    },
                    "required": [
                      "x",
                      "y",
                      "z"
                    ]
                  },
                  "description": "Points along the line"
                },
                "color": {
                  "title": "foxglove.Color",
                  "description": "Solid color to use for the whole line. One of `color` or `colors` must be provided.",
                  "type": "object",
                  "properties": {
                    "r": {
                      "type": "number",
                      "description": "Red value between 0 and 1"
                    },
                    "g": {
                      "type": "number",
                      "description": "Green value between 0 and 1"
                    },
                    "b": {
                      "type": "number",
                      "description": "Blue value between 0 and 1"
                    },
                    "a": {
                      "type": "number",
                      "description": "Alpha value between 0 and 1"
                    }
                  },
                  "required": [
                    "r",
                    "g",
                    "b",
                    "a"
                  ]
                },
                "colors": {
                  "type": "array",
                  "items": {
                    "title": "foxglove.Color",
                    "description": "A color in RGBA format",
                    "type": "object",
                    "properties": {
                      "r": {
                        "type": "number",
                        "description": "Red value between 0 and 1"
                      },
                      "g": {
                        "type": "number",
                        "description": "Green value between 0 and 1"
                      },
                      "b": {
                        "type": "number",
                        "description": "Blue value between 0 and 1"
                      },
                      "a": {
                        "type": "number",
                        "description": "Alpha value between 0 and 1"
                      }
                    },
                    "required": [
                      "r",
                      "g",
                      "b",
                      "a"
                    ]
                  },
                  "description": "Per-point colors (if specified, must have the same length as `points`). One of `color` or `colors` must be provided."
                },
                "indices": {
                  "type": "array",
                  "items": {
                    "type": "integer",
                    "minimum": 0
                  },
                  "description": "Indices into the `points` and `colors` attribute arrays, which can be used to avoid duplicating attribute data.\n\nIf omitted or empty, indexing will not be used. This default behavior is equivalent to specifying [0, 1, ..., N-1] for the indices (where N is the number of `points` provided)."
                }
              },
              "required": [
                "type",
                "pose",
                "thickness",
                "scale_invariant",
                "points",
                "color",
                "colors",
                "indices"
              ]
            },
            "description": "Line primitives"
          },
          "triangles": {
            "type": "array",
            "items": {
              "title": "foxglove.TriangleListPrimitive",
              "description": "A primitive representing a set of triangles or a surface tiled by triangles",
              "type": "object",
              "properties": {
                "pose": {
                  "title": "foxglove.Pose",
                  "description": "Origin of triangles relative to reference frame",
                  "type": "object",
                  "properties": {
                    "position": {
                      "title": "foxglove.Vector3",
                      "description": "Point denoting position in 3D space",
                      "type": "object",
                      "properties": {
                        "x": {
                          "type": "number",
                          "description": "x coordinate length"
                        },
                        "y": {
                          "type": "number",
                          "description": "y coordinate length"
                        },
                        "z": {
                          "type": "number",
                          "description": "z coordinate length"
                        }
                      },
                      "required": [
                        "x",
                        "y",
                        "z"
                      ]
                    },
                    "orientation": {
                      "title": "foxglove.Quaternion",
                      "description": "Quaternion denoting orientation in 3D space",
                      "type": "object",
                      "properties": {
                        "x": {
                          "type": "number",
                          "description": "x value"
                        },
                        "y": {
                          "type": "number",
                          "description": "y value"
                        },
                        "z": {
                          "type": "number",
                          "description": "z value"
                        },
                        "w": {
                          "type": "number",
                          "description": "w value"
                        }
                      },
                      "required": [
                        "x",
                        "y",
                        "z",
                        "w"
                      ]
                    }
                  },
                  "required": [
                    "position",
                    "orientation"
                  ]
                },
                "points": {
                  "type": "array",
                  "items": {
                    "title": "foxglove.Point3",
                    "description": "A point representing a position in 3D space",
                    "type": "object",
                    "properties": {
                      "x": {
                        "type": "number",
                        "description": "x coordinate position"
                      },
                      "y": {
                        "type": "number",
                        "description": "y coordinate position"
                      },
                      "z": {
                        "type": "number",
                        "description": "z coordinate position"
                      }
                    },
                    "required": [
                      "x",
                      "y",
                      "z"
                    ]
                  },
                  "description": "Vertices to use for triangles, interpreted as a list of triples (0-1-2, 3-4-5, ...)"
                },
                "color": {
                  "title": "foxglove.Color",
                  "description": "Solid color to use for the whole shape. One of `color` or `colors` must be provided.",
                  "type": "object",
                  "properties": {
                    "r": {
                      "type": "number",
                      "description": "Red value between 0 and 1"
                    },
                    "g": {
                      "type": "number",
                      "description": "Green value between 0 and 1"
                    },
                    "b": {
                      "type": "number",
                      "description": "Blue value between 0 and 1"
                    },
                    "a": {
                      "type": "number",
                      "description": "Alpha value between 0 and 1"
                    }
                  },
                  "required": [
                    "r",
                    "g",
                    "b",
                    "a"
                  ]
                },
                "colors": {
                  "type": "array",
                  "items": {
                    "title": "foxglove.Color",
                    "description": "A color in RGBA format",
                    "type": "object",
                    "properties": {
                      "r": {
                        "type": "number",
                        "description": "Red value between 0 and 1"
                      },
                      "g": {
                        "type": "number",
                        "description": "Green value between 0 and 1"
                      },
                      "b": {
                        "type": "number",
                        "description": "Blue value between 0 and 1"
                      },
                      "a": {
                        "type": "number",
                        "description": "Alpha value between 0 and 1"
                      }
                    },
                    "required": [
                      "r",
                      "g",
                      "b",
                      "a"
                    ]
                  },
                  "description": "Per-vertex colors (if specified, must have the same length as `points`). One of `color` or `colors` must be provided."
                },
                "indices": {
                  "type": "array",
                  "items": {
                    "type": "integer",
                    "minimum": 0
                  },
                  "description": "Indices into the `points` and `colors` attribute arrays, which can be used to avoid duplicating attribute data.\n\nIf omitted or empty, indexing will not be used. This default behavior is equivalent to specifying [0, 1, ..., N-1] for the indices (where N is the number of `points` provided)."
                }
              },
              "required": [
                "pose",
                "points",
                "color",
                "colors",
                "indices"
              ]
            },
            "description": "Triangle list primitives"
          },
          "texts": {
            "type": "array",
            "items": {
              "title": "foxglove.TextPrimitive",
              "description": "A primitive representing a text label",
              "type": "object",
              "properties": {
                "pose": {
                  "title": "foxglove.Pose",
                  "description": "Position of the center of the text box and orientation of the text. Identity orientation means the text is oriented in the xy-plane and flows from -x to +x.",
                  "type": "object",
                  "properties": {
                    "position": {
                      "title": "foxglove.Vector3",
                      "description": "Point denoting position in 3D space",
                      "type": "object",
                      "properties": {
                        "x": {
                          "type": "number",
                          "description": "x coordinate length"
                        },
                        "y": {
                          "type": "number",
                          "description": "y coordinate length"
                        },
                        "z": {
                          "type": "number",
                          "description": "z coordinate length"
                        }
                      },
                      "required": [
                        "x",
                        "y",
                        "z"
                      ]
                    },
                    "orientation": {
                      "title": "foxglove.Quaternion",
                      "description": "Quaternion denoting orientation in 3D space",
                      "type": "object",
                      "properties": {
                        "x": {
                          "type": "number",
                          "description": "x value"
                        },
                        "y": {
                          "type": "number",
                          "description": "y value"
                        },
                        "z": {
                          "type": "number",
                          "description": "z value"
                        },
                        "w": {
                          "type": "number",
                          "description": "w value"
                        }
                      },
                      "required": [
                        "x",
                        "y",
                        "z",
                        "w"
                      ]
                    }
                  },
                  "required": [
                    "position",
                    "orientation"
                  ]
                },
                "billboard": {
                  "type": "boolean",
                  "description": "Whether the text should respect `pose.orientation` (false) or always face the camera (true)"
                },
                "font_size": {
                  "type": "number",
                  "description": "Font size (height of one line of text)"
                },
                "scale_invariant": {
                  "type": "boolean",
                  "description": "Indicates whether `font_size` is a fixed size in screen pixels (true), or specified in world coordinates and scales with distance from the camera (false)"
                },
                "color": {
                  "title": "foxglove.Color",
                  "description": "Color of the text",
                  "type": "object",
                  "properties": {
                    "r": {
                      "type": "number",
                      "description": "Red value between 0 and 1"
                    },
                    "g": {
                      "type": "number",
                      "description": "Green value between 0 and 1"
                    },
                    "b": {
                      "type": "number",
                      "description": "Blue value between 0 and 1"
                    },
                    "a": {
                      "type": "number",
                      "description": "Alpha value between 0 and 1"
                    }
                  },
                  "required": [
                    "r",
                    "g",
                    "b",
                    "a"
                  ]
                },
                "text": {
                  "type": "string",
                  "description": "Text"
                }
              },
              "required": [
                "pose",
                "billboard",
                "font_size",
                "scale_invariant",
                "color",
                "text"
              ]
            },
            "description": "Text primitives"
          },
          "models": {
            "type": "array",
            "items": {
              "title": "foxglove.ModelPrimitive",
              "description": "A primitive representing a 3D model file loaded from an external URL or embedded data",
              "type": "object",
              "properties": {
                "pose": {
                  "title": "foxglove.Pose",
                  "description": "Origin of model relative to reference frame",
                  "type": "object",
                  "properties": {
                    "position": {
                      "title": "foxglove.Vector3",
                      "description": "Point denoting position in 3D space",
                      "type": "object",
                      "properties": {
                        "x": {
                          "type": "number",
                          "description": "x coordinate length"
                        },
                        "y": {
                          "type": "number",
                          "description": "y coordinate length"
                        },
                        "z": {
                          "type": "number",
                          "description": "z coordinate length"
                        }
                      },
                      "required": [
                        "x",
                        "y",
                        "z"
                      ]
                    },
                    "orientation": {
                      "title": "foxglove.Quaternion",
                      "description": "Quaternion denoting orientation in 3D space",
                      "type": "object",
                      "properties": {
                        "x": {
                          "type": "number",
                          "description": "x value"
                        },
                        "y": {
                          "type": "number",
                          "description": "y value"
                        },
                        "z": {
                          "type": "number",
                          "description": "z value"
                        },
                        "w": {
                          "type": "number",
                          "description": "w value"
                        }
                      },
                      "required": [
                        "x",
                        "y",
                        "z",
                        "w"
                      ]
                    }
                  },
                  "required": [
                    "position",
                    "orientation"
                  ]
                },
                "scale": {
                  "title": "foxglove.Vector3",
                  "description": "Scale factor to apply to the model along each axis",
                  "type": "object",
                  "properties": {
                    "x": {
                      "type": "number",
                      "description": "x coordinate length"
                    },
                    "y": {
                      "type": "number",
                      "description": "y coordinate length"
                    },
                    "z": {
                      "type": "number",
                      "description": "z coordinate length"
                    }
                  },
                  "required": [
                    "x",
                    "y",
                    "z"
                  ]
                },
                "color": {
                  "title": "foxglove.Color",
                  "description": "Solid color to use for the whole model if `override_color` is true.",
                  "type": "object",
                  "properties": {
                    "r": {
                      "type": "number",
                      "description": "Red value between 0 and 1"
                    },
                    "g": {
                      "type": "number",
                      "description": "Green value between 0 and 1"
                    },
                    "b": {
                      "type": "number",
                      "description": "Blue value between 0 and 1"
                    },
                    "a": {
                      "type": "number",
                      "description": "Alpha value between 0 and 1"
                    }
                  },
                  "required": [
                    "r",
                    "g",
                    "b",
                    "a"
                  ]
                },
                "override_color": {
                  "type": "boolean",
                  "description": "Whether to use the color specified in `color` instead of any materials embedded in the original model."
                },
                "url": {
                  "type": "string",
                  "description": "URL pointing to model file. One of `url` or `data` should be provided."
                },
                "media_type": {
                  "type": "string",
                  "description": "[Media type](https://developer.mozilla.org/en-US/docs/Web/HTTP/Basics_of_HTTP/MIME_types) of embedded model (e.g. `model/gltf-binary`). Required if `data` is provided instead of `url`. Overrides the inferred media type if `url` is provided."
                },
                "data": {
                  "type": "string",
                  "contentEncoding": "base64",
                  "description": "Embedded model. One of `url` or `data` should be provided. If `data` is provided, `media_type` must be set to indicate the type of the data."
                }
              },
              "required": [
                "pose",
                "scale",
                "color",
                "override_color",
                "url",
                "media_type",
                "data"
              ]
            },
            "description": "Model primitives"
          }
        },
        "required": [
          "timestamp",
          "frame_id",
          "id",
          "lifetime",
          "frame_locked",
          "metadata",
          "arrows",
          "cubes",
          "spheres",
          "cylinders",
          "lines",
          "triangles",
          "texts",
          "models"
        ]
      },
      "description": "Scene entities to add or replace"
    }
  },
  "required": [
    "deletions",
    "entities"
  ]
};

export const ModelPrimitive = {
  "title": "foxglove.ModelPrimitive",
  "description": "A primitive representing a 3D model file loaded from an external URL or embedded data",
  "$comment": "Generated by https://github.com/foxglove/foxglove-sdk",
  "type": "object",
  "properties": {
    "pose": {
      "title": "foxglove.Pose",
      "description": "Origin of model relative to reference frame",
      "type": "object",
      "properties": {
        "position": {
          "title": "foxglove.Vector3",
          "description": "Point denoting position in 3D space",
          "type": "object",
          "properties": {
            "x": {
              "type": "number",
              "description": "x coordinate length"
            },
            "y": {
              "type": "number",
              "description": "y coordinate length"
            },
            "z": {
              "type": "number",
              "description": "z coordinate length"
            }
          },
          "required": [
            "x",
            "y",
            "z"
          ]
        },
        "orientation": {
          "title": "foxglove.Quaternion",
          "description": "Quaternion denoting orientation in 3D space",
          "type": "object",
          "properties": {
            "x": {
              "type": "number",
              "description": "x value"
            },
            "y": {
              "type": "number",
              "description": "y value"
            },
            "z": {
              "type": "number",
              "description": "z value"
            },
            "w": {
              "type": "number",
              "description": "w value"
            }
          },
          "required": [
            "x",
            "y",
            "z",
            "w"
          ]
        }
      },
      "required": [
        "position",
        "orientation"
      ]
    },
    "scale": {
      "title": "foxglove.Vector3",
      "description": "Scale factor to apply to the model along each axis",
      "type": "object",
      "properties": {
        "x": {
          "type": "number",
          "description": "x coordinate length"
        },
        "y": {
          "type": "number",
          "description": "y coordinate length"
        },
        "z": {
          "type": "number",
          "description": "z coordinate length"
        }
      },
      "required": [
        "x",
        "y",
        "z"
      ]
    },
    "color": {
      "title": "foxglove.Color",
      "description": "Solid color to use for the whole model if `override_color` is true.",
      "type": "object",
      "properties": {
        "r": {
          "type": "number",
          "description": "Red value between 0 and 1"
        },
        "g": {
          "type": "number",
          "description": "Green value between 0 and 1"
        },
        "b": {
          "type": "number",
          "description": "Blue value between 0 and 1"
        },
        "a": {
          "type": "number",
          "description": "Alpha value between 0 and 1"
        }
      },
      "required": [
        "r",
        "g",
        "b",
        "a"
      ]
    },
    "override_color": {
      "type": "boolean",
      "description": "Whether to use the color specified in `color` instead of any materials embedded in the original model."
    },
    "url": {
      "type": "string",
      "description": "URL pointing to model file. One of `url` or `data` should be provided."
    },
    "media_type": {
      "type": "string",
      "description": "[Media type](https://developer.mozilla.org/en-US/docs/Web/HTTP/Basics_of_HTTP/MIME_types) of embedded model (e.g. `model/gltf-binary`). Required if `data` is provided instead of `url`. Overrides the inferred media type if `url` is provided."
    },
    "data": {
      "type": "string",
      "contentEncoding": "base64",
      "description": "Embedded model. One of `url` or `data` should be provided. If `data` is provided, `media_type` must be set to indicate the type of the data."
    }
  },
  "required": [
    "pose",
    "scale",
    "color",
    "override_color",
    "url",
    "media_type",
    "data"
  ]
};

export const PackedElementField = {
  "title": "foxglove.PackedElementField",
  "description": "A field present within each element in a byte array of packed elements.",
  "$comment": "Generated by https://github.com/foxglove/foxglove-sdk",
  "type": "object",
  "properties": {
    "name": {
      "type": "string",
      "description": "Name of the field"
    },
    "offset": {
      "type": "integer",
      "minimum": 0,
      "description": "Byte offset from start of data buffer"
    },
    "type": {
      "title": "foxglove.NumericType",
      "description": "Type of data in the field. Integers are stored using little-endian byte order.",
      "oneOf": [
        {
          "title": "UNKNOWN",
          "const": 0,
          "description": "Unknown numeric type"
        },
        {
          "title": "UINT8",
          "const": 1,
          "description": "Unsigned 8-bit integer"
        },
        {
          "title": "INT8",
          "const": 2,
          "description": "Signed 8-bit integer"
        },
        {
          "title": "UINT16",
          "const": 3,
          "description": "Unsigned 16-bit integer"
        },
        {
          "title": "INT16",
          "const": 4,
          "description": "Signed 16-bit integer"
        },
        {
          "title": "UINT32",
          "const": 5,
          "description": "Unsigned 32-bit integer"
        },
        {
          "title": "INT32",
          "const": 6,
          "description": "Signed 32-bit integer"
        },
        {
          "title": "FLOAT32",
          "const": 7,
          "description": "32-bit floating-point number"
        },
        {
          "title": "FLOAT64",
          "const": 8,
          "description": "64-bit floating-point number"
        }
      ]
    }
  },
  "required": [
    "name",
    "offset",
    "type"
  ]
};

export const Point2 = {
  "title": "foxglove.Point2",
  "description": "A point representing a position in 2D space",
  "$comment": "Generated by https://github.com/foxglove/foxglove-sdk",
  "type": "object",
  "properties": {
    "x": {
      "type": "number",
      "description": "x coordinate position"
    },
    "y": {
      "type": "number",
      "description": "y coordinate position"
    }
  },
  "required": [
    "x",
    "y"
  ]
};

export const Point3 = {
  "title": "foxglove.Point3",
  "description": "A point representing a position in 3D space",
  "$comment": "Generated by https://github.com/foxglove/foxglove-sdk",
  "type": "object",
  "properties": {
    "x": {
      "type": "number",
      "description": "x coordinate position"
    },
    "y": {
      "type": "number",
      "description": "y coordinate position"
    },
    "z": {
      "type": "number",
      "description": "z coordinate position"
    }
  },
  "required": [
    "x",
    "y",
    "z"
  ]
};

export const PointCloud = {
  "title": "foxglove.PointCloud",
  "description": "A collection of N-dimensional points, which may contain additional fields with information like normals, intensity, etc.",
  "$comment": "Generated by https://github.com/foxglove/foxglove-sdk",
  "type": "object",
  "properties": {
    "timestamp": {
      "type": "object",
      "title": "time",
      "properties": {
        "sec": {
          "type": "integer",
          "minimum": 0
        },
        "nsec": {
          "type": "integer",
          "minimum": 0,
          "maximum": 999999999
        }
      },
      "description": "Timestamp of point cloud"
    },
    "frame_id": {
      "type": "string",
      "description": "Frame of reference"
    },
    "pose": {
      "title": "foxglove.Pose",
      "description": "The origin of the point cloud relative to the frame of reference",
      "type": "object",
      "properties": {
        "position": {
          "title": "foxglove.Vector3",
          "description": "Point denoting position in 3D space",
          "type": "object",
          "properties": {
            "x": {
              "type": "number",
              "description": "x coordinate length"
            },
            "y": {
              "type": "number",
              "description": "y coordinate length"
            },
            "z": {
              "type": "number",
              "description": "z coordinate length"
            }
          },
          "required": [
            "x",
            "y",
            "z"
          ]
        },
        "orientation": {
          "title": "foxglove.Quaternion",
          "description": "Quaternion denoting orientation in 3D space",
          "type": "object",
          "properties": {
            "x": {
              "type": "number",
              "description": "x value"
            },
            "y": {
              "type": "number",
              "description": "y value"
            },
            "z": {
              "type": "number",
              "description": "z value"
            },
            "w": {
              "type": "number",
              "description": "w value"
            }
          },
          "required": [
            "x",
            "y",
            "z",
            "w"
          ]
        }
      },
      "required": [
        "position",
        "orientation"
      ]
    },
    "point_stride": {
      "type": "integer",
      "minimum": 0,
      "description": "Number of bytes between points in the `data`"
    },
    "fields": {
      "type": "array",
      "items": {
        "title": "foxglove.PackedElementField",
        "description": "A field present within each element in a byte array of packed elements.",
        "type": "object",
        "properties": {
          "name": {
            "type": "string",
            "description": "Name of the field"
          },
          "offset": {
            "type": "integer",
            "minimum": 0,
            "description": "Byte offset from start of data buffer"
          },
          "type": {
            "title": "foxglove.NumericType",
            "description": "Type of data in the field. Integers are stored using little-endian byte order.",
            "oneOf": [
              {
                "title": "UNKNOWN",
                "const": 0,
                "description": "Unknown numeric type"
              },
              {
                "title": "UINT8",
                "const": 1,
                "description": "Unsigned 8-bit integer"
              },
              {
                "title": "INT8",
                "const": 2,
                "description": "Signed 8-bit integer"
              },
              {
                "title": "UINT16",
                "const": 3,
                "description": "Unsigned 16-bit integer"
              },
              {
                "title": "INT16",
                "const": 4,
                "description": "Signed 16-bit integer"
              },
              {
                "title": "UINT32",
                "const": 5,
                "description": "Unsigned 32-bit integer"
              },
              {
                "title": "INT32",
                "const": 6,
                "description": "Signed 32-bit integer"
              },
              {
                "title": "FLOAT32",
                "const": 7,
                "description": "32-bit floating-point number"
              },
              {
                "title": "FLOAT64",
                "const": 8,
                "description": "64-bit floating-point number"
              }
            ]
          }
        },
        "required": [
          "name",
          "offset",
          "type"
        ]
      },
      "description": "Fields in `data`. At least 2 coordinate fields from `x`, `y`, and `z` are required for each point's position; `red`, `green`, `blue`, and `alpha` are optional for customizing each point's color."
    },
    "data": {
      "type": "string",
      "contentEncoding": "base64",
      "description": "Point data, interpreted using `fields`"
    }
  },
  "required": [
    "timestamp",
    "frame_id",
    "pose",
    "point_stride",
    "fields",
    "data"
  ]
};

export const PointsAnnotation = {
  "title": "foxglove.PointsAnnotation",
  "description": "An array of points on a 2D image",
  "$comment": "Generated by https://github.com/foxglove/foxglove-sdk",
  "type": "object",
  "properties": {
    "timestamp": {
      "type": "object",
      "title": "time",
      "properties": {
        "sec": {
          "type": "integer",
          "minimum": 0
        },
        "nsec": {
          "type": "integer",
          "minimum": 0,
          "maximum": 999999999
        }
      },
      "description": "Timestamp of annotation"
    },
    "type": {
      "title": "foxglove.PointsAnnotationType",
      "description": "Type of points annotation to draw",
      "oneOf": [
        {
          "title": "UNKNOWN",
          "const": 0,
          "description": "Unknown points annotation type"
        },
        {
          "title": "POINTS",
          "const": 1,
          "description": "Individual points: 0, 1, 2, ..."
        },
        {
          "title": "LINE_LOOP",
          "const": 2,
          "description": "Closed polygon: 0-1, 1-2, ..., (n-1)-n, n-0"
        },
        {
          "title": "LINE_STRIP",
          "const": 3,
          "description": "Connected line segments: 0-1, 1-2, ..., (n-1)-n"
        },
        {
          "title": "LINE_LIST",
          "const": 4,
          "description": "Individual line segments: 0-1, 2-3, 4-5, ..."
        }
      ]
    },
    "points": {
      "type": "array",
      "items": {
        "title": "foxglove.Point2",
        "description": "A point representing a position in 2D space",
        "type": "object",
        "properties": {
          "x": {
            "type": "number",
            "description": "x coordinate position"
          },
          "y": {
            "type": "number",
            "description": "y coordinate position"
          }
        },
        "required": [
          "x",
          "y"
        ]
      },
      "description": "Points in 2D image coordinates (pixels).\nThese coordinates use the top-left corner of the top-left pixel of the image as the origin."
    },
    "outline_color": {
      "title": "foxglove.Color",
      "description": "Outline color",
      "type": "object",
      "properties": {
        "r": {
          "type": "number",
          "description": "Red value between 0 and 1"
        },
        "g": {
          "type": "number",
          "description": "Green value between 0 and 1"
        },
        "b": {
          "type": "number",
          "description": "Blue value between 0 and 1"
        },
        "a": {
          "type": "number",
          "description": "Alpha value between 0 and 1"
        }
      },
      "required": [
        "r",
        "g",
        "b",
        "a"
      ]
    },
    "outline_colors": {
      "type": "array",
      "items": {
        "title": "foxglove.Color",
        "description": "A color in RGBA format",
        "type": "object",
        "properties": {
          "r": {
            "type": "number",
            "description": "Red value between 0 and 1"
          },
          "g": {
            "type": "number",
            "description": "Green value between 0 and 1"
          },
          "b": {
            "type": "number",
            "description": "Blue value between 0 and 1"
          },
          "a": {
            "type": "number",
            "description": "Alpha value between 0 and 1"
          }
        },
        "required": [
          "r",
          "g",
          "b",
          "a"
        ]
      },
      "description": "Per-point colors, if `type` is `POINTS`, or per-segment stroke colors, if `type` is `LINE_LIST`, `LINE_STRIP` or `LINE_LOOP`."
    },
    "fill_color": {
      "title": "foxglove.Color",
      "description": "Fill color",
      "type": "object",
      "properties": {
        "r": {
          "type": "number",
          "description": "Red value between 0 and 1"
        },
        "g": {
          "type": "number",
          "description": "Green value between 0 and 1"
        },
        "b": {
          "type": "number",
          "description": "Blue value between 0 and 1"
        },
        "a": {
          "type": "number",
          "description": "Alpha value between 0 and 1"
        }
      },
      "required": [
        "r",
        "g",
        "b",
        "a"
      ]
    },
    "thickness": {
      "type": "number",
      "description": "Stroke thickness in pixels"
    }
  },
  "required": [
    "timestamp",
    "type",
    "points",
    "outline_color",
    "outline_colors",
    "fill_color",
    "thickness"
  ]
};

export const Pose = {
  "title": "foxglove.Pose",
  "description": "A position and orientation for an object or reference frame in 3D space",
  "$comment": "Generated by https://github.com/foxglove/foxglove-sdk",
  "type": "object",
  "properties": {
    "position": {
      "title": "foxglove.Vector3",
      "description": "Point denoting position in 3D space",
      "type": "object",
      "properties": {
        "x": {
          "type": "number",
          "description": "x coordinate length"
        },
        "y": {
          "type": "number",
          "description": "y coordinate length"
        },
        "z": {
          "type": "number",
          "description": "z coordinate length"
        }
      },
      "required": [
        "x",
        "y",
        "z"
      ]
    },
    "orientation": {
      "title": "foxglove.Quaternion",
      "description": "Quaternion denoting orientation in 3D space",
      "type": "object",
      "properties": {
        "x": {
          "type": "number",
          "description": "x value"
        },
        "y": {
          "type": "number",
          "description": "y value"
        },
        "z": {
          "type": "number",
          "description": "z value"
        },
        "w": {
          "type": "number",
          "description": "w value"
        }
      },
      "required": [
        "x",
        "y",
        "z",
        "w"
      ]
    }
  },
  "required": [
    "position",
    "orientation"
  ]
};

export const PoseInFrame = {
  "title": "foxglove.PoseInFrame",
  "description": "A timestamped pose for an object or reference frame in 3D space",
  "$comment": "Generated by https://github.com/foxglove/foxglove-sdk",
  "type": "object",
  "properties": {
    "timestamp": {
      "type": "object",
      "title": "time",
      "properties": {
        "sec": {
          "type": "integer",
          "minimum": 0
        },
        "nsec": {
          "type": "integer",
          "minimum": 0,
          "maximum": 999999999
        }
      },
      "description": "Timestamp of pose"
    },
    "frame_id": {
      "type": "string",
      "description": "Frame of reference for pose position and orientation"
    },
    "pose": {
      "title": "foxglove.Pose",
      "description": "Pose in 3D space",
      "type": "object",
      "properties": {
        "position": {
          "title": "foxglove.Vector3",
          "description": "Point denoting position in 3D space",
          "type": "object",
          "properties": {
            "x": {
              "type": "number",
              "description": "x coordinate length"
            },
            "y": {
              "type": "number",
              "description": "y coordinate length"
            },
            "z": {
              "type": "number",
              "description": "z coordinate length"
            }
          },
          "required": [
            "x",
            "y",
            "z"
          ]
        },
        "orientation": {
          "title": "foxglove.Quaternion",
          "description": "Quaternion denoting orientation in 3D space",
          "type": "object",
          "properties": {
            "x": {
              "type": "number",
              "description": "x value"
            },
            "y": {
              "type": "number",
              "description": "y value"
            },
            "z": {
              "type": "number",
              "description": "z value"
            },
            "w": {
              "type": "number",
              "description": "w value"
            }
          },
          "required": [
            "x",
            "y",
            "z",
            "w"
          ]
        }
      },
      "required": [
        "position",
        "orientation"
      ]
    }
  },
  "required": [
    "timestamp",
    "frame_id",
    "pose"
  ]
};

export const PosesInFrame = {
  "title": "foxglove.PosesInFrame",
  "description": "An array of timestamped poses for an object or reference frame in 3D space",
  "$comment": "Generated by https://github.com/foxglove/foxglove-sdk",
  "type": "object",
  "properties": {
    "timestamp": {
      "type": "object",
      "title": "time",
      "properties": {
        "sec": {
          "type": "integer",
          "minimum": 0
        },
        "nsec": {
          "type": "integer",
          "minimum": 0,
          "maximum": 999999999
        }
      },
      "description": "Timestamp of pose"
    },
    "frame_id": {
      "type": "string",
      "description": "Frame of reference for pose position and orientation"
    },
    "poses": {
      "type": "array",
      "items": {
        "title": "foxglove.Pose",
        "description": "A position and orientation for an object or reference frame in 3D space",
        "type": "object",
        "properties": {
          "position": {
            "title": "foxglove.Vector3",
            "description": "Point denoting position in 3D space",
            "type": "object",
            "properties": {
              "x": {
                "type": "number",
                "description": "x coordinate length"
              },
              "y": {
                "type": "number",
                "description": "y coordinate length"
              },
              "z": {
                "type": "number",
                "description": "z coordinate length"
              }
            },
            "required": [
              "x",
              "y",
              "z"
            ]
          },
          "orientation": {
            "title": "foxglove.Quaternion",
            "description": "Quaternion denoting orientation in 3D space",
            "type": "object",
            "properties": {
              "x": {
                "type": "number",
                "description": "x value"
              },
              "y": {
                "type": "number",
                "description": "y value"
              },
              "z": {
                "type": "number",
                "description": "z value"
              },
              "w": {
                "type": "number",
                "description": "w value"
              }
            },
            "required": [
              "x",
              "y",
              "z",
              "w"
            ]
          }
        },
        "required": [
          "position",
          "orientation"
        ]
      },
      "description": "Poses in 3D space"
    }
  },
  "required": [
    "timestamp",
    "frame_id",
    "poses"
  ]
};

export const Quaternion = {
  "title": "foxglove.Quaternion",
  "description": "A [quaternion](https://eater.net/quaternions) representing a rotation in 3D space",
  "$comment": "Generated by https://github.com/foxglove/foxglove-sdk",
  "type": "object",
  "properties": {
    "x": {
      "type": "number",
      "description": "x value"
    },
    "y": {
      "type": "number",
      "description": "y value"
    },
    "z": {
      "type": "number",
      "description": "z value"
    },
    "w": {
      "type": "number",
      "description": "w value"
    }
  },
  "required": [
    "x",
    "y",
    "z",
    "w"
  ]
};

export const RawAudio = {
  "title": "foxglove.RawAudio",
  "description": "A single block of an audio bitstream",
  "$comment": "Generated by https://github.com/foxglove/foxglove-sdk",
  "type": "object",
  "properties": {
    "timestamp": {
      "type": "object",
      "title": "time",
      "properties": {
        "sec": {
          "type": "integer",
          "minimum": 0
        },
        "nsec": {
          "type": "integer",
          "minimum": 0,
          "maximum": 999999999
        }
      },
      "description": "Timestamp of the start of the audio block"
    },
    "data": {
      "type": "string",
      "contentEncoding": "base64",
      "description": "Audio data. The samples in the data must be interleaved and little-endian"
    },
    "format": {
      "type": "string",
      "description": "Audio format. Only 'pcm-s16' is currently supported"
    },
    "sample_rate": {
      "type": "integer",
      "minimum": 0,
      "description": "Sample rate in Hz"
    },
    "number_of_channels": {
      "type": "integer",
      "minimum": 0,
      "description": "Number of channels in the audio block"
    }
  },
  "required": [
    "timestamp",
    "data",
    "format",
    "sample_rate",
    "number_of_channels"
  ]
};

export const RawImage = {
  "title": "foxglove.RawImage",
  "description": "A raw image",
  "$comment": "Generated by https://github.com/foxglove/foxglove-sdk",
  "type": "object",
  "properties": {
    "timestamp": {
      "type": "object",
      "title": "time",
      "properties": {
        "sec": {
          "type": "integer",
          "minimum": 0
        },
        "nsec": {
          "type": "integer",
          "minimum": 0,
          "maximum": 999999999
        }
      },
      "description": "Timestamp of image"
    },
    "frame_id": {
      "type": "string",
      "description": "Frame of reference for the image. The origin of the frame is the optical center of the camera. +x points to the right in the image, +y points down, and +z points into the plane of the image."
    },
    "width": {
      "type": "integer",
      "minimum": 0,
      "description": "Image width in pixels"
    },
    "height": {
      "type": "integer",
      "minimum": 0,
      "description": "Image height in pixels"
    },
    "encoding": {
      "type": "string",
      "description": "Encoding of the raw image data. See the `data` field description for supported values."
    },
    "step": {
      "type": "integer",
      "minimum": 0,
      "description": "Byte length of a single row. This is usually some multiple of `width` depending on the encoding, but can be greater to incorporate padding."
    },
    "data": {
      "type": "string",
      "contentEncoding": "base64",
      "description": "Raw image data.\n\nFor each `encoding` value, the `data` field contains image pixel data serialized as follows:\n\n- `yuv422` or `uyvy`:\n  - Pixel colors are decomposed into [Y'UV](https://en.wikipedia.org/wiki/Y%E2%80%B2UV) channels.\n  - Pixel channel values are represented as unsigned 8-bit integers.\n  - U and V values are shared between horizontal pairs of pixels. Each pair of output pixels is serialized as [U, Y1, V, Y2].\n  - `step` must be greater than or equal to `width` * 2.\n- `yuv422_yuy2` or  `yuyv`:\n  - Pixel colors are decomposed into [Y'UV](https://en.wikipedia.org/wiki/Y%E2%80%B2UV) channels.\n  - Pixel channel values are represented as unsigned 8-bit integers.\n  - U and V values are shared between horizontal pairs of pixels. Each pair of output pixels is encoded as [Y1, U, Y2, V].\n  - `step` must be greater than or equal to `width` * 2.\n- `rgb8`:\n  - Pixel colors are decomposed into Red, Green, and Blue channels.\n  - Pixel channel values are represented as unsigned 8-bit integers.\n  - Each output pixel is serialized as [R, G, B].\n  - `step` must be greater than or equal to `width` * 3.\n- `rgba8`:\n  - Pixel colors are decomposed into Red, Green, Blue, and Alpha channels.\n  - Pixel channel values are represented as unsigned 8-bit integers.\n  - Each output pixel is serialized as [R, G, B, Alpha].\n  - `step` must be greater than or equal to `width` * 4.\n- `bgr8` or `8UC3`:\n  - Pixel colors are decomposed into Blue, Green, and Red channels.\n  - Pixel channel values are represented as unsigned 8-bit integers.\n  - Each output pixel is serialized as [B, G, R].\n  - `step` must be greater than or equal to `width` * 3.\n- `bgra8`:\n  - Pixel colors are decomposed into Blue, Green, Red, and Alpha channels.\n  - Pixel channel values are represented as unsigned 8-bit integers.\n  - Each output pixel is encoded as [B, G, R, Alpha].\n  - `step` must be greater than or equal to `width` * 4.\n- `32FC1`:\n  - Pixel brightness is represented as a single-channel, 32-bit little-endian IEEE 754 floating-point value, ranging from 0.0 (black) to 1.0 (white).\n  - `step` must be greater than or equal to `width` * 4.\n- `bayer_rggb8`, `bayer_bggr8`, `bayer_gbrg8`, or `bayer_grbg8`:\n  - Pixel colors are decomposed into Red, Blue and Green channels.\n  - Pixel channel values are represented as unsigned 8-bit integers, and serialized in a 2x2 bayer filter pattern.\n  - The order of the four letters after `bayer_` determine the layout, so for `bayer_wxyz8` the pattern is:\n  ```plaintext\n  w | x\n  - + -\n  y | z\n  ```\n  - `step` must be greater than or equal to `width`.\n- `mono8` or `8UC1`:\n  - Pixel brightness is represented as unsigned 8-bit integers.\n  - `step` must be greater than or equal to `width`.\n- `mono16` or `16UC1`:\n  - Pixel brightness is represented as 16-bit unsigned little-endian integers. Rendering of these values is controlled in [Image panel color mode settings](https://docs.foxglove.dev/docs/visualization/panels/image#general).\n  - `step` must be greater than or equal to `width` * 2.\n"
    }
  },
  "required": [
    "timestamp",
    "frame_id",
    "width",
    "height",
    "encoding",
    "step",
    "data"
  ]
};

export const SpherePrimitive = {
  "title": "foxglove.SpherePrimitive",
  "description": "A primitive representing a sphere or ellipsoid",
  "$comment": "Generated by https://github.com/foxglove/foxglove-sdk",
  "type": "object",
  "properties": {
    "pose": {
      "title": "foxglove.Pose",
      "description": "Position of the center of the sphere and orientation of the sphere",
      "type": "object",
      "properties": {
        "position": {
          "title": "foxglove.Vector3",
          "description": "Point denoting position in 3D space",
          "type": "object",
          "properties": {
            "x": {
              "type": "number",
              "description": "x coordinate length"
            },
            "y": {
              "type": "number",
              "description": "y coordinate length"
            },
            "z": {
              "type": "number",
              "description": "z coordinate length"
            }
          },
          "required": [
            "x",
            "y",
            "z"
          ]
        },
        "orientation": {
          "title": "foxglove.Quaternion",
          "description": "Quaternion denoting orientation in 3D space",
          "type": "object",
          "properties": {
            "x": {
              "type": "number",
              "description": "x value"
            },
            "y": {
              "type": "number",
              "description": "y value"
            },
            "z": {
              "type": "number",
              "description": "z value"
            },
            "w": {
              "type": "number",
              "description": "w value"
            }
          },
          "required": [
            "x",
            "y",
            "z",
            "w"
          ]
        }
      },
      "required": [
        "position",
        "orientation"
      ]
    },
    "size": {
      "title": "foxglove.Vector3",
      "description": "Size (diameter) of the sphere along each axis",
      "type": "object",
      "properties": {
        "x": {
          "type": "number",
          "description": "x coordinate length"
        },
        "y": {
          "type": "number",
          "description": "y coordinate length"
        },
        "z": {
          "type": "number",
          "description": "z coordinate length"
        }
      },
      "required": [
        "x",
        "y",
        "z"
      ]
    },
    "color": {
      "title": "foxglove.Color",
      "description": "Color of the sphere",
      "type": "object",
      "properties": {
        "r": {
          "type": "number",
          "description": "Red value between 0 and 1"
        },
        "g": {
          "type": "number",
          "description": "Green value between 0 and 1"
        },
        "b": {
          "type": "number",
          "description": "Blue value between 0 and 1"
        },
        "a": {
          "type": "number",
          "description": "Alpha value between 0 and 1"
        }
      },
      "required": [
        "r",
        "g",
        "b",
        "a"
      ]
    }
  },
  "required": [
    "pose",
    "size",
    "color"
  ]
};

export const TextAnnotation = {
  "title": "foxglove.TextAnnotation",
  "description": "A text label on a 2D image",
  "$comment": "Generated by https://github.com/foxglove/foxglove-sdk",
  "type": "object",
  "properties": {
    "timestamp": {
      "type": "object",
      "title": "time",
      "properties": {
        "sec": {
          "type": "integer",
          "minimum": 0
        },
        "nsec": {
          "type": "integer",
          "minimum": 0,
          "maximum": 999999999
        }
      },
      "description": "Timestamp of annotation"
    },
    "position": {
      "title": "foxglove.Point2",
      "description": "Bottom-left origin of the text label in 2D image coordinates (pixels).\nThe coordinate uses the top-left corner of the top-left pixel of the image as the origin.",
      "type": "object",
      "properties": {
        "x": {
          "type": "number",
          "description": "x coordinate position"
        },
        "y": {
          "type": "number",
          "description": "y coordinate position"
        }
      },
      "required": [
        "x",
        "y"
      ]
    },
    "text": {
      "type": "string",
      "description": "Text to display"
    },
    "font_size": {
      "type": "number",
      "description": "Font size in pixels"
    },
    "text_color": {
      "title": "foxglove.Color",
      "description": "Text color",
      "type": "object",
      "properties": {
        "r": {
          "type": "number",
          "description": "Red value between 0 and 1"
        },
        "g": {
          "type": "number",
          "description": "Green value between 0 and 1"
        },
        "b": {
          "type": "number",
          "description": "Blue value between 0 and 1"
        },
        "a": {
          "type": "number",
          "description": "Alpha value between 0 and 1"
        }
      },
      "required": [
        "r",
        "g",
        "b",
        "a"
      ]
    },
    "background_color": {
      "title": "foxglove.Color",
      "description": "Background fill color",
      "type": "object",
      "properties": {
        "r": {
          "type": "number",
          "description": "Red value between 0 and 1"
        },
        "g": {
          "type": "number",
          "description": "Green value between 0 and 1"
        },
        "b": {
          "type": "number",
          "description": "Blue value between 0 and 1"
        },
        "a": {
          "type": "number",
          "description": "Alpha value between 0 and 1"
        }
      },
      "required": [
        "r",
        "g",
        "b",
        "a"
      ]
    }
  },
  "required": [
    "timestamp",
    "position",
    "text",
    "font_size",
    "text_color",
    "background_color"
  ]
};

export const TextPrimitive = {
  "title": "foxglove.TextPrimitive",
  "description": "A primitive representing a text label",
  "$comment": "Generated by https://github.com/foxglove/foxglove-sdk",
  "type": "object",
  "properties": {
    "pose": {
      "title": "foxglove.Pose",
      "description": "Position of the center of the text box and orientation of the text. Identity orientation means the text is oriented in the xy-plane and flows from -x to +x.",
      "type": "object",
      "properties": {
        "position": {
          "title": "foxglove.Vector3",
          "description": "Point denoting position in 3D space",
          "type": "object",
          "properties": {
            "x": {
              "type": "number",
              "description": "x coordinate length"
            },
            "y": {
              "type": "number",
              "description": "y coordinate length"
            },
            "z": {
              "type": "number",
              "description": "z coordinate length"
            }
          },
          "required": [
            "x",
            "y",
            "z"
          ]
        },
        "orientation": {
          "title": "foxglove.Quaternion",
          "description": "Quaternion denoting orientation in 3D space",
          "type": "object",
          "properties": {
            "x": {
              "type": "number",
              "description": "x value"
            },
            "y": {
              "type": "number",
              "description": "y value"
            },
            "z": {
              "type": "number",
              "description": "z value"
            },
            "w": {
              "type": "number",
              "description": "w value"
            }
          },
          "required": [
            "x",
            "y",
            "z",
            "w"
          ]
        }
      },
      "required": [
        "position",
        "orientation"
      ]
    },
    "billboard": {
      "type": "boolean",
      "description": "Whether the text should respect `pose.orientation` (false) or always face the camera (true)"
    },
    "font_size": {
      "type": "number",
      "description": "Font size (height of one line of text)"
    },
    "scale_invariant": {
      "type": "boolean",
      "description": "Indicates whether `font_size` is a fixed size in screen pixels (true), or specified in world coordinates and scales with distance from the camera (false)"
    },
    "color": {
      "title": "foxglove.Color",
      "description": "Color of the text",
      "type": "object",
      "properties": {
        "r": {
          "type": "number",
          "description": "Red value between 0 and 1"
        },
        "g": {
          "type": "number",
          "description": "Green value between 0 and 1"
        },
        "b": {
          "type": "number",
          "description": "Blue value between 0 and 1"
        },
        "a": {
          "type": "number",
          "description": "Alpha value between 0 and 1"
        }
      },
      "required": [
        "r",
        "g",
        "b",
        "a"
      ]
    },
    "text": {
      "type": "string",
      "description": "Text"
    }
  },
  "required": [
    "pose",
    "billboard",
    "font_size",
    "scale_invariant",
    "color",
    "text"
  ]
};

export const Timestamp = {
  "title": "foxglove.Timestamp",
  "description": "A timestamp composed of seconds and nanoseconds",
  "$comment": "Generated by https://github.com/foxglove/foxglove-sdk",
  "type": "object",
  "properties": {
    "sec": {
      "type": "integer",
      "minimum": 0,
      "description": "The number of seconds since a user-defined epoch"
    },
    "nsec": {
      "type": "integer",
      "minimum": 0,
      "description": "The number of nanoseconds since the sec value"
    }
  },
  "required": [
    "sec",
    "nsec"
  ]
};

export const TriangleListPrimitive = {
  "title": "foxglove.TriangleListPrimitive",
  "description": "A primitive representing a set of triangles or a surface tiled by triangles",
  "$comment": "Generated by https://github.com/foxglove/foxglove-sdk",
  "type": "object",
  "properties": {
    "pose": {
      "title": "foxglove.Pose",
      "description": "Origin of triangles relative to reference frame",
      "type": "object",
      "properties": {
        "position": {
          "title": "foxglove.Vector3",
          "description": "Point denoting position in 3D space",
          "type": "object",
          "properties": {
            "x": {
              "type": "number",
              "description": "x coordinate length"
            },
            "y": {
              "type": "number",
              "description": "y coordinate length"
            },
            "z": {
              "type": "number",
              "description": "z coordinate length"
            }
          },
          "required": [
            "x",
            "y",
            "z"
          ]
        },
        "orientation": {
          "title": "foxglove.Quaternion",
          "description": "Quaternion denoting orientation in 3D space",
          "type": "object",
          "properties": {
            "x": {
              "type": "number",
              "description": "x value"
            },
            "y": {
              "type": "number",
              "description": "y value"
            },
            "z": {
              "type": "number",
              "description": "z value"
            },
            "w": {
              "type": "number",
              "description": "w value"
            }
          },
          "required": [
            "x",
            "y",
            "z",
            "w"
          ]
        }
      },
      "required": [
        "position",
        "orientation"
      ]
    },
    "points": {
      "type": "array",
      "items": {
        "title": "foxglove.Point3",
        "description": "A point representing a position in 3D space",
        "type": "object",
        "properties": {
          "x": {
            "type": "number",
            "description": "x coordinate position"
          },
          "y": {
            "type": "number",
            "description": "y coordinate position"
          },
          "z": {
            "type": "number",
            "description": "z coordinate position"
          }
        },
        "required": [
          "x",
          "y",
          "z"
        ]
      },
      "description": "Vertices to use for triangles, interpreted as a list of triples (0-1-2, 3-4-5, ...)"
    },
    "color": {
      "title": "foxglove.Color",
      "description": "Solid color to use for the whole shape. One of `color` or `colors` must be provided.",
      "type": "object",
      "properties": {
        "r": {
          "type": "number",
          "description": "Red value between 0 and 1"
        },
        "g": {
          "type": "number",
          "description": "Green value between 0 and 1"
        },
        "b": {
          "type": "number",
          "description": "Blue value between 0 and 1"
        },
        "a": {
          "type": "number",
          "description": "Alpha value between 0 and 1"
        }
      },
      "required": [
        "r",
        "g",
        "b",
        "a"
      ]
    },
    "colors": {
      "type": "array",
      "items": {
        "title": "foxglove.Color",
        "description": "A color in RGBA format",
        "type": "object",
        "properties": {
          "r": {
            "type": "number",
            "description": "Red value between 0 and 1"
          },
          "g": {
            "type": "number",
            "description": "Green value between 0 and 1"
          },
          "b": {
            "type": "number",
            "description": "Blue value between 0 and 1"
          },
          "a": {
            "type": "number",
            "description": "Alpha value between 0 and 1"
          }
        },
        "required": [
          "r",
          "g",
          "b",
          "a"
        ]
      },
      "description": "Per-vertex colors (if specified, must have the same length as `points`). One of `color` or `colors` must be provided."
    },
    "indices": {
      "type": "array",
      "items": {
        "type": "integer",
        "minimum": 0
      },
      "description": "Indices into the `points` and `colors` attribute arrays, which can be used to avoid duplicating attribute data.\n\nIf omitted or empty, indexing will not be used. This default behavior is equivalent to specifying [0, 1, ..., N-1] for the indices (where N is the number of `points` provided)."
    }
  },
  "required": [
    "pose",
    "points",
    "color",
    "colors",
    "indices"
  ]
};

export const Vector2 = {
  "title": "foxglove.Vector2",
  "description": "A vector in 2D space that represents a direction only",
  "$comment": "Generated by https://github.com/foxglove/foxglove-sdk",
  "type": "object",
  "properties": {
    "x": {
      "type": "number",
      "description": "x coordinate length"
    },
    "y": {
      "type": "number",
      "description": "y coordinate length"
    }
  },
  "required": [
    "x",
    "y"
  ]
};

export const Vector3 = {
  "title": "foxglove.Vector3",
  "description": "A vector in 3D space that represents a direction only",
  "$comment": "Generated by https://github.com/foxglove/foxglove-sdk",
  "type": "object",
  "properties": {
    "x": {
      "type": "number",
      "description": "x coordinate length"
    },
    "y": {
      "type": "number",
      "description": "y coordinate length"
    },
    "z": {
      "type": "number",
      "description": "z coordinate length"
    }
  },
  "required": [
    "x",
    "y",
    "z"
  ]
};

export const Time = Timestamp;
