# Generated by Django 1.9.5 on 2016-06-03 13:02

from django.db import migrations

# This moves all the data from Media.tweet into Media.tweets.
# Because we're moving from a ForeignKey field (tweet) to a
# ManyToManyField (tweets).


def make_many_tweets(apps, schema_editor):
    """
    Adds the Tweet object in Media.tweet to the
    many-to-many relationship in Media.tweets
    """
    Media = apps.get_model("twitter", "Media")

    for media in Media.objects.all():
        media.tweets.add(media.tweet)


class Migration(migrations.Migration):

    dependencies = [
        ("twitter", "0039_auto_20160603_1301"),
    ]

    operations = [
        migrations.RunPython(make_many_tweets),
    ]
