# 🐧 Penguin Tamer

[![Python Version](https://img.shields.io/badge/python-3.11+-blue.svg)](https://www.python.org/downloads/)
[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)
[![PyPI Version](https://img.shields.io/pypi/v/penguin-tamer.svg)](https://pypi.org/project/penguin-tamer/)
[![GitHub Stars](https://img.shields.io/github/stars/Vivatist/penguin-tamer.svg)](https://github.com/Vivatist/penguin-tamer/stargazers)

> **🐧 Обуздайте свой Linux-терминал с помощью ИИ!** Задавайте вопросы ***ChatGPT***, ***Deep Seek***, ***Grok*** и многим другим большим языковым моделям (LLM). Выполняйте предложенные нейросетью скрипты и команды прямо из командной строки. Идеально подходит для новичков в администрировании Linux и Windows.

🌍 **Available in:** [English](../../README.md) | [Русский](README_ru.md)

![pgram response1](/docs/img/ru_intro.gif)

## Содержание

- [🐧 Penguin Tamer](#-penguin-tamer)
  - [Содержание](#содержание)
  - [Установка](#установка)
  - [Удаление](#удаление)
  - [Описание](#описание)
    - [Возможности](#возможности)
    - [Быстрый старт](#быстрый-старт)
  - [Подключение к нейросетям](#подключение-к-нейросетям)
    - [Получение токена (API\_KEY) и подключение к предустановленной модели](#получение-токена-api_key-и-подключение-к-предустановленной-модели)
    - [Добавление новой модели](#добавление-новой-модели)
      - [Пример подключения](#пример-подключения)
  - [Примеры](#примеры)
    - [Быстрый запрос](#быстрый-запрос)
    - [Режим диалога](#режим-диалога)
    - [Запуск кода из ответов ИИ](#запуск-кода-из-ответов-ии)
  - [Безопасность](#безопасность)
  - [Конфигурация](#конфигурация)
    - [Первоначальная настройка](#первоначальная-настройка)
    - [Поддерживаемые провайдеры ИИ](#поддерживаемые-провайдеры-ии)
    - [Файл конфигурации](#файл-конфигурации)
    - [Сброс настроек](#сброс-настроек)
    - [Лучшие практики](#лучшие-практики)
    - [Лучшие практики](#лучшие-практики-1)
  - [Содействие](#содействие)
    - [Области для содействия](#области-для-содействия)
    - [Настройка среды разработки](#настройка-среды-разработки)
    - [Правила содействия](#правила-содействия)
  - [Лицензия](#лицензия)
  - [Контакты](#контакты)


## Установка
```bash
curl -sSL https://raw.githubusercontent.com/Vivatist/penguin-tamer/main/install.sh | bash
```
## Удаление
```bash
pipx uninstall penguin-tamer
```

## Описание


### Возможности

- **Быстрые запросы к ИИ** — Получайте ответы от больших языковых моделей ИИ через командную строку
- **Отсутствие интерфейса** — Общайтесь с выбранным ИИ в естественной форме и на любом языке `ai как утановить русский шрифт?`
- **Интерактивный режим диалога** — Общайтесь с ИИ в режиме диалога с сохранением контекста беседы
- **Выполнение кода** — Выполняйте в консоли предложенные ИИ скрипты и команды
- **Дружелюбный интерфейс** — Форматированный вывод с подсветкой синтаксиса - все как во время привычной работы с нейросетями.
- **Множество провайдеров ИИ** — Поддержка OpenAI, OpenRouter, DeepSeek, Anthropic и других распространенных провайдеров ИИ.
- **Поддержка нескольких языков** — Сейчас доступны En и Ru. Вы можете [(помочь с переводом)](#содействие) на другие языки.




### Быстрый старт

Попробуйте задать ассистенту вопрос, например `pt кто ты?`. Через пару секунд нейросеть ответит:

![pgram response1](/docs/img/ru_img1.gif)

При первом запуске программа использует нейросеть от Microsoft - **DeepSeek-R1-Lite-Preview** с публичным токеном. Это не самый лучший выбор, так как из-за множества запросов может появляться сообщение о превышении квоты, но для тестового запуска сойдет. 

**Для полноценной работы необходимо [получить](#получение-токена-api_key-и-подключение-к-предустановленной-модели) личный токен и добавить его в настройки выбранной модели в [настройках](#конфигурация) программы.**

> [!NOTE]
> penguin-tamer может работать с любой нейросетью поддерживающей подключение по API. На сегодняшний день это практически все большие языковые модели (LLM) представленные на рынке. [Как подключить новую модель](#добавление-новой-модели).

## Подключение к нейросетям
penguin-tamer поставляется с несколькими популярными моделями, такими как **DeepSeek**, **Grok 4 Fast**, **Qwen3 Coder**. Однако политика провайдеров не позволяет полноценно работать без авторизации. Вам необходимо получить личный токен (API_KEY) на сайте провайдера.

### Получение токена (API_KEY) и подключение к предустановленной модели
Рекомендую пользоваться провайдером [OpenRouter](https://openrouter.ai/models?max_price=0) - легкая регистрация и десятки самых популярных нейросетей в бесплатном доступе по одному токену.

- Зарегистрируйтесь на [сайте](https://openrouter.ai/)
- Получите токен нажав **[Create API key](https://openrouter.ai/settings/keys)**. Cохраните его, OpenRouter покажет вам его только один раз!
- Добавьте токен в penguin-tamer в [настройках](#конфигурация) выбранной модели
- Сделайте эту модель текущей

**Готово! Теперь выбранная модель будет отвечать вам в консоли. Вы можете подключить любую другую модель с этого сайта таким же образом.**

> [!NOTE]
> Один токен OpenRouter действителен для **всех** моделей, доступных у этого провайдера.

Подобная процедура применяется и к другим провайдерам, хотя при наличии **OpenRouter** это может вам не понадобиться.

### Добавление новой модели
Для добавления в penguin-tamer **новой** модели, в том числе локальной или от крупных провайдеров, просто введите в [настройках](#конфигурация) penguin-tamer:
 - API_KEY (личный токен)
 - API_URL (ссылка для подключения)
 - model (название модели)

Вы можете найти эту информацию на сайте провайдера в разделе *API*. 

#### Пример подключения
На примере подключения к бесплатной нейросети ***Meta: Llama 3.1*** представленной на сайте [OpenRouter](https://openrouter.ai/models?max_price=0) среди десятков других бесплатных моделей.

Открываем страницу данной нейросети, ищем раздел [API](https://openrouter.ai/meta-llama/llama-3.1-405b-instruct:free/api). 

Среди кодов с примерами подключения ищем информацию похожую на: 

 - **API_URL** - в случае с OpenRouter этот параметр будет называться ***base_url***
 - **model** - так и называется ***model***

Как получить **API_KEY** [описано](#получение-токена-api_key-и-подключение-к-предустановленной-нейросети) выше

Введите эти значения (***без кавычек***) в настройки penguin-tamer и назначьте эту модель текущей. Теперь ***Meta: Llama 3.1*** будет отвечать на ваши вопросы. 


## Примеры

### Быстрый запрос

```bash
# Simple question
pt скрипт для обновления ядра
```

### Режим диалога

Чтобы начать диалог, используйте ключ `-d` или просто введите `pt` и нажмите `Enter`.
В режиме диалога penguin-tamer сохраняет контекст беседы на протяжении всей сессии.

```bash
pt -d какая версия питона установлена?
```

```bash
pt  # Enter
```

### Запуск кода из ответов ИИ

Когда **в режиме диалога**, если ответ содержит блоки кода — они нумеруются. Для запуска кода просто введите номер блока в консоль.

> [!NOTE]
> В случае, когда **в режиме диалога** в ответе присутствуют блоки кода - они нумеруются. Для запуска кода просто введите номер блока в консоль.

![dialog mode](/docs/img/en_img2.gif)

## Безопасность

> [!WARNING]
> Никогда не выполняйте предложенный нейросетью код если не уверены в том что он делает!



## Конфигурация

### Первоначальная настройка

Запустите режим настройки для конфигурации провайдера ИИ:

```bash
pt -s
```

### Поддерживаемые провайдеры ИИ

- **OpenAI** (GPT-3.5, GPT-4)
- **Anthropic** (Claude)
- **OpenRouter** (Множество моделей)
- **Локальные модели** (Ollama, LM Studio)

И многие другие поддерживающие подключение по API

### Файл конфигурации

Настройки хранятся в:
- **Linux:** `~/.config/penguin-tamer/config.yaml`
- **Windows:** `%APPDATA%\penguin-tamer\config.yaml`

### Сброс настроек

Для восстановления настроек по умолчанию, удалите файл конфигурации вручную или выполните:
```bash
# Для Linux
rm ~/.config/penguin-tamer/config.yaml
```
```bash
# Для Windows
rm %APPDATA%\penguin-tamer\config.yaml
```
### Лучшие практики

### Лучшие практики

1. **Проверяйте код перед выполнением**
   ```bash
   # Всегда проверяйте что предлагает ИИ
   pt Удалить все файлы из /tmp  # Не выполняйте это слепо!
   ```

2. **Используйте безопасные команды**
   ```bash
   # Предпочитайте эти вместо деструктивных операций
   pt Показать использование диска
   pt Показать запущенные процессы
   ```

## Содействие

Буду рад помощи! 

### Области для содействия

- 🌍 **Локализация** — Добавление поддержки новых языков ([шаблон](https://github.com/Vivatist/penguin-tamer/blob/main/src/penguin_tamer/locales/template_locale.json)), включая [README.md](https://github.com/Vivatist/penguin-tamer/blob/main/README.md)
- 🤖 **Провайдеры ИИ** — Интеграция новых провайдеров ИИ
- 🎨 **UI/UX** — Улучшение интерфейса менеджера конфигурации (да, он не идеален)
- 🔧 **Инструменты** — Создание дополнительных утилит
- 💡 **Идеи** — Приветствую любые идеи по улучшению и развитию penguin-tamer. [Присоединяйтесь к обсуждению](https://github.com/Vivatist/penguin-tamer/discussions/10#discussion-8924293)

Вот как начать:

### Настройка среды разработки

1. **Форкните репозиторий**
2. **Клонируйте ваш форк**:
   ```bash
   git clone https://github.com/your-username/penguin-tamer.git
   cd penguin-tamer
   ```

3. **Настройте среду разработки**:
   ```bash
   python -m venv venv
   source venv/bin/activate  # На Windows: venv\Scripts\activate
   pip install -r requirements.txt
   pip install -e .
   ```

### Правила содействия

- 📝 **Стиль кода**: Следуйте PEP 8
- 🧪 **Тестирование**: Добавляйте тесты для новых функций
- 📚 **Документация**: Обновляйте README для новых функций
- 🔄 **Pull Requests**: Используйте понятные сообщения коммитов

## Лицензия

Этот проект лицензирован под MIT License.

## Контакты

- **Автор**: Andrey Bochkarev
- **GitHub Issues**: [🐛 Сообщить об ошибках](https://github.com/Vivatist/penguin-tamer/issues)
- **Обсуждения**: [💬 Присоединиться](https://github.com/Vivatist/penguin-tamer/discussions)

---

<div align="center">

**Создано с ❤️ для Linux сообщества**

[⭐ Поставьте звезду на GitHub](https://github.com/Vivatist/penguin-tamer)
</div>