# Migrating to v0.16

[< Back to Changelog](/changelog#v016x)

This page summarizes the major changes between version 0.15 and 0.16.

## Observer Model

There is now an [Observer model][starplot.Observer] which represents a time and place. It takes a datetime, lat, and lon.

All plot types now require an observer instance. By default the map plot will use a default Observer.

Example:

```python

# Create observer
observer = Observer(
    dt=datetime(2023, 7, 13, 22, 0, tzinfo=ZoneInfo("America/Los_Angeles")),
    lat=33.363484,
    lon=-116.836394,
)

# Use the observer in a horizon plot
p = HorizonPlot(
    altitude=(0, 70),
    azimuth=(320, 435),
    observer=observer,
    ...
)

```

In future versions, we may add more helper methods to the Observer model for creating plots directly from there (e.g. `observer.horizon(altitude=(0,60), azimuth=(130, 255))`)

## Projections

[Projections are now classes](/reference-mapplot/#projections) instead of an enum. This was a difficult decision, but I think it's the best way to allow customizing the central RA/DEC of projections, and this is something I really wanted to support.

The map plot is still the only plot type that requires a projection.

Also new: an equidistant projection!

Example:

```python
from starplot import Equidistant

p = MapPlot(
    dec_min=0,
    projection=Equidistant(center_dec=90),
    ...
)

```

## Zenith Plot

[Zenith plots are now a separate plot type][starplot.ZenithPlot]. They do inherit from map plots, so they still support all the same functions.

Example:

```python
from starplot import ZenithPlot, Observer

observer = Observer(
    dt=datetime(2023, 7, 13, 22, 0, tzinfo=ZoneInfo("America/Los_Angeles")) ,
    lat=33.363484,
    lon=-116.836394,
)

p = ZenithPlot(
    observer=observer,
    ...,
)

```

## Style Context Manager

!!! example "Experimental"

    This is currently an "experimental" feature, which means it's likely to be changed and improved in upcoming versions of Starplot.
    It also means the feature likely has limitations.

    **Help us improve this feature by submitting feedback on [GitHub (open an issue)](https://github.com/steveberardi/starplot/issues) or chat with us on [Discord](https://discord.gg/WewJJjshFu). Thanks!**

When making maps, it's often good to style things differently based on some property. For example, you might want to label bright open clusters with a larger font size and make them bold. Previously in Starplot, you'd have to do something like this:


```python
# make open cluster labels bigger and bolder
p.style.dso_open_cluster.label.font_size *= 1.5
p.style.dso_open_cluster.label.font_weight = 'heavy'
p.open_clusters(where=[_.magnitude < 9])

# reset style back to its original value before plotting dimmer clusters
p.style.dso_open_cluster.label.font_size /= 1.5
p.style.dso_open_cluster.label.font_weight = 'normal'
p.open_clusters(where=[_.magnitude >= 9])
```

Version 0.16 introduces context managers for all styles, so now you can temporarily override styles like this:

```python

with p.style.dso_open_cluster as oc:
    # make open cluster labels bigger and bolder
    oc.label.font_size *= 1.5
    oc.label.font_weight = 'heavy'
    p.open_clusters(where=[_.magnitude < 9])

# when exiting the context manager, the style will be reverted to its original value
# so, the following line will use the original style (BEFORE the context manager)
p.open_clusters(where=[_.magnitude >= 9])
```

<br/><br/>
