---
title: 3 - Adding More Details to the Star Chart | Tutorial 
---

<div class="flex-space-between tutorial-top-nav" markdown>
  [:octicons-arrow-left-24: Previous](02.md){ .text-right }

  [Tutorial Home](/tutorial)

  [Next :octicons-arrow-right-24:](04.md){ .text-right }
  <br/>
</div>

# 3 - Adding More Details to the Star Chart

<figure markdown="span">
  ![Tutorial - Detailed Star Chart](/images/tutorial/tutorial_03.png){ width="600" }
</figure>

Building on the first example, let's add some color and more objects to the plot, to create the chart above. Here's the revised code with comments explaining the new lines:

<div class="tutorial">
```python  linenums="1"
--8<-- "tutorial/tutorial_03.py"
```
</div>

Here are some more details about what we changed:

- **Customized the style** by adding the `style` keyword argument when creating the plot instance. This is an instance of a [`PlotStyle`][starplot.PlotStyle], and it represents ALL the styling properties to use for the plot (e.g. the colors, symbols, sizes, and more). In our revised example here, we create a default `PlotStyle` and then `extend` it with the `BLUE_MEDIUM` color scheme. Starplot has a very customizable [styling framework](/reference-styling) that allows you to customize the appearance of just about anything you plot.

- **Plotted deep sky objects (DSOs)** with a limiting magnitude of 9. The `true_size=False` argument tells Starplot to plot each DSO's size based on what's specified in the style definition and NOT their true apparent size. For zenith plots like this one, plotting the true size can make many DSOs too small to see on the plot. We also pass `where_labels=[False]` to hide all the labels for DSOs to avoid cluttering the plot.

- **Plotted other lines and objects:** constellation borders, ecliptic, and the Milky Way.

- **Added a marker for the [Coma Star Cluster](https://en.wikipedia.org/wiki/Coma_Star_Cluster)** (aka Melotte 111), and customized its style. Starplot also has functions for plotting circles, rectangles, polygons, and more. See the reference for [`MapPlot`][starplot.MapPlot] for details.

*In the [next section](04.md), we'll learn how to create maps in other projections...*

---
<div class="flex-space-between" markdown>

[:octicons-arrow-left-24: Previous](02.md){ .md-button .md-button--primary .text-right }

[Tutorial Home](/tutorial)

[Next :octicons-arrow-right-24:](04.md){ .md-button .md-button--primary .text-right }

</div>
