---
title: 4 - Creating a Basic Map | Tutorial 
---

<div class="flex-space-between tutorial-top-nav" markdown>
  [:octicons-arrow-left-24: Previous](03.md){ .text-right }

  [Tutorial Home](/tutorial)

  [Next :octicons-arrow-right-24:](05.md){ .text-right }
  <br/>
</div>

# 4 - Creating a Basic Map

<figure markdown="span">
  ![Tutorial - Map Plot](/images/tutorial/tutorial_04.png){ width="900" }
</figure>

The zenith plot is known as a [perspective projection](https://en.wikipedia.org/wiki/Perspective_(graphical)), which means it depends on a time and place. They're useful for many things in astronomy, but Starplot also lets you create general-purpose maps of the sky that are independent of location.

To create a general map, you use the `MapPlot` class, which works similar to the zenith plot but takes a few different parameters:

- `projection`: Instance of a Projection, which is the method to use for transforming the curved shape of the three-dimensional sky to a flat two-dimensional map. In this example, we use a `Mercator` projection, but Starplot supports many [types of projections](/reference-mapplot/#map-projections) and you can customize their properties (e.g. central RA/DEC).
- `ra_min` / `ra_max` : Right ascension (RA) extent of the map (in degrees)
- `dec_min` / `dec_max` : Declination (DEC) extent of the map (in degrees)

Here's a code example that creates a MapPlot of the area around Orion:

<div class="tutorial" markdown>
```python linenums="1"
--8<-- "tutorial/tutorial_04.py"
```
</div>

*In the [next section](05.md), we'll learn how to create an optic plot which shows an area of the sky when viewed through an optic (such as binoculars or a telescope)...*

---
<div class="flex-space-between" markdown>

[:octicons-arrow-left-24: Previous](03.md){ .md-button .md-button--primary .text-right }

[Tutorial Home](/tutorial)

[Next :octicons-arrow-right-24:](05.md){ .md-button .md-button--primary .text-right }

</div>
