---
title: 5 - Creating a Basic Optic Plot | Tutorial 
---

<div class="flex-space-between tutorial-top-nav" markdown>
  [:octicons-arrow-left-24: Previous](04.md){ .text-right }

  [Tutorial Home](/tutorial)

  [Next :octicons-arrow-right-24:](06.md){ .text-right }
  <br/>
</div>

# 5 - Creating a Basic Optic Plot

<figure markdown="span">
  ![Tutorial - Map Plot](/images/tutorial/tutorial_05.png){ width="600" }
</figure>

Starplot also has optic plots, which simulate what you'll see through an optic (e.g. binoculars, telescope, camera) at a specific time and location. The simulated view will show you the true field of view for the optic, and it will even orient the stars based on the location you specify and the most logical position of your optic.

Optic plots work very similar to map plots, with a few key differences: they *always* require an observer, and they also require an optic.

For example, here's how you'd create an optic plot of the The Pleiades (M45), viewed through 10x binoculars at 9pm PT on April 8, 2024 from Palomar Mountain:

<div class="tutorial" markdown>
```python linenums="1"
--8<-- "tutorial/tutorial_05.py"
```
</div>

The first 20 lines should look familiar from the other plots we've created in this tutorial.

On line 22, we use a powerful feature of Starplot: looking up an object and then using that object's properties to help us create the plot. In this example, we look up The Pleiades open cluster by calling the `get` function on the `DSO` model. This function returns an instance of the [DSO model](/reference-models/#starplot.DSO), which has various properties of the object, including it's position (RA/Dec).

On line 24, we create the `OpticPlot`, using properties from the `m45` model we just retrieved. Most of the kwargs should look familiar, except for the following: 

- `ra`: Right ascension of the target
- `dec`: Declination of the target
- `optic`: An instance of an [optic](/reference-opticplot/#starplot.optics.Optic). This example uses binoculars, but Starplot also supports refractor/reflector telescopes, generic scopes, and cameras.

The `ra`/`dec` you specify for the target will be the center of the plot.

*In the [next section](06.md), we'll learn how to be more selective of objects to plot...*

---
<div class="flex-space-between" markdown>

[:octicons-arrow-left-24: Previous](04.md){ .md-button .md-button--primary .text-right }

[Tutorial Home](/tutorial)

[Next :octicons-arrow-right-24:](06.md){ .md-button .md-button--primary .text-right }

</div>
