---
title: 6 - Selecting Objects to Plot | Tutorial 
---

<div class="flex-space-between tutorial-top-nav" markdown>
  [:octicons-arrow-left-24: Previous](05.md){ .text-right }

  [Tutorial Home](/tutorial)

  [Next :octicons-arrow-right-24:](07.md){ .text-right }
  <br/>
</div>

# 6 - Selecting Objects to Plot

<figure markdown="span">
  ![Tutorial - Selecting Objects](/images/tutorial/tutorial_06.png){ width="700" }
</figure>

When plotting stars, constellations, or deep sky objects (DSOs), you may want to limit the plotted objects by more than just a limiting magnitude. Starplot provides a way to [filter objects by using expressions](/reference-selecting-objects/). This allows you to be very specific about which objects to plot, and it also gives you a way to style objects differently (e.g. if you want to style very bright stars differently than dim stars).

To select objects to plot, you pass a list of expressions using the `where` keyword argument. For example, here's how you'd plot all stars that have a magnitude less than 6 and a B-V index of more than 0.4:

```python
p.stars(
    where=[
        _.magnitude < 6,
        _.bv > 0.4,
    ],
)
```
When passing the `where` kwarg, only the objects that satisfy ALL the `where` conditions will be plotted. You can reference any field on the [model](/reference-models/) in expressions, and there are also a few functions available for determining if a field is null or is in a list of values. For complete details about selecting objects, see the [reference page](/reference-selecting-objects/).

Here's some code that uses the `where` kwarg extensively to produce the image above:
<div class="tutorial" markdown>
```python linenums="1"
--8<-- "tutorial/tutorial_06.py"
```
</div>

*In the [next section](07.md), we'll learn how to lookup objects to create plots...*

---
<div class="flex-space-between" markdown>

[:octicons-arrow-left-24: Previous](05.md){ .md-button .md-button--primary .text-right }

[Tutorial Home](/tutorial)

[Next :octicons-arrow-right-24:](07.md){ .md-button .md-button--primary .text-right }

</div>
