---
title: 8 - Using Callables | Tutorial 
---

<div class="flex-space-between tutorial-top-nav" markdown>
  [:octicons-arrow-left-24: Previous](07.md){ .text-right }

  [Tutorial Home](/tutorial)

  [Next :octicons-arrow-right-24:](09.md){ .text-right }
  <br/>
</div>

# 8 - Using Callables

<figure markdown="span">
  ![Tutorial - Callables](/images/tutorial/tutorial_08.png){ width="600" }
</figure>


[Callables](/reference-callables/) allow you to define your own functions for calculating a few of the style properties for stars: size, alpha (opacity),  color, and their labels. DSOs support callables for alpha and labels only. Starplot has a few basic callables built-in, but you can also create your own.

Here's an example that uses the built-in callable `color_by_bv` to create an optic plot of [Antares](https://en.wikipedia.org/wiki/Antares) that colorizes the stars based on their B-V index (Antares' B-V is 1.83 so it appears red/orange in the sky):
<div class="tutorial" markdown>
```python linenums="1"
--8<-- "tutorial/tutorial_08.py"
```
</div>

For more details on using callables and an example of how to create your own, check out the [reference page](/reference-callables/).

*In the [next section](09.md), we'll learn where to go from here...*

---
<div class="flex-space-between" markdown>

[:octicons-arrow-left-24: Previous](07.md){ .md-button .md-button--primary .text-right }

[Tutorial Home](/tutorial)

[Next :octicons-arrow-right-24:](09.md){ .md-button .md-button--primary .text-right }

</div>
