LABELS = {
    "en-us": {
        "legend": "legend",
        "star magnitude": "star magnitude",
        "star": "star",
        "deep sky object": "deep sky object",
        "open cluster": "open cluster",
        "globular cluster": "globular cluster",
        "nebula": "nebula",
        "galaxy": "galaxy",
        "dark nebula": "dark nebula",
        "association of stars": "association of stars",
        "double star": "double star",
        "emission nebula": "emission nebula",
        "galaxy pair": "galaxy pair",
        "galaxy triplet": "galaxy triplet",
        "galaxy cluster": "galaxy cluster",
        "group of galaxies": "group of galaxies",
        "hii ionized region": "hii ionized region",
        "nova star": "nova star",
        "planetary nebula": "planetary nebula",
        "reflection nebula": "reflection nebula",
        "star cluster nebula": "star cluster nebula",
        "supernova remnant": "supernova remnant",
        "unknown": "unknown",
        "planet": "planet",
        "mercury": "mercury",
        "venus": "venus",
        "mars": "mars",
        "jupiter": "jupiter",
        "saturn": "saturn",
        "uranus": "uranus",
        "neptune": "neptune",
        "pluto": "pluto",
        "sun": "sun",
        "moon": "moon",
        "north": "north",
        "east": "east",
        "south": "south",
        "west": "west",
        "ecliptic": "ecliptic",
        "celestial equator": "celestial equator",
        "n": "n",
        "e": "e",
        "s": "s",
        "w": "w",
        "milky way": "milky way",
    },
    "fr": {
        "legend": "légende",
        "star magnitude": "magnitude des étoiles",
        "star": "étoile",
        "deep sky object": "objet du ciel profond",
        "open cluster": "amas ouvert",
        "globular cluster": "amas globulaire",
        "nebula": "nébuleuse",
        "galaxy": "galaxie",
        "dark nebula": "nébuleuse obscure",
        "association of stars": "amas d'étoiles",
        "double star": "étoile double",
        "emission nebula": "nébuleuse en émission",
        "galaxy pair": "paire de galaxies",
        "galaxy triplet": "triplet de galaxies",
        "galaxy cluster": "amas de galaxies",
        "group of galaxies": "groupes de galaxies",
        "hii ionized region": "région d'hydrogène ionisé",
        "nova star": "nova",
        "planetary nebula": "nébuleuse planétaire",
        "reflection nebula": "nébuleuse par réflexion",
        "star cluster nebula": "nébuleuse d’amas d’étoiles",
        "supernova remnant": "rémanent de supernova",
        "unknown": "inconnu",
        "planet": "planète",
        "mercury": "mercure",
        "venus": "venus",
        "mars": "mars",
        "jupiter": "jupiter",
        "saturn": "saturne",
        "uranus": "uranus",
        "neptune": "neptune",
        "pluto": "pluton",
        "sun": "soleil",
        "moon": "lune",
        "north": "nord",
        "east": "est",
        "south": "sud",
        "west": "ouest",
        "ecliptic": "écliptique",
        "celestial equator": "équateur céleste",
        "n": "n",
        "e": "e",
        "s": "s",
        "w": "o",
        "milky way": "voie lactée",
    },
    "zh-cn": {
        "legend": "图例",
        "star magnitude": "星等",
        "star": "恒星",
        "deep sky object": "深空天体",
        "open cluster": "疏散星团",
        "globular cluster": "球状星团",
        "nebula": "星云",
        "galaxy": "星系",
        "dark nebula": "暗星云",
        "association of stars": "星协",
        "double star": "双星",
        "emission nebula": "发射星云",
        "galaxy pair": "星系对",
        "galaxy triplet": "三重星系",
        "galaxy cluster": "星系团",
        "group of galaxies": "星系群",
        "hii ionized region": "hii电离氢区",
        "nova star": "新星",
        "planetary nebula": "行星状星云",
        "reflection nebula": "反射星云",
        "star cluster nebula": "星团星云",
        "supernova remnant": "超新星遗迹",
        "unknown": "未知天体",
        "planet": "行星",
        "mercury": "水星",
        "venus": "金星",
        "mars": "火星",
        "jupiter": "木星",
        "saturn": "土星",
        "uranus": "天王星",
        "neptune": "海王星",
        "pluto": "冥王星",
        "sun": "太阳",
        "moon": "月球",
        "north": "北",
        "east": "东",
        "south": "南",
        "west": "西",
        "ecliptic": "黄道",
        "celestial equator": "天赤道",
        "n": "北",
        "e": "东",
        "s": "南",
        "w": "西",
        "milky way": "银河",
    },
}


def language_name_column(language: str, column_prefix: str = "name") -> str:
    language_name = language.replace("-", "_").lower()

    return f"{column_prefix}_{language_name}"


def translate(text: str, language: str) -> str:
    if not text:
        return text

    translation = LABELS[language.lower()].get(text.lower())

    if not translation:
        return text

    return translation.title()
