# Что это?
Cryptronics - это удобная и простая Python обёртка для криптовалютных API сервисов:
- octopusapisoftware.com (usdt TRC20)
- cryptocurrencyapi.net (btc, ltc, doge, dash, bch)
- etherapi.net (eth)
- bnbapi.net (bnb)

# Как этим пользоваться?
Выше был приведен список сервисов, а так же список поддерживаемых ими монет.
Вам необходимо зарегистрировать аккаунты в зависимости от необходимых вам монет и сгенерировать API ключи в личном кабинете каждого из сервисов.

## Импорт и настройка
Для начала работы необходимо импортировать класс Crypto и инициализировать его, передав в качестве параметров Ваши ключи. Обратите внимание, что передавать все ключи не обязательно, можете указывать только для необходимых Вам сервисов.
``` python
from Cryptronics.base_crypto import Crypto

crypto = Crypto(
    octopus_api_key='<Ваш API ключ>',
    crypto_api_key='<Ваш API ключ>',
    eth_api_key='<Ваш API ключ>',
    bnb_api_key='<Ваш API ключ>',
)
```
## Доступные методы
### create_wallet(token, tag)
В качестве параметров принимает:
- token - тикер токена, под который нужно создать кошелек (usdt, btc, etc...)
- tag - метка, идентификатор. Нужна для идентификации операции в апи сервисе

Ниже приведен пример создания кошелька для пользователя, где в качестве тэга используется строка с вставленным в неё ID пользователя
``` python
response = crypto.create_wallet(
    "usdt",
    f"user-wallet-{user_id}"
)
```
В response вернется словарь (dict) с адресом только что созданного кошелька и иной информацией в зависимости от задействованного API сервиса

### send(token, to_address, amount, tag)
`Токены будут отправлены с Вашего ОСНОВНОГО кошелька. Подробнее о принципах работы системы можете почитать в документации к octopusapisoftware или cryptocurrency`
В качестве параметров принимает:
- token - тикер токена, под который нужно создать кошелек (usdt, btc, etc...)
- to_address - адрес для отправки токенов (с основного кошелька)
- amount
- tag - метка, идентификатор. Нужна для идентификации кошелька в апи сервисе

Ниже приведен пример вывода средств пользователю вашей системы. В качестве аргументов передан токен usdt, адрес пользователя стандарта `TRC20`, сумма и тэг 
``` python
response = crypto.send(
    token="usdt",
    to_address="<USDT-TRC20-ADDRESS>",
    amount=200,
    tag=f"user-withdraw-{user_id}-{operation_id}"
)
```
В response вернется словарь (dict) с ID вашей транзакции в блокчейн сети и иной информацией в зависимости от задействованного API сервиса.

### generate_wallets(tokens, tag)

В качестве параметров принимает:
- tokens: список (list) тикеров валют, для которых необходимо создать кошельки
- tag: уникальный тэг, для отслеживания операции в API сервисе (желательно включать в него id пользователя внутри вашей системы)

Ниже приведен пример генерации кошельков по всем доступным API сервисам 
``` python
tokens = [
    'usdt',
    'btc',
    'eth'
]
response = crypto.generate_wallets(
    tag=f"transit-{user.id}",
    tokens=tokens
)
```

Вернется список (list), в котором будут находится сгенерированные кошельки.
```
[
    {
        "token":"usdt",
        "wallet":"<wallet_address>"
    },
    {
        "token":"btc",
        "wallet":"<wallet_address>"
    },
    {
        "token":"eth",
        "wallet":"<wallet_address>"
    }
]

```

# TODO:
- ~~Возможность сгенерировать кошельки по нескольким валютам, для которых указан токен~~
- Возможность отправки монет с использованием крипто-миксера (через биржи)
- Возможность получить баланс кошелька, указав токен или сервис 
- Добавить возможность отслеживать количество подтверждений транзакции в блокчейн сети
- Возможность отслеживать ожидаемое пополнение фиксированной, заранее известной суммы