# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.dataset import Dataset
from ..types.time_series_data_point import TimeSeriesDataPoint
from .raw_client import AsyncRawDatasetsClient, RawDatasetsClient
from .types.create_geospatial_static_api_v_1_dashboard_datasets_geospatial_static_post_request_geometry_type import (
    CreateGeospatialStaticApiV1DashboardDatasetsGeospatialStaticPostRequestGeometryType,
)
from .types.create_timeseries_live_api_v_1_dashboard_datasets_timeseries_live_post_request_data_format import (
    CreateTimeseriesLiveApiV1DashboardDatasetsTimeseriesLivePostRequestDataFormat,
)

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class DatasetsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawDatasetsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawDatasetsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawDatasetsClient
        """
        return self._raw_client

    def create_timeseries_static(
        self,
        *,
        name: str,
        data: typing.Sequence[TimeSeriesDataPoint],
        description: typing.Optional[str] = None,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Dataset:
        """
        Create a static timeseries dataset.

        Parameters
        ----------
        name : str

        data : typing.Sequence[TimeSeriesDataPoint]

        description : typing.Optional[str]

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Dataset
            Successful Response

        Examples
        --------
        from rebase_dashboard import RebaseDashboardApi, TimeSeriesDataPoint

        client = RebaseDashboardApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.datasets.create_timeseries_static(
            name="name",
            data=[
                TimeSeriesDataPoint(
                    timestamp="timestamp",
                    value=1.1,
                )
            ],
        )
        """
        _response = self._raw_client.create_timeseries_static(
            name=name, data=data, description=description, metadata=metadata, request_options=request_options
        )
        return _response.data

    def create_timeseries_live(
        self,
        *,
        name: str,
        url: str,
        data_format: typing.Optional[
            CreateTimeseriesLiveApiV1DashboardDatasetsTimeseriesLivePostRequestDataFormat
        ] = None,
        datetime_format: typing.Optional[str] = None,
        description: typing.Optional[str] = None,
        params: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        aliases: typing.Optional[typing.Dict[str, typing.Optional[str]]] = OMIT,
        headers: typing.Optional[typing.Dict[str, typing.Optional[str]]] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Dataset:
        """
        Create a live timeseries dataset.

        Parameters
        ----------
        name : str

        url : str

        data_format : typing.Optional[CreateTimeseriesLiveApiV1DashboardDatasetsTimeseriesLivePostRequestDataFormat]

        datetime_format : typing.Optional[str]

        description : typing.Optional[str]

        params : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        aliases : typing.Optional[typing.Dict[str, typing.Optional[str]]]

        headers : typing.Optional[typing.Dict[str, typing.Optional[str]]]

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Dataset
            Successful Response

        Examples
        --------
        from rebase_dashboard import RebaseDashboardApi

        client = RebaseDashboardApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.datasets.create_timeseries_live(
            name="name",
            url="url",
        )
        """
        _response = self._raw_client.create_timeseries_live(
            name=name,
            url=url,
            data_format=data_format,
            datetime_format=datetime_format,
            description=description,
            params=params,
            aliases=aliases,
            headers=headers,
            metadata=metadata,
            request_options=request_options,
        )
        return _response.data

    def create_tabular_static(
        self,
        *,
        name: str,
        data: typing.Sequence[typing.Dict[str, typing.Optional[typing.Any]]],
        description: typing.Optional[str] = None,
        column_schema: typing.Optional[typing.Dict[str, typing.Optional[str]]] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[typing.Any]:
        """
        Create a static tabular dataset (placeholder).

        Parameters
        ----------
        name : str

        data : typing.Sequence[typing.Dict[str, typing.Optional[typing.Any]]]

        description : typing.Optional[str]

        column_schema : typing.Optional[typing.Dict[str, typing.Optional[str]]]

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        from rebase_dashboard import RebaseDashboardApi

        client = RebaseDashboardApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.datasets.create_tabular_static(
            name="name",
            data=[{"key": "value"}],
        )
        """
        _response = self._raw_client.create_tabular_static(
            name=name,
            data=data,
            description=description,
            column_schema=column_schema,
            metadata=metadata,
            request_options=request_options,
        )
        return _response.data

    def create_geospatial_static(
        self,
        *,
        name: str,
        data: typing.Sequence[typing.Dict[str, typing.Optional[typing.Any]]],
        coordinate_system: typing.Optional[str] = None,
        geometry_type: typing.Optional[
            CreateGeospatialStaticApiV1DashboardDatasetsGeospatialStaticPostRequestGeometryType
        ] = None,
        description: typing.Optional[str] = None,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Dataset:
        """
        Create a static geospatial dataset compatible with deck.gl data formats.

        Parameters
        ----------
        name : str

        data : typing.Sequence[typing.Dict[str, typing.Optional[typing.Any]]]

        coordinate_system : typing.Optional[str]

        geometry_type : typing.Optional[CreateGeospatialStaticApiV1DashboardDatasetsGeospatialStaticPostRequestGeometryType]

        description : typing.Optional[str]

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Dataset
            Successful Response

        Examples
        --------
        from rebase_dashboard import RebaseDashboardApi

        client = RebaseDashboardApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.datasets.create_geospatial_static(
            name="name",
            data=[{"key": "value"}],
        )
        """
        _response = self._raw_client.create_geospatial_static(
            name=name,
            data=data,
            coordinate_system=coordinate_system,
            geometry_type=geometry_type,
            description=description,
            metadata=metadata,
            request_options=request_options,
        )
        return _response.data

    def list_datasets(self, *, request_options: typing.Optional[RequestOptions] = None) -> typing.List[Dataset]:
        """
        List all datasets for the user.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Dataset]
            Successful Response

        Examples
        --------
        from rebase_dashboard import RebaseDashboardApi

        client = RebaseDashboardApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.datasets.list_datasets()
        """
        _response = self._raw_client.list_datasets(request_options=request_options)
        return _response.data

    def get_dataset(self, dataset_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Dataset:
        """
        Retrieve a single dataset by its ID.

        Parameters
        ----------
        dataset_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Dataset
            Successful Response

        Examples
        --------
        from rebase_dashboard import RebaseDashboardApi

        client = RebaseDashboardApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.datasets.get_dataset(
            dataset_id="dataset_id",
        )
        """
        _response = self._raw_client.get_dataset(dataset_id, request_options=request_options)
        return _response.data

    def update_dataset(
        self,
        dataset_id: str,
        *,
        name: str,
        description: typing.Optional[str] = None,
        request: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Dataset:
        """
        Update a dataset's basic properties (name, description, metadata only).

        Parameters
        ----------
        dataset_id : str

        name : str

        description : typing.Optional[str]

        request : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Dataset
            Successful Response

        Examples
        --------
        from rebase_dashboard import RebaseDashboardApi

        client = RebaseDashboardApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.datasets.update_dataset(
            dataset_id="dataset_id",
            name="name",
        )
        """
        _response = self._raw_client.update_dataset(
            dataset_id, name=name, description=description, request=request, request_options=request_options
        )
        return _response.data

    def delete_dataset(self, dataset_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete a dataset.

        Parameters
        ----------
        dataset_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from rebase_dashboard import RebaseDashboardApi

        client = RebaseDashboardApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.datasets.delete_dataset(
            dataset_id="dataset_id",
        )
        """
        _response = self._raw_client.delete_dataset(dataset_id, request_options=request_options)
        return _response.data

    def get_dataset_data(
        self,
        dataset_id: str,
        *,
        start: typing.Optional[str] = None,
        end: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[typing.Any]:
        """
        Get dataset data with optional time filtering. Works for static and live datasets of all types.

        Parameters
        ----------
        dataset_id : str

        start : typing.Optional[str]

        end : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        from rebase_dashboard import RebaseDashboardApi

        client = RebaseDashboardApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.datasets.get_dataset_data(
            dataset_id="dataset_id",
        )
        """
        _response = self._raw_client.get_dataset_data(dataset_id, start=start, end=end, request_options=request_options)
        return _response.data


class AsyncDatasetsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawDatasetsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawDatasetsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawDatasetsClient
        """
        return self._raw_client

    async def create_timeseries_static(
        self,
        *,
        name: str,
        data: typing.Sequence[TimeSeriesDataPoint],
        description: typing.Optional[str] = None,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Dataset:
        """
        Create a static timeseries dataset.

        Parameters
        ----------
        name : str

        data : typing.Sequence[TimeSeriesDataPoint]

        description : typing.Optional[str]

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Dataset
            Successful Response

        Examples
        --------
        import asyncio

        from rebase_dashboard import AsyncRebaseDashboardApi, TimeSeriesDataPoint

        client = AsyncRebaseDashboardApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.datasets.create_timeseries_static(
                name="name",
                data=[
                    TimeSeriesDataPoint(
                        timestamp="timestamp",
                        value=1.1,
                    )
                ],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_timeseries_static(
            name=name, data=data, description=description, metadata=metadata, request_options=request_options
        )
        return _response.data

    async def create_timeseries_live(
        self,
        *,
        name: str,
        url: str,
        data_format: typing.Optional[
            CreateTimeseriesLiveApiV1DashboardDatasetsTimeseriesLivePostRequestDataFormat
        ] = None,
        datetime_format: typing.Optional[str] = None,
        description: typing.Optional[str] = None,
        params: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        aliases: typing.Optional[typing.Dict[str, typing.Optional[str]]] = OMIT,
        headers: typing.Optional[typing.Dict[str, typing.Optional[str]]] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Dataset:
        """
        Create a live timeseries dataset.

        Parameters
        ----------
        name : str

        url : str

        data_format : typing.Optional[CreateTimeseriesLiveApiV1DashboardDatasetsTimeseriesLivePostRequestDataFormat]

        datetime_format : typing.Optional[str]

        description : typing.Optional[str]

        params : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        aliases : typing.Optional[typing.Dict[str, typing.Optional[str]]]

        headers : typing.Optional[typing.Dict[str, typing.Optional[str]]]

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Dataset
            Successful Response

        Examples
        --------
        import asyncio

        from rebase_dashboard import AsyncRebaseDashboardApi

        client = AsyncRebaseDashboardApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.datasets.create_timeseries_live(
                name="name",
                url="url",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_timeseries_live(
            name=name,
            url=url,
            data_format=data_format,
            datetime_format=datetime_format,
            description=description,
            params=params,
            aliases=aliases,
            headers=headers,
            metadata=metadata,
            request_options=request_options,
        )
        return _response.data

    async def create_tabular_static(
        self,
        *,
        name: str,
        data: typing.Sequence[typing.Dict[str, typing.Optional[typing.Any]]],
        description: typing.Optional[str] = None,
        column_schema: typing.Optional[typing.Dict[str, typing.Optional[str]]] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[typing.Any]:
        """
        Create a static tabular dataset (placeholder).

        Parameters
        ----------
        name : str

        data : typing.Sequence[typing.Dict[str, typing.Optional[typing.Any]]]

        description : typing.Optional[str]

        column_schema : typing.Optional[typing.Dict[str, typing.Optional[str]]]

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        import asyncio

        from rebase_dashboard import AsyncRebaseDashboardApi

        client = AsyncRebaseDashboardApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.datasets.create_tabular_static(
                name="name",
                data=[{"key": "value"}],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_tabular_static(
            name=name,
            data=data,
            description=description,
            column_schema=column_schema,
            metadata=metadata,
            request_options=request_options,
        )
        return _response.data

    async def create_geospatial_static(
        self,
        *,
        name: str,
        data: typing.Sequence[typing.Dict[str, typing.Optional[typing.Any]]],
        coordinate_system: typing.Optional[str] = None,
        geometry_type: typing.Optional[
            CreateGeospatialStaticApiV1DashboardDatasetsGeospatialStaticPostRequestGeometryType
        ] = None,
        description: typing.Optional[str] = None,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Dataset:
        """
        Create a static geospatial dataset compatible with deck.gl data formats.

        Parameters
        ----------
        name : str

        data : typing.Sequence[typing.Dict[str, typing.Optional[typing.Any]]]

        coordinate_system : typing.Optional[str]

        geometry_type : typing.Optional[CreateGeospatialStaticApiV1DashboardDatasetsGeospatialStaticPostRequestGeometryType]

        description : typing.Optional[str]

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Dataset
            Successful Response

        Examples
        --------
        import asyncio

        from rebase_dashboard import AsyncRebaseDashboardApi

        client = AsyncRebaseDashboardApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.datasets.create_geospatial_static(
                name="name",
                data=[{"key": "value"}],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_geospatial_static(
            name=name,
            data=data,
            coordinate_system=coordinate_system,
            geometry_type=geometry_type,
            description=description,
            metadata=metadata,
            request_options=request_options,
        )
        return _response.data

    async def list_datasets(self, *, request_options: typing.Optional[RequestOptions] = None) -> typing.List[Dataset]:
        """
        List all datasets for the user.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Dataset]
            Successful Response

        Examples
        --------
        import asyncio

        from rebase_dashboard import AsyncRebaseDashboardApi

        client = AsyncRebaseDashboardApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.datasets.list_datasets()


        asyncio.run(main())
        """
        _response = await self._raw_client.list_datasets(request_options=request_options)
        return _response.data

    async def get_dataset(self, dataset_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Dataset:
        """
        Retrieve a single dataset by its ID.

        Parameters
        ----------
        dataset_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Dataset
            Successful Response

        Examples
        --------
        import asyncio

        from rebase_dashboard import AsyncRebaseDashboardApi

        client = AsyncRebaseDashboardApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.datasets.get_dataset(
                dataset_id="dataset_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_dataset(dataset_id, request_options=request_options)
        return _response.data

    async def update_dataset(
        self,
        dataset_id: str,
        *,
        name: str,
        description: typing.Optional[str] = None,
        request: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Dataset:
        """
        Update a dataset's basic properties (name, description, metadata only).

        Parameters
        ----------
        dataset_id : str

        name : str

        description : typing.Optional[str]

        request : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Dataset
            Successful Response

        Examples
        --------
        import asyncio

        from rebase_dashboard import AsyncRebaseDashboardApi

        client = AsyncRebaseDashboardApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.datasets.update_dataset(
                dataset_id="dataset_id",
                name="name",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_dataset(
            dataset_id, name=name, description=description, request=request, request_options=request_options
        )
        return _response.data

    async def delete_dataset(self, dataset_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete a dataset.

        Parameters
        ----------
        dataset_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from rebase_dashboard import AsyncRebaseDashboardApi

        client = AsyncRebaseDashboardApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.datasets.delete_dataset(
                dataset_id="dataset_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_dataset(dataset_id, request_options=request_options)
        return _response.data

    async def get_dataset_data(
        self,
        dataset_id: str,
        *,
        start: typing.Optional[str] = None,
        end: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[typing.Any]:
        """
        Get dataset data with optional time filtering. Works for static and live datasets of all types.

        Parameters
        ----------
        dataset_id : str

        start : typing.Optional[str]

        end : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        import asyncio

        from rebase_dashboard import AsyncRebaseDashboardApi

        client = AsyncRebaseDashboardApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.datasets.get_dataset_data(
                dataset_id="dataset_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_dataset_data(
            dataset_id, start=start, end=end, request_options=request_options
        )
        return _response.data
