# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.ui_config import UiConfig
from .raw_client import AsyncRawLayersClient, RawLayersClient
from .types.create_layer_api_v_1_dashboard_layers_post_response import CreateLayerApiV1DashboardLayersPostResponse
from .types.get_layer_api_v_1_dashboard_layers_layer_id_get_response import (
    GetLayerApiV1DashboardLayersLayerIdGetResponse,
)
from .types.list_layers_api_v_1_dashboard_layers_get_response_item import ListLayersApiV1DashboardLayersGetResponseItem
from .types.resolve_latest_dates_api_v_1_dashboard_layers_resolve_latest_post_response_item import (
    ResolveLatestDatesApiV1DashboardLayersResolveLatestPostResponseItem,
)
from .types.update_layer_api_v_1_dashboard_layers_layer_id_put_request_map_layer_type import (
    UpdateLayerApiV1DashboardLayersLayerIdPutRequestMapLayerType,
)
from .types.update_layer_api_v_1_dashboard_layers_layer_id_put_request_weather_layer_type import (
    UpdateLayerApiV1DashboardLayersLayerIdPutRequestWeatherLayerType,
)
from .types.update_layer_api_v_1_dashboard_layers_layer_id_put_response import (
    UpdateLayerApiV1DashboardLayersLayerIdPutResponse,
)

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class LayersClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawLayersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawLayersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawLayersClient
        """
        return self._raw_client

    def list_layers(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[ListLayersApiV1DashboardLayersGetResponseItem]:
        """
        List all layers for the authenticated user.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ListLayersApiV1DashboardLayersGetResponseItem]
            Successful Response

        Examples
        --------
        from rebase_dashboard import RebaseDashboardApi

        client = RebaseDashboardApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.layers.list_layers()
        """
        _response = self._raw_client.list_layers(request_options=request_options)
        return _response.data

    def create_layer(
        self,
        *,
        name: str,
        type: str,
        weather_model_id: typing.Optional[str] = None,
        variable: typing.Optional[str] = None,
        altitude: typing.Optional[int] = None,
        run_hour: typing.Optional[int] = None,
        run_day: typing.Optional[str] = None,
        dataset_id: typing.Optional[str] = None,
        deckgl_props: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        ui_config: typing.Optional[UiConfig] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateLayerApiV1DashboardLayersPostResponse:
        """
        Create a new layer using the discriminator pattern.

        The 'type' field determines which layer type to create:
        - Weather layers: 'wl:RasterLayer', 'wl:ParticleLayer', 'wl:IsolineLayer'
        - Map layers: 'ScatterPlotLayer', 'GeoJsonLayer'

        Parameters
        ----------
        name : str

        type : str

        weather_model_id : typing.Optional[str]

        variable : typing.Optional[str]

        altitude : typing.Optional[int]

        run_hour : typing.Optional[int]

        run_day : typing.Optional[str]

        dataset_id : typing.Optional[str]

        deckgl_props : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        ui_config : typing.Optional[UiConfig]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateLayerApiV1DashboardLayersPostResponse
            Successful Response

        Examples
        --------
        from rebase_dashboard import RebaseDashboardApi

        client = RebaseDashboardApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.layers.create_layer(
            name="name",
            type="type",
        )
        """
        _response = self._raw_client.create_layer(
            name=name,
            type=type,
            weather_model_id=weather_model_id,
            variable=variable,
            altitude=altitude,
            run_hour=run_hour,
            run_day=run_day,
            dataset_id=dataset_id,
            deckgl_props=deckgl_props,
            ui_config=ui_config,
            request_options=request_options,
        )
        return _response.data

    def get_layer(
        self, layer_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetLayerApiV1DashboardLayersLayerIdGetResponse:
        """
        Get a specific layer by ID.

        Parameters
        ----------
        layer_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetLayerApiV1DashboardLayersLayerIdGetResponse
            Successful Response

        Examples
        --------
        from rebase_dashboard import RebaseDashboardApi

        client = RebaseDashboardApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.layers.get_layer(
            layer_id="layer_id",
        )
        """
        _response = self._raw_client.get_layer(layer_id, request_options=request_options)
        return _response.data

    def update_layer(
        self,
        layer_id: str,
        *,
        name: str,
        weather_model_id: typing.Optional[str] = None,
        variable: typing.Optional[str] = None,
        altitude: typing.Optional[int] = None,
        run_hour: typing.Optional[int] = None,
        run_day: typing.Optional[str] = None,
        weather_layer_type: typing.Optional[UpdateLayerApiV1DashboardLayersLayerIdPutRequestWeatherLayerType] = None,
        map_layer_type: typing.Optional[UpdateLayerApiV1DashboardLayersLayerIdPutRequestMapLayerType] = None,
        dataset_id: typing.Optional[str] = None,
        deckgl_props: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        ui_config: typing.Optional[UiConfig] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateLayerApiV1DashboardLayersLayerIdPutResponse:
        """
        Update an existing layer.

        Parameters
        ----------
        layer_id : str

        name : str

        weather_model_id : typing.Optional[str]

        variable : typing.Optional[str]

        altitude : typing.Optional[int]

        run_hour : typing.Optional[int]

        run_day : typing.Optional[str]

        weather_layer_type : typing.Optional[UpdateLayerApiV1DashboardLayersLayerIdPutRequestWeatherLayerType]

        map_layer_type : typing.Optional[UpdateLayerApiV1DashboardLayersLayerIdPutRequestMapLayerType]

        dataset_id : typing.Optional[str]

        deckgl_props : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        ui_config : typing.Optional[UiConfig]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateLayerApiV1DashboardLayersLayerIdPutResponse
            Successful Response

        Examples
        --------
        from rebase_dashboard import RebaseDashboardApi

        client = RebaseDashboardApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.layers.update_layer(
            layer_id="layer_id",
            name="name",
        )
        """
        _response = self._raw_client.update_layer(
            layer_id,
            name=name,
            weather_model_id=weather_model_id,
            variable=variable,
            altitude=altitude,
            run_hour=run_hour,
            run_day=run_day,
            weather_layer_type=weather_layer_type,
            map_layer_type=map_layer_type,
            dataset_id=dataset_id,
            deckgl_props=deckgl_props,
            ui_config=ui_config,
            request_options=request_options,
        )
        return _response.data

    def delete_layer(
        self, layer_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[typing.Any]:
        """
        Delete a layer by ID.

        Parameters
        ----------
        layer_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        from rebase_dashboard import RebaseDashboardApi

        client = RebaseDashboardApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.layers.delete_layer(
            layer_id="layer_id",
        )
        """
        _response = self._raw_client.delete_layer(layer_id, request_options=request_options)
        return _response.data

    def resolve_latest_dates(
        self, *, request: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[ResolveLatestDatesApiV1DashboardLayersResolveLatestPostResponseItem]:
        """
        Resolve 'latest' run_day values to actual dates for multiple layers.

        Parameters
        ----------
        request : typing.Sequence[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ResolveLatestDatesApiV1DashboardLayersResolveLatestPostResponseItem]
            Successful Response

        Examples
        --------
        from rebase_dashboard import RebaseDashboardApi

        client = RebaseDashboardApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.layers.resolve_latest_dates(
            request=["string"],
        )
        """
        _response = self._raw_client.resolve_latest_dates(request=request, request_options=request_options)
        return _response.data


class AsyncLayersClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawLayersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawLayersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawLayersClient
        """
        return self._raw_client

    async def list_layers(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[ListLayersApiV1DashboardLayersGetResponseItem]:
        """
        List all layers for the authenticated user.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ListLayersApiV1DashboardLayersGetResponseItem]
            Successful Response

        Examples
        --------
        import asyncio

        from rebase_dashboard import AsyncRebaseDashboardApi

        client = AsyncRebaseDashboardApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.layers.list_layers()


        asyncio.run(main())
        """
        _response = await self._raw_client.list_layers(request_options=request_options)
        return _response.data

    async def create_layer(
        self,
        *,
        name: str,
        type: str,
        weather_model_id: typing.Optional[str] = None,
        variable: typing.Optional[str] = None,
        altitude: typing.Optional[int] = None,
        run_hour: typing.Optional[int] = None,
        run_day: typing.Optional[str] = None,
        dataset_id: typing.Optional[str] = None,
        deckgl_props: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        ui_config: typing.Optional[UiConfig] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateLayerApiV1DashboardLayersPostResponse:
        """
        Create a new layer using the discriminator pattern.

        The 'type' field determines which layer type to create:
        - Weather layers: 'wl:RasterLayer', 'wl:ParticleLayer', 'wl:IsolineLayer'
        - Map layers: 'ScatterPlotLayer', 'GeoJsonLayer'

        Parameters
        ----------
        name : str

        type : str

        weather_model_id : typing.Optional[str]

        variable : typing.Optional[str]

        altitude : typing.Optional[int]

        run_hour : typing.Optional[int]

        run_day : typing.Optional[str]

        dataset_id : typing.Optional[str]

        deckgl_props : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        ui_config : typing.Optional[UiConfig]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateLayerApiV1DashboardLayersPostResponse
            Successful Response

        Examples
        --------
        import asyncio

        from rebase_dashboard import AsyncRebaseDashboardApi

        client = AsyncRebaseDashboardApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.layers.create_layer(
                name="name",
                type="type",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_layer(
            name=name,
            type=type,
            weather_model_id=weather_model_id,
            variable=variable,
            altitude=altitude,
            run_hour=run_hour,
            run_day=run_day,
            dataset_id=dataset_id,
            deckgl_props=deckgl_props,
            ui_config=ui_config,
            request_options=request_options,
        )
        return _response.data

    async def get_layer(
        self, layer_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetLayerApiV1DashboardLayersLayerIdGetResponse:
        """
        Get a specific layer by ID.

        Parameters
        ----------
        layer_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetLayerApiV1DashboardLayersLayerIdGetResponse
            Successful Response

        Examples
        --------
        import asyncio

        from rebase_dashboard import AsyncRebaseDashboardApi

        client = AsyncRebaseDashboardApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.layers.get_layer(
                layer_id="layer_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_layer(layer_id, request_options=request_options)
        return _response.data

    async def update_layer(
        self,
        layer_id: str,
        *,
        name: str,
        weather_model_id: typing.Optional[str] = None,
        variable: typing.Optional[str] = None,
        altitude: typing.Optional[int] = None,
        run_hour: typing.Optional[int] = None,
        run_day: typing.Optional[str] = None,
        weather_layer_type: typing.Optional[UpdateLayerApiV1DashboardLayersLayerIdPutRequestWeatherLayerType] = None,
        map_layer_type: typing.Optional[UpdateLayerApiV1DashboardLayersLayerIdPutRequestMapLayerType] = None,
        dataset_id: typing.Optional[str] = None,
        deckgl_props: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        ui_config: typing.Optional[UiConfig] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateLayerApiV1DashboardLayersLayerIdPutResponse:
        """
        Update an existing layer.

        Parameters
        ----------
        layer_id : str

        name : str

        weather_model_id : typing.Optional[str]

        variable : typing.Optional[str]

        altitude : typing.Optional[int]

        run_hour : typing.Optional[int]

        run_day : typing.Optional[str]

        weather_layer_type : typing.Optional[UpdateLayerApiV1DashboardLayersLayerIdPutRequestWeatherLayerType]

        map_layer_type : typing.Optional[UpdateLayerApiV1DashboardLayersLayerIdPutRequestMapLayerType]

        dataset_id : typing.Optional[str]

        deckgl_props : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        ui_config : typing.Optional[UiConfig]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateLayerApiV1DashboardLayersLayerIdPutResponse
            Successful Response

        Examples
        --------
        import asyncio

        from rebase_dashboard import AsyncRebaseDashboardApi

        client = AsyncRebaseDashboardApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.layers.update_layer(
                layer_id="layer_id",
                name="name",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_layer(
            layer_id,
            name=name,
            weather_model_id=weather_model_id,
            variable=variable,
            altitude=altitude,
            run_hour=run_hour,
            run_day=run_day,
            weather_layer_type=weather_layer_type,
            map_layer_type=map_layer_type,
            dataset_id=dataset_id,
            deckgl_props=deckgl_props,
            ui_config=ui_config,
            request_options=request_options,
        )
        return _response.data

    async def delete_layer(
        self, layer_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[typing.Any]:
        """
        Delete a layer by ID.

        Parameters
        ----------
        layer_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        import asyncio

        from rebase_dashboard import AsyncRebaseDashboardApi

        client = AsyncRebaseDashboardApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.layers.delete_layer(
                layer_id="layer_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_layer(layer_id, request_options=request_options)
        return _response.data

    async def resolve_latest_dates(
        self, *, request: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[ResolveLatestDatesApiV1DashboardLayersResolveLatestPostResponseItem]:
        """
        Resolve 'latest' run_day values to actual dates for multiple layers.

        Parameters
        ----------
        request : typing.Sequence[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ResolveLatestDatesApiV1DashboardLayersResolveLatestPostResponseItem]
            Successful Response

        Examples
        --------
        import asyncio

        from rebase_dashboard import AsyncRebaseDashboardApi

        client = AsyncRebaseDashboardApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.layers.resolve_latest_dates(
                request=["string"],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.resolve_latest_dates(request=request, request_options=request_options)
        return _response.data
