# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..core.serialization import convert_and_respect_annotation_metadata
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.http_validation_error import HttpValidationError
from ..types.ui_config import UiConfig
from .types.create_layer_api_v_1_dashboard_layers_post_response import CreateLayerApiV1DashboardLayersPostResponse
from .types.get_layer_api_v_1_dashboard_layers_layer_id_get_response import (
    GetLayerApiV1DashboardLayersLayerIdGetResponse,
)
from .types.list_layers_api_v_1_dashboard_layers_get_response_item import ListLayersApiV1DashboardLayersGetResponseItem
from .types.resolve_latest_dates_api_v_1_dashboard_layers_resolve_latest_post_response_item import (
    ResolveLatestDatesApiV1DashboardLayersResolveLatestPostResponseItem,
)
from .types.update_layer_api_v_1_dashboard_layers_layer_id_put_request_map_layer_type import (
    UpdateLayerApiV1DashboardLayersLayerIdPutRequestMapLayerType,
)
from .types.update_layer_api_v_1_dashboard_layers_layer_id_put_request_weather_layer_type import (
    UpdateLayerApiV1DashboardLayersLayerIdPutRequestWeatherLayerType,
)
from .types.update_layer_api_v_1_dashboard_layers_layer_id_put_response import (
    UpdateLayerApiV1DashboardLayersLayerIdPutResponse,
)

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawLayersClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list_layers(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[typing.List[ListLayersApiV1DashboardLayersGetResponseItem]]:
        """
        List all layers for the authenticated user.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[ListLayersApiV1DashboardLayersGetResponseItem]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/v1/dashboard/layers",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ListLayersApiV1DashboardLayersGetResponseItem],
                    parse_obj_as(
                        type_=typing.List[ListLayersApiV1DashboardLayersGetResponseItem],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create_layer(
        self,
        *,
        name: str,
        type: str,
        weather_model_id: typing.Optional[str] = None,
        variable: typing.Optional[str] = None,
        altitude: typing.Optional[int] = None,
        run_hour: typing.Optional[int] = None,
        run_day: typing.Optional[str] = None,
        dataset_id: typing.Optional[str] = None,
        deckgl_props: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        ui_config: typing.Optional[UiConfig] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[CreateLayerApiV1DashboardLayersPostResponse]:
        """
        Create a new layer using the discriminator pattern.

        The 'type' field determines which layer type to create:
        - Weather layers: 'wl:RasterLayer', 'wl:ParticleLayer', 'wl:IsolineLayer'
        - Map layers: 'ScatterPlotLayer', 'GeoJsonLayer'

        Parameters
        ----------
        name : str

        type : str

        weather_model_id : typing.Optional[str]

        variable : typing.Optional[str]

        altitude : typing.Optional[int]

        run_hour : typing.Optional[int]

        run_day : typing.Optional[str]

        dataset_id : typing.Optional[str]

        deckgl_props : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        ui_config : typing.Optional[UiConfig]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CreateLayerApiV1DashboardLayersPostResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/v1/dashboard/layers",
            method="POST",
            params={
                "name": name,
                "type": type,
                "weather_model_id": weather_model_id,
                "variable": variable,
                "altitude": altitude,
                "run_hour": run_hour,
                "run_day": run_day,
                "dataset_id": dataset_id,
            },
            json={
                "deckgl_props": deckgl_props,
                "ui_config": convert_and_respect_annotation_metadata(
                    object_=ui_config, annotation=UiConfig, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CreateLayerApiV1DashboardLayersPostResponse,
                    parse_obj_as(
                        type_=CreateLayerApiV1DashboardLayersPostResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_layer(
        self, layer_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[GetLayerApiV1DashboardLayersLayerIdGetResponse]:
        """
        Get a specific layer by ID.

        Parameters
        ----------
        layer_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetLayerApiV1DashboardLayersLayerIdGetResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/v1/dashboard/layers/{jsonable_encoder(layer_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetLayerApiV1DashboardLayersLayerIdGetResponse,
                    parse_obj_as(
                        type_=GetLayerApiV1DashboardLayersLayerIdGetResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update_layer(
        self,
        layer_id: str,
        *,
        name: str,
        weather_model_id: typing.Optional[str] = None,
        variable: typing.Optional[str] = None,
        altitude: typing.Optional[int] = None,
        run_hour: typing.Optional[int] = None,
        run_day: typing.Optional[str] = None,
        weather_layer_type: typing.Optional[UpdateLayerApiV1DashboardLayersLayerIdPutRequestWeatherLayerType] = None,
        map_layer_type: typing.Optional[UpdateLayerApiV1DashboardLayersLayerIdPutRequestMapLayerType] = None,
        dataset_id: typing.Optional[str] = None,
        deckgl_props: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        ui_config: typing.Optional[UiConfig] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[UpdateLayerApiV1DashboardLayersLayerIdPutResponse]:
        """
        Update an existing layer.

        Parameters
        ----------
        layer_id : str

        name : str

        weather_model_id : typing.Optional[str]

        variable : typing.Optional[str]

        altitude : typing.Optional[int]

        run_hour : typing.Optional[int]

        run_day : typing.Optional[str]

        weather_layer_type : typing.Optional[UpdateLayerApiV1DashboardLayersLayerIdPutRequestWeatherLayerType]

        map_layer_type : typing.Optional[UpdateLayerApiV1DashboardLayersLayerIdPutRequestMapLayerType]

        dataset_id : typing.Optional[str]

        deckgl_props : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        ui_config : typing.Optional[UiConfig]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[UpdateLayerApiV1DashboardLayersLayerIdPutResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/v1/dashboard/layers/{jsonable_encoder(layer_id)}",
            method="PUT",
            params={
                "name": name,
                "weather_model_id": weather_model_id,
                "variable": variable,
                "altitude": altitude,
                "run_hour": run_hour,
                "run_day": run_day,
                "weather_layer_type": weather_layer_type,
                "map_layer_type": map_layer_type,
                "dataset_id": dataset_id,
            },
            json={
                "deckgl_props": deckgl_props,
                "ui_config": convert_and_respect_annotation_metadata(
                    object_=ui_config, annotation=UiConfig, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UpdateLayerApiV1DashboardLayersLayerIdPutResponse,
                    parse_obj_as(
                        type_=UpdateLayerApiV1DashboardLayersLayerIdPutResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete_layer(
        self, layer_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[typing.Optional[typing.Any]]:
        """
        Delete a layer by ID.

        Parameters
        ----------
        layer_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.Optional[typing.Any]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/v1/dashboard/layers/{jsonable_encoder(layer_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if _response is None or not _response.text.strip():
                return HttpResponse(response=_response, data=None)
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[typing.Any],
                    parse_obj_as(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def resolve_latest_dates(
        self, *, request: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[typing.List[ResolveLatestDatesApiV1DashboardLayersResolveLatestPostResponseItem]]:
        """
        Resolve 'latest' run_day values to actual dates for multiple layers.

        Parameters
        ----------
        request : typing.Sequence[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[ResolveLatestDatesApiV1DashboardLayersResolveLatestPostResponseItem]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/v1/dashboard/layers/resolve-latest",
            method="POST",
            json=request,
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ResolveLatestDatesApiV1DashboardLayersResolveLatestPostResponseItem],
                    parse_obj_as(
                        type_=typing.List[ResolveLatestDatesApiV1DashboardLayersResolveLatestPostResponseItem],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawLayersClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list_layers(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[typing.List[ListLayersApiV1DashboardLayersGetResponseItem]]:
        """
        List all layers for the authenticated user.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[ListLayersApiV1DashboardLayersGetResponseItem]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/v1/dashboard/layers",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ListLayersApiV1DashboardLayersGetResponseItem],
                    parse_obj_as(
                        type_=typing.List[ListLayersApiV1DashboardLayersGetResponseItem],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create_layer(
        self,
        *,
        name: str,
        type: str,
        weather_model_id: typing.Optional[str] = None,
        variable: typing.Optional[str] = None,
        altitude: typing.Optional[int] = None,
        run_hour: typing.Optional[int] = None,
        run_day: typing.Optional[str] = None,
        dataset_id: typing.Optional[str] = None,
        deckgl_props: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        ui_config: typing.Optional[UiConfig] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[CreateLayerApiV1DashboardLayersPostResponse]:
        """
        Create a new layer using the discriminator pattern.

        The 'type' field determines which layer type to create:
        - Weather layers: 'wl:RasterLayer', 'wl:ParticleLayer', 'wl:IsolineLayer'
        - Map layers: 'ScatterPlotLayer', 'GeoJsonLayer'

        Parameters
        ----------
        name : str

        type : str

        weather_model_id : typing.Optional[str]

        variable : typing.Optional[str]

        altitude : typing.Optional[int]

        run_hour : typing.Optional[int]

        run_day : typing.Optional[str]

        dataset_id : typing.Optional[str]

        deckgl_props : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        ui_config : typing.Optional[UiConfig]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CreateLayerApiV1DashboardLayersPostResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/v1/dashboard/layers",
            method="POST",
            params={
                "name": name,
                "type": type,
                "weather_model_id": weather_model_id,
                "variable": variable,
                "altitude": altitude,
                "run_hour": run_hour,
                "run_day": run_day,
                "dataset_id": dataset_id,
            },
            json={
                "deckgl_props": deckgl_props,
                "ui_config": convert_and_respect_annotation_metadata(
                    object_=ui_config, annotation=UiConfig, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CreateLayerApiV1DashboardLayersPostResponse,
                    parse_obj_as(
                        type_=CreateLayerApiV1DashboardLayersPostResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_layer(
        self, layer_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[GetLayerApiV1DashboardLayersLayerIdGetResponse]:
        """
        Get a specific layer by ID.

        Parameters
        ----------
        layer_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetLayerApiV1DashboardLayersLayerIdGetResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/v1/dashboard/layers/{jsonable_encoder(layer_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetLayerApiV1DashboardLayersLayerIdGetResponse,
                    parse_obj_as(
                        type_=GetLayerApiV1DashboardLayersLayerIdGetResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update_layer(
        self,
        layer_id: str,
        *,
        name: str,
        weather_model_id: typing.Optional[str] = None,
        variable: typing.Optional[str] = None,
        altitude: typing.Optional[int] = None,
        run_hour: typing.Optional[int] = None,
        run_day: typing.Optional[str] = None,
        weather_layer_type: typing.Optional[UpdateLayerApiV1DashboardLayersLayerIdPutRequestWeatherLayerType] = None,
        map_layer_type: typing.Optional[UpdateLayerApiV1DashboardLayersLayerIdPutRequestMapLayerType] = None,
        dataset_id: typing.Optional[str] = None,
        deckgl_props: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        ui_config: typing.Optional[UiConfig] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[UpdateLayerApiV1DashboardLayersLayerIdPutResponse]:
        """
        Update an existing layer.

        Parameters
        ----------
        layer_id : str

        name : str

        weather_model_id : typing.Optional[str]

        variable : typing.Optional[str]

        altitude : typing.Optional[int]

        run_hour : typing.Optional[int]

        run_day : typing.Optional[str]

        weather_layer_type : typing.Optional[UpdateLayerApiV1DashboardLayersLayerIdPutRequestWeatherLayerType]

        map_layer_type : typing.Optional[UpdateLayerApiV1DashboardLayersLayerIdPutRequestMapLayerType]

        dataset_id : typing.Optional[str]

        deckgl_props : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        ui_config : typing.Optional[UiConfig]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[UpdateLayerApiV1DashboardLayersLayerIdPutResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/v1/dashboard/layers/{jsonable_encoder(layer_id)}",
            method="PUT",
            params={
                "name": name,
                "weather_model_id": weather_model_id,
                "variable": variable,
                "altitude": altitude,
                "run_hour": run_hour,
                "run_day": run_day,
                "weather_layer_type": weather_layer_type,
                "map_layer_type": map_layer_type,
                "dataset_id": dataset_id,
            },
            json={
                "deckgl_props": deckgl_props,
                "ui_config": convert_and_respect_annotation_metadata(
                    object_=ui_config, annotation=UiConfig, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UpdateLayerApiV1DashboardLayersLayerIdPutResponse,
                    parse_obj_as(
                        type_=UpdateLayerApiV1DashboardLayersLayerIdPutResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete_layer(
        self, layer_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[typing.Optional[typing.Any]]:
        """
        Delete a layer by ID.

        Parameters
        ----------
        layer_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.Optional[typing.Any]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/v1/dashboard/layers/{jsonable_encoder(layer_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if _response is None or not _response.text.strip():
                return AsyncHttpResponse(response=_response, data=None)
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[typing.Any],
                    parse_obj_as(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def resolve_latest_dates(
        self, *, request: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[typing.List[ResolveLatestDatesApiV1DashboardLayersResolveLatestPostResponseItem]]:
        """
        Resolve 'latest' run_day values to actual dates for multiple layers.

        Parameters
        ----------
        request : typing.Sequence[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[ResolveLatestDatesApiV1DashboardLayersResolveLatestPostResponseItem]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/v1/dashboard/layers/resolve-latest",
            method="POST",
            json=request,
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ResolveLatestDatesApiV1DashboardLayersResolveLatestPostResponseItem],
                    parse_obj_as(
                        type_=typing.List[ResolveLatestDatesApiV1DashboardLayersResolveLatestPostResponseItem],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
