# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.image_meta_response import ImageMetaResponse
from ..types.model_meta import ModelMeta
from ..types.model_meta_response import ModelMetaResponse
from ..types.model_runs_response import ModelRunsResponse
from .raw_client import AsyncRawWeatherClient, RawWeatherClient


class WeatherClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawWeatherClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawWeatherClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawWeatherClient
        """
        return self._raw_client

    def get_model_list(self, *, request_options: typing.Optional[RequestOptions] = None) -> typing.List[ModelMeta]:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ModelMeta]
            Successful Response

        Examples
        --------
        from rebase_dashboard import RebaseDashboardApi

        client = RebaseDashboardApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.weather.get_model_list()
        """
        _response = self._raw_client.get_model_list(request_options=request_options)
        return _response.data

    def get_model_meta(
        self, model: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ModelMetaResponse:
        """
        Parameters
        ----------
        model : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ModelMetaResponse
            Successful Response

        Examples
        --------
        from rebase_dashboard import RebaseDashboardApi

        client = RebaseDashboardApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.weather.get_model_meta(
            model="model",
        )
        """
        _response = self._raw_client.get_model_meta(model, request_options=request_options)
        return _response.data

    def get_available_model_runs_for_date(
        self, model: str, year: int, month: int, day: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ModelRunsResponse:
        """
        Parameters
        ----------
        model : str

        year : int

        month : int

        day : int

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ModelRunsResponse
            Successful Response

        Examples
        --------
        from rebase_dashboard import RebaseDashboardApi

        client = RebaseDashboardApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.weather.get_available_model_runs_for_date(
            model="model",
            year=1,
            month=1,
            day=1,
        )
        """
        _response = self._raw_client.get_available_model_runs_for_date(
            model, year, month, day, request_options=request_options
        )
        return _response.data

    def get_forecast_run(
        self,
        model: str,
        year: int,
        month: int,
        day: int,
        hour: int,
        variable: str,
        height: str,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ImageMetaResponse:
        """
        Parameters
        ----------
        model : str

        year : int

        month : int

        day : int

        hour : int

        variable : str

        height : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ImageMetaResponse
            Successful Response

        Examples
        --------
        from rebase_dashboard import RebaseDashboardApi

        client = RebaseDashboardApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.weather.get_forecast_run(
            model="model",
            year=1,
            month=1,
            day=1,
            hour=1,
            variable="variable",
            height="height",
        )
        """
        _response = self._raw_client.get_forecast_run(
            model, year, month, day, hour, variable, height, request_options=request_options
        )
        return _response.data

    def get_historical_data(
        self,
        model: str,
        variable: str,
        height: str,
        *,
        start_date: str,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ImageMetaResponse:
        """
        Fetch historical images for a given model/variable/height and date range.
        Uses new storage structure: ERA5/CloudCover/Height_High/YYYY/MM/DD/filename.webp
        This allows fetching all images for a variable/height in a single S3 call.

        Parameters
        ----------
        model : str

        variable : str

        height : str

        start_date : str
            Start date in YYYY-MM-DD format

        end_date : typing.Optional[str]
            End date in YYYY-MM-DD format (optional, defaults to start_date, inclusive)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ImageMetaResponse
            Successful Response

        Examples
        --------
        from rebase_dashboard import RebaseDashboardApi

        client = RebaseDashboardApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.weather.get_historical_data(
            model="model",
            variable="variable",
            height="height",
            start_date="start_date",
        )
        """
        _response = self._raw_client.get_historical_data(
            model, variable, height, start_date=start_date, end_date=end_date, request_options=request_options
        )
        return _response.data


class AsyncWeatherClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawWeatherClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawWeatherClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawWeatherClient
        """
        return self._raw_client

    async def get_model_list(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[ModelMeta]:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ModelMeta]
            Successful Response

        Examples
        --------
        import asyncio

        from rebase_dashboard import AsyncRebaseDashboardApi

        client = AsyncRebaseDashboardApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.weather.get_model_list()


        asyncio.run(main())
        """
        _response = await self._raw_client.get_model_list(request_options=request_options)
        return _response.data

    async def get_model_meta(
        self, model: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ModelMetaResponse:
        """
        Parameters
        ----------
        model : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ModelMetaResponse
            Successful Response

        Examples
        --------
        import asyncio

        from rebase_dashboard import AsyncRebaseDashboardApi

        client = AsyncRebaseDashboardApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.weather.get_model_meta(
                model="model",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_model_meta(model, request_options=request_options)
        return _response.data

    async def get_available_model_runs_for_date(
        self, model: str, year: int, month: int, day: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ModelRunsResponse:
        """
        Parameters
        ----------
        model : str

        year : int

        month : int

        day : int

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ModelRunsResponse
            Successful Response

        Examples
        --------
        import asyncio

        from rebase_dashboard import AsyncRebaseDashboardApi

        client = AsyncRebaseDashboardApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.weather.get_available_model_runs_for_date(
                model="model",
                year=1,
                month=1,
                day=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_available_model_runs_for_date(
            model, year, month, day, request_options=request_options
        )
        return _response.data

    async def get_forecast_run(
        self,
        model: str,
        year: int,
        month: int,
        day: int,
        hour: int,
        variable: str,
        height: str,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ImageMetaResponse:
        """
        Parameters
        ----------
        model : str

        year : int

        month : int

        day : int

        hour : int

        variable : str

        height : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ImageMetaResponse
            Successful Response

        Examples
        --------
        import asyncio

        from rebase_dashboard import AsyncRebaseDashboardApi

        client = AsyncRebaseDashboardApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.weather.get_forecast_run(
                model="model",
                year=1,
                month=1,
                day=1,
                hour=1,
                variable="variable",
                height="height",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_forecast_run(
            model, year, month, day, hour, variable, height, request_options=request_options
        )
        return _response.data

    async def get_historical_data(
        self,
        model: str,
        variable: str,
        height: str,
        *,
        start_date: str,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ImageMetaResponse:
        """
        Fetch historical images for a given model/variable/height and date range.
        Uses new storage structure: ERA5/CloudCover/Height_High/YYYY/MM/DD/filename.webp
        This allows fetching all images for a variable/height in a single S3 call.

        Parameters
        ----------
        model : str

        variable : str

        height : str

        start_date : str
            Start date in YYYY-MM-DD format

        end_date : typing.Optional[str]
            End date in YYYY-MM-DD format (optional, defaults to start_date, inclusive)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ImageMetaResponse
            Successful Response

        Examples
        --------
        import asyncio

        from rebase_dashboard import AsyncRebaseDashboardApi

        client = AsyncRebaseDashboardApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.weather.get_historical_data(
                model="model",
                variable="variable",
                height="height",
                start_date="start_date",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_historical_data(
            model, variable, height, start_date=start_date, end_date=end_date, request_options=request_options
        )
        return _response.data
