"""Stub file for reflex/components/plotly/plotly.py"""

# ------------------- DO NOT EDIT ----------------------
# This file was generated by `reflex/utils/pyi_generator.py`!
# ------------------------------------------------------
from collections.abc import Mapping, Sequence
from typing import TYPE_CHECKING, Any, TypedDict, TypeVar

from reflex.components.component import NoSSRComponent
from reflex.components.core.breakpoints import Breakpoints
from reflex.event import EventType, PointerEventInfo
from reflex.utils import console
from reflex.utils.imports import ImportDict
from reflex.vars.base import Var

try:
    from plotly.graph_objs import Figure
    from plotly.graph_objs.layout import Template
except ImportError:
    console.warn("Plotly is not installed. Please run `pip install plotly`.")
    if not TYPE_CHECKING:
        Figure = Any
        Template = Any
T = TypeVar("T")
ItemOrList = T | list[T]

class BBox(TypedDict):
    x0: float | int | None
    x1: float | int | None
    y0: float | int | None
    y1: float | int | None
    z0: float | int | None
    z1: float | int | None

class Point(TypedDict):
    x: float | int | None
    y: float | int | None
    z: float | int | None
    lat: float | int | None
    lon: float | int | None
    curveNumber: int | None
    pointNumber: int | None
    pointNumbers: list[int] | None
    pointIndex: int | None
    markerColor: ItemOrList[ItemOrList[float | int | str | None]] | None
    markerSize: ItemOrList[ItemOrList[float | int | None,]] | None
    bbox: BBox | None

class Plotly(NoSSRComponent):
    def add_imports(self) -> dict[str, str]: ...
    def add_custom_code(self) -> list[str]: ...
    @classmethod
    def create(
        cls,
        *children,
        data: Figure | Var[Figure] | None = None,
        layout: Var[dict] | dict | None = None,
        template: Template | Var[Template] | None = None,
        config: Var[dict] | dict | None = None,
        use_resize_handler: Var[bool] | bool | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        autofocus: bool | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_after_plot: EventType[()] | None = None,
        on_animated: EventType[()] | None = None,
        on_animating_frame: EventType[()] | None = None,
        on_animation_interrupted: EventType[()] | None = None,
        on_autosize: EventType[()] | None = None,
        on_before_hover: EventType[()] | None = None,
        on_blur: EventType[()] | None = None,
        on_button_clicked: EventType[()] | None = None,
        on_click: EventType[()] | EventType[list[Point]] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_deselect: EventType[()] | None = None,
        on_double_click: EventType[()] | None = None,
        on_focus: EventType[()] | None = None,
        on_hover: EventType[()] | EventType[list[Point]] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_redraw: EventType[()] | None = None,
        on_relayout: EventType[()] | None = None,
        on_relayouting: EventType[()] | None = None,
        on_restyle: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_selected: EventType[()] | EventType[list[Point]] | None = None,
        on_selecting: EventType[()] | EventType[list[Point]] | None = None,
        on_transition_interrupted: EventType[()] | None = None,
        on_transitioning: EventType[()] | None = None,
        on_unhover: EventType[()] | EventType[list[Point]] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> Plotly:
        """Create the Plotly component.

        Args:
            *children: The children of the component.
            data: The figure to display. This can be a plotly figure or a plotly data json.
            layout: The layout of the graph.
            template: The template for visual appearance of the graph.
            config: The config of the graph.
            use_resize_handler: If true, the graph will resize when the window is resized.
            on_after_plot: Fired after the plot is redrawn.
            on_animated: Fired after the plot was animated.
            on_animating_frame: Fired while animating a single frame (does not currently pass data through).
            on_animation_interrupted: Fired when an animation is interrupted (to start a new animation for example).
            on_autosize: Fired when the plot is responsively sized.
            on_before_hover: Fired whenever mouse moves over a plot.
            on_button_clicked: Fired when a plotly UI button is clicked.
            on_click: Fired when the plot is clicked.
            on_deselect: Fired when a selection is cleared (via double click).
            on_double_click: Fired when the plot is double clicked.
            on_hover: Fired when a plot element is hovered over.
            on_relayout: Fired after the plot is laid out (zoom, pan, etc).
            on_relayouting: Fired while the plot is being laid out.
            on_restyle: Fired after the plot style is changed.
            on_redraw: Fired after the plot is redrawn.
            on_selected: Fired after selecting plot elements.
            on_selecting: Fired while dragging a selection.
            on_transitioning: Fired while an animation is occurring.
            on_transition_interrupted: Fired when a transition is stopped early.
            on_unhover: Fired when a hovered element is no longer hovered.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            autofocus: Whether the component should take the focus once the page is loaded
            custom_attrs: custom attribute
            **props: The properties of the component.

        Returns:
            The Plotly component.
        """

CREATE_PLOTLY_COMPONENT: ImportDict

def dynamic_plotly_import(name: str, package: str) -> str: ...

class PlotlyBasic(Plotly):
    def add_imports(self) -> ImportDict | list[ImportDict]: ...
    @classmethod
    def create(
        cls,
        *children,
        data: Figure | Var[Figure] | None = None,
        layout: Var[dict] | dict | None = None,
        template: Template | Var[Template] | None = None,
        config: Var[dict] | dict | None = None,
        use_resize_handler: Var[bool] | bool | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        autofocus: bool | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_after_plot: EventType[()] | None = None,
        on_animated: EventType[()] | None = None,
        on_animating_frame: EventType[()] | None = None,
        on_animation_interrupted: EventType[()] | None = None,
        on_autosize: EventType[()] | None = None,
        on_before_hover: EventType[()] | None = None,
        on_blur: EventType[()] | None = None,
        on_button_clicked: EventType[()] | None = None,
        on_click: EventType[()] | EventType[list[Point]] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_deselect: EventType[()] | None = None,
        on_double_click: EventType[()] | None = None,
        on_focus: EventType[()] | None = None,
        on_hover: EventType[()] | EventType[list[Point]] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_redraw: EventType[()] | None = None,
        on_relayout: EventType[()] | None = None,
        on_relayouting: EventType[()] | None = None,
        on_restyle: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_selected: EventType[()] | EventType[list[Point]] | None = None,
        on_selecting: EventType[()] | EventType[list[Point]] | None = None,
        on_transition_interrupted: EventType[()] | None = None,
        on_transitioning: EventType[()] | None = None,
        on_unhover: EventType[()] | EventType[list[Point]] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> PlotlyBasic:
        """Create the Plotly component.

        Args:
            *children: The children of the component.
            data: The figure to display. This can be a plotly figure or a plotly data json.
            layout: The layout of the graph.
            template: The template for visual appearance of the graph.
            config: The config of the graph.
            use_resize_handler: If true, the graph will resize when the window is resized.
            on_after_plot: Fired after the plot is redrawn.
            on_animated: Fired after the plot was animated.
            on_animating_frame: Fired while animating a single frame (does not currently pass data through).
            on_animation_interrupted: Fired when an animation is interrupted (to start a new animation for example).
            on_autosize: Fired when the plot is responsively sized.
            on_before_hover: Fired whenever mouse moves over a plot.
            on_button_clicked: Fired when a plotly UI button is clicked.
            on_click: Fired when the plot is clicked.
            on_deselect: Fired when a selection is cleared (via double click).
            on_double_click: Fired when the plot is double clicked.
            on_hover: Fired when a plot element is hovered over.
            on_relayout: Fired after the plot is laid out (zoom, pan, etc).
            on_relayouting: Fired while the plot is being laid out.
            on_restyle: Fired after the plot style is changed.
            on_redraw: Fired after the plot is redrawn.
            on_selected: Fired after selecting plot elements.
            on_selecting: Fired while dragging a selection.
            on_transitioning: Fired while an animation is occurring.
            on_transition_interrupted: Fired when a transition is stopped early.
            on_unhover: Fired when a hovered element is no longer hovered.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            autofocus: Whether the component should take the focus once the page is loaded
            custom_attrs: custom attribute
            **props: The properties of the component.

        Returns:
            The Plotly component.
        """

class PlotlyCartesian(Plotly):
    def add_imports(self) -> ImportDict | list[ImportDict]: ...
    @classmethod
    def create(
        cls,
        *children,
        data: Figure | Var[Figure] | None = None,
        layout: Var[dict] | dict | None = None,
        template: Template | Var[Template] | None = None,
        config: Var[dict] | dict | None = None,
        use_resize_handler: Var[bool] | bool | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        autofocus: bool | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_after_plot: EventType[()] | None = None,
        on_animated: EventType[()] | None = None,
        on_animating_frame: EventType[()] | None = None,
        on_animation_interrupted: EventType[()] | None = None,
        on_autosize: EventType[()] | None = None,
        on_before_hover: EventType[()] | None = None,
        on_blur: EventType[()] | None = None,
        on_button_clicked: EventType[()] | None = None,
        on_click: EventType[()] | EventType[list[Point]] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_deselect: EventType[()] | None = None,
        on_double_click: EventType[()] | None = None,
        on_focus: EventType[()] | None = None,
        on_hover: EventType[()] | EventType[list[Point]] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_redraw: EventType[()] | None = None,
        on_relayout: EventType[()] | None = None,
        on_relayouting: EventType[()] | None = None,
        on_restyle: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_selected: EventType[()] | EventType[list[Point]] | None = None,
        on_selecting: EventType[()] | EventType[list[Point]] | None = None,
        on_transition_interrupted: EventType[()] | None = None,
        on_transitioning: EventType[()] | None = None,
        on_unhover: EventType[()] | EventType[list[Point]] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> PlotlyCartesian:
        """Create the Plotly component.

        Args:
            *children: The children of the component.
            data: The figure to display. This can be a plotly figure or a plotly data json.
            layout: The layout of the graph.
            template: The template for visual appearance of the graph.
            config: The config of the graph.
            use_resize_handler: If true, the graph will resize when the window is resized.
            on_after_plot: Fired after the plot is redrawn.
            on_animated: Fired after the plot was animated.
            on_animating_frame: Fired while animating a single frame (does not currently pass data through).
            on_animation_interrupted: Fired when an animation is interrupted (to start a new animation for example).
            on_autosize: Fired when the plot is responsively sized.
            on_before_hover: Fired whenever mouse moves over a plot.
            on_button_clicked: Fired when a plotly UI button is clicked.
            on_click: Fired when the plot is clicked.
            on_deselect: Fired when a selection is cleared (via double click).
            on_double_click: Fired when the plot is double clicked.
            on_hover: Fired when a plot element is hovered over.
            on_relayout: Fired after the plot is laid out (zoom, pan, etc).
            on_relayouting: Fired while the plot is being laid out.
            on_restyle: Fired after the plot style is changed.
            on_redraw: Fired after the plot is redrawn.
            on_selected: Fired after selecting plot elements.
            on_selecting: Fired while dragging a selection.
            on_transitioning: Fired while an animation is occurring.
            on_transition_interrupted: Fired when a transition is stopped early.
            on_unhover: Fired when a hovered element is no longer hovered.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            autofocus: Whether the component should take the focus once the page is loaded
            custom_attrs: custom attribute
            **props: The properties of the component.

        Returns:
            The Plotly component.
        """

class PlotlyGeo(Plotly):
    def add_imports(self) -> ImportDict | list[ImportDict]: ...
    @classmethod
    def create(
        cls,
        *children,
        data: Figure | Var[Figure] | None = None,
        layout: Var[dict] | dict | None = None,
        template: Template | Var[Template] | None = None,
        config: Var[dict] | dict | None = None,
        use_resize_handler: Var[bool] | bool | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        autofocus: bool | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_after_plot: EventType[()] | None = None,
        on_animated: EventType[()] | None = None,
        on_animating_frame: EventType[()] | None = None,
        on_animation_interrupted: EventType[()] | None = None,
        on_autosize: EventType[()] | None = None,
        on_before_hover: EventType[()] | None = None,
        on_blur: EventType[()] | None = None,
        on_button_clicked: EventType[()] | None = None,
        on_click: EventType[()] | EventType[list[Point]] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_deselect: EventType[()] | None = None,
        on_double_click: EventType[()] | None = None,
        on_focus: EventType[()] | None = None,
        on_hover: EventType[()] | EventType[list[Point]] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_redraw: EventType[()] | None = None,
        on_relayout: EventType[()] | None = None,
        on_relayouting: EventType[()] | None = None,
        on_restyle: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_selected: EventType[()] | EventType[list[Point]] | None = None,
        on_selecting: EventType[()] | EventType[list[Point]] | None = None,
        on_transition_interrupted: EventType[()] | None = None,
        on_transitioning: EventType[()] | None = None,
        on_unhover: EventType[()] | EventType[list[Point]] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> PlotlyGeo:
        """Create the Plotly component.

        Args:
            *children: The children of the component.
            data: The figure to display. This can be a plotly figure or a plotly data json.
            layout: The layout of the graph.
            template: The template for visual appearance of the graph.
            config: The config of the graph.
            use_resize_handler: If true, the graph will resize when the window is resized.
            on_after_plot: Fired after the plot is redrawn.
            on_animated: Fired after the plot was animated.
            on_animating_frame: Fired while animating a single frame (does not currently pass data through).
            on_animation_interrupted: Fired when an animation is interrupted (to start a new animation for example).
            on_autosize: Fired when the plot is responsively sized.
            on_before_hover: Fired whenever mouse moves over a plot.
            on_button_clicked: Fired when a plotly UI button is clicked.
            on_click: Fired when the plot is clicked.
            on_deselect: Fired when a selection is cleared (via double click).
            on_double_click: Fired when the plot is double clicked.
            on_hover: Fired when a plot element is hovered over.
            on_relayout: Fired after the plot is laid out (zoom, pan, etc).
            on_relayouting: Fired while the plot is being laid out.
            on_restyle: Fired after the plot style is changed.
            on_redraw: Fired after the plot is redrawn.
            on_selected: Fired after selecting plot elements.
            on_selecting: Fired while dragging a selection.
            on_transitioning: Fired while an animation is occurring.
            on_transition_interrupted: Fired when a transition is stopped early.
            on_unhover: Fired when a hovered element is no longer hovered.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            autofocus: Whether the component should take the focus once the page is loaded
            custom_attrs: custom attribute
            **props: The properties of the component.

        Returns:
            The Plotly component.
        """

class PlotlyGl3d(Plotly):
    def add_imports(self) -> ImportDict | list[ImportDict]: ...
    @classmethod
    def create(
        cls,
        *children,
        data: Figure | Var[Figure] | None = None,
        layout: Var[dict] | dict | None = None,
        template: Template | Var[Template] | None = None,
        config: Var[dict] | dict | None = None,
        use_resize_handler: Var[bool] | bool | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        autofocus: bool | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_after_plot: EventType[()] | None = None,
        on_animated: EventType[()] | None = None,
        on_animating_frame: EventType[()] | None = None,
        on_animation_interrupted: EventType[()] | None = None,
        on_autosize: EventType[()] | None = None,
        on_before_hover: EventType[()] | None = None,
        on_blur: EventType[()] | None = None,
        on_button_clicked: EventType[()] | None = None,
        on_click: EventType[()] | EventType[list[Point]] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_deselect: EventType[()] | None = None,
        on_double_click: EventType[()] | None = None,
        on_focus: EventType[()] | None = None,
        on_hover: EventType[()] | EventType[list[Point]] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_redraw: EventType[()] | None = None,
        on_relayout: EventType[()] | None = None,
        on_relayouting: EventType[()] | None = None,
        on_restyle: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_selected: EventType[()] | EventType[list[Point]] | None = None,
        on_selecting: EventType[()] | EventType[list[Point]] | None = None,
        on_transition_interrupted: EventType[()] | None = None,
        on_transitioning: EventType[()] | None = None,
        on_unhover: EventType[()] | EventType[list[Point]] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> PlotlyGl3d:
        """Create the Plotly component.

        Args:
            *children: The children of the component.
            data: The figure to display. This can be a plotly figure or a plotly data json.
            layout: The layout of the graph.
            template: The template for visual appearance of the graph.
            config: The config of the graph.
            use_resize_handler: If true, the graph will resize when the window is resized.
            on_after_plot: Fired after the plot is redrawn.
            on_animated: Fired after the plot was animated.
            on_animating_frame: Fired while animating a single frame (does not currently pass data through).
            on_animation_interrupted: Fired when an animation is interrupted (to start a new animation for example).
            on_autosize: Fired when the plot is responsively sized.
            on_before_hover: Fired whenever mouse moves over a plot.
            on_button_clicked: Fired when a plotly UI button is clicked.
            on_click: Fired when the plot is clicked.
            on_deselect: Fired when a selection is cleared (via double click).
            on_double_click: Fired when the plot is double clicked.
            on_hover: Fired when a plot element is hovered over.
            on_relayout: Fired after the plot is laid out (zoom, pan, etc).
            on_relayouting: Fired while the plot is being laid out.
            on_restyle: Fired after the plot style is changed.
            on_redraw: Fired after the plot is redrawn.
            on_selected: Fired after selecting plot elements.
            on_selecting: Fired while dragging a selection.
            on_transitioning: Fired while an animation is occurring.
            on_transition_interrupted: Fired when a transition is stopped early.
            on_unhover: Fired when a hovered element is no longer hovered.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            autofocus: Whether the component should take the focus once the page is loaded
            custom_attrs: custom attribute
            **props: The properties of the component.

        Returns:
            The Plotly component.
        """

class PlotlyGl2d(Plotly):
    def add_imports(self) -> ImportDict | list[ImportDict]: ...
    @classmethod
    def create(
        cls,
        *children,
        data: Figure | Var[Figure] | None = None,
        layout: Var[dict] | dict | None = None,
        template: Template | Var[Template] | None = None,
        config: Var[dict] | dict | None = None,
        use_resize_handler: Var[bool] | bool | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        autofocus: bool | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_after_plot: EventType[()] | None = None,
        on_animated: EventType[()] | None = None,
        on_animating_frame: EventType[()] | None = None,
        on_animation_interrupted: EventType[()] | None = None,
        on_autosize: EventType[()] | None = None,
        on_before_hover: EventType[()] | None = None,
        on_blur: EventType[()] | None = None,
        on_button_clicked: EventType[()] | None = None,
        on_click: EventType[()] | EventType[list[Point]] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_deselect: EventType[()] | None = None,
        on_double_click: EventType[()] | None = None,
        on_focus: EventType[()] | None = None,
        on_hover: EventType[()] | EventType[list[Point]] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_redraw: EventType[()] | None = None,
        on_relayout: EventType[()] | None = None,
        on_relayouting: EventType[()] | None = None,
        on_restyle: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_selected: EventType[()] | EventType[list[Point]] | None = None,
        on_selecting: EventType[()] | EventType[list[Point]] | None = None,
        on_transition_interrupted: EventType[()] | None = None,
        on_transitioning: EventType[()] | None = None,
        on_unhover: EventType[()] | EventType[list[Point]] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> PlotlyGl2d:
        """Create the Plotly component.

        Args:
            *children: The children of the component.
            data: The figure to display. This can be a plotly figure or a plotly data json.
            layout: The layout of the graph.
            template: The template for visual appearance of the graph.
            config: The config of the graph.
            use_resize_handler: If true, the graph will resize when the window is resized.
            on_after_plot: Fired after the plot is redrawn.
            on_animated: Fired after the plot was animated.
            on_animating_frame: Fired while animating a single frame (does not currently pass data through).
            on_animation_interrupted: Fired when an animation is interrupted (to start a new animation for example).
            on_autosize: Fired when the plot is responsively sized.
            on_before_hover: Fired whenever mouse moves over a plot.
            on_button_clicked: Fired when a plotly UI button is clicked.
            on_click: Fired when the plot is clicked.
            on_deselect: Fired when a selection is cleared (via double click).
            on_double_click: Fired when the plot is double clicked.
            on_hover: Fired when a plot element is hovered over.
            on_relayout: Fired after the plot is laid out (zoom, pan, etc).
            on_relayouting: Fired while the plot is being laid out.
            on_restyle: Fired after the plot style is changed.
            on_redraw: Fired after the plot is redrawn.
            on_selected: Fired after selecting plot elements.
            on_selecting: Fired while dragging a selection.
            on_transitioning: Fired while an animation is occurring.
            on_transition_interrupted: Fired when a transition is stopped early.
            on_unhover: Fired when a hovered element is no longer hovered.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            autofocus: Whether the component should take the focus once the page is loaded
            custom_attrs: custom attribute
            **props: The properties of the component.

        Returns:
            The Plotly component.
        """

class PlotlyMapbox(Plotly):
    def add_imports(self) -> ImportDict | list[ImportDict]: ...
    @classmethod
    def create(
        cls,
        *children,
        data: Figure | Var[Figure] | None = None,
        layout: Var[dict] | dict | None = None,
        template: Template | Var[Template] | None = None,
        config: Var[dict] | dict | None = None,
        use_resize_handler: Var[bool] | bool | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        autofocus: bool | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_after_plot: EventType[()] | None = None,
        on_animated: EventType[()] | None = None,
        on_animating_frame: EventType[()] | None = None,
        on_animation_interrupted: EventType[()] | None = None,
        on_autosize: EventType[()] | None = None,
        on_before_hover: EventType[()] | None = None,
        on_blur: EventType[()] | None = None,
        on_button_clicked: EventType[()] | None = None,
        on_click: EventType[()] | EventType[list[Point]] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_deselect: EventType[()] | None = None,
        on_double_click: EventType[()] | None = None,
        on_focus: EventType[()] | None = None,
        on_hover: EventType[()] | EventType[list[Point]] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_redraw: EventType[()] | None = None,
        on_relayout: EventType[()] | None = None,
        on_relayouting: EventType[()] | None = None,
        on_restyle: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_selected: EventType[()] | EventType[list[Point]] | None = None,
        on_selecting: EventType[()] | EventType[list[Point]] | None = None,
        on_transition_interrupted: EventType[()] | None = None,
        on_transitioning: EventType[()] | None = None,
        on_unhover: EventType[()] | EventType[list[Point]] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> PlotlyMapbox:
        """Create the Plotly component.

        Args:
            *children: The children of the component.
            data: The figure to display. This can be a plotly figure or a plotly data json.
            layout: The layout of the graph.
            template: The template for visual appearance of the graph.
            config: The config of the graph.
            use_resize_handler: If true, the graph will resize when the window is resized.
            on_after_plot: Fired after the plot is redrawn.
            on_animated: Fired after the plot was animated.
            on_animating_frame: Fired while animating a single frame (does not currently pass data through).
            on_animation_interrupted: Fired when an animation is interrupted (to start a new animation for example).
            on_autosize: Fired when the plot is responsively sized.
            on_before_hover: Fired whenever mouse moves over a plot.
            on_button_clicked: Fired when a plotly UI button is clicked.
            on_click: Fired when the plot is clicked.
            on_deselect: Fired when a selection is cleared (via double click).
            on_double_click: Fired when the plot is double clicked.
            on_hover: Fired when a plot element is hovered over.
            on_relayout: Fired after the plot is laid out (zoom, pan, etc).
            on_relayouting: Fired while the plot is being laid out.
            on_restyle: Fired after the plot style is changed.
            on_redraw: Fired after the plot is redrawn.
            on_selected: Fired after selecting plot elements.
            on_selecting: Fired while dragging a selection.
            on_transitioning: Fired while an animation is occurring.
            on_transition_interrupted: Fired when a transition is stopped early.
            on_unhover: Fired when a hovered element is no longer hovered.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            autofocus: Whether the component should take the focus once the page is loaded
            custom_attrs: custom attribute
            **props: The properties of the component.

        Returns:
            The Plotly component.
        """

class PlotlyFinance(Plotly):
    def add_imports(self) -> ImportDict | list[ImportDict]: ...
    @classmethod
    def create(
        cls,
        *children,
        data: Figure | Var[Figure] | None = None,
        layout: Var[dict] | dict | None = None,
        template: Template | Var[Template] | None = None,
        config: Var[dict] | dict | None = None,
        use_resize_handler: Var[bool] | bool | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        autofocus: bool | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_after_plot: EventType[()] | None = None,
        on_animated: EventType[()] | None = None,
        on_animating_frame: EventType[()] | None = None,
        on_animation_interrupted: EventType[()] | None = None,
        on_autosize: EventType[()] | None = None,
        on_before_hover: EventType[()] | None = None,
        on_blur: EventType[()] | None = None,
        on_button_clicked: EventType[()] | None = None,
        on_click: EventType[()] | EventType[list[Point]] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_deselect: EventType[()] | None = None,
        on_double_click: EventType[()] | None = None,
        on_focus: EventType[()] | None = None,
        on_hover: EventType[()] | EventType[list[Point]] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_redraw: EventType[()] | None = None,
        on_relayout: EventType[()] | None = None,
        on_relayouting: EventType[()] | None = None,
        on_restyle: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_selected: EventType[()] | EventType[list[Point]] | None = None,
        on_selecting: EventType[()] | EventType[list[Point]] | None = None,
        on_transition_interrupted: EventType[()] | None = None,
        on_transitioning: EventType[()] | None = None,
        on_unhover: EventType[()] | EventType[list[Point]] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> PlotlyFinance:
        """Create the Plotly component.

        Args:
            *children: The children of the component.
            data: The figure to display. This can be a plotly figure or a plotly data json.
            layout: The layout of the graph.
            template: The template for visual appearance of the graph.
            config: The config of the graph.
            use_resize_handler: If true, the graph will resize when the window is resized.
            on_after_plot: Fired after the plot is redrawn.
            on_animated: Fired after the plot was animated.
            on_animating_frame: Fired while animating a single frame (does not currently pass data through).
            on_animation_interrupted: Fired when an animation is interrupted (to start a new animation for example).
            on_autosize: Fired when the plot is responsively sized.
            on_before_hover: Fired whenever mouse moves over a plot.
            on_button_clicked: Fired when a plotly UI button is clicked.
            on_click: Fired when the plot is clicked.
            on_deselect: Fired when a selection is cleared (via double click).
            on_double_click: Fired when the plot is double clicked.
            on_hover: Fired when a plot element is hovered over.
            on_relayout: Fired after the plot is laid out (zoom, pan, etc).
            on_relayouting: Fired while the plot is being laid out.
            on_restyle: Fired after the plot style is changed.
            on_redraw: Fired after the plot is redrawn.
            on_selected: Fired after selecting plot elements.
            on_selecting: Fired while dragging a selection.
            on_transitioning: Fired while an animation is occurring.
            on_transition_interrupted: Fired when a transition is stopped early.
            on_unhover: Fired when a hovered element is no longer hovered.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            autofocus: Whether the component should take the focus once the page is loaded
            custom_attrs: custom attribute
            **props: The properties of the component.

        Returns:
            The Plotly component.
        """

class PlotlyStrict(Plotly):
    def add_imports(self) -> ImportDict | list[ImportDict]: ...
    @classmethod
    def create(
        cls,
        *children,
        data: Figure | Var[Figure] | None = None,
        layout: Var[dict] | dict | None = None,
        template: Template | Var[Template] | None = None,
        config: Var[dict] | dict | None = None,
        use_resize_handler: Var[bool] | bool | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        autofocus: bool | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_after_plot: EventType[()] | None = None,
        on_animated: EventType[()] | None = None,
        on_animating_frame: EventType[()] | None = None,
        on_animation_interrupted: EventType[()] | None = None,
        on_autosize: EventType[()] | None = None,
        on_before_hover: EventType[()] | None = None,
        on_blur: EventType[()] | None = None,
        on_button_clicked: EventType[()] | None = None,
        on_click: EventType[()] | EventType[list[Point]] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_deselect: EventType[()] | None = None,
        on_double_click: EventType[()] | None = None,
        on_focus: EventType[()] | None = None,
        on_hover: EventType[()] | EventType[list[Point]] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_redraw: EventType[()] | None = None,
        on_relayout: EventType[()] | None = None,
        on_relayouting: EventType[()] | None = None,
        on_restyle: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_selected: EventType[()] | EventType[list[Point]] | None = None,
        on_selecting: EventType[()] | EventType[list[Point]] | None = None,
        on_transition_interrupted: EventType[()] | None = None,
        on_transitioning: EventType[()] | None = None,
        on_unhover: EventType[()] | EventType[list[Point]] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> PlotlyStrict:
        """Create the Plotly component.

        Args:
            *children: The children of the component.
            data: The figure to display. This can be a plotly figure or a plotly data json.
            layout: The layout of the graph.
            template: The template for visual appearance of the graph.
            config: The config of the graph.
            use_resize_handler: If true, the graph will resize when the window is resized.
            on_after_plot: Fired after the plot is redrawn.
            on_animated: Fired after the plot was animated.
            on_animating_frame: Fired while animating a single frame (does not currently pass data through).
            on_animation_interrupted: Fired when an animation is interrupted (to start a new animation for example).
            on_autosize: Fired when the plot is responsively sized.
            on_before_hover: Fired whenever mouse moves over a plot.
            on_button_clicked: Fired when a plotly UI button is clicked.
            on_click: Fired when the plot is clicked.
            on_deselect: Fired when a selection is cleared (via double click).
            on_double_click: Fired when the plot is double clicked.
            on_hover: Fired when a plot element is hovered over.
            on_relayout: Fired after the plot is laid out (zoom, pan, etc).
            on_relayouting: Fired while the plot is being laid out.
            on_restyle: Fired after the plot style is changed.
            on_redraw: Fired after the plot is redrawn.
            on_selected: Fired after selecting plot elements.
            on_selecting: Fired while dragging a selection.
            on_transitioning: Fired while an animation is occurring.
            on_transition_interrupted: Fired when a transition is stopped early.
            on_unhover: Fired when a hovered element is no longer hovered.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            autofocus: Whether the component should take the focus once the page is loaded
            custom_attrs: custom attribute
            **props: The properties of the component.

        Returns:
            The Plotly component.
        """
