"""Stub file for reflex/components/radix/themes/components/checkbox.py"""

# ------------------- DO NOT EDIT ----------------------
# This file was generated by `reflex/utils/pyi_generator.py`!
# ------------------------------------------------------
from collections.abc import Mapping, Sequence
from typing import Any, Literal

from reflex.components.component import ComponentNamespace
from reflex.components.core.breakpoints import Breakpoints
from reflex.components.radix.themes.base import RadixThemesComponent
from reflex.event import EventType, PointerEventInfo
from reflex.vars.base import Var

LiteralCheckboxSize = Literal["1", "2", "3"]
LiteralCheckboxVariant = Literal["classic", "surface", "soft"]

class Checkbox(RadixThemesComponent):
    @classmethod
    def create(
        cls,
        *children,
        as_child: Var[bool] | bool | None = None,
        size: Breakpoints[str, Literal["1", "2", "3"]]
        | Literal["1", "2", "3"]
        | Var[Breakpoints[str, Literal["1", "2", "3"]] | Literal["1", "2", "3"]]
        | None = None,
        variant: Literal["classic", "soft", "surface"]
        | Var[Literal["classic", "soft", "surface"]]
        | None = None,
        color_scheme: Literal[
            "amber",
            "blue",
            "bronze",
            "brown",
            "crimson",
            "cyan",
            "gold",
            "grass",
            "gray",
            "green",
            "indigo",
            "iris",
            "jade",
            "lime",
            "mint",
            "orange",
            "pink",
            "plum",
            "purple",
            "red",
            "ruby",
            "sky",
            "teal",
            "tomato",
            "violet",
            "yellow",
        ]
        | Var[
            Literal[
                "amber",
                "blue",
                "bronze",
                "brown",
                "crimson",
                "cyan",
                "gold",
                "grass",
                "gray",
                "green",
                "indigo",
                "iris",
                "jade",
                "lime",
                "mint",
                "orange",
                "pink",
                "plum",
                "purple",
                "red",
                "ruby",
                "sky",
                "teal",
                "tomato",
                "violet",
                "yellow",
            ]
        ]
        | None = None,
        high_contrast: Var[bool] | bool | None = None,
        default_checked: Var[bool] | bool | None = None,
        checked: Var[bool] | bool | None = None,
        disabled: Var[bool] | bool | None = None,
        required: Var[bool] | bool | None = None,
        name: Var[str] | str | None = None,
        value: Var[str] | str | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        autofocus: bool | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_change: EventType[()] | EventType[bool] | None = None,
        on_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> Checkbox:
        """Create a new component instance.

        Will prepend "RadixThemes" to the component tag to avoid conflicts with
        other UI libraries for common names, like Text and Button.

        Args:
            *children: Child components.
            as_child: Change the default rendered element for the one passed as a child, merging their props and behavior.
            size: Checkbox size "1" - "3"
            variant: Variant of checkbox: "classic" | "surface" | "soft"
            color_scheme: Override theme color for checkbox
            high_contrast: Whether to render the checkbox with higher contrast color against background
            default_checked: Whether the checkbox is checked by default
            checked: Whether the checkbox is checked
            disabled: Whether the checkbox is disabled
            required: Whether the checkbox is required
            name: The name of the checkbox control when submitting the form.
            value: The value of the checkbox control when submitting the form.
            on_change: Fired when the checkbox is checked or unchecked.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            autofocus: Whether the component should take the focus once the page is loaded
            custom_attrs: custom attribute
            **props: Component properties.

        Returns:
            A new component instance.
        """

class HighLevelCheckbox(RadixThemesComponent):
    @classmethod
    def create(
        cls,
        *children,
        text: Var[str] | str | None = None,
        spacing: Literal["0", "1", "2", "3", "4", "5", "6", "7", "8", "9"]
        | Var[Literal["0", "1", "2", "3", "4", "5", "6", "7", "8", "9"]]
        | None = None,
        size: Literal["1", "2", "3"] | Var[Literal["1", "2", "3"]] | None = None,
        as_child: Var[bool] | bool | None = None,
        variant: Literal["classic", "soft", "surface"]
        | Var[Literal["classic", "soft", "surface"]]
        | None = None,
        color_scheme: Literal[
            "amber",
            "blue",
            "bronze",
            "brown",
            "crimson",
            "cyan",
            "gold",
            "grass",
            "gray",
            "green",
            "indigo",
            "iris",
            "jade",
            "lime",
            "mint",
            "orange",
            "pink",
            "plum",
            "purple",
            "red",
            "ruby",
            "sky",
            "teal",
            "tomato",
            "violet",
            "yellow",
        ]
        | Var[
            Literal[
                "amber",
                "blue",
                "bronze",
                "brown",
                "crimson",
                "cyan",
                "gold",
                "grass",
                "gray",
                "green",
                "indigo",
                "iris",
                "jade",
                "lime",
                "mint",
                "orange",
                "pink",
                "plum",
                "purple",
                "red",
                "ruby",
                "sky",
                "teal",
                "tomato",
                "violet",
                "yellow",
            ]
        ]
        | None = None,
        high_contrast: Var[bool] | bool | None = None,
        default_checked: Var[bool] | bool | None = None,
        checked: Var[bool] | bool | None = None,
        disabled: Var[bool] | bool | None = None,
        required: Var[bool] | bool | None = None,
        name: Var[str] | str | None = None,
        value: Var[str] | str | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        autofocus: bool | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_change: EventType[()] | EventType[bool] | None = None,
        on_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> HighLevelCheckbox:
        """Create a checkbox with a label.

        Args:
            text: The text of the label.
            text: The text label for the checkbox.
            spacing: The gap between the checkbox and the label.
            size: The size of the checkbox "1" - "3".
            as_child: Change the default rendered element for the one passed as a child, merging their props and behavior.
            variant: Variant of checkbox: "classic" | "surface" | "soft"
            color_scheme: Override theme color for checkbox
            high_contrast: Whether to render the checkbox with higher contrast color against background
            default_checked: Whether the checkbox is checked by default
            checked: Whether the checkbox is checked
            disabled: Whether the checkbox is disabled
            required: Whether the checkbox is required
            name: The name of the checkbox control when submitting the form.
            value: The value of the checkbox control when submitting the form.
            on_change: Fired when the checkbox is checked or unchecked.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            autofocus: Whether the component should take the focus once the page is loaded
            custom_attrs: custom attribute
            **props: Additional properties to apply to the checkbox item.

        Returns:
            The checkbox component with a label.
        """

class CheckboxNamespace(ComponentNamespace):
    @staticmethod
    def __call__(
        *children,
        text: Var[str] | str | None = None,
        spacing: Literal["0", "1", "2", "3", "4", "5", "6", "7", "8", "9"]
        | Var[Literal["0", "1", "2", "3", "4", "5", "6", "7", "8", "9"]]
        | None = None,
        size: Literal["1", "2", "3"] | Var[Literal["1", "2", "3"]] | None = None,
        as_child: Var[bool] | bool | None = None,
        variant: Literal["classic", "soft", "surface"]
        | Var[Literal["classic", "soft", "surface"]]
        | None = None,
        color_scheme: Literal[
            "amber",
            "blue",
            "bronze",
            "brown",
            "crimson",
            "cyan",
            "gold",
            "grass",
            "gray",
            "green",
            "indigo",
            "iris",
            "jade",
            "lime",
            "mint",
            "orange",
            "pink",
            "plum",
            "purple",
            "red",
            "ruby",
            "sky",
            "teal",
            "tomato",
            "violet",
            "yellow",
        ]
        | Var[
            Literal[
                "amber",
                "blue",
                "bronze",
                "brown",
                "crimson",
                "cyan",
                "gold",
                "grass",
                "gray",
                "green",
                "indigo",
                "iris",
                "jade",
                "lime",
                "mint",
                "orange",
                "pink",
                "plum",
                "purple",
                "red",
                "ruby",
                "sky",
                "teal",
                "tomato",
                "violet",
                "yellow",
            ]
        ]
        | None = None,
        high_contrast: Var[bool] | bool | None = None,
        default_checked: Var[bool] | bool | None = None,
        checked: Var[bool] | bool | None = None,
        disabled: Var[bool] | bool | None = None,
        required: Var[bool] | bool | None = None,
        name: Var[str] | str | None = None,
        value: Var[str] | str | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        autofocus: bool | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_change: EventType[()] | EventType[bool] | None = None,
        on_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> HighLevelCheckbox:
        """Create a checkbox with a label.

        Args:
            text: The text of the label.
            text: The text label for the checkbox.
            spacing: The gap between the checkbox and the label.
            size: The size of the checkbox "1" - "3".
            as_child: Change the default rendered element for the one passed as a child, merging their props and behavior.
            variant: Variant of checkbox: "classic" | "surface" | "soft"
            color_scheme: Override theme color for checkbox
            high_contrast: Whether to render the checkbox with higher contrast color against background
            default_checked: Whether the checkbox is checked by default
            checked: Whether the checkbox is checked
            disabled: Whether the checkbox is disabled
            required: Whether the checkbox is required
            name: The name of the checkbox control when submitting the form.
            value: The value of the checkbox control when submitting the form.
            on_change: Fired when the checkbox is checked or unchecked.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            autofocus: Whether the component should take the focus once the page is loaded
            custom_attrs: custom attribute
            **props: Additional properties to apply to the checkbox item.

        Returns:
            The checkbox component with a label.
        """

checkbox = CheckboxNamespace()
