"""Stub file for reflex/components/recharts/cartesian.py"""

# ------------------- DO NOT EDIT ----------------------
# This file was generated by `reflex/utils/pyi_generator.py`!
# ------------------------------------------------------
from collections.abc import Mapping, Sequence
from typing import Any, Literal, TypedDict

from reflex.components.core.breakpoints import Breakpoints
from reflex.constants.colors import Color
from reflex.event import EventType, PointerEventInfo
from reflex.vars.base import Var

from .recharts import Recharts

class Axis(Recharts):
    @classmethod
    def create(
        cls,
        *children,
        data_key: Var[int | str] | int | str | None = None,
        hide: Var[bool] | bool | None = None,
        width: Var[int | str] | int | str | None = None,
        height: Var[int | str] | int | str | None = None,
        type_: Literal["category", "number"]
        | Var[Literal["category", "number"]]
        | None = None,
        interval: Literal[
            "equidistantPreserveStart",
            "preserveEnd",
            "preserveStart",
            "preserveStartEnd",
        ]
        | Var[
            Literal[
                "equidistantPreserveStart",
                "preserveEnd",
                "preserveStart",
                "preserveStartEnd",
            ]
            | int
        ]
        | int
        | None = None,
        allow_decimals: Var[bool] | bool | None = None,
        allow_data_overflow: Var[bool] | bool | None = None,
        allow_duplicated_category: Var[bool] | bool | None = None,
        domain: Sequence | Var[Sequence] | None = None,
        axis_line: Var[bool] | bool | None = None,
        mirror: Var[bool] | bool | None = None,
        reversed: Var[bool] | bool | None = None,
        label: Var[dict[str, Any] | int | str]
        | dict[str, Any]
        | int
        | str
        | None = None,
        scale: Literal[
            "auto",
            "band",
            "identity",
            "linear",
            "log",
            "ordinal",
            "point",
            "pow",
            "quantile",
            "quantize",
            "sequential",
            "sqrt",
            "threshold",
            "time",
            "utc",
        ]
        | Var[
            Literal[
                "auto",
                "band",
                "identity",
                "linear",
                "log",
                "ordinal",
                "point",
                "pow",
                "quantile",
                "quantize",
                "sequential",
                "sqrt",
                "threshold",
                "time",
                "utc",
            ]
        ]
        | None = None,
        unit: Var[int | str] | int | str | None = None,
        name: Var[int | str] | int | str | None = None,
        ticks: Sequence[int | str] | Var[Sequence[int | str]] | None = None,
        tick: Var[bool | dict] | bool | dict | None = None,
        tick_count: Var[int] | int | None = None,
        tick_line: Var[bool] | bool | None = None,
        tick_size: Var[int] | int | None = None,
        min_tick_gap: Var[int] | int | None = None,
        stroke: Color | Var[Color | str] | str | None = None,
        text_anchor: Literal["end", "middle", "start"]
        | Var[Literal["end", "middle", "start"]]
        | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        autofocus: bool | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> Axis:
        """Create the component.

        Args:
            *children: The children of the component.
            data_key: The key of data displayed in the axis.
            hide: If set true, the axis do not display in the chart. Default: False
            width: The width of axis which is usually calculated internally.
            height: The height of axis, which can be set by user.
            type_: The type of axis 'number' | 'category'
            interval: If set 0, all the ticks will be shown. If set preserveStart", "preserveEnd" or "preserveStartEnd", the ticks which is to be shown or hidden will be calculated automatically. Default: "preserveEnd"
            allow_decimals: Allow the ticks of Axis to be decimals or not. Default: True
            allow_data_overflow: When domain of the axis is specified and the type of the axis is 'number', if allowDataOverflow is set to be false, the domain will be adjusted when the minimum value of data is smaller than domain[0] or the maximum value of data is greater than domain[1] so that the axis displays all data values. If set to true, graphic elements (line, area, bars) will be clipped to conform to the specified domain. Default: False
            allow_duplicated_category: Allow the axis has duplicated categorys or not when the type of axis is "category". Default: True
            domain: The range of the axis. Work best in conjunction with allow_data_overflow. Default: [0, "auto"]
            axis_line: If set false, no axis line will be drawn. Default: True
            mirror: If set true, flips ticks around the axis line, displaying the labels inside the chart instead of outside. Default: False
            reversed: Reverse the ticks or not. Default: False
            label: The label of axis, which appears next to the axis.
            scale: If 'auto' set, the scale function is decided by the type of chart, and the props type. 'auto' | 'linear' | 'pow' | 'sqrt' | 'log' | 'identity' | 'time' | 'band' | 'point' | 'ordinal' | 'quantile' | 'quantize' | 'utc' | 'sequential' | 'threshold'. Default: "auto"
            unit: The unit of data displayed in the axis. This option will be used to represent an index unit in a scatter chart.
            name: The name of data displayed in the axis. This option will be used to represent an index in a scatter chart.
            ticks: Set the values of axis ticks manually.
            tick: If set false, no ticks will be drawn.
            tick_count: The count of axis ticks. Not used if 'type' is 'category'. Default: 5
            tick_line: If set false, no axis tick lines will be drawn. Default: True
            tick_size: The length of tick line. Default: 6
            min_tick_gap: The minimum gap between two adjacent labels. Default: 5
            stroke: The stroke color of axis. Default: rx.color("gray", 9)
            text_anchor: The text anchor of axis. Default: "middle"
            on_click: The customized event handler of click on the ticks of this axis
            on_mouse_down: The customized event handler of mousedown on the ticks of this axis
            on_mouse_up: The customized event handler of mouseup on the ticks of this axis
            on_mouse_move: The customized event handler of mousemove on the ticks of this axis
            on_mouse_out: The customized event handler of mouseout on the ticks of this axis
            on_mouse_enter: The customized event handler of mouseenter on the ticks of this axis
            on_mouse_leave: The customized event handler of mouseleave on the ticks of this axis
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            autofocus: Whether the component should take the focus once the page is loaded
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The component.
        """

class XAxis(Axis):
    @classmethod
    def create(
        cls,
        *children,
        orientation: Literal["bottom", "top"]
        | Var[Literal["bottom", "top"]]
        | None = None,
        x_axis_id: Var[int | str] | int | str | None = None,
        include_hidden: Var[bool] | bool | None = None,
        angle: Var[int] | int | None = None,
        padding: Var[dict[str, int]] | dict[str, int] | None = None,
        data_key: Var[int | str] | int | str | None = None,
        hide: Var[bool] | bool | None = None,
        width: Var[int | str] | int | str | None = None,
        height: Var[int | str] | int | str | None = None,
        type_: Literal["category", "number"]
        | Var[Literal["category", "number"]]
        | None = None,
        interval: Literal[
            "equidistantPreserveStart",
            "preserveEnd",
            "preserveStart",
            "preserveStartEnd",
        ]
        | Var[
            Literal[
                "equidistantPreserveStart",
                "preserveEnd",
                "preserveStart",
                "preserveStartEnd",
            ]
            | int
        ]
        | int
        | None = None,
        allow_decimals: Var[bool] | bool | None = None,
        allow_data_overflow: Var[bool] | bool | None = None,
        allow_duplicated_category: Var[bool] | bool | None = None,
        domain: Sequence | Var[Sequence] | None = None,
        axis_line: Var[bool] | bool | None = None,
        mirror: Var[bool] | bool | None = None,
        reversed: Var[bool] | bool | None = None,
        label: Var[dict[str, Any] | int | str]
        | dict[str, Any]
        | int
        | str
        | None = None,
        scale: Literal[
            "auto",
            "band",
            "identity",
            "linear",
            "log",
            "ordinal",
            "point",
            "pow",
            "quantile",
            "quantize",
            "sequential",
            "sqrt",
            "threshold",
            "time",
            "utc",
        ]
        | Var[
            Literal[
                "auto",
                "band",
                "identity",
                "linear",
                "log",
                "ordinal",
                "point",
                "pow",
                "quantile",
                "quantize",
                "sequential",
                "sqrt",
                "threshold",
                "time",
                "utc",
            ]
        ]
        | None = None,
        unit: Var[int | str] | int | str | None = None,
        name: Var[int | str] | int | str | None = None,
        ticks: Sequence[int | str] | Var[Sequence[int | str]] | None = None,
        tick: Var[bool | dict] | bool | dict | None = None,
        tick_count: Var[int] | int | None = None,
        tick_line: Var[bool] | bool | None = None,
        tick_size: Var[int] | int | None = None,
        min_tick_gap: Var[int] | int | None = None,
        stroke: Color | Var[Color | str] | str | None = None,
        text_anchor: Literal["end", "middle", "start"]
        | Var[Literal["end", "middle", "start"]]
        | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        autofocus: bool | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> XAxis:
        """Create the component.

        Args:
            *children: The children of the component.
            orientation: The orientation of axis 'top' | 'bottom'. Default: "bottom"
            x_axis_id: The id of x-axis which is corresponding to the data. Default: 0
            include_hidden: Ensures that all datapoints within a chart contribute to its domain calculation, even when they are hidden. Default: False
            angle: The angle of axis ticks. Default: 0
            padding: Specify the padding of x-axis. Default: {"left": 0, "right": 0}
            data_key: The key of data displayed in the axis.
            hide: If set true, the axis do not display in the chart. Default: False
            width: The width of axis which is usually calculated internally.
            height: The height of axis, which can be set by user.
            type_: The type of axis 'number' | 'category'
            interval: If set 0, all the ticks will be shown. If set preserveStart", "preserveEnd" or "preserveStartEnd", the ticks which is to be shown or hidden will be calculated automatically. Default: "preserveEnd"
            allow_decimals: Allow the ticks of Axis to be decimals or not. Default: True
            allow_data_overflow: When domain of the axis is specified and the type of the axis is 'number', if allowDataOverflow is set to be false, the domain will be adjusted when the minimum value of data is smaller than domain[0] or the maximum value of data is greater than domain[1] so that the axis displays all data values. If set to true, graphic elements (line, area, bars) will be clipped to conform to the specified domain. Default: False
            allow_duplicated_category: Allow the axis has duplicated categorys or not when the type of axis is "category". Default: True
            domain: The range of the axis. Work best in conjunction with allow_data_overflow. Default: [0, "auto"]
            axis_line: If set false, no axis line will be drawn. Default: True
            mirror: If set true, flips ticks around the axis line, displaying the labels inside the chart instead of outside. Default: False
            reversed: Reverse the ticks or not. Default: False
            label: The label of axis, which appears next to the axis.
            scale: If 'auto' set, the scale function is decided by the type of chart, and the props type. 'auto' | 'linear' | 'pow' | 'sqrt' | 'log' | 'identity' | 'time' | 'band' | 'point' | 'ordinal' | 'quantile' | 'quantize' | 'utc' | 'sequential' | 'threshold'. Default: "auto"
            unit: The unit of data displayed in the axis. This option will be used to represent an index unit in a scatter chart.
            name: The name of data displayed in the axis. This option will be used to represent an index in a scatter chart.
            ticks: Set the values of axis ticks manually.
            tick: If set false, no ticks will be drawn.
            tick_count: The count of axis ticks. Not used if 'type' is 'category'. Default: 5
            tick_line: If set false, no axis tick lines will be drawn. Default: True
            tick_size: The length of tick line. Default: 6
            min_tick_gap: The minimum gap between two adjacent labels. Default: 5
            stroke: The stroke color of axis. Default: rx.color("gray", 9)
            text_anchor: The text anchor of axis. Default: "middle"
            on_click: The customized event handler of click on the ticks of this axis
            on_mouse_down: The customized event handler of mousedown on the ticks of this axis
            on_mouse_up: The customized event handler of mouseup on the ticks of this axis
            on_mouse_move: The customized event handler of mousemove on the ticks of this axis
            on_mouse_out: The customized event handler of mouseout on the ticks of this axis
            on_mouse_enter: The customized event handler of mouseenter on the ticks of this axis
            on_mouse_leave: The customized event handler of mouseleave on the ticks of this axis
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            autofocus: Whether the component should take the focus once the page is loaded
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The component.
        """

class YAxis(Axis):
    @classmethod
    def create(
        cls,
        *children,
        orientation: Literal["left", "right"]
        | Var[Literal["left", "right"]]
        | None = None,
        y_axis_id: Var[int | str] | int | str | None = None,
        padding: Var[dict[str, int]] | dict[str, int] | None = None,
        data_key: Var[int | str] | int | str | None = None,
        hide: Var[bool] | bool | None = None,
        width: Var[int | str] | int | str | None = None,
        height: Var[int | str] | int | str | None = None,
        type_: Literal["category", "number"]
        | Var[Literal["category", "number"]]
        | None = None,
        interval: Literal[
            "equidistantPreserveStart",
            "preserveEnd",
            "preserveStart",
            "preserveStartEnd",
        ]
        | Var[
            Literal[
                "equidistantPreserveStart",
                "preserveEnd",
                "preserveStart",
                "preserveStartEnd",
            ]
            | int
        ]
        | int
        | None = None,
        allow_decimals: Var[bool] | bool | None = None,
        allow_data_overflow: Var[bool] | bool | None = None,
        allow_duplicated_category: Var[bool] | bool | None = None,
        domain: Sequence | Var[Sequence] | None = None,
        axis_line: Var[bool] | bool | None = None,
        mirror: Var[bool] | bool | None = None,
        reversed: Var[bool] | bool | None = None,
        label: Var[dict[str, Any] | int | str]
        | dict[str, Any]
        | int
        | str
        | None = None,
        scale: Literal[
            "auto",
            "band",
            "identity",
            "linear",
            "log",
            "ordinal",
            "point",
            "pow",
            "quantile",
            "quantize",
            "sequential",
            "sqrt",
            "threshold",
            "time",
            "utc",
        ]
        | Var[
            Literal[
                "auto",
                "band",
                "identity",
                "linear",
                "log",
                "ordinal",
                "point",
                "pow",
                "quantile",
                "quantize",
                "sequential",
                "sqrt",
                "threshold",
                "time",
                "utc",
            ]
        ]
        | None = None,
        unit: Var[int | str] | int | str | None = None,
        name: Var[int | str] | int | str | None = None,
        ticks: Sequence[int | str] | Var[Sequence[int | str]] | None = None,
        tick: Var[bool | dict] | bool | dict | None = None,
        tick_count: Var[int] | int | None = None,
        tick_line: Var[bool] | bool | None = None,
        tick_size: Var[int] | int | None = None,
        min_tick_gap: Var[int] | int | None = None,
        stroke: Color | Var[Color | str] | str | None = None,
        text_anchor: Literal["end", "middle", "start"]
        | Var[Literal["end", "middle", "start"]]
        | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        autofocus: bool | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> YAxis:
        """Create the component.

        Args:
            *children: The children of the component.
            orientation: The orientation of axis 'left' | 'right'. Default: "left"
            y_axis_id: The id of y-axis which is corresponding to the data. Default: 0
            padding: Specify the padding of y-axis. Default: {"top": 0, "bottom": 0}
            data_key: The key of data displayed in the axis.
            hide: If set true, the axis do not display in the chart. Default: False
            width: The width of axis which is usually calculated internally.
            height: The height of axis, which can be set by user.
            type_: The type of axis 'number' | 'category'
            interval: If set 0, all the ticks will be shown. If set preserveStart", "preserveEnd" or "preserveStartEnd", the ticks which is to be shown or hidden will be calculated automatically. Default: "preserveEnd"
            allow_decimals: Allow the ticks of Axis to be decimals or not. Default: True
            allow_data_overflow: When domain of the axis is specified and the type of the axis is 'number', if allowDataOverflow is set to be false, the domain will be adjusted when the minimum value of data is smaller than domain[0] or the maximum value of data is greater than domain[1] so that the axis displays all data values. If set to true, graphic elements (line, area, bars) will be clipped to conform to the specified domain. Default: False
            allow_duplicated_category: Allow the axis has duplicated categorys or not when the type of axis is "category". Default: True
            domain: The range of the axis. Work best in conjunction with allow_data_overflow. Default: [0, "auto"]
            axis_line: If set false, no axis line will be drawn. Default: True
            mirror: If set true, flips ticks around the axis line, displaying the labels inside the chart instead of outside. Default: False
            reversed: Reverse the ticks or not. Default: False
            label: The label of axis, which appears next to the axis.
            scale: If 'auto' set, the scale function is decided by the type of chart, and the props type. 'auto' | 'linear' | 'pow' | 'sqrt' | 'log' | 'identity' | 'time' | 'band' | 'point' | 'ordinal' | 'quantile' | 'quantize' | 'utc' | 'sequential' | 'threshold'. Default: "auto"
            unit: The unit of data displayed in the axis. This option will be used to represent an index unit in a scatter chart.
            name: The name of data displayed in the axis. This option will be used to represent an index in a scatter chart.
            ticks: Set the values of axis ticks manually.
            tick: If set false, no ticks will be drawn.
            tick_count: The count of axis ticks. Not used if 'type' is 'category'. Default: 5
            tick_line: If set false, no axis tick lines will be drawn. Default: True
            tick_size: The length of tick line. Default: 6
            min_tick_gap: The minimum gap between two adjacent labels. Default: 5
            stroke: The stroke color of axis. Default: rx.color("gray", 9)
            text_anchor: The text anchor of axis. Default: "middle"
            on_click: The customized event handler of click on the ticks of this axis
            on_mouse_down: The customized event handler of mousedown on the ticks of this axis
            on_mouse_up: The customized event handler of mouseup on the ticks of this axis
            on_mouse_move: The customized event handler of mousemove on the ticks of this axis
            on_mouse_out: The customized event handler of mouseout on the ticks of this axis
            on_mouse_enter: The customized event handler of mouseenter on the ticks of this axis
            on_mouse_leave: The customized event handler of mouseleave on the ticks of this axis
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            autofocus: Whether the component should take the focus once the page is loaded
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The component.
        """

class ZAxis(Recharts):
    @classmethod
    def create(
        cls,
        *children,
        data_key: Var[int | str] | int | str | None = None,
        z_axis_id: Var[int | str] | int | str | None = None,
        range: Sequence[int] | Var[Sequence[int]] | None = None,
        unit: Var[int | str] | int | str | None = None,
        name: Var[int | str] | int | str | None = None,
        scale: Literal[
            "auto",
            "band",
            "identity",
            "linear",
            "log",
            "ordinal",
            "point",
            "pow",
            "quantile",
            "quantize",
            "sequential",
            "sqrt",
            "threshold",
            "time",
            "utc",
        ]
        | Var[
            Literal[
                "auto",
                "band",
                "identity",
                "linear",
                "log",
                "ordinal",
                "point",
                "pow",
                "quantile",
                "quantize",
                "sequential",
                "sqrt",
                "threshold",
                "time",
                "utc",
            ]
        ]
        | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        autofocus: bool | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> ZAxis:
        """Create the component.

        Args:
            *children: The children of the component.
            data_key: The key of data displayed in the axis.
            z_axis_id: The unique id of z-axis. Default: 0
            range: The range of axis. Default: [60, 400]
            unit: The unit of data displayed in the axis. This option will be used to represent an index unit in a scatter chart.
            name: The name of data displayed in the axis. This option will be used to represent an index in a scatter chart.
            scale: If 'auto' set, the scale function is decided by the type of chart, and the props type. Default: "auto"
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            autofocus: Whether the component should take the focus once the page is loaded
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The component.
        """

class Brush(Recharts):
    @classmethod
    def get_event_triggers(cls) -> dict[str, Var | Any]: ...
    @classmethod
    def create(
        cls,
        *children,
        stroke: Color | Var[Color | str] | str | None = None,
        fill: Color | Var[Color | str] | str | None = None,
        data_key: Var[int | str] | int | str | None = None,
        x: Var[int] | int | None = None,
        y: Var[int] | int | None = None,
        width: Var[int] | int | None = None,
        height: Var[int] | int | None = None,
        data: Sequence[Any] | Var[Sequence[Any]] | None = None,
        traveller_width: Var[int] | int | None = None,
        gap: Var[int] | int | None = None,
        start_index: Var[int] | int | None = None,
        end_index: Var[int] | int | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        autofocus: bool | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_change: EventType[()] | None = None,
        **props,
    ) -> Brush:
        """Create the component.

        Args:
            *children: The children of the component.
            stroke: The stroke color of brush
            fill: The fill color of brush
            data_key: The key of data displayed in the axis.
            x: The x-coordinate of brush. Default: 0
            y: The y-coordinate of brush. Default: 0
            width: The width of brush. Default: 0
            height: The height of brush. Default: 40
            data: The original data of a LineChart, a BarChart or an AreaChart.
            traveller_width: The width of each traveller. Default: 5
            gap: The data with gap of refreshing chart. If the option is not set, the chart will be refreshed every time. Default: 1
            start_index: The default start index of brush. If the option is not set, the start index will be 0. Default: 0
            end_index: The default end index of brush. If the option is not set, the end index will be calculated by the length of data.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            autofocus: Whether the component should take the focus once the page is loaded
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The component.
        """

class Cartesian(Recharts):
    @classmethod
    def create(
        cls,
        *children,
        layout: Literal["horizontal", "vertical"]
        | Var[Literal["horizontal", "vertical"]]
        | None = None,
        data_key: Var[int | str] | int | str | None = None,
        x_axis_id: Var[int | str] | int | str | None = None,
        y_axis_id: Var[int | str] | int | str | None = None,
        legend_type: Literal[
            "circle",
            "cross",
            "diamond",
            "line",
            "none",
            "plainline",
            "rect",
            "square",
            "star",
            "triangle",
            "wye",
        ]
        | Var[
            Literal[
                "circle",
                "cross",
                "diamond",
                "line",
                "none",
                "plainline",
                "rect",
                "square",
                "star",
                "triangle",
                "wye",
            ]
        ]
        | None = None,
        label: Var[bool | dict[str, Any]] | bool | dict[str, Any] | None = None,
        is_animation_active: Var[bool] | bool | None = None,
        animation_begin: Var[int] | int | None = None,
        animation_duration: Var[int] | int | None = None,
        animation_easing: Literal[
            "ease", "ease-in", "ease-in-out", "ease-out", "linear"
        ]
        | Var[Literal["ease", "ease-in", "ease-in-out", "ease-out", "linear"]]
        | None = None,
        unit: Var[int | str] | int | str | None = None,
        name: Var[int | str] | int | str | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        autofocus: bool | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_animation_end: EventType[()] | None = None,
        on_animation_start: EventType[()] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> Cartesian:
        """Create the component.

        Args:
            *children: The children of the component.
            layout: The layout of bar in the chart, usually inherited from parent. 'horizontal' | 'vertical'
            data_key: The key of a group of data which should be unique in an area chart.
            x_axis_id: The id of x-axis which is corresponding to the data. Default: 0
            y_axis_id: The id of y-axis which is corresponding to the data. Default: 0
            legend_type: The type of icon in legend. If set to 'none', no legend item will be rendered. 'line' | 'plainline' | 'square' | 'rect'| 'circle' | 'cross' | 'diamond' | 'star' | 'triangle' | 'wye' | 'none' optional
            label: If false set, labels will not be drawn. If true set, labels will be drawn which have the props calculated internally. Default: False
            is_animation_active: If set false, animation of bar will be disabled. Default: True
            animation_begin: Specifies when the animation should begin, the unit of this option is ms. Default: 0
            animation_duration: Specifies the duration of animation, the unit of this option is ms. Default: 1500
            animation_easing: The type of easing function. Default: "ease"
            unit: The unit of data. This option will be used in tooltip.
            name: The name of data. This option will be used in tooltip and legend to represent the component. If no value was set to this option, the value of dataKey will be used alternatively.
            on_animation_start: The customized event handler of animation start
            on_animation_end: The customized event handler of animation end
            on_click: The customized event handler of click on the component in this group
            on_mouse_down: The customized event handler of mousedown on the component in this group
            on_mouse_up: The customized event handler of mouseup on the component in this group
            on_mouse_move: The customized event handler of mousemove on the component in this group
            on_mouse_over: The customized event handler of mouseover on the component in this group
            on_mouse_out: The customized event handler of mouseout on the component in this group
            on_mouse_enter: The customized event handler of mouseenter on the component in this group
            on_mouse_leave: The customized event handler of mouseleave on the component in this group
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            autofocus: Whether the component should take the focus once the page is loaded
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The component.
        """

class Area(Cartesian):
    @classmethod
    def create(
        cls,
        *children,
        stroke: Color | Var[Color | str] | str | None = None,
        stroke_width: Var[float | int | str] | float | int | str | None = None,
        fill: Color | Var[Color | str] | str | None = None,
        type_: Literal[
            "basis",
            "basisClosed",
            "basisOpen",
            "bump",
            "bumpX",
            "bumpY",
            "linear",
            "linearClosed",
            "monotone",
            "monotoneX",
            "monotoneY",
            "natural",
            "step",
            "stepAfter",
            "stepBefore",
        ]
        | Var[
            Literal[
                "basis",
                "basisClosed",
                "basisOpen",
                "bump",
                "bumpX",
                "bumpY",
                "linear",
                "linearClosed",
                "monotone",
                "monotoneX",
                "monotoneY",
                "natural",
                "step",
                "stepAfter",
                "stepBefore",
            ]
        ]
        | None = None,
        dot: Var[bool | dict[str, Any]] | bool | dict[str, Any] | None = None,
        active_dot: Var[bool | dict[str, Any]] | bool | dict[str, Any] | None = None,
        base_line: Sequence[dict[str, Any]]
        | Var[Sequence[dict[str, Any]] | int]
        | int
        | None = None,
        points: Sequence[dict[str, Any]] | Var[Sequence[dict[str, Any]]] | None = None,
        stack_id: Var[int | str] | int | str | None = None,
        connect_nulls: Var[bool] | bool | None = None,
        layout: Literal["horizontal", "vertical"]
        | Var[Literal["horizontal", "vertical"]]
        | None = None,
        data_key: Var[int | str] | int | str | None = None,
        x_axis_id: Var[int | str] | int | str | None = None,
        y_axis_id: Var[int | str] | int | str | None = None,
        legend_type: Literal[
            "circle",
            "cross",
            "diamond",
            "line",
            "none",
            "plainline",
            "rect",
            "square",
            "star",
            "triangle",
            "wye",
        ]
        | Var[
            Literal[
                "circle",
                "cross",
                "diamond",
                "line",
                "none",
                "plainline",
                "rect",
                "square",
                "star",
                "triangle",
                "wye",
            ]
        ]
        | None = None,
        label: Var[bool | dict[str, Any]] | bool | dict[str, Any] | None = None,
        is_animation_active: Var[bool] | bool | None = None,
        animation_begin: Var[int] | int | None = None,
        animation_duration: Var[int] | int | None = None,
        animation_easing: Literal[
            "ease", "ease-in", "ease-in-out", "ease-out", "linear"
        ]
        | Var[Literal["ease", "ease-in", "ease-in-out", "ease-out", "linear"]]
        | None = None,
        unit: Var[int | str] | int | str | None = None,
        name: Var[int | str] | int | str | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        autofocus: bool | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_animation_end: EventType[()] | None = None,
        on_animation_start: EventType[()] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> Area:
        """Create the component.

        Args:
            *children: The children of the component.
            stroke: The color of the line stroke. Default: rx.color("accent", 9)
            stroke_width: The width of the line stroke. Default: 1
            fill: The color of the area fill. Default: rx.color("accent", 5)
            type_: The interpolation type of area. And customized interpolation function can be set to type. 'basis' | 'basisClosed' | 'basisOpen' | 'bumpX' | 'bumpY' | 'bump' | 'linear' | 'linearClosed' | 'natural' | 'monotoneX' | 'monotoneY' | 'monotone' | 'step' | 'stepBefore' | 'stepAfter'. Default: "monotone"
            dot: If false set, dots will not be drawn. If true set, dots will be drawn which have the props calculated internally. Default: False
            active_dot: The dot is shown when user enter an area chart and this chart has tooltip. If false set, no active dot will not be drawn. If true set, active dot will be drawn which have the props calculated internally. Default: {stroke: rx.color("accent", 2), fill: rx.color("accent", 10)}
            base_line: The value which can describle the line, usually calculated internally.
            points: The coordinates of all the points in the area, usually calculated internally.
            stack_id: The stack id of area, when two areas have the same value axis and same stack_id, then the two areas are stacked in order.
            connect_nulls: Whether to connect a graph area across null points. Default: False
            layout: The layout of bar in the chart, usually inherited from parent. 'horizontal' | 'vertical'
            data_key: The key of a group of data which should be unique in an area chart.
            x_axis_id: The id of x-axis which is corresponding to the data. Default: 0
            y_axis_id: The id of y-axis which is corresponding to the data. Default: 0
            legend_type: The type of icon in legend. If set to 'none', no legend item will be rendered. 'line' | 'plainline' | 'square' | 'rect'| 'circle' | 'cross' | 'diamond' | 'star' | 'triangle' | 'wye' | 'none' optional
            label: If false set, labels will not be drawn. If true set, labels will be drawn which have the props calculated internally. Default: False
            is_animation_active: If set false, animation of bar will be disabled. Default: True
            animation_begin: Specifies when the animation should begin, the unit of this option is ms. Default: 0
            animation_duration: Specifies the duration of animation, the unit of this option is ms. Default: 1500
            animation_easing: The type of easing function. Default: "ease"
            unit: The unit of data. This option will be used in tooltip.
            name: The name of data. This option will be used in tooltip and legend to represent the component. If no value was set to this option, the value of dataKey will be used alternatively.
            on_animation_start: The customized event handler of animation start
            on_animation_end: The customized event handler of animation end
            on_click: The customized event handler of click on the component in this group
            on_mouse_down: The customized event handler of mousedown on the component in this group
            on_mouse_up: The customized event handler of mouseup on the component in this group
            on_mouse_move: The customized event handler of mousemove on the component in this group
            on_mouse_over: The customized event handler of mouseover on the component in this group
            on_mouse_out: The customized event handler of mouseout on the component in this group
            on_mouse_enter: The customized event handler of mouseenter on the component in this group
            on_mouse_leave: The customized event handler of mouseleave on the component in this group
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            autofocus: Whether the component should take the focus once the page is loaded
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The component.
        """

class Bar(Cartesian):
    @classmethod
    def create(
        cls,
        *children,
        stroke: Color | Var[Color | str] | str | None = None,
        stroke_width: Var[float | int | str] | float | int | str | None = None,
        fill: Color | Var[Color | str] | str | None = None,
        background: Var[bool] | bool | None = None,
        stack_id: Var[str] | str | None = None,
        unit: Var[int | str] | int | str | None = None,
        min_point_size: Var[int] | int | None = None,
        name: Var[int | str] | int | str | None = None,
        bar_size: Var[int] | int | None = None,
        max_bar_size: Var[int] | int | None = None,
        radius: Sequence[int] | Var[Sequence[int] | int] | int | None = None,
        layout: Literal["horizontal", "vertical"]
        | Var[Literal["horizontal", "vertical"]]
        | None = None,
        data_key: Var[int | str] | int | str | None = None,
        x_axis_id: Var[int | str] | int | str | None = None,
        y_axis_id: Var[int | str] | int | str | None = None,
        legend_type: Literal[
            "circle",
            "cross",
            "diamond",
            "line",
            "none",
            "plainline",
            "rect",
            "square",
            "star",
            "triangle",
            "wye",
        ]
        | Var[
            Literal[
                "circle",
                "cross",
                "diamond",
                "line",
                "none",
                "plainline",
                "rect",
                "square",
                "star",
                "triangle",
                "wye",
            ]
        ]
        | None = None,
        label: Var[bool | dict[str, Any]] | bool | dict[str, Any] | None = None,
        is_animation_active: Var[bool] | bool | None = None,
        animation_begin: Var[int] | int | None = None,
        animation_duration: Var[int] | int | None = None,
        animation_easing: Literal[
            "ease", "ease-in", "ease-in-out", "ease-out", "linear"
        ]
        | Var[Literal["ease", "ease-in", "ease-in-out", "ease-out", "linear"]]
        | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        autofocus: bool | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_animation_end: EventType[()] | None = None,
        on_animation_start: EventType[()] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> Bar:
        """Create the component.

        Args:
            *children: The children of the component.
            stroke: The color of the line stroke.
            stroke_width: The width of the line stroke.
            fill: The width of the line stroke. Default: Color("accent", 9)
            background: If false set, background of bars will not be drawn. If true set, background of bars will be drawn which have the props calculated internally. Default: False
            stack_id: The stack id of bar, when two bars have the same value axis and same stack_id, then the two bars are stacked in order.
            unit: The unit of data. This option will be used in tooltip.
            min_point_size: The minimal height of a bar in a horizontal BarChart, or the minimal width of a bar in a vertical BarChart. By default, 0 values are not shown. To visualize a 0 (or close to zero) point, set the minimal point size to a pixel value like 3. In stacked bar charts, minPointSize might not be respected for tightly packed values. So we strongly recommend not using this prop in stacked BarCharts.
            name: The name of data. This option will be used in tooltip and legend to represent the component. If no value was set to this option, the value of dataKey will be used alternatively.
            bar_size: Size of the bar (if one bar_size is set then a bar_size must be set for all bars)
            max_bar_size: Max size of the bar
            radius: If set a value, the option is the radius of all the rounded corners. If set a array, the option are in turn the radiuses of top-left corner, top-right corner, bottom-right corner, bottom-left corner. Default: 0
            layout: The layout of bar in the chart, usually inherited from parent. 'horizontal' | 'vertical'
            data_key: The key of a group of data which should be unique in an area chart.
            x_axis_id: The id of x-axis which is corresponding to the data. Default: 0
            y_axis_id: The id of y-axis which is corresponding to the data. Default: 0
            legend_type: The type of icon in legend. If set to 'none', no legend item will be rendered. 'line' | 'plainline' | 'square' | 'rect'| 'circle' | 'cross' | 'diamond' | 'star' | 'triangle' | 'wye' | 'none' optional
            label: If false set, labels will not be drawn. If true set, labels will be drawn which have the props calculated internally. Default: False
            is_animation_active: If set false, animation of bar will be disabled. Default: True
            animation_begin: Specifies when the animation should begin, the unit of this option is ms. Default: 0
            animation_duration: Specifies the duration of animation, the unit of this option is ms. Default: 1500
            animation_easing: The type of easing function. Default: "ease"
            on_animation_start: The customized event handler of animation start
            on_animation_end: The customized event handler of animation end
            on_click: The customized event handler of click on the component in this group
            on_mouse_down: The customized event handler of mousedown on the component in this group
            on_mouse_up: The customized event handler of mouseup on the component in this group
            on_mouse_move: The customized event handler of mousemove on the component in this group
            on_mouse_over: The customized event handler of mouseover on the component in this group
            on_mouse_out: The customized event handler of mouseout on the component in this group
            on_mouse_enter: The customized event handler of mouseenter on the component in this group
            on_mouse_leave: The customized event handler of mouseleave on the component in this group
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            autofocus: Whether the component should take the focus once the page is loaded
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The component.
        """

class Line(Cartesian):
    @classmethod
    def create(
        cls,
        *children,
        type_: Literal[
            "basis",
            "basisClosed",
            "basisOpen",
            "bump",
            "bumpX",
            "bumpY",
            "linear",
            "linearClosed",
            "monotone",
            "monotoneX",
            "monotoneY",
            "natural",
            "step",
            "stepAfter",
            "stepBefore",
        ]
        | Var[
            Literal[
                "basis",
                "basisClosed",
                "basisOpen",
                "bump",
                "bumpX",
                "bumpY",
                "linear",
                "linearClosed",
                "monotone",
                "monotoneX",
                "monotoneY",
                "natural",
                "step",
                "stepAfter",
                "stepBefore",
            ]
        ]
        | None = None,
        stroke: Color | Var[Color | str] | str | None = None,
        stroke_width: Var[float | int | str] | float | int | str | None = None,
        dot: Var[bool | dict[str, Any]] | bool | dict[str, Any] | None = None,
        active_dot: Var[bool | dict[str, Any]] | bool | dict[str, Any] | None = None,
        hide: Var[bool] | bool | None = None,
        connect_nulls: Var[bool] | bool | None = None,
        unit: Var[int | str] | int | str | None = None,
        points: Sequence[dict[str, Any]] | Var[Sequence[dict[str, Any]]] | None = None,
        stroke_dasharray: Var[str] | str | None = None,
        layout: Literal["horizontal", "vertical"]
        | Var[Literal["horizontal", "vertical"]]
        | None = None,
        data_key: Var[int | str] | int | str | None = None,
        x_axis_id: Var[int | str] | int | str | None = None,
        y_axis_id: Var[int | str] | int | str | None = None,
        legend_type: Literal[
            "circle",
            "cross",
            "diamond",
            "line",
            "none",
            "plainline",
            "rect",
            "square",
            "star",
            "triangle",
            "wye",
        ]
        | Var[
            Literal[
                "circle",
                "cross",
                "diamond",
                "line",
                "none",
                "plainline",
                "rect",
                "square",
                "star",
                "triangle",
                "wye",
            ]
        ]
        | None = None,
        label: Var[bool | dict[str, Any]] | bool | dict[str, Any] | None = None,
        is_animation_active: Var[bool] | bool | None = None,
        animation_begin: Var[int] | int | None = None,
        animation_duration: Var[int] | int | None = None,
        animation_easing: Literal[
            "ease", "ease-in", "ease-in-out", "ease-out", "linear"
        ]
        | Var[Literal["ease", "ease-in", "ease-in-out", "ease-out", "linear"]]
        | None = None,
        name: Var[int | str] | int | str | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        autofocus: bool | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_animation_end: EventType[()] | None = None,
        on_animation_start: EventType[()] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> Line:
        """Create the component.

        Args:
            *children: The children of the component.
            type_: The interpolation type of line. And customized interpolation function can be set to type. It's the same as type in Area.
            stroke: The color of the line stroke. Default: rx.color("accent", 9)
            stroke_width: The width of the line stroke. Default: 1
            dot: The dot is shown when mouse enter a line chart and this chart has tooltip. If false set, no active dot will not be drawn. If true set, active dot will be drawn which have the props calculated internally. Default: {"stroke": rx.color("accent", 10), "fill": rx.color("accent", 4)}
            active_dot: The dot is shown when user enter an area chart and this chart has tooltip. If false set, no active dot will not be drawn. If true set, active dot will be drawn which have the props calculated internally. Default: {"stroke": rx.color("accent", 2), "fill": rx.color("accent", 10)}
            hide: Hides the line when true, useful when toggling visibility state via legend. Default: False
            connect_nulls: Whether to connect a graph line across null points.
            unit: The unit of data. This option will be used in tooltip.
            points: The coordinates of all the points in the line, usually calculated internally.
            stroke_dasharray: The pattern of dashes and gaps used to paint the line.
            layout: The layout of bar in the chart, usually inherited from parent. 'horizontal' | 'vertical'
            data_key: The key of a group of data which should be unique in an area chart.
            x_axis_id: The id of x-axis which is corresponding to the data. Default: 0
            y_axis_id: The id of y-axis which is corresponding to the data. Default: 0
            legend_type: The type of icon in legend. If set to 'none', no legend item will be rendered. 'line' | 'plainline' | 'square' | 'rect'| 'circle' | 'cross' | 'diamond' | 'star' | 'triangle' | 'wye' | 'none' optional
            label: If false set, labels will not be drawn. If true set, labels will be drawn which have the props calculated internally. Default: False
            is_animation_active: If set false, animation of bar will be disabled. Default: True
            animation_begin: Specifies when the animation should begin, the unit of this option is ms. Default: 0
            animation_duration: Specifies the duration of animation, the unit of this option is ms. Default: 1500
            animation_easing: The type of easing function. Default: "ease"
            name: The name of data. This option will be used in tooltip and legend to represent the component. If no value was set to this option, the value of dataKey will be used alternatively.
            on_animation_start: The customized event handler of animation start
            on_animation_end: The customized event handler of animation end
            on_click: The customized event handler of click on the component in this group
            on_mouse_down: The customized event handler of mousedown on the component in this group
            on_mouse_up: The customized event handler of mouseup on the component in this group
            on_mouse_move: The customized event handler of mousemove on the component in this group
            on_mouse_over: The customized event handler of mouseover on the component in this group
            on_mouse_out: The customized event handler of mouseout on the component in this group
            on_mouse_enter: The customized event handler of mouseenter on the component in this group
            on_mouse_leave: The customized event handler of mouseleave on the component in this group
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            autofocus: Whether the component should take the focus once the page is loaded
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The component.
        """

class Scatter(Recharts):
    @classmethod
    def create(
        cls,
        *children,
        data: Sequence[dict[str, Any]] | Var[Sequence[dict[str, Any]]] | None = None,
        name: Var[str] | str | None = None,
        legend_type: Literal[
            "circle",
            "cross",
            "diamond",
            "line",
            "none",
            "plainline",
            "rect",
            "square",
            "star",
            "triangle",
            "wye",
        ]
        | Var[
            Literal[
                "circle",
                "cross",
                "diamond",
                "line",
                "none",
                "plainline",
                "rect",
                "square",
                "star",
                "triangle",
                "wye",
            ]
        ]
        | None = None,
        x_axis_id: Var[int | str] | int | str | None = None,
        y_axis_id: Var[int | str] | int | str | None = None,
        z_axis_id: Var[int | str] | int | str | None = None,
        line: Var[bool] | bool | None = None,
        shape: Literal[
            "circle", "cross", "diamond", "square", "star", "triangle", "wye"
        ]
        | Var[
            Literal["circle", "cross", "diamond", "square", "star", "triangle", "wye"]
        ]
        | None = None,
        line_type: Literal["fitting", "joint"]
        | Var[Literal["fitting", "joint"]]
        | None = None,
        fill: Color | Var[Color | str] | str | None = None,
        is_animation_active: Var[bool] | bool | None = None,
        animation_begin: Var[int] | int | None = None,
        animation_duration: Var[int] | int | None = None,
        animation_easing: Literal[
            "ease", "ease-in", "ease-in-out", "ease-out", "linear"
        ]
        | Var[Literal["ease", "ease-in", "ease-in-out", "ease-out", "linear"]]
        | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        autofocus: bool | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> Scatter:
        """Create the component.

        Args:
            *children: The children of the component.
            data: The source data, in which each element is an object.
            name: The name of the data. It is used to represent the scatter in legend.
            legend_type: The type of icon in legend. If set to 'none', no legend item will be rendered. 'line' | 'plainline' | 'square' | 'rect'| 'circle' | 'cross' | 'diamond' | 'square' | 'star' | 'triangle' | 'wye' | 'none'. Default: "circle"
            x_axis_id: The id of x-axis which is corresponding to the data. Default: 0
            y_axis_id: The id of y-axis which is corresponding to the data. Default: 0
            z_axis_id: The id of z-axis which is corresponding to the data. Default: 0
            line: If false set, line will not be drawn. If true set, line will be drawn which have the props calculated internally. Default: False
            shape: If a string set, specified symbol will be used to show scatter item. 'circle' | 'cross' | 'diamond' | 'square' | 'star' | 'triangle' | 'wye'. Default: "circle"
            line_type: If 'joint' set, line will generated by just jointing all the points. If 'fitting' set, line will be generated by fitting algorithm. 'joint' | 'fitting'. Default: "joint"
            fill: The fill color of the scatter. Default: rx.color("accent", 9)
            is_animation_active: If set false, animation of bar will be disabled. Default: True in CSR, False in SSR
            animation_begin: Specifies when the animation should begin, the unit of this option is ms. Default: 0
            animation_duration: Specifies the duration of animation, the unit of this option is ms. Default: 1500
            animation_easing: The type of easing function. Default: "ease"
            on_click: The customized event handler of click on the component in this group
            on_mouse_down: The customized event handler of mousedown on the component in this group
            on_mouse_up: The customized event handler of mouseup on the component in this group
            on_mouse_move: The customized event handler of mousemove on the component in this group
            on_mouse_over: The customized event handler of mouseover on the component in this group
            on_mouse_out: The customized event handler of mouseout on the component in this group
            on_mouse_enter: The customized event handler of mouseenter on the component in this group
            on_mouse_leave: The customized event handler of mouseleave on the component in this group
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            autofocus: Whether the component should take the focus once the page is loaded
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The component.
        """

class Funnel(Recharts):
    @classmethod
    def create(
        cls,
        *children,
        data: Sequence[dict[str, Any]] | Var[Sequence[dict[str, Any]]] | None = None,
        data_key: Var[int | str] | int | str | None = None,
        name_key: Var[str] | str | None = None,
        legend_type: Literal[
            "circle",
            "cross",
            "diamond",
            "line",
            "none",
            "plainline",
            "rect",
            "square",
            "star",
            "triangle",
            "wye",
        ]
        | Var[
            Literal[
                "circle",
                "cross",
                "diamond",
                "line",
                "none",
                "plainline",
                "rect",
                "square",
                "star",
                "triangle",
                "wye",
            ]
        ]
        | None = None,
        is_animation_active: Var[bool] | bool | None = None,
        animation_begin: Var[int] | int | None = None,
        animation_duration: Var[int] | int | None = None,
        animation_easing: Literal[
            "ease", "ease-in", "ease-in-out", "ease-out", "linear"
        ]
        | Var[Literal["ease", "ease-in", "ease-in-out", "ease-out", "linear"]]
        | None = None,
        stroke: Color | Var[Color | str] | str | None = None,
        trapezoids: Sequence[dict[str, Any]]
        | Var[Sequence[dict[str, Any]]]
        | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        autofocus: bool | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_animation_end: EventType[()] | None = None,
        on_animation_start: EventType[()] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> Funnel:
        """Create the component.

        Args:
            *children: The children of the component.
            data: The source data, in which each element is an object.
            data_key: The key or getter of a group of data which should be unique in a FunnelChart.
            name_key: The key of each sector's name. Default: "name"
            legend_type: The type of icon in legend. If set to 'none', no legend item will be rendered. Default: "line"
            is_animation_active: If set false, animation of line will be disabled. Default: True
            animation_begin: Specifies when the animation should begin, the unit of this option is ms. Default: 0
            animation_duration: Specifies the duration of animation, the unit of this option is ms. Default: 1500
            animation_easing: The type of easing function. 'ease' | 'ease-in' | 'ease-out' | 'ease-in-out' | 'linear'. Default "ease"
            stroke: Stroke color. Default: rx.color("gray", 3)
            trapezoids: The coordinates of all the trapezoids in the funnel, usually calculated internally.
            on_animation_start: The customized event handler of animation start
            on_animation_end: The customized event handler of animation end
            on_click: The customized event handler of click on the component in this group
            on_mouse_down: The customized event handler of mousedown on the component in this group
            on_mouse_up: The customized event handler of mouseup on the component in this group
            on_mouse_move: The customized event handler of mousemove on the component in this group
            on_mouse_over: The customized event handler of mouseover on the component in this group
            on_mouse_out: The customized event handler of mouseout on the component in this group
            on_mouse_enter: The customized event handler of mouseenter on the component in this group
            on_mouse_leave: The customized event handler of mouseleave on the component in this group
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            autofocus: Whether the component should take the focus once the page is loaded
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The component.
        """

class ErrorBar(Recharts):
    @classmethod
    def create(
        cls,
        *children,
        direction: Literal["x", "y"] | Var[Literal["x", "y"]] | None = None,
        data_key: Var[int | str] | int | str | None = None,
        width: Var[int] | int | None = None,
        stroke: Color | Var[Color | str] | str | None = None,
        stroke_width: Var[float | int | str] | float | int | str | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        autofocus: bool | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> ErrorBar:
        """Create the component.

        Args:
            *children: The children of the component.
            direction: Only used for ScatterChart with error bars in two directions. Only accepts a value of "x" or "y" and makes the error bars lie in that direction.
            data_key: The key of a group of data which should be unique in an area chart.
            width: The width of the error bar ends. Default: 5
            stroke: The stroke color of error bar. Default: rx.color("gray", 8)
            stroke_width: The stroke width of error bar. Default: 1.5
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            autofocus: Whether the component should take the focus once the page is loaded
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The component.
        """

class Reference(Recharts):
    @classmethod
    def create(
        cls,
        *children,
        x_axis_id: Var[int | str] | int | str | None = None,
        y_axis_id: Var[int | str] | int | str | None = None,
        if_overflow: Literal["discard", "extendDomain", "hidden", "visible"]
        | Var[Literal["discard", "extendDomain", "hidden", "visible"]]
        | None = None,
        label: Var[int | str] | int | str | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        autofocus: bool | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> Reference:
        """Create the component.

        Args:
            *children: The children of the component.
            x_axis_id: The id of x-axis which is corresponding to the data. Default: 0
            y_axis_id: The id of y-axis which is corresponding to the data. Default: 0
            if_overflow: Defines how to draw the reference line if it falls partly outside the canvas. If set to 'discard', the reference line will not be drawn at all. If set to 'hidden', the reference line will be clipped to the canvas. If set to 'visible', the reference line will be drawn completely. If set to 'extendDomain', the domain of the overflown axis will be extended such that the reference line fits into the canvas. Default: "discard"
            label: If set a string or a number, default label will be drawn, and the option is content.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            autofocus: Whether the component should take the focus once the page is loaded
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The component.
        """

class Segment(TypedDict):
    x: str | int
    y: str | int

class ReferenceLine(Reference):
    @classmethod
    def create(
        cls,
        *children,
        x: Var[int | str] | int | str | None = None,
        y: Var[int | str] | int | str | None = None,
        stroke: Color | Var[Color | str] | str | None = None,
        stroke_width: Var[float | int | str] | float | int | str | None = None,
        segment: Sequence[Segment] | Var[Sequence[Segment]] | None = None,
        x_axis_id: Var[int | str] | int | str | None = None,
        y_axis_id: Var[int | str] | int | str | None = None,
        if_overflow: Literal["discard", "extendDomain", "hidden", "visible"]
        | Var[Literal["discard", "extendDomain", "hidden", "visible"]]
        | None = None,
        label: Var[int | str] | int | str | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        autofocus: bool | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> ReferenceLine:
        """Create the component.

        Args:
            *children: The children of the component.
            x: If set a string or a number, a vertical line perpendicular to the x-axis specified by xAxisId will be drawn. If the specified x-axis is a number axis, the type of x must be Number. If the specified x-axis is a category axis, the value of x must be one of the categorys, otherwise no line will be drawn.
            y: If set a string or a number, a horizontal line perpendicular to the y-axis specified by yAxisId will be drawn. If the specified y-axis is a number axis, the type of y must be Number. If the specified y-axis is a category axis, the value of y must be one of the categorys, otherwise no line will be drawn.
            stroke: The color of the reference line.
            stroke_width: The width of the stroke. Default: 1
            segment: Array of endpoints in { x, y } format. These endpoints would be used to draw the ReferenceLine.
            x_axis_id: The id of x-axis which is corresponding to the data. Default: 0
            y_axis_id: The id of y-axis which is corresponding to the data. Default: 0
            if_overflow: Defines how to draw the reference line if it falls partly outside the canvas. If set to 'discard', the reference line will not be drawn at all. If set to 'hidden', the reference line will be clipped to the canvas. If set to 'visible', the reference line will be drawn completely. If set to 'extendDomain', the domain of the overflown axis will be extended such that the reference line fits into the canvas. Default: "discard"
            label: If set a string or a number, default label will be drawn, and the option is content.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            autofocus: Whether the component should take the focus once the page is loaded
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The component.
        """

class ReferenceDot(Reference):
    @classmethod
    def create(
        cls,
        *children,
        x: Var[int | str] | int | str | None = None,
        y: Var[int | str] | int | str | None = None,
        r: Var[int] | int | None = None,
        fill: Color | Var[Color | str] | str | None = None,
        stroke: Color | Var[Color | str] | str | None = None,
        x_axis_id: Var[int | str] | int | str | None = None,
        y_axis_id: Var[int | str] | int | str | None = None,
        if_overflow: Literal["discard", "extendDomain", "hidden", "visible"]
        | Var[Literal["discard", "extendDomain", "hidden", "visible"]]
        | None = None,
        label: Var[int | str] | int | str | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        autofocus: bool | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> ReferenceDot:
        """Create the component.

        Args:
            *children: The children of the component.
            x: If set a string or a number, a vertical line perpendicular to the x-axis specified by xAxisId will be drawn. If the specified x-axis is a number axis, the type of x must be Number. If the specified x-axis is a category axis, the value of x must be one of the categorys, otherwise no line will be drawn.
            y: If set a string or a number, a horizontal line perpendicular to the y-axis specified by yAxisId will be drawn. If the specified y-axis is a number axis, the type of y must be Number. If the specified y-axis is a category axis, the value of y must be one of the categorys, otherwise no line will be drawn.
            r: The radius of dot.
            fill: The color of the area fill.
            stroke: The color of the line stroke.
            on_click: The customized event handler of click on the component in this chart
            on_mouse_down: The customized event handler of mousedown on the component in this chart
            on_mouse_up: The customized event handler of mouseup on the component in this chart
            on_mouse_over: The customized event handler of mouseover on the component in this chart
            on_mouse_out: The customized event handler of mouseout on the component in this chart
            on_mouse_enter: The customized event handler of mouseenter on the component in this chart
            on_mouse_move: The customized event handler of mousemove on the component in this chart
            on_mouse_leave: The customized event handler of mouseleave on the component in this chart
            x_axis_id: The id of x-axis which is corresponding to the data. Default: 0
            y_axis_id: The id of y-axis which is corresponding to the data. Default: 0
            if_overflow: Defines how to draw the reference line if it falls partly outside the canvas. If set to 'discard', the reference line will not be drawn at all. If set to 'hidden', the reference line will be clipped to the canvas. If set to 'visible', the reference line will be drawn completely. If set to 'extendDomain', the domain of the overflown axis will be extended such that the reference line fits into the canvas. Default: "discard"
            label: If set a string or a number, default label will be drawn, and the option is content.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            autofocus: Whether the component should take the focus once the page is loaded
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The component.
        """

class ReferenceArea(Recharts):
    @classmethod
    def create(
        cls,
        *children,
        stroke: Color | Var[Color | str] | str | None = None,
        fill: Color | Var[Color | str] | str | None = None,
        fill_opacity: Var[float] | float | None = None,
        x_axis_id: Var[int | str] | int | str | None = None,
        y_axis_id: Var[int | str] | int | str | None = None,
        x1: Var[int | str] | int | str | None = None,
        x2: Var[int | str] | int | str | None = None,
        y1: Var[int | str] | int | str | None = None,
        y2: Var[int | str] | int | str | None = None,
        if_overflow: Literal["discard", "extendDomain", "hidden", "visible"]
        | Var[Literal["discard", "extendDomain", "hidden", "visible"]]
        | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        autofocus: bool | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> ReferenceArea:
        """Create the component.

        Args:
            *children: The children of the component.
            stroke: Stroke color
            fill: Fill color
            fill_opacity: The opacity of area.
            x_axis_id: The id of x-axis which is corresponding to the data.
            y_axis_id: The id of y-axis which is corresponding to the data.
            x1: A boundary value of the area. If the specified x-axis is a number axis, the type of x must be Number. If the specified x-axis is a category axis, the value of x must be one of the categorys. If one of x1 or x2 is invalidate, the area will cover along x-axis.
            x2: A boundary value of the area. If the specified x-axis is a number axis, the type of x must be Number. If the specified x-axis is a category axis, the value of x must be one of the categorys. If one of x1 or x2 is invalidate, the area will cover along x-axis.
            y1: A boundary value of the area. If the specified y-axis is a number axis, the type of y must be Number. If the specified y-axis is a category axis, the value of y must be one of the categorys. If one of y1 or y2 is invalidate, the area will cover along y-axis.
            y2: A boundary value of the area. If the specified y-axis is a number axis, the type of y must be Number. If the specified y-axis is a category axis, the value of y must be one of the categorys. If one of y1 or y2 is invalidate, the area will cover along y-axis.
            if_overflow: Defines how to draw the reference line if it falls partly outside the canvas. If set to 'discard', the reference line will not be drawn at all. If set to 'hidden', the reference line will be clipped to the canvas. If set to 'visible', the reference line will be drawn completely. If set to 'extendDomain', the domain of the overflown axis will be extended such that the reference line fits into the canvas. Default: "discard"
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            autofocus: Whether the component should take the focus once the page is loaded
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The component.
        """

class Grid(Recharts):
    @classmethod
    def create(
        cls,
        *children,
        x: Var[int] | int | None = None,
        y: Var[int] | int | None = None,
        width: Var[int] | int | None = None,
        height: Var[int] | int | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        autofocus: bool | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> Grid:
        """Create the component.

        Args:
            *children: The children of the component.
            x: The x-coordinate of grid. Default: 0
            y: The y-coordinate of grid. Default: 0
            width: The width of grid. Default: 0
            height: The height of grid. Default: 0
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            autofocus: Whether the component should take the focus once the page is loaded
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The component.
        """

class CartesianGrid(Grid):
    @classmethod
    def create(
        cls,
        *children,
        horizontal: Var[bool] | bool | None = None,
        vertical: Var[bool] | bool | None = None,
        vertical_points: Sequence[int | str] | Var[Sequence[int | str]] | None = None,
        horizontal_points: Sequence[int | str] | Var[Sequence[int | str]] | None = None,
        fill: Color | Var[Color | str] | str | None = None,
        fill_opacity: Var[float] | float | None = None,
        stroke_dasharray: Var[str] | str | None = None,
        stroke: Color | Var[Color | str] | str | None = None,
        x: Var[int] | int | None = None,
        y: Var[int] | int | None = None,
        width: Var[int] | int | None = None,
        height: Var[int] | int | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        autofocus: bool | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> CartesianGrid:
        """Create the component.

        Args:
            *children: The children of the component.
            horizontal: The horizontal line configuration. Default: True
            vertical: The vertical line configuration. Default: True
            vertical_points: The x-coordinates in pixel values of all vertical lines. Default: []
            horizontal_points: The x-coordinates in pixel values of all vertical lines. Default: []
            fill: The background of grid.
            fill_opacity: The opacity of the background used to fill the space between grid lines.
            stroke_dasharray: The pattern of dashes and gaps used to paint the lines of the grid.
            stroke: the stroke color of grid. Default: rx.color("gray", 7)
            x: The x-coordinate of grid. Default: 0
            y: The y-coordinate of grid. Default: 0
            width: The width of grid. Default: 0
            height: The height of grid. Default: 0
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            autofocus: Whether the component should take the focus once the page is loaded
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The component.
        """

class CartesianAxis(Grid):
    @classmethod
    def create(
        cls,
        *children,
        orientation: Literal["bottom", "left", "right", "top"]
        | Var[Literal["bottom", "left", "right", "top"]]
        | None = None,
        view_box: Var[dict[str, Any]] | dict[str, Any] | None = None,
        axis_line: Var[bool | dict] | bool | dict | None = None,
        tick: Var[bool | dict] | bool | dict | None = None,
        tick_line: Var[bool] | bool | None = None,
        tick_size: Var[int] | int | None = None,
        interval: Literal["preserveEnd", "preserveStart", "preserveStartEnd"]
        | Var[Literal["preserveEnd", "preserveStart", "preserveStartEnd"]]
        | None = None,
        label: Var[int | str] | int | str | None = None,
        mirror: Var[bool] | bool | None = None,
        tick_margin: Var[int] | int | None = None,
        x: Var[int] | int | None = None,
        y: Var[int] | int | None = None,
        width: Var[int] | int | None = None,
        height: Var[int] | int | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        autofocus: bool | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> CartesianAxis:
        """Create the component.

        Args:
            *children: The children of the component.
            orientation: The orientation of axis 'top' | 'bottom' | 'left' | 'right'. Default: "bottom"
            view_box: The box of viewing area. Default: {"x": 0, "y": 0, "width": 0, "height": 0}
            axis_line: If set false, no axis line will be drawn. If set a object, the option is the configuration of axis line. Default: True
            tick: If set false, no ticks will be drawn.
            tick_line: If set false, no axis tick lines will be drawn. If set a object, the option is the configuration of tick lines. Default: True
            tick_size: The length of tick line. Default: 6
            interval: If set 0, all the ticks will be shown. If set preserveStart", "preserveEnd" or "preserveStartEnd", the ticks which is to be shown or hidden will be calculated automatically. Default: "preserveEnd"
            label: If set a string or a number, default label will be drawn, and the option is content.
            mirror: If set true, flips ticks around the axis line, displaying the labels inside the chart instead of outside. Default: False
            tick_margin: The margin between tick line and tick.
            x: The x-coordinate of grid. Default: 0
            y: The y-coordinate of grid. Default: 0
            width: The width of grid. Default: 0
            height: The height of grid. Default: 0
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            autofocus: Whether the component should take the focus once the page is loaded
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The component.
        """

area = Area.create
bar = Bar.create
line = Line.create
scatter = Scatter.create
x_axis = XAxis.create
y_axis = YAxis.create
z_axis = ZAxis.create
brush = Brush.create
cartesian_axis = CartesianAxis.create
cartesian_grid = CartesianGrid.create
reference_line = ReferenceLine.create
reference_dot = ReferenceDot.create
reference_area = ReferenceArea.create
error_bar = ErrorBar.create
funnel = Funnel.create
