# coding=utf-8
# *** WARNING: this file was generated by pulumigen. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from ... import _utilities
from ._inputs import *

__all__ = ['ChartArgs', 'Chart']

@pulumi.input_type
class ChartArgs:
    def __init__(__self__, *,
                 chart: pulumi.Input[_builtins.str],
                 dependency_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 devel: Optional[pulumi.Input[_builtins.bool]] = None,
                 keyring: Optional[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 plain_http: Optional[pulumi.Input[_builtins.bool]] = None,
                 post_renderer: Optional[pulumi.Input['PostRendererArgs']] = None,
                 repository_opts: Optional[pulumi.Input['RepositoryOptsArgs']] = None,
                 resource_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_await: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_crds: Optional[pulumi.Input[_builtins.bool]] = None,
                 value_yaml_files: Optional[pulumi.Input[Sequence[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]]]] = None,
                 values: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 verify: Optional[pulumi.Input[_builtins.bool]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Chart resource.
        :param pulumi.Input[_builtins.str] chart: Chart name to be installed. A path may be used.
        :param pulumi.Input[_builtins.bool] dependency_update: Run helm dependency update before installing the chart.
        :param pulumi.Input[_builtins.bool] devel: Use chart development versions, too. Equivalent to version '>0.0.0-0'. If `version` is set, this is ignored.
        :param pulumi.Input[Union[pulumi.Asset, pulumi.Archive]] keyring: Location of public keys used for verification. Used only if `verify` is true
        :param pulumi.Input[_builtins.str] name: Release name.
        :param pulumi.Input[_builtins.str] namespace: Namespace for the release.
        :param pulumi.Input[_builtins.bool] plain_http: Use insecure HTTP for the chart download instead of HTTPS.
        :param pulumi.Input['PostRendererArgs'] post_renderer: Specification defining the post-renderer to use.
        :param pulumi.Input['RepositoryOptsArgs'] repository_opts: Specification defining the Helm chart repository to use.
        :param pulumi.Input[_builtins.str] resource_prefix: An optional prefix for the auto-generated resource names. Example: A resource created with resourcePrefix="foo" would produce a resource named "foo:resourceName".
        :param pulumi.Input[_builtins.bool] skip_await: By default, the provider waits until all resources are in a ready state before marking the release as successful. Setting this to true will skip such await logic.
        :param pulumi.Input[_builtins.bool] skip_crds: If set, no CRDs will be installed. By default, CRDs are installed if not already present.
        :param pulumi.Input[Sequence[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]]] value_yaml_files: List of assets (raw yaml files). Content is read and merged with values.
        :param pulumi.Input[Mapping[str, Any]] values: Custom values set for the release.
        :param pulumi.Input[_builtins.bool] verify: Verify the chart's integrity.
        :param pulumi.Input[_builtins.str] version: Specify the chart version to install. If this is not specified, the latest version is installed.
        """
        pulumi.set(__self__, "chart", chart)
        if dependency_update is not None:
            pulumi.set(__self__, "dependency_update", dependency_update)
        if devel is not None:
            pulumi.set(__self__, "devel", devel)
        if keyring is not None:
            pulumi.set(__self__, "keyring", keyring)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if plain_http is not None:
            pulumi.set(__self__, "plain_http", plain_http)
        if post_renderer is not None:
            pulumi.set(__self__, "post_renderer", post_renderer)
        if repository_opts is not None:
            pulumi.set(__self__, "repository_opts", repository_opts)
        if resource_prefix is not None:
            pulumi.set(__self__, "resource_prefix", resource_prefix)
        if skip_await is not None:
            pulumi.set(__self__, "skip_await", skip_await)
        if skip_crds is not None:
            pulumi.set(__self__, "skip_crds", skip_crds)
        if value_yaml_files is not None:
            pulumi.set(__self__, "value_yaml_files", value_yaml_files)
        if values is not None:
            pulumi.set(__self__, "values", values)
        if verify is not None:
            pulumi.set(__self__, "verify", verify)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def chart(self) -> pulumi.Input[_builtins.str]:
        """
        Chart name to be installed. A path may be used.
        """
        return pulumi.get(self, "chart")

    @chart.setter
    def chart(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "chart", value)

    @_builtins.property
    @pulumi.getter(name="dependencyUpdate")
    def dependency_update(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Run helm dependency update before installing the chart.
        """
        return pulumi.get(self, "dependency_update")

    @dependency_update.setter
    def dependency_update(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dependency_update", value)

    @_builtins.property
    @pulumi.getter
    def devel(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Use chart development versions, too. Equivalent to version '>0.0.0-0'. If `version` is set, this is ignored.
        """
        return pulumi.get(self, "devel")

    @devel.setter
    def devel(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "devel", value)

    @_builtins.property
    @pulumi.getter
    def keyring(self) -> Optional[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]]:
        """
        Location of public keys used for verification. Used only if `verify` is true
        """
        return pulumi.get(self, "keyring")

    @keyring.setter
    def keyring(self, value: Optional[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]]):
        pulumi.set(self, "keyring", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Release name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Namespace for the release.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="plainHttp")
    def plain_http(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Use insecure HTTP for the chart download instead of HTTPS.
        """
        return pulumi.get(self, "plain_http")

    @plain_http.setter
    def plain_http(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "plain_http", value)

    @_builtins.property
    @pulumi.getter(name="postRenderer")
    def post_renderer(self) -> Optional[pulumi.Input['PostRendererArgs']]:
        """
        Specification defining the post-renderer to use.
        """
        return pulumi.get(self, "post_renderer")

    @post_renderer.setter
    def post_renderer(self, value: Optional[pulumi.Input['PostRendererArgs']]):
        pulumi.set(self, "post_renderer", value)

    @_builtins.property
    @pulumi.getter(name="repositoryOpts")
    def repository_opts(self) -> Optional[pulumi.Input['RepositoryOptsArgs']]:
        """
        Specification defining the Helm chart repository to use.
        """
        return pulumi.get(self, "repository_opts")

    @repository_opts.setter
    def repository_opts(self, value: Optional[pulumi.Input['RepositoryOptsArgs']]):
        pulumi.set(self, "repository_opts", value)

    @_builtins.property
    @pulumi.getter(name="resourcePrefix")
    def resource_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional prefix for the auto-generated resource names. Example: A resource created with resourcePrefix="foo" would produce a resource named "foo:resourceName".
        """
        return pulumi.get(self, "resource_prefix")

    @resource_prefix.setter
    def resource_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_prefix", value)

    @_builtins.property
    @pulumi.getter(name="skipAwait")
    def skip_await(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        By default, the provider waits until all resources are in a ready state before marking the release as successful. Setting this to true will skip such await logic.
        """
        return pulumi.get(self, "skip_await")

    @skip_await.setter
    def skip_await(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_await", value)

    @_builtins.property
    @pulumi.getter(name="skipCrds")
    def skip_crds(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set, no CRDs will be installed. By default, CRDs are installed if not already present.
        """
        return pulumi.get(self, "skip_crds")

    @skip_crds.setter
    def skip_crds(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_crds", value)

    @_builtins.property
    @pulumi.getter(name="valueYamlFiles")
    def value_yaml_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]]]]:
        """
        List of assets (raw yaml files). Content is read and merged with values.
        """
        return pulumi.get(self, "value_yaml_files")

    @value_yaml_files.setter
    def value_yaml_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]]]]):
        pulumi.set(self, "value_yaml_files", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Custom values set for the release.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def verify(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Verify the chart's integrity.
        """
        return pulumi.get(self, "verify")

    @verify.setter
    def verify(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "verify", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify the chart version to install. If this is not specified, the latest version is installed.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("kubernetes:helm.sh/v4:Chart")
class Chart(pulumi.ComponentResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 chart: Optional[pulumi.Input[_builtins.str]] = None,
                 dependency_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 devel: Optional[pulumi.Input[_builtins.bool]] = None,
                 keyring: Optional[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 plain_http: Optional[pulumi.Input[_builtins.bool]] = None,
                 post_renderer: Optional[pulumi.Input[Union['PostRendererArgs', 'PostRendererArgsDict']]] = None,
                 repository_opts: Optional[pulumi.Input[Union['RepositoryOptsArgs', 'RepositoryOptsArgsDict']]] = None,
                 resource_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_await: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_crds: Optional[pulumi.Input[_builtins.bool]] = None,
                 value_yaml_files: Optional[pulumi.Input[Sequence[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]]]] = None,
                 values: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 verify: Optional[pulumi.Input[_builtins.bool]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        _Looking for the Release resource? Please use the [v3 package](/registry/packages/kubernetes/api-docs/helm/v3/release/)
        for production use cases, and stay tuned for an updated Release resource, coming soon._

        _See also: [New: Helm Chart v4 resource with new features and languages](/blog/kubernetes-chart-v4/)_

        Chart is a component representing a collection of resources described by a Helm Chart.
        Helm charts are a popular packaging format for Kubernetes applications, and published
        to registries such as [Artifact Hub](https://artifacthub.io/packages/search?kind=0&sort=relevance&page=1).

        Chart does not use Tiller or create a Helm Release; the semantics are equivalent to
        running `helm template --dry-run=server` and then using Pulumi to deploy the resulting YAML manifests.
        This allows you to apply [Pulumi Transformations](https://www.pulumi.com/docs/concepts/options/transformations/) and
        [Pulumi Policies](https://www.pulumi.com/docs/using-pulumi/crossguard/) to the Kubernetes resources.

        You may also want to consider the `Release` resource as an alternative method for managing helm charts. For more
        information about the trade-offs between these options, see: [Choosing the right Helm resource for your use case](https://www.pulumi.com/registry/packages/kubernetes/how-to-guides/choosing-the-right-helm-resource-for-your-use-case).

        ### Chart Resolution

        The Helm Chart can be fetched from any source that is accessible to the `helm` command line.
        The following variations are supported:

        1. By chart reference with repo prefix: `chart: "example/mariadb"`
        2. By path to a packaged chart: `chart: "./nginx-1.2.3.tgz"`
        3. By path to an unpacked chart directory: `chart: "./nginx"`
        4. By absolute URL: `chart: "https://example.com/charts/nginx-1.2.3.tgz"`
        5. By chart reference with repo URL: `chart: "nginx", repositoryOpts: { repo: "https://example.com/charts/" }`
        6. By OCI registry: `chart: "oci://example.com/charts/nginx", version: "1.2.3"`

        A chart reference is a convenient way of referencing a chart in a chart repository.

        When you use a chart reference with a repo prefix (`example/mariadb`), Pulumi will look in Helm's local configuration
        for a chart repository named `example`, and will then look for a chart in that repository whose name is `mariadb`.
        It will install the latest stable version of that chart, unless you specify `devel` to also include
        development versions (alpha, beta, and release candidate releases), or supply a version number with `version`.

        Use the `verify` and optional `keyring` inputs to enable Chart verification.
        By default, Pulumi uses the keyring at `$HOME/.gnupg/pubring.gpg`. See: [Helm Provenance and Integrity](https://helm.sh/docs/topics/provenance/).

        ### Chart Values

        [Values files](https://helm.sh/docs/chart_template_guide/values_files/#helm) (`values.yaml`) may be supplied
        with the `valueYamlFiles` input, accepting [Pulumi Assets](https://www.pulumi.com/docs/concepts/assets-archives/#assets).

        A map of chart values may also be supplied with the `values` input, with highest precedence. You're able to use literals,
        nested maps, [Pulumi outputs](https://www.pulumi.com/docs/concepts/inputs-outputs/), and Pulumi assets as values.
        Assets are automatically opened and converted to a string.

        Note that the use of expressions (e.g. `--set service.type`) is not supported.

        ### Chart Dependency Resolution

        For unpacked chart directories, Pulumi automatically rebuilds the dependencies if dependencies are missing
        and a `Chart.lock` file is present (see: [Helm Dependency Build](https://helm.sh/docs/helm/helm_dependency_build/)).
        Use the `dependencyUpdate` input to have Pulumi update the dependencies (see: [Helm Dependency Update](https://helm.sh/docs/helm/helm_dependency_update/)).

        ### Templating

        The `Chart` resource renders the templates from your chart and then manages the resources directly with the
        Pulumi Kubernetes provider. A default namespace is applied based on the `namespace` input, the provider's
        configured namespace, and the active Kubernetes context. Use the `skipCrds` option to skip installing the
        Custom Resource Definition (CRD) objects located in the chart's `crds/` special directory.

        Use the `postRenderer` input to pipe the rendered manifest through a [post-rendering command](https://helm.sh/docs/topics/advanced/#post-rendering).

        ### Resource Ordering

        Sometimes resources must be applied in a specific order. For example, a namespace resource must be
        created before any namespaced resources, or a Custom Resource Definition (CRD) must be pre-installed.

        Pulumi uses heuristics to determine which order to apply and delete objects within the Chart.  Pulumi also
        waits for each object to be fully reconciled, unless `skipAwait` is enabled.

        Pulumi supports the `config.kubernetes.io/depends-on` annotation to declare an explicit dependency on a given resource.
        The annotation accepts a list of resource references, delimited by commas.

        Note that references to resources outside the Chart aren't supported.

        **Resource reference**

        A resource reference is a string that uniquely identifies a resource.

        It consists of the group, kind, name, and optionally the namespace, delimited by forward slashes.

        | Resource Scope   | Format                                         |
        | :--------------- | :--------------------------------------------- |
        | namespace-scoped | `<group>/namespaces/<namespace>/<kind>/<name>` |
        | cluster-scoped   | `<group>/<kind>/<name>`                        |

        For resources in the “core” group, the empty string is used instead (for example: `/namespaces/test/Pod/pod-a`).

        ## Example Usage
        ### Local Chart Directory
        ```python
        import pulumi
        from pulumi_kubernetes.helm.v4 import Chart

        nginx = Chart("nginx",
            chart="./nginx"
        )
        ```
        ### Repository Chart
        ```python
        import pulumi
        from pulumi_kubernetes.helm.v4 import Chart,RepositoryOptsArgs

        nginx = Chart("nginx",
            chart="nginx",
            repository_opts=RepositoryOptsArgs(
                repo="https://charts.bitnami.com/bitnami",
            )
        )
        ```
        ### OCI Chart
        ```python
        import pulumi
        from pulumi_kubernetes.helm.v4 import Chart

        nginx = Chart("nginx",
            chart="oci://registry-1.docker.io/bitnamicharts/nginx",
            version="16.0.7",
        )
        ```
        ### Chart Values
        ```python
        \"\"\"A Kubernetes Python Pulumi program\"\"\"

        import pulumi
        from pulumi_kubernetes.helm.v4 import Chart,RepositoryOptsArgs

        nginx = Chart("nginx",
            chart="nginx",
            repository_opts=RepositoryOptsArgs(
                repo="https://charts.bitnami.com/bitnami"
            ),
            value_yaml_files=[
                pulumi.FileAsset("./values.yaml")
            ],
            values={
                "service": {
                    "type": "ClusterIP"
                },
                "notes": pulumi.FileAsset("./notes.txt")
            }
        )
        ```
        ### Chart Namespace
        ```python
        import pulumi
        from pulumi_kubernetes.meta.v1 import ObjectMetaArgs
        from pulumi_kubernetes.core.v1 import Namespace
        from pulumi_kubernetes.helm.v4 import Chart,RepositoryOptsArgs

        ns = Namespace("nginx",
            metadata=ObjectMetaArgs(
                name="nginx",
            )
        )
        nginx = Chart("nginx",
            namespace=ns.metadata.name,
            chart="nginx",
            repository_opts=RepositoryOptsArgs(
                repo="https://charts.bitnami.com/bitnami",
            )
        )
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] chart: Chart name to be installed. A path may be used.
        :param pulumi.Input[_builtins.bool] dependency_update: Run helm dependency update before installing the chart.
        :param pulumi.Input[_builtins.bool] devel: Use chart development versions, too. Equivalent to version '>0.0.0-0'. If `version` is set, this is ignored.
        :param pulumi.Input[Union[pulumi.Asset, pulumi.Archive]] keyring: Location of public keys used for verification. Used only if `verify` is true
        :param pulumi.Input[_builtins.str] name: Release name.
        :param pulumi.Input[_builtins.str] namespace: Namespace for the release.
        :param pulumi.Input[_builtins.bool] plain_http: Use insecure HTTP for the chart download instead of HTTPS.
        :param pulumi.Input[Union['PostRendererArgs', 'PostRendererArgsDict']] post_renderer: Specification defining the post-renderer to use.
        :param pulumi.Input[Union['RepositoryOptsArgs', 'RepositoryOptsArgsDict']] repository_opts: Specification defining the Helm chart repository to use.
        :param pulumi.Input[_builtins.str] resource_prefix: An optional prefix for the auto-generated resource names. Example: A resource created with resourcePrefix="foo" would produce a resource named "foo:resourceName".
        :param pulumi.Input[_builtins.bool] skip_await: By default, the provider waits until all resources are in a ready state before marking the release as successful. Setting this to true will skip such await logic.
        :param pulumi.Input[_builtins.bool] skip_crds: If set, no CRDs will be installed. By default, CRDs are installed if not already present.
        :param pulumi.Input[Sequence[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]]] value_yaml_files: List of assets (raw yaml files). Content is read and merged with values.
        :param pulumi.Input[Mapping[str, Any]] values: Custom values set for the release.
        :param pulumi.Input[_builtins.bool] verify: Verify the chart's integrity.
        :param pulumi.Input[_builtins.str] version: Specify the chart version to install. If this is not specified, the latest version is installed.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ChartArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        _Looking for the Release resource? Please use the [v3 package](/registry/packages/kubernetes/api-docs/helm/v3/release/)
        for production use cases, and stay tuned for an updated Release resource, coming soon._

        _See also: [New: Helm Chart v4 resource with new features and languages](/blog/kubernetes-chart-v4/)_

        Chart is a component representing a collection of resources described by a Helm Chart.
        Helm charts are a popular packaging format for Kubernetes applications, and published
        to registries such as [Artifact Hub](https://artifacthub.io/packages/search?kind=0&sort=relevance&page=1).

        Chart does not use Tiller or create a Helm Release; the semantics are equivalent to
        running `helm template --dry-run=server` and then using Pulumi to deploy the resulting YAML manifests.
        This allows you to apply [Pulumi Transformations](https://www.pulumi.com/docs/concepts/options/transformations/) and
        [Pulumi Policies](https://www.pulumi.com/docs/using-pulumi/crossguard/) to the Kubernetes resources.

        You may also want to consider the `Release` resource as an alternative method for managing helm charts. For more
        information about the trade-offs between these options, see: [Choosing the right Helm resource for your use case](https://www.pulumi.com/registry/packages/kubernetes/how-to-guides/choosing-the-right-helm-resource-for-your-use-case).

        ### Chart Resolution

        The Helm Chart can be fetched from any source that is accessible to the `helm` command line.
        The following variations are supported:

        1. By chart reference with repo prefix: `chart: "example/mariadb"`
        2. By path to a packaged chart: `chart: "./nginx-1.2.3.tgz"`
        3. By path to an unpacked chart directory: `chart: "./nginx"`
        4. By absolute URL: `chart: "https://example.com/charts/nginx-1.2.3.tgz"`
        5. By chart reference with repo URL: `chart: "nginx", repositoryOpts: { repo: "https://example.com/charts/" }`
        6. By OCI registry: `chart: "oci://example.com/charts/nginx", version: "1.2.3"`

        A chart reference is a convenient way of referencing a chart in a chart repository.

        When you use a chart reference with a repo prefix (`example/mariadb`), Pulumi will look in Helm's local configuration
        for a chart repository named `example`, and will then look for a chart in that repository whose name is `mariadb`.
        It will install the latest stable version of that chart, unless you specify `devel` to also include
        development versions (alpha, beta, and release candidate releases), or supply a version number with `version`.

        Use the `verify` and optional `keyring` inputs to enable Chart verification.
        By default, Pulumi uses the keyring at `$HOME/.gnupg/pubring.gpg`. See: [Helm Provenance and Integrity](https://helm.sh/docs/topics/provenance/).

        ### Chart Values

        [Values files](https://helm.sh/docs/chart_template_guide/values_files/#helm) (`values.yaml`) may be supplied
        with the `valueYamlFiles` input, accepting [Pulumi Assets](https://www.pulumi.com/docs/concepts/assets-archives/#assets).

        A map of chart values may also be supplied with the `values` input, with highest precedence. You're able to use literals,
        nested maps, [Pulumi outputs](https://www.pulumi.com/docs/concepts/inputs-outputs/), and Pulumi assets as values.
        Assets are automatically opened and converted to a string.

        Note that the use of expressions (e.g. `--set service.type`) is not supported.

        ### Chart Dependency Resolution

        For unpacked chart directories, Pulumi automatically rebuilds the dependencies if dependencies are missing
        and a `Chart.lock` file is present (see: [Helm Dependency Build](https://helm.sh/docs/helm/helm_dependency_build/)).
        Use the `dependencyUpdate` input to have Pulumi update the dependencies (see: [Helm Dependency Update](https://helm.sh/docs/helm/helm_dependency_update/)).

        ### Templating

        The `Chart` resource renders the templates from your chart and then manages the resources directly with the
        Pulumi Kubernetes provider. A default namespace is applied based on the `namespace` input, the provider's
        configured namespace, and the active Kubernetes context. Use the `skipCrds` option to skip installing the
        Custom Resource Definition (CRD) objects located in the chart's `crds/` special directory.

        Use the `postRenderer` input to pipe the rendered manifest through a [post-rendering command](https://helm.sh/docs/topics/advanced/#post-rendering).

        ### Resource Ordering

        Sometimes resources must be applied in a specific order. For example, a namespace resource must be
        created before any namespaced resources, or a Custom Resource Definition (CRD) must be pre-installed.

        Pulumi uses heuristics to determine which order to apply and delete objects within the Chart.  Pulumi also
        waits for each object to be fully reconciled, unless `skipAwait` is enabled.

        Pulumi supports the `config.kubernetes.io/depends-on` annotation to declare an explicit dependency on a given resource.
        The annotation accepts a list of resource references, delimited by commas.

        Note that references to resources outside the Chart aren't supported.

        **Resource reference**

        A resource reference is a string that uniquely identifies a resource.

        It consists of the group, kind, name, and optionally the namespace, delimited by forward slashes.

        | Resource Scope   | Format                                         |
        | :--------------- | :--------------------------------------------- |
        | namespace-scoped | `<group>/namespaces/<namespace>/<kind>/<name>` |
        | cluster-scoped   | `<group>/<kind>/<name>`                        |

        For resources in the “core” group, the empty string is used instead (for example: `/namespaces/test/Pod/pod-a`).

        ## Example Usage
        ### Local Chart Directory
        ```python
        import pulumi
        from pulumi_kubernetes.helm.v4 import Chart

        nginx = Chart("nginx",
            chart="./nginx"
        )
        ```
        ### Repository Chart
        ```python
        import pulumi
        from pulumi_kubernetes.helm.v4 import Chart,RepositoryOptsArgs

        nginx = Chart("nginx",
            chart="nginx",
            repository_opts=RepositoryOptsArgs(
                repo="https://charts.bitnami.com/bitnami",
            )
        )
        ```
        ### OCI Chart
        ```python
        import pulumi
        from pulumi_kubernetes.helm.v4 import Chart

        nginx = Chart("nginx",
            chart="oci://registry-1.docker.io/bitnamicharts/nginx",
            version="16.0.7",
        )
        ```
        ### Chart Values
        ```python
        \"\"\"A Kubernetes Python Pulumi program\"\"\"

        import pulumi
        from pulumi_kubernetes.helm.v4 import Chart,RepositoryOptsArgs

        nginx = Chart("nginx",
            chart="nginx",
            repository_opts=RepositoryOptsArgs(
                repo="https://charts.bitnami.com/bitnami"
            ),
            value_yaml_files=[
                pulumi.FileAsset("./values.yaml")
            ],
            values={
                "service": {
                    "type": "ClusterIP"
                },
                "notes": pulumi.FileAsset("./notes.txt")
            }
        )
        ```
        ### Chart Namespace
        ```python
        import pulumi
        from pulumi_kubernetes.meta.v1 import ObjectMetaArgs
        from pulumi_kubernetes.core.v1 import Namespace
        from pulumi_kubernetes.helm.v4 import Chart,RepositoryOptsArgs

        ns = Namespace("nginx",
            metadata=ObjectMetaArgs(
                name="nginx",
            )
        )
        nginx = Chart("nginx",
            namespace=ns.metadata.name,
            chart="nginx",
            repository_opts=RepositoryOptsArgs(
                repo="https://charts.bitnami.com/bitnami",
            )
        )
        ```

        :param str resource_name: The name of the resource.
        :param ChartArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ChartArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 chart: Optional[pulumi.Input[_builtins.str]] = None,
                 dependency_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 devel: Optional[pulumi.Input[_builtins.bool]] = None,
                 keyring: Optional[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 plain_http: Optional[pulumi.Input[_builtins.bool]] = None,
                 post_renderer: Optional[pulumi.Input[Union['PostRendererArgs', 'PostRendererArgsDict']]] = None,
                 repository_opts: Optional[pulumi.Input[Union['RepositoryOptsArgs', 'RepositoryOptsArgsDict']]] = None,
                 resource_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_await: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_crds: Optional[pulumi.Input[_builtins.bool]] = None,
                 value_yaml_files: Optional[pulumi.Input[Sequence[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]]]] = None,
                 values: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 verify: Optional[pulumi.Input[_builtins.bool]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is not None:
            raise ValueError('ComponentResource classes do not support opts.id')
        else:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ChartArgs.__new__(ChartArgs)

            if chart is None and not opts.urn:
                raise TypeError("Missing required property 'chart'")
            __props__.__dict__["chart"] = chart
            __props__.__dict__["dependency_update"] = dependency_update
            __props__.__dict__["devel"] = devel
            __props__.__dict__["keyring"] = keyring
            __props__.__dict__["name"] = name
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["plain_http"] = plain_http
            __props__.__dict__["post_renderer"] = post_renderer
            __props__.__dict__["repository_opts"] = repository_opts
            __props__.__dict__["resource_prefix"] = resource_prefix
            __props__.__dict__["skip_await"] = skip_await
            __props__.__dict__["skip_crds"] = skip_crds
            __props__.__dict__["value_yaml_files"] = value_yaml_files
            __props__.__dict__["values"] = values
            __props__.__dict__["verify"] = verify
            __props__.__dict__["version"] = version
            __props__.__dict__["resources"] = None
        super(Chart, __self__).__init__(
            'kubernetes:helm.sh/v4:Chart',
            resource_name,
            __props__,
            opts,
            remote=True)

    @_builtins.property
    @pulumi.getter
    def resources(self) -> pulumi.Output[Optional[Sequence[Any]]]:
        """
        Resources created by the Chart.
        """
        return pulumi.get(self, "resources")

