# coding=utf-8
# *** WARNING: this file was generated by pulumigen. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from ... import _utilities
from . import outputs
from ... import meta as _meta

__all__ = [
    'GroupVersionResource',
    'GroupVersionResourcePatch',
    'MigrationCondition',
    'MigrationConditionPatch',
    'StorageVersionMigration',
    'StorageVersionMigrationSpec',
    'StorageVersionMigrationSpecPatch',
    'StorageVersionMigrationStatus',
    'StorageVersionMigrationStatusPatch',
]

@pulumi.output_type
class GroupVersionResource(dict):
    """
    The names of the group, the version, and the resource.
    """
    def __init__(__self__, *,
                 group: Optional[_builtins.str] = None,
                 resource: Optional[_builtins.str] = None,
                 version: Optional[_builtins.str] = None):
        """
        The names of the group, the version, and the resource.
        :param _builtins.str group: The name of the group.
        :param _builtins.str resource: The name of the resource.
        :param _builtins.str version: The name of the version.
        """
        if group is not None:
            pulumi.set(__self__, "group", group)
        if resource is not None:
            pulumi.set(__self__, "resource", resource)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def group(self) -> Optional[_builtins.str]:
        """
        The name of the group.
        """
        return pulumi.get(self, "group")

    @_builtins.property
    @pulumi.getter
    def resource(self) -> Optional[_builtins.str]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "resource")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        The name of the version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GroupVersionResourcePatch(dict):
    """
    The names of the group, the version, and the resource.
    """
    def __init__(__self__, *,
                 group: Optional[_builtins.str] = None,
                 resource: Optional[_builtins.str] = None,
                 version: Optional[_builtins.str] = None):
        """
        The names of the group, the version, and the resource.
        :param _builtins.str group: The name of the group.
        :param _builtins.str resource: The name of the resource.
        :param _builtins.str version: The name of the version.
        """
        if group is not None:
            pulumi.set(__self__, "group", group)
        if resource is not None:
            pulumi.set(__self__, "resource", resource)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def group(self) -> Optional[_builtins.str]:
        """
        The name of the group.
        """
        return pulumi.get(self, "group")

    @_builtins.property
    @pulumi.getter
    def resource(self) -> Optional[_builtins.str]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "resource")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        The name of the version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class MigrationCondition(dict):
    """
    Describes the state of a migration at a certain point.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastUpdateTime":
            suggest = "last_update_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrationCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrationCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrationCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status: _builtins.str,
                 type: _builtins.str,
                 last_update_time: Optional[_builtins.str] = None,
                 message: Optional[_builtins.str] = None,
                 reason: Optional[_builtins.str] = None):
        """
        Describes the state of a migration at a certain point.
        :param _builtins.str status: Status of the condition, one of True, False, Unknown.
        :param _builtins.str type: Type of the condition.
        :param _builtins.str last_update_time: The last time this condition was updated.
        :param _builtins.str message: A human readable message indicating details about the transition.
        :param _builtins.str reason: The reason for the condition's last transition.
        """
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        if last_update_time is not None:
            pulumi.set(__self__, "last_update_time", last_update_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the condition, one of True, False, Unknown.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the condition.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="lastUpdateTime")
    def last_update_time(self) -> Optional[_builtins.str]:
        """
        The last time this condition was updated.
        """
        return pulumi.get(self, "last_update_time")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        A human readable message indicating details about the transition.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        The reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")


@pulumi.output_type
class MigrationConditionPatch(dict):
    """
    Describes the state of a migration at a certain point.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastUpdateTime":
            suggest = "last_update_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrationConditionPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrationConditionPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrationConditionPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_update_time: Optional[_builtins.str] = None,
                 message: Optional[_builtins.str] = None,
                 reason: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        Describes the state of a migration at a certain point.
        :param _builtins.str last_update_time: The last time this condition was updated.
        :param _builtins.str message: A human readable message indicating details about the transition.
        :param _builtins.str reason: The reason for the condition's last transition.
        :param _builtins.str status: Status of the condition, one of True, False, Unknown.
        :param _builtins.str type: Type of the condition.
        """
        if last_update_time is not None:
            pulumi.set(__self__, "last_update_time", last_update_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="lastUpdateTime")
    def last_update_time(self) -> Optional[_builtins.str]:
        """
        The last time this condition was updated.
        """
        return pulumi.get(self, "last_update_time")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        A human readable message indicating details about the transition.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        The reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        Status of the condition, one of True, False, Unknown.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type of the condition.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class StorageVersionMigration(dict):
    """
    StorageVersionMigration represents a migration of stored data to the latest storage version.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageVersionMigration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageVersionMigration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageVersionMigration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[_builtins.str] = None,
                 kind: Optional[_builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 spec: Optional['outputs.StorageVersionMigrationSpec'] = None,
                 status: Optional['outputs.StorageVersionMigrationStatus'] = None):
        """
        StorageVersionMigration represents a migration of stored data to the latest storage version.
        :param _builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param _builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param 'StorageVersionMigrationSpecArgs' spec: Specification of the migration.
        :param 'StorageVersionMigrationStatusArgs' status: Status of the migration.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'storagemigration.k8s.io/v1alpha1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'StorageVersionMigration')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[_builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[_builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> Optional['outputs.StorageVersionMigrationSpec']:
        """
        Specification of the migration.
        """
        return pulumi.get(self, "spec")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional['outputs.StorageVersionMigrationStatus']:
        """
        Status of the migration.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class StorageVersionMigrationSpec(dict):
    """
    Spec of the storage version migration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "continueToken":
            suggest = "continue_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageVersionMigrationSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageVersionMigrationSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageVersionMigrationSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource: 'outputs.GroupVersionResource',
                 continue_token: Optional[_builtins.str] = None):
        """
        Spec of the storage version migration.
        :param 'GroupVersionResourceArgs' resource: The resource that is being migrated. The migrator sends requests to the endpoint serving the resource. Immutable.
        :param _builtins.str continue_token: The token used in the list options to get the next chunk of objects to migrate. When the .status.conditions indicates the migration is "Running", users can use this token to check the progress of the migration.
        """
        pulumi.set(__self__, "resource", resource)
        if continue_token is not None:
            pulumi.set(__self__, "continue_token", continue_token)

    @_builtins.property
    @pulumi.getter
    def resource(self) -> 'outputs.GroupVersionResource':
        """
        The resource that is being migrated. The migrator sends requests to the endpoint serving the resource. Immutable.
        """
        return pulumi.get(self, "resource")

    @_builtins.property
    @pulumi.getter(name="continueToken")
    def continue_token(self) -> Optional[_builtins.str]:
        """
        The token used in the list options to get the next chunk of objects to migrate. When the .status.conditions indicates the migration is "Running", users can use this token to check the progress of the migration.
        """
        return pulumi.get(self, "continue_token")


@pulumi.output_type
class StorageVersionMigrationSpecPatch(dict):
    """
    Spec of the storage version migration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "continueToken":
            suggest = "continue_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageVersionMigrationSpecPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageVersionMigrationSpecPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageVersionMigrationSpecPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 continue_token: Optional[_builtins.str] = None,
                 resource: Optional['outputs.GroupVersionResourcePatch'] = None):
        """
        Spec of the storage version migration.
        :param _builtins.str continue_token: The token used in the list options to get the next chunk of objects to migrate. When the .status.conditions indicates the migration is "Running", users can use this token to check the progress of the migration.
        :param 'GroupVersionResourcePatchArgs' resource: The resource that is being migrated. The migrator sends requests to the endpoint serving the resource. Immutable.
        """
        if continue_token is not None:
            pulumi.set(__self__, "continue_token", continue_token)
        if resource is not None:
            pulumi.set(__self__, "resource", resource)

    @_builtins.property
    @pulumi.getter(name="continueToken")
    def continue_token(self) -> Optional[_builtins.str]:
        """
        The token used in the list options to get the next chunk of objects to migrate. When the .status.conditions indicates the migration is "Running", users can use this token to check the progress of the migration.
        """
        return pulumi.get(self, "continue_token")

    @_builtins.property
    @pulumi.getter
    def resource(self) -> Optional['outputs.GroupVersionResourcePatch']:
        """
        The resource that is being migrated. The migrator sends requests to the endpoint serving the resource. Immutable.
        """
        return pulumi.get(self, "resource")


@pulumi.output_type
class StorageVersionMigrationStatus(dict):
    """
    Status of the storage version migration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceVersion":
            suggest = "resource_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageVersionMigrationStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageVersionMigrationStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageVersionMigrationStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 conditions: Optional[Sequence['outputs.MigrationCondition']] = None,
                 resource_version: Optional[_builtins.str] = None):
        """
        Status of the storage version migration.
        :param Sequence['MigrationConditionArgs'] conditions: The latest available observations of the migration's current state.
        :param _builtins.str resource_version: ResourceVersion to compare with the GC cache for performing the migration. This is the current resource version of given group, version and resource when kube-controller-manager first observes this StorageVersionMigration resource.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if resource_version is not None:
            pulumi.set(__self__, "resource_version", resource_version)

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.MigrationCondition']]:
        """
        The latest available observations of the migration's current state.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter(name="resourceVersion")
    def resource_version(self) -> Optional[_builtins.str]:
        """
        ResourceVersion to compare with the GC cache for performing the migration. This is the current resource version of given group, version and resource when kube-controller-manager first observes this StorageVersionMigration resource.
        """
        return pulumi.get(self, "resource_version")


@pulumi.output_type
class StorageVersionMigrationStatusPatch(dict):
    """
    Status of the storage version migration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceVersion":
            suggest = "resource_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageVersionMigrationStatusPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageVersionMigrationStatusPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageVersionMigrationStatusPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 conditions: Optional[Sequence['outputs.MigrationConditionPatch']] = None,
                 resource_version: Optional[_builtins.str] = None):
        """
        Status of the storage version migration.
        :param Sequence['MigrationConditionPatchArgs'] conditions: The latest available observations of the migration's current state.
        :param _builtins.str resource_version: ResourceVersion to compare with the GC cache for performing the migration. This is the current resource version of given group, version and resource when kube-controller-manager first observes this StorageVersionMigration resource.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if resource_version is not None:
            pulumi.set(__self__, "resource_version", resource_version)

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.MigrationConditionPatch']]:
        """
        The latest available observations of the migration's current state.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter(name="resourceVersion")
    def resource_version(self) -> Optional[_builtins.str]:
        """
        ResourceVersion to compare with the GC cache for performing the migration. This is the current resource version of given group, version and resource when kube-controller-manager first observes this StorageVersionMigration resource.
        """
        return pulumi.get(self, "resource_version")


