"""
The ``kauri.cem`` sub-package implements the Calaque, Ebrahimi-Fard and Manchon (CEM) :cite:`calaque2011two` Hopf algebra
:math:`(\\widetilde{H}, \\Delta_{CEM}, \\mu, \\varepsilon_{CEM}, \\bullet, S_{CEM})`, defined as follows.

- :math:`\\widetilde{H}` is the space of non-empty trees, defined as
  :math:`\\widetilde{H} = H / J` where :math:`J` is the ideal
  generated by :math:`\\bullet - \\emptyset`.
- The unit is the single-node tree, :math:`\\bullet`.
- The counit map is defined by :math:`\\varepsilon_{CEM}(\\bullet) = 1`,
  :math:`\\varepsilon_{CEM}(t) = 0` for all :math:`\\bullet \\neq t \\in \\widetilde{H}`.
- Multiplication :math:`\\mu : \\widetilde{H} \\otimes \\widetilde{H} \\to \\widetilde{H}` is defined as the
  commutative juxtaposition of two forests.
- Comultiplication :math:`\\Delta : \\widetilde{H} \\to \\widetilde{H} \\otimes \\widetilde{H}` is defined as

  .. math::

      \\Delta_{CEM}(t) = \\sum_{s \\subset t} s \\otimes t / s

  where the sum runs over all possible subforests :math:`s` of :math:`t`, and
  :math:`t / s` is the tree obtained by contracting each connected component of
  :math:`s` onto a vertex :cite:`calaque2011two`.
- The antipode :math:`S_{CEM}` is defined by :math:`S_{CEM}(\\bullet) = \\bullet` and

  .. math::

      S_{CEM}(t) = -t - \\sum_{t, \\bullet \\neq s \\subset t} S_{CEM}(s) \\, t / s.

.. note::

    We adopt the singleton-reduced coproduct, where the singleton tree :math:`\\bullet`
    appears in each forest at most once. This defines a Hopf algebra
    on :math:`\\widetilde{H} = H / J`. There are alternative forms of the
    coproduct defined directly on :math:`H`, but these do not define a Hopf
    algebra.

.. note::

    Since :math:`\\bullet` is the unit, characters :math:`\\phi` on the resulting
    Hopf algebra must satisfy :math:`\\phi(\\bullet) = 1`.

"""

from .cem import antipode, counit, coproduct, map_power, map_product
