import os
import json
import pickle
import tkinter as tk
from tkinter import filedialog

class FileHelper:
    """CrystalWindow integrated file helper with default folders & Tk dialogs"""

    def __init__(self, default_save_folder="saves"):
        self.default_save_folder = default_save_folder
        os.makedirs(self.default_save_folder, exist_ok=True)

    # ---- TK FILE DIALOGS ----
    def ask_save_file(self, default_name="save.json", filetypes=[("JSON files","*.json"),("All files","*.*")]):
        root = tk.Tk()
        root.withdraw()
        path = filedialog.asksaveasfilename(
            initialdir=self.default_save_folder,
            initialfile=default_name,
            filetypes=filetypes,
            defaultextension=filetypes[0][1]
        )
        root.destroy()
        return path

    def ask_open_file(self, filetypes=[("JSON files","*.json"),("All files","*.*")]):
        root = tk.Tk()
        root.withdraw()
        path = filedialog.askopenfilename(
            initialdir=self.default_save_folder,
            filetypes=filetypes
        )
        root.destroy()
        return path

    # ---- TEXT ----
    def save_text(self, filename, content):
        path = os.path.join(self.default_save_folder, filename)
        with open(path, "w", encoding="utf-8") as f:
            f.write(content)
        return path

    def load_text(self, filename):
        path = os.path.join(self.default_save_folder, filename)
        if os.path.exists(path):
            with open(path, "r", encoding="utf-8") as f:
                return f.read()
        return None

    # ---- JSON ----
    def save_json(self, filename, data):
        path = os.path.join(self.default_save_folder, filename)
        with open(path, "w", encoding="utf-8") as f:
            json.dump(data, f, indent=4)
        return path

    def load_json(self, filename):
        path = os.path.join(self.default_save_folder, filename)
        if os.path.exists(path):
            with open(path, "r", encoding="utf-8") as f:
                return json.load(f)
        return None

    # ---- PICKLE ----
    def save_pickle(self, filename, obj):
        path = os.path.join(self.default_save_folder, filename)
        with open(path, "wb") as f:
            pickle.dump(obj, f)
        return path

    def load_pickle(self, filename):
        path = os.path.join(self.default_save_folder, filename)
        if os.path.exists(path):
            with open(path, "rb") as f:
                return pickle.load(f)
        return None
