from .window import Window
from .assets import load_image
from .sprites import Sprite
from .gui import Button

class Toggle:
    def __init__(self, rect, value=False, color=(200,200,200), hover_color=(255,255,255)):
        self.rect = rect
        self.value = value
        self.color = color
        self.hover_color = hover_color
        self.hovered = False

    def update(self, win):
        mx, my = win.mouse_pos
        x,y,w,h = self.rect
        self.hovered = x <= mx <= x+w and y <= my <= y+h
        if self.hovered and win.is_mouse_pressed(1):
            self.value = not self.value

    def draw(self, win):
        draw_color = self.hover_color if self.hovered else self.color
        win.draw_rect(draw_color, self.rect)

from .window import Window

class Slider:
    def __init__(self, rect, min_val=0, max_val=100, value=50, color=(150,150,150), handle_radius=10):
        self.rect = rect  # x, y, w, h
        self.min_val = min_val
        self.max_val = max_val
        self.value = value
        self.color = color
        self.handle_radius = handle_radius
        self.dragging = False

    def update(self, win: Window):
        mx, my = win.mouse_pos
        x, y, w, h = self.rect

        # Start dragging if clicked on the slider track or handle
        handle_x = x + ((self.value - self.min_val) / (self.max_val - self.min_val)) * w
        handle_y = y + h // 2
        if win.is_mouse_pressed(1):
            if (x <= mx <= x + w and y <= my <= y + h) or ((mx-handle_x)**2 + (my-handle_y)**2 <= self.handle_radius**2):
                self.dragging = True
        else:
            self.dragging = False

        # Drag the handle
        if self.dragging:
            rel_x = max(0, min(mx - x, w))
            self.value = self.min_val + (rel_x / w) * (self.max_val - self.min_val)

    def draw(self, win: Window):
        x, y, w, h = self.rect
        # draw slider track
        win.draw_rect(self.color, (x, y + h//2 - 2, w, 4))
        # draw handle as circle
        handle_x = x + ((self.value - self.min_val) / (self.max_val - self.min_val)) * w
        handle_y = y + h // 2
        win.draw_circle((255,0,0), (int(handle_x), int(handle_y)), self.handle_radius)
