import pygame as py

class Sprite:
    def __init__(self, image=None, x=0, y=0, w=50, h=50, color=(255,255,255)):
        self.image = image
        self.x = x
        self.y = y
        self.color = color

        # optional rect if no image
        if image:
            self.rect = self.image.get_rect(topleft=(x, y))
        else:
            self.rect = py.Rect(x, y, w, h)

    def draw(self, screen):
        if self.image:
            screen.blit(self.image, (self.x, self.y))
        else:
            py.draw.rect(screen, self.color, self.rect)

    def move(self, dx, dy):
        self.x += dx
        self.y += dy
        self.rect.topleft = (self.x, self.y)
