import numpy as np
import pytest

from zarr.core.chunk_grids import _guess_chunks


@pytest.mark.parametrize(
    "shape", ((0,), (0,) * 2, (1, 2, 0, 4, 5), (10, 0), (10,), (100,) * 3, (1000000,), (10000,) * 2)
)
@pytest.mark.parametrize("itemsize", (1, 2, 4))
def test_guess_chunks(shape: tuple[int, ...], itemsize: int) -> None:
    chunks = _guess_chunks(shape, itemsize)
    chunk_size = np.prod(chunks) * itemsize
    assert isinstance(chunks, tuple)
    assert len(chunks) == len(shape)
    assert chunk_size < (64 * 1024 * 1024)
    # doesn't make any sense to allow chunks to have zero length dimension
    assert all(0 < c <= max(s, 1) for c, s in zip(chunks, shape, strict=False))
