# Generated by Django 4.1.5 on 2023-01-16 14:46

from django.db import migrations, models
import django.db.models.deletion
import taggit.managers
import utilities.json


class Migration(migrations.Migration):

    replaces = [
        ("netbox_circuitmaintenance", "0001_initial"),
        ("netbox_circuitmaintenance", "0002_circuitmaintenance_provider"),
        ("netbox_circuitmaintenance", "0003_alter_circuitmaintenance_options_and_more"),
        ("netbox_circuitmaintenance", "0004_alter_circuitmaintenance_options_and_more"),
        ("netbox_circuitmaintenance", "0005_alter_circuitmaintenance_options"),
    ]

    initial = True

    dependencies = [
        ("circuits", "0041_standardize_description_comments"),
        ("extras", "0084_staging"),
    ]

    operations = [
        migrations.CreateModel(
            name="CircuitMaintenance",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "custom_field_data",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=utilities.json.CustomFieldJSONEncoder,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                ("summary", models.CharField(max_length=200)),
                ("status", models.CharField(max_length=30)),
                ("start", models.DateTimeField(max_length=100)),
                ("end", models.DateTimeField(max_length=100)),
                ("comments", models.TextField(blank=True)),
                (
                    "tags",
                    taggit.managers.TaggableManager(
                        help_text="A comma-separated list of tags.",
                        through="extras.TaggedItem",
                        to="extras.Tag",
                        verbose_name="Tags",
                    ),
                ),
                (
                    "provider",
                    models.ForeignKey(
                        default=None,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="maintenance",
                        to="circuits.provider",
                    ),
                ),
                (
                    "acknowledged",
                    models.BooleanField(blank=True, default=False, null=True),
                ),
                ("internal_ticket", models.CharField(blank=True, max_length=100)),
            ],
            options={
                "ordering": ("-created",),
                "verbose_name": "Circuit Maintenance",
                "verbose_name_plural": "Circuit Maintenances",
            },
        ),
        migrations.CreateModel(
            name="CircuitMaintenanceNotifications",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "custom_field_data",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=utilities.json.CustomFieldJSONEncoder,
                    ),
                ),
                ("email", models.BinaryField()),
                ("subject", models.CharField(max_length=100)),
                ("email_from", models.CharField(max_length=100)),
                ("email_recieved", models.DateTimeField()),
                (
                    "circuitmaintenance",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="notification",
                        to="netbox_circuitmaintenance.circuitmaintenance",
                    ),
                ),
                (
                    "provider",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="notification",
                        to="circuits.provider",
                    ),
                ),
                (
                    "tags",
                    taggit.managers.TaggableManager(
                        help_text="A comma-separated list of tags.",
                        through="extras.TaggedItem",
                        to="extras.Tag",
                        verbose_name="Tags",
                    ),
                ),
            ],
            options={
                "ordering": ("email_recieved",),
            },
        ),
        migrations.CreateModel(
            name="CircuitMaintenanceImpact",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "custom_field_data",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=utilities.json.CustomFieldJSONEncoder,
                    ),
                ),
                ("impact", models.CharField(blank=True, max_length=30, null=True)),
                (
                    "circuit",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="maintenance",
                        to="circuits.circuit",
                    ),
                ),
                (
                    "circuitmaintenance",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="impact",
                        to="netbox_circuitmaintenance.circuitmaintenance",
                    ),
                ),
                (
                    "tags",
                    taggit.managers.TaggableManager(
                        help_text="A comma-separated list of tags.",
                        through="extras.TaggedItem",
                        to="extras.Tag",
                        verbose_name="Tags",
                    ),
                ),
            ],
            options={
                "ordering": ("impact",),
                "verbose_name": "Circuit Maintenance Impact",
                "verbose_name_plural": "Circuit Maintenance Imapct",
            },
        ),
    ]
