# Self Assessment Exams: Prompt Driven Development (PDD) and Governed Prompt Software (GPS) Engineering

We’ve built a series of 8 MCQ exams with 60-question each (480 questions in total) that emphasizes concepts (not trivia) from “Prompt-Driven Development” materials (PHRs, ADRs, PRs, Cursor workflow, TDD/SDD, prompt-driven chatbots, governance, evals, safety, and the “Prompt Architect” mindset). The objective of these assessments is that they will help you learn by giving you feedback on your level of understanding of the PDD process and make you an expert in GPS Engineering.

Taking quizzes and reviewing answers enhances learning through several evidence-based mechanisms, particularly when applied to complex topics like GPS Engineering. Here’s a concise explanation of how this process fosters effective learning:

1. **Active Recall**: Quizzes force you to retrieve information from memory, strengthening neural pathways. For example, answering questions about concepts like SDD or PHRs reinforces understanding of their roles by making you actively recall definitions and applications.

2. **Spaced Repetition**: Reviewing answers, especially for missed questions, reinforces concepts over time. For instance, revisiting why “prompt drift” is a distributional shift helps solidify the concept through repeated exposure, improving long-term retention.

3. **Feedback Loop**: Checking answers against the key (e.g., `answer_key.md`) provides immediate feedback, clarifying misconceptions. If you incorrectly chose A for Question 23 in Quiz 4, reviewing the correct answer (A) and its justification (“converts informal confidence into formal gates”) helps correct errors and deepen understanding.

4. **Metacognition**: Quizzes reveal gaps in knowledge. 

5. **Application and Transfer**: PhD-level questions (e.g., Quiz 4) require applying concepts to nuanced scenarios, like distinguishing tests from evals. This promotes higher-order thinking, helping you transfer knowledge to real-world GPS Engineering tasks.

6. **Engagement and Motivation**: The challenge of quizzes, especially with varied answer distributions, keeps you engaged. Reviewing why C is correct for Question 3 can spark curiosity about evaluation protocols, motivating further exploration.

By taking quizzes and reviewing answers, you actively engage with material, identify weaknesses, and reinforce correct understanding, making it a powerful tool for mastering complex frameworks like GPS Engineering. 
