"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const path_1 = require("path");
const aws_autoscaling_1 = require("@aws-cdk/aws-autoscaling");
const core_1 = require("@aws-cdk/core");
const nag_rules_1 = require("../../nag-rules");
/**
 * Auto Scaling Groups have notifications for all scaling events configured
 * @param node the CfnResource to check
 */
exports.default = Object.defineProperty((node) => {
    if (node instanceof aws_autoscaling_1.CfnAutoScalingGroup) {
        if (node.notificationConfigurations == undefined) {
            return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
        }
        const notificationConfigurations = core_1.Stack.of(node).resolve(node.notificationConfigurations);
        const requiredEvents = [
            aws_autoscaling_1.ScalingEvent.INSTANCE_LAUNCH,
            aws_autoscaling_1.ScalingEvent.INSTANCE_LAUNCH_ERROR,
            aws_autoscaling_1.ScalingEvent.INSTANCE_TERMINATE,
            aws_autoscaling_1.ScalingEvent.INSTANCE_TERMINATE_ERROR,
        ];
        const compliant = requiredEvents.every((req) => {
            return notificationConfigurations.some((config) => {
                var _a;
                return (_a = config.notificationTypes) === null || _a === void 0 ? void 0 : _a.includes(req);
            });
        });
        if (compliant !== true) {
            return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
        }
        return nag_rules_1.NagRuleCompliance.COMPLIANT;
    }
    else {
        return nag_rules_1.NagRuleCompliance.NOT_APPLICABLE;
    }
}, 'name', { value: path_1.parse(__filename).name });
//# sourceMappingURL=data:application/json;base64,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