"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const path_1 = require("path");
const aws_ec2_1 = require("@aws-cdk/aws-ec2");
const core_1 = require("@aws-cdk/core");
const nag_rules_1 = require("../../nag-rules");
/**
 * EC2 instances do not have public IPs
 * @param node the CfnResource to check
 */
exports.default = Object.defineProperty((node) => {
    if (node instanceof aws_ec2_1.CfnInstance) {
        const networkInterfaces = core_1.Stack.of(node).resolve(node.networkInterfaces);
        if (networkInterfaces != undefined) {
            //Iterate through network interfaces, checking if public IPs are enabled
            for (const networkInterface of networkInterfaces) {
                const resolvedInterface = core_1.Stack.of(node).resolve(networkInterface);
                const associatePublicIpAddress = nag_rules_1.NagRules.resolveIfPrimitive(node, resolvedInterface.associatePublicIpAddress);
                if (associatePublicIpAddress === true) {
                    return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
                }
            }
        }
        return nag_rules_1.NagRuleCompliance.COMPLIANT;
    }
    else {
        return nag_rules_1.NagRuleCompliance.NOT_APPLICABLE;
    }
}, 'name', { value: path_1.parse(__filename).name });
//# sourceMappingURL=data:application/json;base64,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