"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const path_1 = require("path");
const aws_rds_1 = require("@aws-cdk/aws-rds");
const nag_rules_1 = require("../../nag-rules");
/**
 *  RDS DB instances and Aurora DB clusters do not use the default endpoint ports
 * @param node the CfnResource to check
 */
exports.default = Object.defineProperty((node) => {
    if (node instanceof aws_rds_1.CfnDBCluster) {
        if (node.port == undefined) {
            return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
        }
        const port = nag_rules_1.NagRules.resolveIfPrimitive(node, node.port);
        const engine = nag_rules_1.NagRules.resolveIfPrimitive(node, node.engine).toLowerCase();
        const engineMode = nag_rules_1.NagRules.resolveIfPrimitive(node, node.engineMode);
        if (engineMode == undefined ||
            engineMode.toLowerCase() == 'provisioned') {
            if (engine.includes('aurora') && port == 3306) {
                return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
            }
        }
        else if ((engine == 'aurora' || engine == 'aurora-mysql') &&
            port == 3306) {
            return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
        }
        else if (engine == 'aurora-postgresql' && port == 5432) {
            return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
        }
        return nag_rules_1.NagRuleCompliance.COMPLIANT;
    }
    else if (node instanceof aws_rds_1.CfnDBInstance) {
        if (node.engine == undefined) {
            return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
        }
        const port = nag_rules_1.NagRules.resolveIfPrimitive(node, node.port);
        const engine = nag_rules_1.NagRules.resolveIfPrimitive(node, node.engine).toLowerCase();
        if (port == undefined) {
            if (!engine.includes('aurora')) {
                return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
            }
        }
        else {
            if ((engine == 'mariadb' || engine == 'mysql') && port == 3306) {
                return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
            }
            else if (engine == 'postgres' && port == 5432) {
                return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
            }
            else if (engine.includes('oracle') && port == 1521) {
                return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
            }
            else if (engine.includes('sqlserver') && port == 1433) {
                return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
            }
        }
        return nag_rules_1.NagRuleCompliance.COMPLIANT;
    }
    else {
        return nag_rules_1.NagRuleCompliance.NOT_APPLICABLE;
    }
}, 'name', { value: path_1.parse(__filename).name });
//# sourceMappingURL=data:application/json;base64,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