YARP 2.3.68 (2016-11-28)                                              {#v2_3_68}
========================

[TOC]

YARP 2.3.68 Release Notes
=========================


A (partial) list of bug fixed and issues resolved in this release can be found
[here](https://github.com/robotology/yarp/issues?q=label%3A%22Fixed+in%3A+YARP+v2.3.68%22).


Important Changes
-----------------

### Dependencies

* Readline library is no longer used and was replaced with the NetBSD Editline
  library (libedit-dev on debian/ubuntu).
* [YCM](http://robotology.github.io/ycm) 0.2.2 is now an optional dependency.

### YARP_OS

* The yarp::os::Contact class was widely refactored:
  * The add*() methods are now deprecated. The new set*() methods should be used
    instead.
  * The by*(), invalid() and empty() factory methods are now deprecated. The
    class constructors should be used instead (a few new constructors were added
    to allow this).
  * The byConfig() method is now deprecated. fromConfig() should be used
    instead.
  * The Contact::toURI() method now accepts an includeCarrier parameter (true by
    default) to simplify the generation of the URI without the carrier.
    Moreover the string returned always end with a `/` character.
  * ROS integration was heavily improved and it is now possible to register
    one `Publisher` and one `Subscriber` on the same `Node` using the same
    topic, and to use tools like `roswtf` and `rqt`.
    If you are using YARP with ROS, upgrading is strongly recommended.
  * Added `ConnectionReader::setParentConnectionReader` method. This method
    should be used by `Carriers` that reimplement `modifyIncomingData` and that
    return a ConnectionReader that is not the same as the one in input.
* `PortCore` now uses the "new" version of the protocol for signalling to
  suppress the reply. This was expected since YARP 2.1.2, but it was never
  applied. Both versions of the protocol are accepted in input, unless
  `YARP_NO_DEPRECATED` is enabled, in this case YARP it is not compatible with
  previous releases since only the new version is recognized.
* It is now possible to get and set parameters to portmonitors directly attached
  to a port.

### YARP_sig

* Important: we removed methods for interoperability with the GNU Scientific
  Library (GSL).
  The reason for this was to avoid licensing problems generated by the inclusion
  of a structure defined by GSL. Methods for interoperability have been
  implemented in a new library libYARP_gsl (see below). In details:
  * We removed yarp::sig::Matrix::getGslMatrix()
  * We removed yarp::sig::Vector::getGslVector()

### YARP_dev

* New depth camera stack, device driver interface and wrapper. The old
  interfaces and devices will be deprecated in the next release, when all the
  features will be ported to the new stack.

### YARP_gsl

* This library contains methods for interoperability with the GNU Scientific
  Library. Notice that this library is released as GPL (and not LGPL) because it
  uses a structure defined by GSL.
  * Checkout yarp::gsl::GslMatrix and yarp::gsl::GslVector

### YARP_math

* libYARP_math can be compiled with GSL or Eigen (via CMake flag
  `CREATE_LIB_MATH_USING_GSL`). Important: the use of GSL and this flag will be
  removed in the next release of YARP.
  * When compiled with GSL libYARP_math uses libYARP_gsl internally. A small
    performance hit could affect methods that use GSL.
  * When compiled without GSL libYARP_math uses Eigen.
* The option to link Atlas library has been broken for a while, and therefore it
  was removed. On debian/ubuntu it is still possible to use the atlas library by
  installing the `libatlas-base-dev` package, and use `update-alternatives` to
  configure the alternatives for `libblas.so`, `libblas.so.3`, `liblapack.so`,
  and `liblapack.so.3`

### CMake Modules

* All deprecated CMake modules have been removed.
* All GTK2 CMake modules have been removed and are no longer installed in
  `${YARP_MODULE_PATH}`. They can still be found in
  [YCM](http://robotology.github.io/ycm).
* The `FindReadline` module has been removed.
* The `FindAtlas` module has been removed.
* The `YarpPlugin` module and the relative templates received several
  improvements and fixes:
  - `yarp_prepare_plugin` no longer include any directory or namespace.
    As a consecuence, it might be necessary to fix the `TYPE` for plugins adding
    the full namespace to the class name, and to add the current directory to
    CMake include directories.
  - `yarp_prepare_carrier` and `yarp_prepare_device` are deprecated in favour
    of `yarp_prepare_plugin`.
  - The new `TEMPLATE` and `TEMPLATE_DIR` accepted by `yarp_prepare_plugin`
    can be used to specify a file name and a directory for the template that
    will be configured and added to the plugin. If a template is not specified,
    a file `yarp_plugin_<CATEGORY>.cpp.in` is searched in current directory, in
    CMake module path, and in YARP cmake modules directory. If still it cannot
    be found, but the `PARENT_TYPE` argument, containing the name of the parent
    class for the plugin, was specified, then a default template is generated in
    current binary directory. This should simplify the creation of new types of
    plugins. Please note that static plugins will not work with the default
    template.
  - The `CODE` and `WRAPPER` arguments for the `yarp_prepare_plugin` command are
    deprecated, the new `EXTRA_CONFIG` argument should be used instead.
    Each variable in the form `KEY=VALUE` passed to the `EXTRA_CONFIG` argument
    is changed to `YARPPLUG_<KEY>` and used when the template is configured.
    For example `EXTRA_CONFIG WRAPPER=foo` generates the `YARPPLUG_WRAPPER`
    variable that is then replaced in the `yarp_plugin_device.cpp.in`.
  - The `DEFAULT` argument for the `yarp_prepare_plugin` can be used to specify
    whether the plugin should be enabled by default or not (default = OFF).
  - The `ADVANCED` option for the `yarp_prepare_plugin` can be used to specify
    that the generated CMake variable should be marked as advanced
    (default = OFF).
  - The `INTERNAL` option for the `yarp_prepare_plugin` can be used to specify
    that the generated CMake variable should be marked as internal (and
    therefore not displayed in CMake gui). This also implies `DEFAULT=ON` unless
    explicitly specified.
  - The `DOC` argument for the `yarp_prepare_plugin` can be used to specify a
    documentation line for the generated CMake variable.
  - The `OPTION` argument for the `yarp_prepare_plugin` can be used to rename
    the generated CMake option.
  - The `DEPENDS` argument for the `yarp_prepare_plugin` can be used to specify
    a list of dependencies that should be satisfied in order to enable the
    plugin. If these dependencies are not available, the plugin is disabled, and
    the generated CMake option is not shown on CMake.
* All CMake modules from YCM, CMake, and private are now deprecated, and are
  installed only if `YARP_NO_DEPRECATED` is `OFF`. Projects that require these
  files should depend on YCM instead.

### Tools

* `yarpserver2` and `yarpserver3` have been deprecated for a long time, and
  replaced by `yarpserver`, therefore they have been removed. Please update your
  scripts

### GUIs

* All GTK2 GUIs have a Qt5 replacement and have been deprecated since YARP
  2.3.65, therefore they have been removed.
* `yarpmanager++` and `yarpbuilder` no longer exists, `yarpmanager` now includes
  all the builder functionality.

### Devices

* The `microphone` device is deprecated in favour of `portaudio` (#891).
* The new `depthCamera` camera driver implements the `IRGBD` and
  `FrameGrabberControl2`  interfaces, and works with the devices supported by
  `openni2`.

Bug Fixes
---------

### YARP_OS

* Fixed some cases of connections leaving a streaming connection pending.
* Support dynamic plugins when YARP is built without ACE.
* Fixed several possible race conditions in `yarp::os::Thread`.
* `getBusInfo` ROS command was implemented.
* `getMasterUri` ROS command was implemented.
* `getPid` ROS command was fixed and now returns just one integer instead of a
  vector.
* The right caller_id is returned by `PortCore` for `publisherUpdate` and
  `requestTopic` ROS commands.
* The right caller_id is returned by the tcpros carrier.
* `yarp::os::Node` now handles correctly multiple publishers and subscribers on
  the same topic. The limit on YARP is that only one publisher and one
  subscriber can be registered on the same node using the same topic.
* The `Carriers` class was moved outside of the impl namespace (#402).
* Fixed crash on prop get command from admin rpc port (#969).

### Carriers

* Fixed portmonitor and bayer carriers not handling envelope correctly when
  attached on the receiving side (#729, #782, #909).

### Devices

* `RemoteControlBoard`
  * Fixed race condition.
* `ControlBoardWrapper`
  * Fixed bug in setRemoteVariable`
  * Fixed value not initialized in `CheckMotionDone`
* `fakeMotionControl`
  * `controlboardwrapper2` is now used as default wrapper instead of
    `controlboard` and is no longer erroneously reported as deprecated.

### GUIs

* yarpmanager
  * Fixed yarpmanager cannot display and disconnect mjpeg connections
    (#595).
* yarplogger
  * Fixed segfault when the logger receives a malformed log message.


New Features
------------

### YARP_OS

* Improved PortCore `list [in|out]` commands
  They also return now:
  * `(connectionless 1)` when the connection is connectionless (i.e. udp).
  * `(push 0)` when the connection is not push (i.e. mjpeg).
* Improved Portcore `[prop] [get] $portname` command.
  It also returns now some more information about the port in this form:
  `(port ((is_input [0|1]) (is_output [0|1]) (is_rpc [0|1]) (type "[type]")))`
* Improved compiler detection and added <yarp/conf/compiler.h> header
  containing macros to check if a specific feature is available.
* Added method `yarp::os::Thread::yield()` that reschedules the execution of
  current thread, allowing other threads to run.
* Added method `yarp::os::Contactable::resetReporter()` to remove the
  `PortReport` set by `setReporter()`.

### YARP_math

* Added the `yarp::math::FrameTransform` class.

### YARP_dev

* Added the `yarp::dev::IDepthSensor` and `yarp::dev::IRGBDSensor` interfaces.
* Added the `yarp::dev::IFrameTransform.h interface.
* Added the `transformServer` and `transformClient` devices.

### Carriers

* Added `depthimage` portmonitor plugin.

### Devices

* The `ControlBoardRemapper` and `RemoteControlBoardRemapper` devices were
  introduced that is a state-less and thread-less YARP device that takes axes
  belonging to several controlboards and expose them as a unique controlboard
  device.
* The `RGBDSensorClient` and `RGBDSensorWrapper` devices were added.
* Rangefinder2DWrapper: use timestamp from device driver.
* The `fakeAnalogSensor` has been introduced to easily test and as a reference
  for new analogSensor devices. It has only one channel sending timestamp as
  data.

### GUIs

* yarpmanager
  * Use service tag from module description to add as input/output
    service port.
  * It's now possible to set environment variables within application xml file.
* yarpmotorgui
  * Command "Save all joints" from main menu now open a single dialog
    box (#912) and propagates file name to all parts.


Contributors
------------

This is a list of people that contributed to this release (generated from the
git history using `git shortlog -ens --no-merges v2.3.68..v2.3.68`):

```
   430	Daniele E. Domenichelli <daniele.domenichelli@iit.it>
    56	Alberto Cardellino <alberto.cardellino@iit.it>
    49	Andrea Ruzzenenti <andrea.ruzzenenti@iit.it>
    47	Marco Randazzo <marco.randazzo@iit.it>
    41	Silvio Traversaro <silvio.traversaro@iit.it>
    34	Tobias Fischer <t.fischer@imperial.ac.uk>
    16	Francesco Romano <francesco.romano@iit.it>
    13	Claudio Fantacci <claudio.fantacci@iit.it>
    11	Matteo Brunettini <matteo.brunettini@iit.it>
    10	Lorenzo Natale <lorenzo.natale@iit.it>
     9	Ugo Pattacini <ugo.pattacini@iit.it>
     8	Vadim Tikhanoff <vadim.tikhanoff@iit.it>
     7	Alexandros Paraschos <paraschos@ias.tu-darmstadt.de>
     6	Ali Paikan <ali.paikan@iit.it>
     3	Giovanni Saponaro <gsaponaro@isr.ist.utl.pt>
     1	Claudia Latella <claudia.latella@iit.it>
     1	Gabriele Nava <gabriele.nava@mail.polimi.it>
     1	Plinio Moreno <plinio@isr.tecnico.ulisboa.pt>
     1	Valentina Gaggero <valentina.gaggero@iit.it>
     1	YARP Developers <yarp0-devel@lists.sourceforge.net>
```
